/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class CommitApplicationEvent
extends CompletableApplicationEvent<Void> {
    private final Map<TopicPartition, OffsetAndMetadata> offsets;
    private final Optional<Long> retryTimeoutMs;

    public CommitApplicationEvent(Map<TopicPartition, OffsetAndMetadata> offsets, Optional<Long> retryTimeoutMs) {
        super(ApplicationEvent.Type.COMMIT);
        this.offsets = Collections.unmodifiableMap(offsets);
        this.retryTimeoutMs = retryTimeoutMs;
        for (OffsetAndMetadata offsetAndMetadata : offsets.values()) {
            if (offsetAndMetadata.offset() >= 0L) continue;
            throw new IllegalArgumentException("Invalid offset: " + offsetAndMetadata.offset());
        }
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    public Optional<Long> retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommitApplicationEvent that = (CommitApplicationEvent)o;
        return this.offsets.equals(that.offsets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.offsets.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CommitApplicationEvent{" + this.toStringBase() + ", offsets=" + this.offsets + ", retryTimeout=" + this.retryTimeoutMs.map(t2 -> t2 + "ms").orElse("none") + '}';
    }
}

