/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public abstract class EventProcessor<T>
implements Closeable {
    private final Logger log;
    private final BlockingQueue<T> eventQueue;
    private final IdempotentCloser closer;

    protected EventProcessor(LogContext logContext, BlockingQueue<T> eventQueue) {
        this.log = logContext.logger(EventProcessor.class);
        this.eventQueue = eventQueue;
        this.closer = new IdempotentCloser();
    }

    public abstract boolean process();

    protected abstract void process(T var1);

    @Override
    public void close() {
        this.closer.close(this::closeInternal, () -> this.log.warn("The event processor was already closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ProcessHandler<T> processHandler) {
        this.closer.assertOpen("The processor was previously closed, so no further processing can occur");
        List<T> events = this.drain();
        if (events.isEmpty()) {
            this.log.trace("No events to process");
            return false;
        }
        try {
            this.log.trace("Starting processing of {} event{}", (Object)events.size(), (Object)(events.size() == 1 ? "" : "s"));
            for (T event : events) {
                try {
                    Objects.requireNonNull(event, "Attempted to process a null event");
                    this.log.trace("Processing event: {}", event);
                    this.process(event);
                    processHandler.onProcess(event, Optional.empty());
                }
                catch (Throwable t2) {
                    KafkaException error = ConsumerUtils.maybeWrapAsKafkaException(t2);
                    processHandler.onProcess(event, Optional.of(error));
                }
            }
        }
        finally {
            this.log.trace("Completed processing");
        }
        return true;
    }

    private void closeInternal() {
        this.log.trace("Closing event processor");
        List<T> incompleteEvents = this.drain();
        if (incompleteEvents.isEmpty()) {
            return;
        }
        KafkaException exception = new KafkaException("The consumer is closed");
        incompleteEvents.stream().filter(e -> e instanceof CompletableEvent).map(e -> ((CompletableEvent)e).future()).filter(f -> !f.isDone()).forEach(f -> {
            this.log.debug("Completing {} with exception {}", f, (Object)exception.getMessage());
            f.completeExceptionally(exception);
        });
        this.log.debug("Discarding {} events because the consumer is closing", (Object)incompleteEvents.size());
    }

    private List<T> drain() {
        LinkedList events = new LinkedList();
        this.eventQueue.drainTo(events);
        return events;
    }

    protected static interface ProcessHandler<T> {
        public void onProcess(T var1, Optional<KafkaException> var2);
    }
}

