/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CellState {
    UNKNOWN(0),
    READY(1),
    QUARANTINED(2),
    EXCLUDED(3);

    public static final Set<CellState> VALID_CELL_STATES;
    private static final Map<Byte, CellState> CODE_TO_CELL_STATE;
    private final byte code;

    public byte code() {
        return this.code;
    }

    private CellState(byte code) {
        this.code = code;
    }

    public static CellState toEnum(byte code) {
        return CODE_TO_CELL_STATE.getOrDefault(code, UNKNOWN);
    }

    static {
        VALID_CELL_STATES = Collections.unmodifiableSet(new HashSet<CellState>(Arrays.asList(READY, QUARANTINED, EXCLUDED)));
        CODE_TO_CELL_STATE = Arrays.stream(CellState.values()).collect(Collectors.toMap(CellState::code, Function.identity()));
    }
}

