/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyFactory {
    public static final int MAX_CHUNK_SIZE_IN_BYTES = 0x1000000;

    private SnappyFactory() {
    }

    public static OutputStream wrapForOutput(ByteBufferOutputStream buffer) {
        try {
            return new SnappyOutputStream((OutputStream)buffer);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static InputStream wrapForInput(ByteBuffer buffer) {
        try {
            return new SnappyInputStream((InputStream)new ByteBufferInputStream(buffer), 0x1000000);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }
}

