/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.requests.SamplingRequestLogFilter;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.license.LicenseValidator;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.multitenant.MultiTenantSecretsStore;
import org.apache.kafka.server.multitenant.UserMetadataStore;
import org.apache.kafka.server.quota.MultiTenantQuotaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentConfigs {
    private static final Logger log = LoggerFactory.getLogger(ConfluentConfigs.class);
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String TRAFFIC_PREFIX = "confluent.traffic.";
    public static final String CLUSTER_LINK_PREFIX = "confluent.cluster.link.";
    public static final String CDC_TOPIC_METADATA_CONFIG_PREFIX = "confluent.cdc.topic.metadata.";
    public static final String BROKER_SESSION_ID_PROP = "broker.session.uuid";
    public static final String CONFIGS_LOGGING_ENABLED_PROP = "confluent.configs.logging.enabled";
    public static final String BROKER_INTERCEPTOR_CLASS_CONFIG = "broker.interceptor.class";
    public static final Class<?> BROKER_INTERCEPTOR_CLASS_DEFAULT = DefaultBrokerInterceptor.class;
    public static final String MULTITENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    public static final String MULTITENANT_METADATA_CLASS_CONFIG = "multitenant.metadata.class";
    public static final String MULTITENANT_METADATA_CLASS_DEFAULT = null;
    public static final String MULTITENANT_METADATA_DIR_CONFIG = "multitenant.metadata.dir";
    public static final String MULTITENANT_METADATA_DIR_DEFAULT = null;
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_CONFIG = "multitenant.metadata.ssl.certs.path";
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_DEFAULT = null;
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_CONFIG = "multitenant.metadata.reload.delay.ms";
    public static final Long MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_DOC = "Interval (in ms) between full reloads of logical cluster metadata. Defaults to 2 minutes.";
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_CONFIG = "multitenant.tenant.delete.delay";
    public static final Long MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT = TimeUnit.DAYS.toMillis(7L);
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_DOC = "Delay between the time the tenant is marked as deactivated in JSON file, until we actually start deleting topics. This defaults to 7 days to allow plenty of times for operators and users to regret their decisions and do something about it";
    public static final String MULTITENANT_TENANT_DELETE_CHECK_MS_CONFIG = "multitenant.tenant.delete.check.ms";
    public static final Long MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_TENANT_DELETE_CHECK_MS_DOC = "How often to check the list of deactivated tenants for those that needs be deleted. This is the maximum time, and the check could happen sooner. The actual time for tenant deletion is in the interval " + MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT + "[0, " + MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT + "].";
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_CONFIG = "multitenant.tenant.delete.batch.size";
    public static final Integer MULTITENANT_TENANT_DELETE_BATCH_SIZE_DEFAULT = 10;
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_DOC = "Batch size for topic deletion of deactivated tenants. We wait for each batch to complete before sending another";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_CONFIG = "confluent.schema.validator.multitenant.enable";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_DOC = "Controls enablement of the schema validation plugin in the cloud";
    public static final boolean MULTITENANT_SCHEMA_VALIDATION_ENABLED_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_CONFIG = "confluent.multitenant.interceptor.balancer.apis.enabled";
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DOC = "Denotes whether the multi-tenant interceptor will enable requests for the Self-Balancing Clusters (SBC) APIs.";
    public static final boolean MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DEFAULT = false;
    public static final String API_VISIBILITY_CONFIG = "confluent.api.visibility";
    public static final String API_VISIBILITY_DOC = "API visibility to be advertised by the broker. " + (Object)((Object)ApiMessageType.ApiVisibility.DEFAULT) + " enables all Apache Kafka APIs and Confluent APIs intended for on-prem. " + (Object)((Object)ApiMessageType.ApiVisibility.CONFLUENT_CLOUD) + " additionally enables Confluent Cloud-specific APIs.";
    public static final ApiMessageType.ApiVisibility API_VISIBILITY_DEFAULT = ApiMessageType.ApiVisibility.DEFAULT;
    public static final String MULTITENANT_OAUTH_SUPERUSER_DISABLE = "multitenant.oauth.superuser.disable";
    public static final boolean MULTITENANT_OAUTH_SUPERUSER_DISABLE_DEFAULT = false;
    public static final String ENABLE_DATAPLANE_RBAC_FOR_PKC = "confluent.metadata.kafka.enable.dataplane.rbac";
    public static final boolean ENABLE_DATAPLANE_RBAC_FOR_PKC_DEFAULT = false;
    public static final String SUPPORT_USER_RESOURCE_ID_IN_ACL = "multitenant.authorizer.support.resource.ids";
    public static final boolean SUPPORT_USER_RESOURCE_ID_IN_ACL_DEFAULT = false;
    public static final String SUPPORT_USER_RESOURCE_ID_IN_ACL_DOC = "Enable using resourceId in kafka ACL APIs";
    private static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_CONFIG = "confluent.schema.validator.interceptor.class";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DOC = "Interceptor class used during schema validation";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DEFAULT = "io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_CONFIG = "confluent.schema.validator.samples.per.min";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_DOC = "Number of error samples that will be printed per minute during schema validation";
    public static final Integer SCHEMA_VALIDATION_SAMPLES_PER_MIN_DEFAULT = 0;
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String WAIT_FOR_AUTHORIZER = "confluent.wait.for.authorizer.startup";
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 20000;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "confluent.missing.schema.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_DOC = "The TTL in seconds for caching missing schemas";
    public static final long MISSING_SCHEMA_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = null;
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = null;
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL = "confluent.bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC = "The HTTP(S)-based URL for the OAuth/OIDC identity provider which issues access token";
    public static final String BEARER_AUTH_CLIENT_ID = "confluent.bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_ID_DOC = "Client Id used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_CLIENT_SECRET = "confluent.bearer.auth.client.secret";
    public static final String BEARER_AUTH_CLIENT_SECRET_DOC = "Client secret used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_SCOPE = "confluent.bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_DOC = "Access Token Scope used to obtain Client Credentials Grant OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-3.3\"> ";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "confluent.bearer.auth.scope.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME = "scope";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DOC = "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "confluent.bearer.auth.sub.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME = "sub";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER = "confluent.bearer.auth.logical.cluster";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER_DOC = "Additional property which can added in Request header to Schema Registry";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID = "confluent.bearer.auth.identity.pool.id";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID_DOC = "Additional property which can added in Request header to Schema Registry. This maybe used as Principal Id for Authorization";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "confluent.bearer.auth.cache.expiry.buffer.seconds";
    public static final Short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = 300;
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC = "The amount of buffer time between expiration times of the OAuth Token and corresponding cache which hold the token. Ideally we would want to get a new token before the current one expires. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value is ignored if it exceeds the remaining lifetime of a token from the moment it is retrieved into schema registry.";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String PRODUCER_MIN_ACKS_CONFIG = "confluent.min.acks";
    public static final String TENANT_QUOTA_CALLBACK_CLASS = "io.confluent.kafka.multitenant.quota.TenantQuotaCallback";
    public static final String BACKPRESSURE_TYPES_CONFIG = "confluent.backpressure.types";
    public static final String BACKPRESSURE_TYPES_DEFAULT = null;
    public static final String BACKPRESSURE_TYPES_DOC = "Comma separated list of resource types for which broker back-pressure is enabled. Backpressure is not enabled by default. Accepted values: 'request', 'produce', 'fetch', 'clusterlinkrequest'.Invalid values are ignored. This config is ignored if client.quota.callback.class is not set, or set to class other than TenantQuotaCallback. In other words, broker back-pressure can be enabled for multi-tenant clusters only.";
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_CONFIG = "confluent.backpressure.request.min.broker.limit";
    public static final Long BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT = 200L;
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DOC = "The minimum broker request quota, i.e., request backpressure would not reduce the broker request quota any further even if the request overload is still detected. Broker-wide request quota, if not unlimited, caps the combined dynamic request quotas of currently active tenants. All values are accepted, but values below 10 will result in the minimum limit of 10.";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_CONFIG = "confluent.backpressure.request.queue.size.percentile";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DEFAULT = "p95";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DOC = "Queue size percentile used by request backpressure. For example, p95 means that when the number of requests in the request queue exceeds 80% of `queued.max.requests` in more than 5% of cases, the backpressure mechanism starts reducing the total broker request quota. Accepted values: `p90`, `p95`, `p98`, `p99`. Setting an invalid value will default to `p95`.";
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_CONFIG = "confluent.backpressure.disk.produce.bytes.per.second";
    public static final long BACKPRESSURE_PRODUCE_THROUGHPUT_DEFAULT = 131072L;
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_DOC = "The cumulative bandwidth (in Bytes/s) available to all the producers in the broker";
    public static final String BACKPRESSURE_DISK_ENABLE_CONFIG = "confluent.backpressure.disk.enable";
    public static final boolean BACKPRESSURE_DISK_ENABLE_DEFAULT = false;
    public static final String BACKPRESSURE_DISK_ENABLE_DOC = "This flag will be used to turn on the disk based backpressure";
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_CONFIG = "confluent.backpressure.disk.free.threshold.bytes";
    public static final long BACKPRESSURE_DISK_THRESHOLD_BYTES_DEFAULT = 0x500000000L;
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_DOC = "The disk space available (in bytes) considered as the minimum across all the log dirs, below which the broker will limit aggregate produce bandwidth from all clients to the bandwidth specified in confluent.backpressure.disk.produce.bytes.per.second";
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_CONFIG = "confluent.backpressure.disk.threshold.recovery.factor";
    public static final double BACKPRESSURE_DISK_RECOVERY_FACTOR_DEFAULT = 1.5;
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_DOC = "The multiplier for the free disk threshold (specified via confluent.backpressure.disk.free.threshold.bytes) above which the throttling would be deactivated";
    public static final String BROKER_LIMIT_PRODUCER_CONFIG = "confluent.broker.limit.producer.bytes.per.second";
    public static final Long BROKER_LIMIT_PRODUCER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_PRODUCER_DOC = "Broker-wide produce bandwidth limit in bytes per second. Broker will throttle produce requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String BROKER_LIMIT_CONSUMER_CONFIG = "confluent.broker.limit.consumer.bytes.per.second";
    public static final Long BROKER_LIMIT_CONSUMER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_CONSUMER_DOC = "Broker-wide consumer bandwidth limit in bytes per second. Broker will throttle fetch requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.produce.multiplier";
    public static final Double TENANT_PRODUCE_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_DOC = "Broker-wide produce bandwidth limit multiplier for tenant quotas.";
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.fetch.multiplier";
    public static final Double TENANT_FETCH_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_DOC = "Broker-wide fetch bandwidth limit multiplier for tenant quotas.";
    public static final String QUOTA_DYNAMIC_REPORTING_MIN_USAGE_CONFIG = "confluent.quota.dynamic.reporting.min.usage";
    public static final Integer QUOTA_DYNAMIC_REPORTING_MIN_USAGE_DEFAULT = 102400;
    public static final String QUOTA_DYNAMIC_REPORTING_MIN_USAGE_DOC = "Minimal quota consumption reported by the broker.";
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_CONFIG = "confluent.quota.dynamic.reporting.interval.ms";
    public static final Long QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DOC = "Broker-wide quota consumption reporting interval, in milli seconds.";
    public static final String QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_CONFIG = "confluent.quota.dynamic.publishing.interval.ms";
    public static final Long QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
    public static final String QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_DOC = "Broker-wide quota publishing interval, in milliseconds.";
    public static final String MAX_CONNECTION_REAP_AMOUNT_CONFIG = "max.connections.reap.amount";
    public static final int MAX_CONNECTION_REAP_AMOUNT_DEFAULT = 0;
    public static final String MAX_CONNECTION_REAP_AMOUNT_DOC = "Connections will start to get closed once connection count is greater than max.connections - max.connections.reap.amount";
    public static final String MAX_CONNECTION_PROTECTED_LISTENERS_CONFIG = "max.connections.protected.listeners";
    public static final String MAX_CONNECTION_PROTECTED_LISTENERS_DEFAULT = "";
    public static final String MAX_CONNECTION_PROTECTED_LISTENERS_DOC = "Comma separated list of listener names that are protected from the max connection limit";
    public static final String CONNECTION_CREATION_RATE_FLOOR_CONFIG = "floor.max.connection.creation.rate";
    public static final String CONNECTION_CREATION_RATE_FLOOR_DOC = "The minimum rate that self-tuned connection creation rate quota will reduce to. This property can only be configured at a per-listener level. If unconfigured, connection rate auto-tuning will be disabled.";
    public static final String VALID_BROKER_RACK_SET_CONFIG = "confluent.valid.broker.rack.set";
    public static final String VALID_BROKER_RACK_SET_DOC = "Comma-delimited list of rack ids that are considered valid.";
    public static final String VALID_BROKER_RACK_SET_DEFAULT = null;
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_CONFIG = "confluent.reporters.telemetry.auto.enable";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_DOC = "Auto-enable telemetry on the broker. This will add the telemetry reporter to the broker's 'metric.reporters' property if it is not already present. Disabling this property will prevent Self-balancing Clusters from working properly.";
    public static final boolean AUTO_ENABLE_TELEMETRY_REPORTER_DEFAULT = true;
    public static final String METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_CONFIG = "confluent.metadata.max.leader.balance.changes.per.slice";
    public static final String METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DOC = "This configuration determines the maximum number of leader elections to perform during one partition leader balancing operation. Use this configuration and {METADATA_LEADER_BALANCE_SLICE_DELAY_MS_CONFIG} to controller how quickly the controller performs leader elections. The default value is {METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DEFAULT}.";
    public static final int METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DEFAULT = 1000;
    public static final String METADATA_LEADER_BALANCE_SLICE_DELAY_MS_CONFIG = "confluent.metadata.leader.balance.slice.delay.ms";
    public static final String METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DOC = "This configuration determines how much time the controller will wait between leader balancing operation. Use this configuration and {METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_CONFIG} to controller how quickly the controller performs leader elections. The default value is {METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DEFAULT}.";
    public static final int METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DEFAULT = 100;
    public static final String METADATA_JVM_WARMUP_MS_CONFIG = "confluent.metadata.jvm.warmup.ms";
    public static final String METADATA_JVM_WARMUP_MS_DOC = "This configuration determines how much time the controller will wait between balancing internal topic partitions and external topic partitions, It is the time for jvm to warm up the PRODUCE and FETCH paths before moving any customer visible partition leaders.";
    public static final int METADATA_JVM_WARMUP_MS_DEFAULT = 60000;
    public static final String METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_CONFIG = "confluent.metadata.max.controlled.shutdown.partition.changes.per.slice";
    public static final String METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DOC = "This configuration determines the maximum number of partition changes performed concurrently by the controller. Use this configuration and {METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_CONFIG} to controller how quickly the controller performs partition changes during controlled shutdown. The default value is {METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DEFAULT}.";
    public static final int METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DEFAULT = 1000;
    public static final String METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_CONFIG = "confluent.metadata.controlled.shutdown.partition.slice.delay.ms";
    public static final String METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DOC = "This configuration determines how much time the controller will wait between partition changes. Use this configuration and {METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_CONFIG} to controller how quickly the controller performs partition changes during controlled shutdown. The default value is {METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DEFAULT}.";
    public static final int METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DEFAULT = 100;
    public static final String TELEMETRY_ENABLED_CONFIG = "confluent.telemetry.enabled";
    public static final String TELEMETRY_ENABLED_DOC = "True if telemetry data can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_ENABLED_DEFAULT = false;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_CONFIG = "confluent.alter.broker.health.max.demoted.brokers";
    public static final Integer ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_DEFAULT = Integer.MAX_VALUE;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_DOC = "The maximum number of brokers that can be demoted when limit is enforced. Int.MaxValue means that any number of brokers can be demoted.";
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_CONFIG = "confluent.alter.broker.health.max.demoted.brokers.percentage";
    public static final Integer ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_DEFAULT = 0;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_DOC = "The maximum percentage of brokers that can be demoted when limit is enforced. We always allow at least one broker to be demoted given 3 live brokers, but will allow demotion of more if the configured percentage of brokers in the cluster is greater than one. Valid values are 0 (minimum (1) broker can be demoted) to 100 (all brokers can be demoted).";
    public static final String ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_CONFIG = "confluent.automatic.alter.broker.health.retry.backoff.ms";
    public static final Integer AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_DEFAULT = 2000;
    public static final String AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_DOC = "Before each retry, the system needs time to recover from the state that caused the previous failure. This config determines the amount of time to wait before retrying. The delay will grow exponentially by factor of 2.";
    public static final String BROKER_TYPE_CONFIG = "confluent.broker.type";
    public static final String BROKER_TYPE_DEFAULT = "confluent_platform";
    public static final String BROKER_TYPE_DOC = "Specifies the type of broker, can be either 'confluent_cloud' or 'confluent_platform'";
    public static final String BROKER_TYPE_TOPIC_ENABLED_CONFIG = "confluent.broker.type.topic.enabled";
    public static final boolean BROKER_TYPE_TOPIC_ENABLED_DEFAULT = true;
    public static final String BROKER_TYPE_TOPIC_ENABLED_DOC = "True if a topic to reveal the type of the cluster should be created.";
    public static final String ENABLE_ACL_STATE = "confluent.multitenant.authorizer.enable.acl.state";
    public static final boolean ENABLE_ACL_STATE_DEFAULT = false;
    public static final String ENABLE_ACL_STATE_DOC = "Enable using AclState in kafka ACL APIs";
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.SbcDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DEFAULT;
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DOC;
    public static final String BALANCER_V2_ADDITION_ENABLED_SBC_CONFIG = "v2.addition.enabled";
    public static final String BALANCER_V2_ADDITION_ENABLED_CONFIG = "confluent.balancer.v2.addition.enabled";
    public static final boolean BALANCER_V2_ADDITION_ENABLED_DEFAULT = false;
    public static final String BALANCER_V2_ADDITION_ENABLED_SBC_DOC = "A boolean denoting whether the version 2 of the broker addition operation is enabled. Because V2 broker addition relies exclusively on self healing to add the broker to the cluster, its enablement also depends on incremental balancing being enabled ('confluent.balancer.incremental.balancing.enabled'). To enable V2 broker addition, configure both this config and 'confluent.balancer.incremental.balancing.enabled' to true.";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT;
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_NO_THROTTLE;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN = BalancerConfigs.BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT = BalancerConfigs.BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_SBK_CONFIG = "capacity.threshold.upper.limit";
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_CONFIG = "confluent.balancer.capacity.threshold.upper.limit";
    public static final Double BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DEFAULT = BalancerConfigs.BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DEFAULT;
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DOC = "Upper limit on capacity threshold config. If balancing fail with original capacity thresholds defined for each resource, SBC will try to bump it up to this limit (maybe in multiple stages) and try to balance again. Balancing will fail only if capacity threshold is set to this value and brokers can't be balanced.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_SBK_CONFIG = "disk.min.free.space.gb";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_CONFIG = "confluent.balancer.disk.min.free.space.gb";
    public static final Integer BALANCER_DISK_MIN_FREE_SPACE_DEFAULT = BalancerConfigs.BALANCER_DISK_MIN_FREE_SPACE_DEFAULT;
    public static final String BALANCER_DISK_MIN_FREE_SPACE_DOC = "The minimum amount of disk space, in GB, that needs to remain unused on a broker. Valid values are between 0 and disk size. The balancer will enforce the stricter bound between this config and 'confluent.balancer.disk.max.load'.";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_SBK_CONFIG = "disk.min.free.space.lower.limit.gb";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_CONFIG = "confluent.balancer.disk.min.free.space.lower.limit.gb";
    public static final Integer BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DEFAULT = BalancerConfigs.BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DEFAULT;
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DOC = "The lower limit on minimum amount of free disk space, in gigabytes, that needs to remain unused on a broker. On failing to balance, SBC will reset the min disk space config DISK_CAPACITY_MIN_FREE_SPACE_CONFIG to this value and will try to balance again.The balancer will enforce the stricter bound between this config and 'confluent.balancer.disk.max.load'.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = BalancerConfigs.BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = BalancerConfigs.BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG = "confluent.balancer.max.capacity.balancing.delta.percentage";
    public static final Double BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT = BalancerConfigs.BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT;
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DOC = "The extra percentage of total capacity that SBC will attempt to balance below the allowed capacity once it gets triggered to fix a broker hitting its maximum allowed capacity for a given resource.";
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_SBC_CONFIG = "demotion.support.enabled";
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_CONFIG = "confluent.balancer.demotion.support.enabled";
    public static final boolean BALANCER_DEFAULT_DEMOTION_SUPPORT_ENABLED = false;
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_DOC = "This config controls whether the Balancer supports demoted brokers. If disabled, the Balancer will shut down at the presence of demoted brokers.";
    public static final String MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore";
    public static final String CONFLUENT_CDC_API_KEYS_PREFIX = "confluent.cdc.api.keys.";
    public static final String CDC_API_KEYS_TOPIC_CONFIG = "confluent.cdc.api.keys.topic";
    public static final String CDC_API_KEYS_TOPIC_DEFAULT = "";
    public static final String CDC_API_KEYS_TOPIC_DOC = "Name of the internal topic holding api keys";
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_CONFIG = "confluent.cdc.api.keys.topic.load.timeout.ms";
    public static final Long CDC_TOPIC_LOAD_TIMEOUT_MS_DEFAULT = Duration.ofMinutes(10L).toMillis();
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_DOC = "Time (in milliseconds) to wait before giving up on trying to consume the topics for logical clusters api keys and tenant metadata. Default is 10min";
    public static final String CONFLUENT_CDC_LKC_METADATA_PREFIX = "confluent.cdc.lkc.metadata.";
    public static final String CDC_LKC_METADATA_TOPIC_CONFIG = "confluent.cdc.lkc.metadata.topic";
    public static final String CDC_LKC_METADATA_TOPIC_DEFAULT = "";
    public static final String CDC_LKC_METADATA_TOPIC_DOC = "Name of the internal topic holding lkc metadata";
    public static final String MULTI_TENANT_QUOTA_CONSUMER_CLASS_NAME = "io.confluent.kafka.multitenant.quota.TenantClientQuotaConsumer";
    public static final String CONFLUENT_CDC_CLIENT_QUOTAS_PREFIX = "confluent.cdc.client.quotas.";
    public static final String CDC_CLIENT_QUOTAS_ENABLE_CONFIG = "confluent.cdc.client.quotas.enable";
    public static final boolean CDC_CLIENT_QUOTAS_ENABLE_DEFAULT = false;
    public static final String CDC_CLIENT_QUOTAS_ENABLE_DOC = "Should the broker try and read client qutoas from internal topic";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_CONFIG = "confluent.cdc.client.quotas.topic.name";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_DEFAULT = "";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_DOC = "Name of the internal topic holding client quotas";
    public static final String NETWORK_ID_ROUTES_UPDATER_CLASS_NAME = "io.confluent.kafka.traffic.TopicBasedTrafficNetworkIdRoutesUpdater";
    public static final String CONFLUENT_TRAFFIC_CDC_NETWORK_ID_ROUTES_PREFIX = "confluent.traffic.cdc.network.id.routes.";
    public static final String CDC_NETWORK_ID_ROUTES_ENABLE_CONFIG = "confluent.traffic.cdc.network.id.routes.enable";
    public static final boolean CDC_NETWORK_ID_ROUTES_ENABLE_DEFAULT = false;
    public static final String CDC_NETWORK_ID_ROUTES_ENABLE_DOC = "Should the broker try and read networkId routes from internal topic";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_CONFIG = "confluent.traffic.cdc.network.id.routes.topic.name";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_DEFAULT = "_confluent-network_id_routes";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_DOC = "Name of the internal topic holding networkId routes";
    public static final String CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_CONFIG = "confluent.traffic.cdc.network.id.routes.periodic.start.task.ms";
    public static final Long CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_DEFAULT = Duration.ofMinutes(5L).toMillis();
    public static final String CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_DOC = "Time (in milliseconds) to periodically check for routes topic existence  and start the consumer if topic is available. Default is 5min";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES = "confluent.traffic.cdc.network.id.routes.listener.names";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES_DEFAULT = "EXTERNAL_BACKCHANNEL";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES_DOC = "Name of the listeners that need to wait for the TopicBasedTrafficNetworkIdRoutesUpdater to start before accepting requests";
    public static final String CDC_USER_METADATA_STORE_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore";
    public static final String CONFLUENT_CDC_USER_METADATA_PREFIX = "confluent.cdc.user.metadata.";
    public static final String CDC_USER_METADATA_ENABLE_CONFIG = "confluent.cdc.user.metadata.enable";
    public static final boolean CDC_USER_METADATA_ENABLE_DEFAULT = false;
    public static final String CDC_USER_METADATA_ENABLE_DOC = "Should the broker read user metadata from internal topics";
    public static final String CDC_USER_METADATA_TOPIC_CONFIG = "confluent.cdc.user.metadata.topic";
    public static final String CDC_USER_METADATA_TOPIC_DEFAULT = "_confluent-user_metadata";
    public static final String CDC_USER_METADATA_TOPIC_DOC = "Name of the topic holding user metadata";
    public static final String CDC_USER_DELETION_HANDLER_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.UserDeletionEventHandler";
    public static final String CDC_USER_DELETION_HANDLER_ENABLE_CONFIG = "confluent.cdc.user.deletion.handler.enable";
    public static final boolean CDC_USER_DELETION_HANDLER_ENABLE_DEFAULT = false;
    public static final String CDC_USER_DELETION_HANDLER_DOC = "Enable the User deletion handler to soft delete the ACLs for deleted users";
    public static final String OPERATOR_MANAGED_CONFIG = "confluent.operator.managed";
    public static final boolean OPERATOR_MANAGED_DEFAULT = false;
    public static final String OPERATOR_MANAGED_DOC = "This config indicates if the Confluent Operator was involved in generating the broker configuration.";
    public static final String ANSIBLE_MANAGED_CONFIG = "confluent.ansible.managed";
    public static final boolean ANSIBLE_MANAGED_DEFAULT = false;
    public static final String ANSIBLE_MANAGED_DOC = "This config indicates if Ansible was involved in generating the broker configuration.";
    public static final String MULTITENANT_LISTENER_NAMES_CONFIG = "confluent.multitenant.listener.names";
    public static final String MULTITENANT_LISTENER_NAMES_DEFAULT = null;
    public static final String MULTITENANT_LISTENER_NAMES_DOC = "Comma separated list of listener names used for communications with tenants. It MUST BE SPECIFIED IN MULTI-TENANT environment! It is needed to enable both broker request (time on network and IO threads)backpressure, and for a proper startup of the topic based tenant metadata plugins. Note that this should bedisjoint from inter.broker.listener.name (which should not receive connections from tenants)";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_CONFIG = "confluent.internal.tenant.scoped.listener.name";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_DEFAULT = "INTERNAL_TENANT_SCOPED";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_DOC = "The name of internal tenant scoped listener";
    public static final String REQUEST_LOG_FILTER_CLASS_CONFIG = "confluent.request.log.filter.class";
    public static final String REQUEST_LOG_FILTER_DEFAULT = SamplingRequestLogFilter.class.getName();
    public static final String REQUEST_LOG_FILTER_CLASS_DOC = "Class of request log filter which can be used to select a subset of requests for logging. Every request handler thread will get a separate instance of this class and it is only consulted if the request log level is set to INFO or higher. If DEBUG or TRACE logging is enabled, then all requests get logged regardless of filtering.";
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_CLASS_CONFIG = "confluent.security.event.logger.detailed.audit.logs.filter.class";
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_DEFAULT = DetailedRequestAuditLogFilter.class.getName();
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_CLASS_DOC = "Class of detailed request audit log filter which can be used to enable a subset of requests for audit logging.";
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS = "confluent.apply.create.topic.policy.to.create.partitions";
    public static final boolean APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DEFAULT = false;
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DOC = "If this is set, CreateTopicsPolicy will also apply to CreatePartitions.";
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX = "confluent.verify.group.subscription.prefix";
    public static final boolean VERIFY_GROUP_SUBSCRIPTION_PREFIX_DEFAULT = false;
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX_DOC = "If this is set, the group coordinator will verify that the subscriptions are prefixed with the tenant.";
    public static final String STRAY_PARTITION_DELETION_ENABLE_CONFIG = "confluent.enable.stray.partition.deletion";
    public static final boolean STRAY_PARTITION_DELETION_ENABLE_DEFAULT = false;
    public static final String STRAY_PARTITION_DELETION_ENABLE_DOC = "Whether stray partition deletion is enabled";
    public static final String STRAY_LOG_DELETE_DELAY_MS_CONFIG = "confluent.stray.log.delete.delay.ms";
    public static final long STRAY_LOG_DELETE_DELAY_MS_DEFAULT = 604800000L;
    public static final String STRAY_LOG_DELETE_DELAY_MS_DOC = "Backoff time before actual deletion of stray logs";
    public static final String STRAY_LOG_MAX_DELETIONS_PER_RUN_CONFIG = "confluent.stray.log.max.deletions.per.run";
    public static final int STRAY_LOG_MAX_DELETIONS_PER_RUN_DEFAULT = 72;
    public static final String STRAY_LOG_MAX_DELETIONS_PER_RUN_DOC = "Max number of logs to be deleted in a single run of stray log deletion job.";
    public static final String CRN_AUTHORITY_PREFIX = "confluent.authorizer.authority.";
    public static final String CRN_AUTHORITY_NAME_CONFIG = "confluent.authorizer.authority.name";
    public static final String CRN_AUTHORITY_NAME_DEFAULT = "";
    public static final String CRN_AUTHORITY_NAME_DOC = "The DNS name of the authority that this clusteruses to authorize. This should be a name for the cluster hosting metadata topics.";
    public static final String EVENT_LOGGER_PREFIX = "event.logger.";
    public static final String AUDIT_PREFIX = "confluent.security.";
    public static final String AUDIT_EVENT_LOGGER_PREFIX = "confluent.security.event.logger.";
    public static final String AUDIT_EVENT_ROUTER_PREFIX = "confluent.security.event.router.";
    public static final String AUDIT_EVENT_ROUTER_CONFIG = "confluent.security.event.router.config";
    public static final String AUDIT_EVENT_ROUTER_DEFAULT = "";
    public static final String AUDIT_EVENT_ROUTER_DOC = "JSON configuration for routing events to topics";
    public static final String AUDIT_LOGGER_ENABLE_CONFIG = "confluent.security.event.logger.enable";
    public static final String AUDIT_LOGGER_ENABLE_DEFAULT = "true";
    public static final String AUDIT_LOGGER_ENABLE_DOC = "Whether the event logger is enabled";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.replicas";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DEFAULT = "3";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DOC = "Replication factor for audit log topics";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.enable";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DEFAULT = "false";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DOC = "Enable authentication audit logs";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID = "confluent.security.event.logger.physical.cluster.id";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID_DEFAULT = "";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID_DOC = "Physical cluster id of the source cluster";
    public static final String RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.event.rate.limit";
    public static final int RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which authentication audit events are sent to the clearing house per second";
    public static final String RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS = "confluent.security.event.logger.authorization.event.rate.limit";
    public static final int RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which authorization audit events are sent to the clearing house per second";
    public static final String RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS = "confluent.security.event.logger.kafka.request.rate.limit";
    public static final int RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which kafka requests (kafka management, produce or consume) are processed to extract and send audit events to the clearing house per second.";
    public static final String CLUSTER_REGISTRY_CONFIG = "confluent.metadata.server.cluster.registry.clusters";
    public static final String CLUSTER_REGISTRY_CONFIG_DEFAULT = "[]";
    public static final String CLUSTER_REGISTRY_CONFIG_DOC = "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.";
    public static final String ENABLE_FIPS_CONFIG = "enable.fips";
    public static final String ENABLE_FIPS_DEFAULT = "false";
    public static final String ENABLE_FIPS_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, broker listener security protocols, TLS versions and cipher suites will be validated based on FIPS compliance requirement.";
    public static final String TRAFFIC_NETWORK_ID_CONFIG = "confluent.traffic.network.id";
    public static final String TRAFFIC_NETWORK_ID_DEFAULT = "";
    public static final String TRAFFIC_NETWORK_ID_DOC = "The network ID that this cluster belongs to.";
    public static final String CLUSTER_LINK_ENABLE_CONFIG = "confluent.cluster.link.enable";
    public static final boolean CLUSTER_LINK_ENABLE_DEFAULT = true;
    public static final String CLUSTER_LINK_ENABLE_DOC = "Enable cluster linking feature.";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_CONFIG = "confluent.cluster.link.fetch.response.total.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_CONFIG = "confluent.cluster.link.fetch.response.min.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_DOC = "Maximum amount of data fetched by all cluster link fetchers in a broker. If total 'replica.fetch.response.max.bytes' for all fetchers on the broker exceeds this value, all cluster link fetchers reduce their response size to meet this limit. Minimum value for each fetcher can be configured using 'confluent.cluster.link.fetch.response.min.bytes'.";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_DOC = "Minimum fetch response size used by cluster link fetchers if the total size is limited by 'confluent.cluster.link.fetch.response.total.bytes'.";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_CONFIG = "confluent.cluster.link.io.max.bytes.per.second";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_DOC = "A long value representing the upper bound (bytes/sec) on throughput for cluster link replication. It is suggested that the limit be kept above 1MB/s for accurate behaviour.";
    public static final String CLUSTER_LINK_LOCAL_REVERSE_CONNECTION_LISTENER_MAP_CONFIG = "confluent.cluster.link.local.reverse.connection.listener.map";
    public static final String CLUSTER_LINK_LOCAL_REVERSE_CONNECTION_LISTENER_MAP_DOC = "A map from listener name to listener name for configuring the cluster link local.listener.name, which is used to establish local end of reverse connections.";
    public static final String CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_CONFIG = "confluent.cluster.link.allow.config.providers";
    public static final boolean CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_DEFAULT = true;
    public static final String CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_DOC = "Allow cluster link to use config providers to resolve the cluster link configurations.";
    public static final String CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_CONFIG = "confluent.cluster.link.fetcher.auto.tune.enable";
    public static final boolean CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_DOC = "Enable cluster link fetcher auto tuning. The number of cluster link fetchers will be automatically increased or decreased to achieve optimal cluster link throughput.";
    public static final String CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_CONFIG = "confluent.cluster.link.allow.truncation.below.hwm";
    public static final boolean CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_DEFAULT = true;
    public static final String CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_DOC = "Allow cluster link to truncate the mirror topic partitions below high watermark. Disallowing truncation below high watermark is only effective for cluster links between Confluent Cloud clusters.";
    public static final String ENABLE_FIPS_CONNECT_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, worker listener security protocols, TLS versions and cipher suites and rest protocols will be validated based on FIPS compliance requirement.";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_CONFIG = "confluent.cluster.link.replication.quota.mode";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_DOC = "The default mode for cluster link quota for all tenants that applies to 'confluent.cluster.link.io.max.bytes.per.second' if not overridden by confluent.cluster.link.replication.quota.mode.per.tenant.overrides. The mode indicates which inbound traffic is counted towards the limit. Valid values are '" + (Object)((Object)ClusterLinkQuotaMode.CLUSTER_LINK_ONLY) + "' and '" + (Object)((Object)ClusterLinkQuotaMode.TOTAL_INBOUND) + "'.";
    public static final String CLUSTER_LINK_TENANT_QUOTAS_ENABLE_CONFIG = "confluent.cluster.link.tenant.quotas.enable";
    public static final boolean CLUSTER_LINK_TENANT_QUOTAS_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_TENANT_QUOTAS_ENABLE_DOC = "Enable tenant quotas for cluster linking on this cluster, this will be true for multi tenant clusters and false for dedicated clusters.";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_CONFIG = "confluent.cluster.link.replication.quota.mode.per.tenant.overrides";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_DEFAULT = "";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_DOC = "A comma-separated list of per-tenant overrides to the default cluster link quota mode. An example value is \"lkc-abcd:CLUSTER_LINK_ONLY\",\"lkc-efgh:TOTAL_INBOUND\"";
    public static final String CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_CONFIG = "confluent.cluster.link.max.client.connections";
    public static final int CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_DEFAULT = Integer.MAX_VALUE;
    public static final String CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_DOC = "The maximum number of active cluster linking client connections allowed on the broker.";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_CONFIG = "confluent.cluster.link.replication.quota.window.num";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_DOC = "The number of samples to retain in memory for cluster link replication quotas";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_CONFIG = "confluent.cluster.link.replication.quota.window.size.seconds";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for cluster link replication quotas";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_CAPACITY_CONFIG = "confluent.cluster.link.request.quota.capacity";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_CAPACITY_DOC = "The total capacity i.e. broker quota limit for the total amount of time cluster link requests can spend on fetcher and background threads if tenant quotas are enabled. This is configured as total percentage of CPU i.e. a value of 400 means cluster link can use up to 4 CPUs.";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_CONFIG = "confluent.cluster.link.request.quota.request.percentage.multiplier";
    public static final Double CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DEFAULT = 1.0;
    public static final String CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DOC = "The multiplier used to derive broker cluster link request percentage from the broker request percentage, for e.g. a multiplier of 0.1 gives 10% request capacity to cluster link of what the normal produce/consume gets, the default value is 1.0.";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_CONFIG = "confluent.cluster.link.metadata.topic.enable";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_DOC = "Whether the cluster link metadata topic should be created and used. Only applicable in ZK mode";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_CONFIG = "confluent.cluster.link.metadata.topic.partitions";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_DOC = "Number of partitions for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.cluster.link.metadata.topic.replication.factor";
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor the for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_CONFIG = "confluent.cluster.link.metadata.topic.min.isr";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_DOC = "The minimum number of in sync replicas for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_CONFIG = "confluent.cluster.link.metadata.topic.create.retry.delay.ms";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_DOC = "The retry delay in milliseconds when the attempt to create cluster linking metadata topic is failed";
    public static final String CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_CONFIG = "confluent.cluster.link.allow.legacy.message.format";
    public static final Boolean CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_DEFAULT = false;
    public static final String CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_DOC = "Whether or not to allow mirroring v0/v1 messages into the topic";
    public static final String CLUSTER_LINK_ENABLE_LOCAL_ADMIN_CONFIG = "confluent.cluster.link.enable.local.admin";
    public static final Boolean CLUSTER_LINK_ENABLE_LOCAL_ADMIN_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_LOCAL_ADMIN_DOC = "Whether internal cluster link operations may use an optimized local admin that obtains metadata from its metadata cache and sends some requests directly to KRaft controller.";
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_CONFIG = "confluent.cluster.link.enable.metrics.reduction";
    public static final Boolean CLUSTER_LINK_ENABLE_METRICS_REDUCTION_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_DOC = "Controls whether certain metrics emitted per link are reduced to emit only when they have a non default value.";
    public static final String CLUSTER_LINK_NUM_BACKGROUND_THREADS_CONFIG = "confluent.cluster.link.num.background.threads";
    public static final int CLUSTER_LINK_NUM_BACKGROUND_THREADS_DEFAULT = 1;
    public static final String CLUSTER_LINK_NUM_BACKGROUND_THREADS_DOC = "Maximum number of threads used for cluster linking background tasks including periodic migration of metadata.";
    public static final String CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_CONFIG = "confluent.cluster.link.background.thread.affinity";
    public static final ClusterLinkThreadAffinity CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_DEFAULT = ClusterLinkThreadAffinity.LINK;
    public static final String CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_DOC = "Indicates the grouping of cluster links for allocation of background scheduler threads configured using confluent.cluster.link.num.background.threads. Valid values are " + Utils.join(Arrays.asList(ClusterLinkThreadAffinity.values()), ",") + " By default, all tasks of a link share the same thread.";
    public static final String CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_CONFIG = "confluent.cluster.link.clients.max.idle.ms";
    public static final Long CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_DEFAULT = TimeUnit.MILLISECONDS.convert(36500L, TimeUnit.DAYS);
    public static final String CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_DOC = "The interval in milliseconds after which idle cluster link clients and associated threads are closed.";
    public static final String CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_CONFIG = "confluent.cluster.link.mirror.transition.batch.size";
    public static final int CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_DEFAULT = 50;
    public static final String CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_DOC = "The maximum number of mirror topics of a cluster link included in each batch while processing state transitions like promote, failover and failback.";
    public static final String CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_CONFIG = "confluent.cluster.link.admin.request.batch.size";
    public static final int CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_DEFAULT = 1;
    public static final String CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_DOC = "The maximum number of mirror topics, partitions or consumer groups from multiple background task admin requests that may be batched together. No batching is performed with the default size of 1. Individual requests containing resources exceeding this limit are processed as-is without splitting.";
    public static final String CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_CONFIG = "confluent.cluster.link.admin.max.in.flight.requests";
    public static final int CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_DEFAULT = 1000;
    public static final String CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_DOC = "The maximum number of in-flight requests that are queued on a cluster link admin client when batching is enabled with confluent.cluster.link.admin.request.batch.size greater than 1.";
    public static final String CLUSTER_LINK_AVAILABILITY_CHECK_MODE_CONFIG = "confluent.cluster.link.availability.check.mode";
    public static final ClusterLinkAvailabilityCheckMode CLUSTER_LINK_AVAILABILITY_CHECK_MODE_DEFAULT = ClusterLinkAvailabilityCheckMode.ALL;
    public static final String CLUSTER_LINK_AVAILABILITY_CHECK_MODE_DOC = "Configure the brokers on which remote availability check is scheduled for cluster links.";
    public static final String CCLOUD_HOST_SUFFIXES_CONFIG = "confluent.ccloud.host.suffixes";
    public static final String CCLOUD_HOST_SUFFIXES_DEFAULT = ".confluent.cloud,.cpdev.cloud,.confluentgov.com,.confluentgov-internal.com";
    public static final String CCLOUD_HOST_SUFFIXES_DOC = "Comma separated list of confluent cloud host suffixes used to determine things like whether this is a cloud to cloud cluster link. It MUST BE SPECIFIED IN CCLOUD environment!. An example of config value is \".cpdev.cloud,.confluent.cloud\" ";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_CONFIG = "confluent.security.revoked.certificate.ids";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_DEFAULT = "";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_DOC = "JSON configuration for revoked certificate ids, this is used to block mTLS authentication of revoked certificates. The format of property is [{\"issuer\":\"C = US, O = Let's Encrypt, CN = R3\",\"serialNumbers\":[\"b5f6f3b84479c5e8\",\"618f7a9150bfb1bb\"]}] and the issuer is in RFC 2253 format. The serialNumbers is a list of hex encoded serial numbers without the colon.";
    public static final String INTERNAL_REST_SERVER_BIND_PORT_CONFIG = "confluent.internal.rest.server.bind.port";
    public static final Integer INTERNAL_REST_SERVER_BIND_PORT_DEFAULT = null;
    public static final String INTERNAL_REST_SERVER_BIND_PORT_DOC = "The port to bind the internal rest server to.";
    public static final String HTTP_SERVER_START_TIMEOUT_MS_CONFIG = "confluent.http.server.start.timeout.ms";
    public static final Long HTTP_SERVER_START_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
    public static final String HTTP_SERVER_START_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to start up, in milliseconds. Default is 60s.";
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_CONFIG = "confluent.http.server.stop.timeout.ms";
    public static final Long HTTP_SERVER_STOP_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to shutdown, in milliseconds. Default is 30s.";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.producer.rate";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Maximum producer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.consumer.rate";
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Maximum consumer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String DEFAULT_PRODUCER_ID_RATE_PER_TENANT_CONFIG = "confluent.quota.tenant.default.producer.id.rate";
    public static final String DEFAULT_PRODUCER_ID_RATE_PER_TENANT_DOC = "Producer id quota count per tenant per broker";
    public static final double DEFAULT_PRODUCER_ID_RATE_PER_TENANT_DEFAULT = 2.147483647E9;
    public static final String TENANT_USER_QUOTAS_ENABLE_CONFIG = "confluent.quota.tenant.user.quotas.enable";
    public static final String TENANT_USER_QUOTAS_ENABLE_DOC = "If enabled, return service-account quotas from TenantQuotaCallback.";
    public static final boolean TENANT_USER_QUOTAS_ENABLE_DEFAULT = false;
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE = "confluent.multitenant.listener.hostname.cluster.prefix.enable";
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE_DOC = "If enabled, return tenant-specific broker endpoints by prepending tenant cluster id to the advertised hostname configured for multi-tenant listeners";
    public static final boolean MULTITENANT_LISTENER_PREFIX_ENABLE_DEFAULT = false;
    public static final String PARSE_SNI_HOST_NAME_ENABLED = "confluent.multitenant.parse.sni.host.name.enable";
    public static final String PARSE_SNI_HOST_NAME_ENABLED_DOC = "When enabled, parse the SNI host name upon SASL_SSL connection establishment.";
    public static final boolean PARSE_SNI_HOST_NAME_ENABLED_DEFAULT = false;
    public static final String PARSE_LKC_ID_ENABLED_CONFIG = "confluent.multitenant.parse.lkc.id.enable";
    public static final String PARSE_LKC_ID_ENABLED_DOC = "When enabled, parse the LKC Id upon SASL_SSL connection establishment.";
    public static final boolean PARSE_LKC_ID_ENABLED_DEFAULT = false;
    public static final String TOPIC_REPLICA_ASSIGNOR_BUILDER = "confluent.topic.replica.assignor.builder.class";
    public static final String TOPIC_REPLICA_ASSIGNOR_DOC = "The configurable builder class for the replica assignor used to assign replicas on topic/partition creation without explicit assignment.";
    public static final String TOPIC_REPLICA_ASSIGNOR_DEFAULT = "";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES = "confluent.spiffe.id.principal.extraction.rules";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES_DOC = "Used to specify the rules for mapping SPIFFE IDs to principals. The parameter can be either an empty string (\"\") or a list of rules separated by commas. Each rule follows the format \"RULE:(regex)!(extraction logic)!(case)\". A rule comprises three parts separated by \"!\": a regular expression to match the incoming SPIFFE ID, a pattern for extracting the principal if the ID matches, and an optional specification for converting the extracted principal to uppercase (U) or lowercase (L). Multiple rules can be provided, each separated by commas.";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES_DEFAULT = "";
    public static final String METADATA_COLLECTOR_ENABLE = "confluent.catalog.collector.enable";
    public static final String METADATA_COLLECTOR_ENABLE_DOC = "When enabled, collect metadata for catalog.";
    public static final boolean METADATA_COLLECTOR_ENABLE_DEFAULT = false;
    public static final String METADATA_COLLECTOR_FULL_CONFIGS_ENABLE = "confluent.catalog.collector.full.configs.enable";
    public static final String METADATA_COLLECTOR_FULL_CONFIGS_ENABLE_DOC = "When enabled, collect full topic configs. Other wise collect subset of topic configs";
    public static final boolean METADATA_COLLECTOR_FULL_CONFIGS_ENABLE_DEFAULT = false;
    public static final String METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_SEC = "confluent.catalog.collector.snapshot.init.delay.sec";
    public static final String METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_DOC = "The configurable initial delay in seconds for the collector to take snapshot";
    public static final int METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_DEFAULT = 60;
    public static final String METADATA_COLLECTOR_SNAPSHOT_INTERVAL_SEC = "confluent.catalog.collector.snapshot.interval.sec";
    public static final String METADATA_COLLECTOR_SNAPSHOT_INTERVAL_DOC = "The configurable interval in seconds for the collector to take snapshot";
    public static final int METADATA_COLLECTOR_SNAPSHOT_INTERVAL_DEFAULT = 300;
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC = "confluent.catalog.collector.destination.topic";
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC_DOC = "The topic where metadata collector will emit events to.";
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC_DEFAULT = "telemetry.events.data_catalog_source";
    public static final String METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT = "confluent.catalog.collector.max.bytes.per.snapshot";
    public static final String METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT_DOC = "The maximum bytes allow per snapshot";
    public static final Integer METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT_DEFAULT = 850000;
    public static final String METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC = "confluent.catalog.collector.max.zookeeper.request.per.sec";
    public static final String METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC_DOC = "The maximum number of requests per second that collector allow to make to zookeeper";
    public static final Integer METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC_DEFAULT = 100;
    public static final String METADATA_COLLECTOR_MAX_TOPICS_PROCESS = "confluent.catalog.collector.max.topics.process";
    public static final String METADATA_COLLECTOR_MAX_TOPICS_PROCESS_DOC = "The maximum number of topics in batch that collector allow to process when start up. This config only apply for zookeeper based controller.";
    public static final Integer METADATA_COLLECTOR_MAX_TOPICS_PROCESS_DEFAULT = 500;
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE = "confluent.connection.invalid.request.delay.enable";
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE_DOC = "When enabled, delay closing connections that fail in request parsing.The delay used will be from `\"connection.failed.authentication.delay.ms\"`";
    public static final boolean DELAY_CLOSING_INVALID_REQUEST_ENABLE_DEFAULT = false;
    public static final String MAX_CONNECTIONS_PER_TENANT = "max.connections.per.tenant";
    public static final String MAX_CONNECTIONS_PER_TENANT_DOC = "The maximum number of connections we allow from each tenant. This can be set to 0 if there are overrides configured using 'max.connections.per.tenant' property. New connections from the tenant are dropped if the limit is reached.";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP = "confluent.max.connection.creation.rate.per.ip";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP_DOC = "An int representing the upper bound of connection rate accepted for each IP. This config is a static equivalent to the dynamic connection_creation_rate quota for the default IP entity";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_TENANT = "confluent.max.connection.creation.rate.per.tenant";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_TENANT_DOC = "An int representing the upper bound of connection rate accepted for each tenant. This config is a static equivalent to the dynamic tenant connection_creation_rate quota for the default tenant entity";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_IP = "confluent.max.connection.rate.per.ip";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the max for autotuning the connection rate accepted for each IP.";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.max.connection.rate.per.tenant";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the max for autotuning the connection rate accepted for each tenant.";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_IP = "confluent.floor.connection.rate.per.ip";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the floor for autotuning the connection rate accepted for each IP.";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.floor.connection.rate.per.tenant";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the floor for autotuning the connection rate accepted for each tenant.";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_IP = "confluent.step.connection.rate.per.ip";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the increment size for autotuning the connection rate accepted for each IP. Defaults to 0.0 (no autotuning).";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.step.connection.rate.per.tenant";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the increment size for autotuning the connection rate accepted for each tenant. Defaults to 0.0 (no autotuning).";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD = "max.connection.creation.rate.per.ip.enable.threshold";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DOC = "A double representing the proportional threshold for listener connection rate after which to apply IP rate limits";
    public static final double IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DEFAULT = 0.0;
    public static final String TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD = "max.connection.creation.rate.per.tenant.enable.threshold";
    public static final String TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DOC = "A double representing the proportional threshold for listener connection rate after which to apply tenant rate limits";
    public static final double TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DEFAULT = 0.0;
    public static final String MAX_CONNECTION_THROTTLE_MS = "confluent.max.connection.throttle.ms";
    public static final String MAX_CONNECTION_THROTTLE_MS_DOC = "An int representing the max time in milliseconds to throttle accepting a connection. If not set \"quota.window.size.seconds\" will be used to bound connection acceptance throttling.";
    public static final Long MAX_CONNECTION_THROTTLE_MS_DEFAULT = null;
    public static final String MIN_CONNECTION_THROTTLE_MS = "confluent.min.connection.throttle.ms";
    public static final String MIN_CONNECTION_THROTTLE_MS_DOC = "An int representing the min time in milliseconds to throttle accepting a connection.";
    public static final Long MIN_CONNECTION_THROTTLE_MS_DEFAULT = 0L;
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_CONFIG = "confluent.connections.idle.expiry.manager.ignore.idleness.requests";
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_DEFAULT = "";
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_DOC = "A list of request types, representing requests where idle expiry manager will ignore updating their idleness.";
    public static final String CONNECTIONS_MAX_AGE_MS = "connections.max.age.ms";
    public static final Long CONNECTIONS_MAX_AGE_MS_DEFAULT;
    public static final Long CONNECTIONS_MAX_AGE_MS_MAX;
    public static final String CONNECTIONS_MAX_AGE_MS_DOC;
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_MS = "connection.min.expire.interval.ms";
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_DOC = "Minimum interval in milliseconds between closing of expired connections on a single server socket processor thread.";
    public static final Long CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT;
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_CONFIG = "confluent.close.connections.on.credential.delete";
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DOC = "When enabled, broker will terminate all existing connections using a deleted credential if the broker is notified of a deleted credential by a broker plugin that manages credentials.";
    public static final boolean CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DEFAULT = false;
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_CONFIG = "confluent.password.encoder.old.secret.ttl.ms";
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DOC = "The minimum amount of time in milliseconds that configs encrypted using old encryption secret 'password.encoder.old.secret' should be retained.";
    public static final long PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DEFAULT = Long.MAX_VALUE;
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.producer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Minimum producer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.consumer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Minimum consumer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String DURABILITY_AUDIT_ENABLE = "confluent.durability.audit.enable";
    public static final String DURABILITY_AUDIT_ENABLE_DOC = "If enabled, this will start the long-lived durability audits";
    public static final boolean DURABILITY_AUDIT_ENABLE_DEFAULT = false;
    public static final String DURABILITY_AUDIT_CHECKS = "confluent.durability.audit.checks";
    public static final String DURABILITY_AUDIT_CHECKS_DOC = "Comma-separated list of the audit checks types that will be allowed by AuditManager.";
    public static final String DURABILITY_AUDIT_CHECKS_DEFAULT = "PeriodicalAudit,ChecksumAudit";
    public static final String DURABILITY_ALLOWED_EVENTS = "confluent.durability.events.allowed";
    public static final String DURABILITY_ALLOWED_EVENTS_DOC = "Comma-separated list of the event types that will be accepted by AuditManager.";
    public static final String DURABILITY_ALLOWED_EVENTS_DEFAULT = "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType";
    public static final String DURABILITY_AUDIT_IDEMPOTENT_PRODUCER = "confluent.durability.audit.idempotent.producer";
    public static final String DURABILITY_AUDIT_IDEMPOTENT_PRODUCER_DOC = "Option to use idempotent producer for durability audit";
    public static final boolean DURABILITY_AUDIT_IDEMPOTENT_PRODUCER_DEFAULT = false;
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR = "confluent.durability.topic.replication.factor";
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT;
    public static final String DURABILITY_TOPIC_PARTITION_COUNT = "confluent.durability.topic.partition.count";
    public static final String DURABILITY_TOPIC_PARTITION_COUNT_DOC = "Partition count of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT;
    public static final String DURABILITY_AUDIT_IO_BYTES_PER_SEC = "confluent.durability.audit.io.bytes.per.sec";
    public static final String DURABILITY_AUDIT_IO_BYTES_PER_SEC_DOC = "The rate at which we want to throttle I/O operations in DA, current used only for compacted topics";
    public static final long DURABILITY_AUDIT_IO_BYTES_PER_SEC_DEFAULT = 0xA00000L;
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS = "confluent.durability.audit.reporting.batch.ms";
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS_DOC = "Time to linger and consolidate durability audit error metrics before reporting";
    public static final Integer DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS = "confluent.durability.audit.batch.flush.frequency.ms";
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DOC = "Frequency of flushing batch events of durability audit";
    public static final Integer DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS = "confluent.durability.audit.initial.job.delay.ms";
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DOC = "Initial durability audit job delay";
    public static final Long DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT;
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_CONFIG = "confluent.quota.tenant.default.controller.mutation.rate";
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DOC = "The rate per tenant at which mutations are accepted for the create topics request, the create partitions request and the delete topics request. The rate is accumulated by the number of partitions created or deleted.";
    public static final double DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DEFAULT = 2.147483647E9;
    public static final String CELL_TAG = "confluent.cell";
    public static final String MAX_REPLICAS_PER_BROKER_CONFIG = "confluent.plugins.topic.policy.max.replicas.per.broker";
    public static final String MAX_REPLICAS_PER_BROKER_DOC = "The maximum replicas per broker.";
    public static final int MAX_REPLICAS_PER_BROKER_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_PARTITIONS_PER_TENANT_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.tenant";
    public static final String MAX_PARTITIONS_PER_TENANT_DOC = "The maximum partitions per tenant.";
    public static final int MAX_PARTITIONS_PER_TENANT_DEFAULT = 512;
    public static final String MAX_PARTITIONS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.cluster";
    public static final String MAX_PARTITIONS_PER_CLUSTER_DOC = "The maximum partitions per physical cluster.";
    public static final int MAX_PARTITIONS_PER_CLUSTER_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_TOPICS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.topics.per.cluster";
    public static final String MAX_TOPICS_PER_CLUSTER_DOC = "The maximum topics per physical cluster.";
    public static final int MAX_TOPICS_PER_CLUSTER_DEFAULT = Integer.MAX_VALUE;
    public static final String MIN_CELL_SIZE_CONFIG = "confluent.cells.min.size";
    public static final String MIN_CELL_SIZE_DOC = "The minimum brokers per cell.";
    public static final short MIN_CELL_SIZE_DEFAULT = 6;
    public static final String MAX_CELL_SIZE_CONFIG = "confluent.cells.max.size";
    public static final String MAX_CELL_SIZE_DOC = "The maximum brokers per cell.";
    public static final short MAX_CELL_SIZE_DEFAULT = 15;
    public static final String CELL_SIZE_CONFIG = "confluent.cells.default.size";
    public static final String CELL_SIZE_DOC = "The default number of brokers per cell.";
    public static final short CELL_SIZE_DEFAULT = 15;
    public static final String ENABLE_CELLS_CONFIG = "confluent.cells.enable";
    public static final String ENABLE_CELLS_DOC = "Whether to enable the cells feature (sub-flags also need to be enabled to turn on cells)";
    public static final boolean ENABLE_CELLS_DEFAULT = false;
    public static final String ENABLE_CELLS_IMPLICIT_CREATION_CONFIG = "confluent.cells.implicit.creation.enable";
    public static final String ENABLE_CELLS_IMPLICIT_CREATION_DOC = "Whether to enable implicit cell creation";
    public static final boolean ENABLE_CELLS_IMPLICIT_CREATION_DEFAULT = false;
    public static final String ENABLE_CELL_LOAD_REFRESHER_CONFIG = "confluent.cells.load.refresher.enable";
    public static final String ENABLE_CELL_LOAD_REFRESHER_DOC = "Whether to enable the cell load refresher";
    public static final boolean ENABLE_CELL_LOAD_REFRESHER_DEFAULT = true;
    public static final String OMIT_NETWORK_PROCESSOR_METRIC_TAG = "confluent.omit.network.processor.metric.tag";
    public static final String OMIT_NETWORK_PROCESSOR_METRIC_TAG_DOC = "Whether to omit network processed metric tag.";
    public static final boolean OMIT_NETWORK_PROCESSOR_METRIC_TAG_DEFAULT = false;
    public static final String TRACK_TENANT_ID_PER_IP = "confluent.track.tenant.id.per.ip";
    public static final String TRACK_TENANT_ID_PER_IP_DOC = "Whether to track tenant id per ip on the broker if passing authentication.";
    public static final boolean TRACK_TENANT_ID_PER_IP_DEFAULT = false;
    public static final String TRACK_API_KEY_PER_IP = "confluent.track.api.key.per.ip";
    public static final String TRACK_API_KEY_PER_IP_DOC = "Whether to track api key per ip on the broker if failing authentication.";
    public static final boolean TRACK_API_KEY_PER_IP_DEFAULT = false;
    public static final String TRACK_IP_MAPPING_MAX_SIZE_CONFIG = "confluent.track.per.ip.max.size";
    public static final String TRACK_IP_MAPPING_MAX_SIZE_DOC = "Max size of the ip to api key and ip to tenantId mapping.";
    public static final int TRACK_IP_MAPPING_MAX_SIZE_DEFAULT = 100000;
    public static final String DEFAULT_PARTITION_PLACEMENT_STRATEGY_CONFIG = "confluent.topic.partition.default.placement";
    public static final String DEFAULT_PARTITION_PLACEMENT_STRATEGY_DOC = "The default partition placement strategy (partition in cell, tenant in cell, or cluster wide)";
    public static final int DEFAULT_PARTITION_PLACEMENT_STRATEGY = 2;
    public static final String MAX_DEST_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.destination.links.per.tenant";
    public static final String MAX_DEST_LINKS_PER_TENANT_DOC = "The maximum destination cluster links per tenant.";
    public static final int MAX_DEST_LINKS_PER_TENANT_DEFAULT = 5;
    public static final String MAX_SOURCE_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.source.links.per.tenant";
    public static final String MAX_SOURCE_LINKS_PER_TENANT_DOC = "The maximum source cluster links per tenant. This limit is only applicable to source initiated links.";
    public static final int MAX_SOURCE_LINKS_PER_TENANT_DEFAULT = 5;
    private static final String BROKER_LOAD_PREFIX = "confluent.broker.load.";
    public static final String BROKER_LOAD_ENABLED_CONFIG = "confluent.broker.load.enabled";
    public static final String BROKER_LOAD_ENABLED_DOC = "Whether the broker load metric is enabled";
    public static final boolean BROKER_LOAD_ENABLED_DEFAULT = false;
    public static final String BROKER_LOAD_TENANT_METRIC_ENABLE_CONFIG = "confluent.broker.load.tenant.metric.enable";
    public static final String BROKER_LOAD_TENANT_METRIC_ENABLE_DOC = "Whether the broker load metric should be customer-visible by tagging it with their logical Kafka clusters";
    public static final boolean BROKER_LOAD_TENANT_METRIC_ENABLE_DEFAULT = false;
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_CONFIG = "confluent.broker.load.update.metric.tags.interval.ms";
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DOC = "Interval for which to update the broker load metric tags in case of Kafka LKC changes";
    public static final long BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT;
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_CONFIG = "confluent.broker.load.window.size.ms";
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_DOC = "The interval (in milliseconds) between request or connection samples for calculating the broker load";
    public static final long BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT;
    public static final String BROKER_LOAD_NUM_SAMPLES_CONFIG = "confluent.broker.load.num.samples";
    public static final String BROKER_LOAD_NUM_SAMPLES_DOC = "The number of samples to include in a calculation window";
    public static final int BROKER_LOAD_NUM_SAMPLES_DEFAULT = 60;
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_CONFIG = "confluent.broker.load.average.service.request.time.ms";
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DOC = "The average time taken to service a request on the broker";
    public static final double BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DEFAULT = 0.1;
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_CONFIG = "confluent.broker.load.workload.coefficient";
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_DOC = "A constant to tune the broker load for a specific workload characteristic";
    public static final double BROKER_LOAD_WORKLOAD_COEFFICIENT_DEFAULT = 20.0;
    public static final String BROKER_LOAD_DELAY_METRIC_START_MS_CONFIG = "confluent.broker.load.delay.metric.start.ms";
    public static final String BROKER_LOAD_START_METRIC_DELAY_MS_DOC = "The time (in milliseconds) to delay the start of the broker load metric after we start processing requests";
    public static final long BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT;
    public static final String BROKER_LOAD_ADVERTISED_LIMIT_LOAD_CONFIG = "confluent.broker.load.advertised.limit.load";
    public static final String BROKER_LOAD_ADVERTISED_LIMIT_LOAD_DOC = "The value of the broker load metric when the advertised limit is hit";
    public static final double BROKER_LOAD_ADVERTISED_LIMIT_LOAD_DEFAULT = 0.8;
    public static final String PROXY_PROTOCOL_VERSION = "confluent.proxy.protocol.version";
    public static final String PROXY_PROTOCOL_VERSION_DOC = "The version of the PROXY protocol that the broker will use, or NONE if the PROXY protocol will not be used. This value can be overridden for each listener by prefixing the config with the normalized listener name. For example, to enable V1 of the protocol for the EXTERNAL listener, set <code>listener.name.external.confluent.proxy.protocol.version=V1</code>. Because the inter-broker listener and any admin listeners will likely not be accessed through a proxy, the typical configuration would be to use the default value of NONE and enable the protocol explicitly for a subset of listeners. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.";
    public static final String PROXY_PROTOCOL_VERSION_DEFAULT;
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED = "confluent.proxy.protocol.fallback.enabled";
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED_DOC = "If true, and if <code>confluent.proxy.protocol.version</code> is not set to <code>NONE</code>, the network layer will accept both PROXY and non-PROXY protocol requests. If the PROXY header is present, it will parse it and interpret the specified client IP address and port appropriately; if not, it will fall back to a normal, non-PROXY request. This value can be overridden for each listener by prefixing the config with the normalized listener name.";
    public static final Boolean PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT;
    public static final String PROXY_PROTOCOL_CLIENT_VERSION = "confluent.proxy.protocol.client.version";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DOC = "The version of the PROXY protocol that the client will use, or NONE if the PROXY protocol will not be used. This value must match that of the brokers to which the client is connecting. See the confluent.proxy.protocol.version configuration option for the broker configuration. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT;
    public static final String PROXY_PROTOCOL_CLIENT_ADDRESS = "confluent.proxy.protocol.client.address";
    public static final String PROXY_PROTOCOL_CLIENT_ADDRESS_DOC = "This configuration specifies the connection initiator's IP address. While the configuration option is of type String, the user configuring the client should pass in a value representing an IPv4 or IPv6 address, since the broker will be attempting to parse one of those two IP address types. Note that this should be IP address, not a host name. This configuration option is conditionally required. The default value is null, but if the confluent.proxy.protocol.client.version is set to a valid protocol version, it is an error if this configuration option is not set.";
    public static final String PROXY_PROTOCOL_CLIENT_PORT = "confluent.proxy.protocol.client.port";
    public static final String PROXY_PROTOCOL_CLIENT_PORT_DOC = "This configuration specifies the connection initiator's port. The configuration option is of type Integer, though the port range is within the limits of a 16-bit value. This configuration option is conditionally required. The default value is null, but if the confluent.proxy.protocol.client.version is set to a valid protocol version, it is an error if this configuration option is not set.";
    public static final String PROXY_PROTOCOL_CLIENT_MODE = "confluent.proxy.protocol.client.mode";
    public static final String PROXY_PROTOCOL_CLIENT_MODE_DOC;
    public static final String PROXY_PROTOCOL_CLIENT_MODE_DEFAULT;
    public static final String LKC_ID = "confluent.lkc.id";
    public static final String LKC_ID_DOC;
    public static final String CONSUMER_LAG_EMITTER_ENABLED_CONFIG = "confluent.consumer.lag.emitter.enabled";
    public static final String CONSUMER_LAG_EMITTER_ENABLED_DOC = "Enables consumer lag emitter. The emitter records lag for all consumer groups in the server.";
    public static final boolean CONSUMER_LAG_EMITTER_ENABLED_DEFAULT = false;
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_CONFIG = "confluent.consumer.lag.emitter.interval.ms";
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_DOC = "Interval in which consumer lag is recorded.";
    public static final Long CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT;
    public static final String CHECKSUM_ENABLED_FILES_CONFIG = "confluent.checksum.enabled.files";
    public static final String CHECKSUM_ENABLED_FILES_DOC = "Contains the list of object types in comma separated format for which checksum should be enabled. \"all\" will enable checksums for all files where available, \"none\" will disable checksums for all files, and \"tierstate\" will enable checksums for only tier state files. Currently only \"tierstate\" object type is supported .NOTE: Turning on may prevent downgrades safely to versions that don't support checksumsNOTE: This config is independent of record level batch CRCs";
    public static final String CHECKSUM_ENABLED_FILES_TIERSTATE = "tierstate";
    public static final String CHECKSUM_ENABLED_FILES_ALL = "all";
    public static final String CHECKSUM_ENABLED_FILES_NONE = "none";
    public static final String CHECKSUM_ENABLED_FILES_DEFAULT = "none";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG = "confluent.require.compatible.keystore.updates";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DOC = "This configuration controls whether strict compatibility is required when dynamically updating broker keystores. When enabled, dynamically updated keystores must contain the same number of certificates and each certificate must have matching distinguished names and the alternative names must be a superset of the old certificate. If disabled, then no compatibility checks will be done.";
    public static final Boolean REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT;
    public static final String ELIGIBLE_CONTROLLERS_CONFIG = "confluent.eligible.controllers";
    public static final String ELIGIBLE_CONTROLLERS_DOC = "This configuration provides the ability for zk-based clusters to set an explicit list of the brokers that are eligible to become controller. Brokers which are not included in this list will not attempt to become controller by creating the `/controller` znode. If the current controller is not among the eligible controllers when the configuration is changed dynamically, it will resign so that one of the eligible controllers can be elected. Additionally, when changed dynamically, at least one of the eligible controllers must be online. The default value is an empty list, which we treat as indicating that all brokers are eligible to become controller.";
    public static final List<String> ELIGIBLE_CONTROLLERS_DEFAULT;
    public static final String TRANSACTION_LOGGING_VERBOSITY_CONFIG = "confluent.transaction.logging.verbosity";
    public static final String TRANSACTION_LOGGING_VERBOSITY_DOC = "This configuration controls the verbosity of transaction-related logging. When enabled with a value of 1 or 2, additional logging as well as more verbose logging messages will be displayed at the INFO log level. This is useful when we need to dynamically enable extra logging for a particular cluster indefinitely. The default of 0 means no additional logging. The difference between levels 1 and 2 is that the latter will print all partitions included in each transaction while the former will only print a sampling.";
    public static final Integer TRANSACTION_LOGGING_VERBOSITY_DEFAULT;
    public static final String MIN_SEGMENT_MS_CONFIG = "confluent.min.segment.ms";
    public static final long MIN_SEGMENT_MS_DEFAULT = 1L;
    public static final String MIN_SEGMENT_MS_DOC = "Minimum period of time to force a segment roll. Segment will be rolled after the maximum of the topic's configured segment.ms and min.segment.ms has passed.";
    public static final String MAX_SEGMENT_MS_CONFIG = "confluent.max.segment.ms";
    public static final long MAX_SEGMENT_MS_DEFAULT = Long.MAX_VALUE;
    public static final String MAX_SEGMENT_MS_DOC = "Maximum period of time to force a segment roll. Segment will be rolled after the minimum of the topic's configured segment.ms and max.segment.ms has passed.";
    public static final String SYSTEM_TIME_BASED_ROLL_ENABLE_CONFIG = "confluent.system.time.roll.enable";
    public static final boolean SYSTEM_TIME_BASED_ROLL_ENABLE_DEFAULT = false;
    public static final String SYSTEM_TIME_BASED_ROLL_ENABLE_DOC = "Roll a segment based on system time rather than user timestamp";
    public static final String ROLL_CHECK_INTERVAL_MS_CONFIG = "confluent.roll.check.interval.ms";
    public static final long ROLL_CHECK_INTERVAL_MS_DEFAULT = 300000L;
    public static final String ROLL_CHECK_INTERVAL_MS_DOC = "The interval in milliseconds to check if the active segment should be rolled";
    public static final String EAGER_ROLL_ENABLE_CONFIG = "confluent.segment.eager.roll.enable";
    public static final boolean EAGER_ROLL_ENABLE_DEFAULT = false;
    public static final String EAGER_ROLL_ENABLE_DOC = "If enabled, active segments will roll at a recurring interval whenever the roll conditions are met";
    public static final String MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_CONFIG = "confluent.multitenant.listener.hostname.subdomain.suffix.enable";
    public static final Boolean MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT;
    public static final String MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DOC = "If enabled, append the DNS subdomain parsed from the SNI header to the advertised hostname configured for multitenant listeners";
    public static final String SUBDOMAIN_SEPARATOR_MAP_CONFIG = "confluent.subdomain.separator.map";
    public static final String SUBDOMAIN_SEPARATOR_MAP_DEFAULT;
    public static final String SUBDOMAIN_SEPARATOR_MAP_DOC = "A map from DNS subdomains to separators, used to construct hostnames when using split-path DNS. If defined, the map must include an entry with a 'default' key.";
    public static final String SUBDOMAIN_PREFIX_CONFIG = "confluent.subdomain.prefix";
    public static final String SUBDOMAIN_PREFIX_DEFAULT;
    public static final String SUBDOMAIN_PREFIX_DOC = "A prefix string that the broker can use to identify the DNS subdomain from the SNI header. Everything in the SNI header from this value to the end will be considered the subdomain.";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_CONFIG = "confluent.subdomain.separator.variable";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_DEFAULT = "%sep";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_DOC = "The string that will be replaced in dynamic broker hostnames by the appropriate separator string from confluent.subdomain.separator.map";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_CONFIG = "confluent.metrics.reporter.bootstrap.servers";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for metrics reporting.";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_DEFAULT = "kafka-0:9071";
    public static final String FETCH_PARTITION_PRUNING_ENABLE_CONFIG = "confluent.fetch.partition.pruning.enable";
    public static final String FETCH_PARTITION_PRUNING_ENABLE_DOC = "Specifies if inactive partitions could be ignored when a fetch request from a follower is processed.";
    public static final boolean FETCH_PARTITION_PRUNING_ENABLE_DEFAULT = true;
    public static final String CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_CONFIG = "confluent.consumer.fetch.partition.pruning.enable";
    public static final String CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_DOC = "Specifies if inactive partitions could be ignored when a fetch request from a consumer is processed.";
    public static final boolean CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_DEFAULT = true;
    public static final String FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_CONFIG = "confluent.fetch.from.follower.require.leader.epoch.enable";
    public static final String FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_DOC = "Fetching from follower is only allowed if a leader epoch is provided.";
    public static final boolean FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_DEFAULT = false;
    public static final String DEFER_ISR_SHRINK_ENABLE_CONFIG = "confluent.defer.isr.shrink.enable";
    public static final String DEFER_ISR_SHRINK_ENABLE_DOC = "Defer ISR shrinking for partitions that only have messages with acks = \"all\" if shrinking ISR would make partition fall under min ISR.";
    public static final boolean DEFER_ISR_SHRINK_ENABLE_DEFAULT = false;
    public static final String REQUEST_PIPELINING_ENABLE_CONFIG = "confluent.request.pipelining.enable";
    public static final String REQUEST_PIPELINING_ENABLE_DOC = "Setting this configuration to true enables the broker to process multiple in-flight produce requests per connection.";
    public static final boolean REQUEST_PIPELINING_ENABLE_DEFAULT = true;
    public static final String REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_CONFIG = "confluent.request.pipelining.max.in.flight.requests.per.connection";
    public static final String REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DOC = "This configures the maximum number of in-flight requests per connection if request pipelining is enabled.";
    public static final int REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DEFAULT = 5;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_CONFIG = "confluent.cluster.metadata.snapshot.tier.upload.enable";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_DOC = "Setting this configuration to true, enables KRaft metadata snapshots to be backed up to object store";
    public static final boolean CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_DEFAULT = false;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.enable";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_DOC = "Setting this configuration to true, enables KRaft metadata snapshots backed up to object store to be deleted";
    public static final boolean CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_DEFAULT = false;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.retention.ms";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DOC = "This configures the time duration after which KRaft metadata snapshots backed up to object store should be deleted";
    public static final long CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DEFAULT;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.maintain.min.snapshots";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_DOC = "This configures the minimum number of KRaft metadata snapshots backed up to object store that should always be maintained";
    public static final int CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_DEFAULT = 3;
    public static final String SSL_ENABLE_DYNAMIC_STORE_UPDATE = "confluent.ssl.enable.dynamic.store.update";
    public static final String SSL_ENABLE_DYNAMIC_STORE_UPDATE_DOC = "The config is to enable dynamic update of ssl keystore and truststore when user modifies the key store or trust files. This config doesn't apply to custom factories or stores configured using ssl.keystore.certificate.chain";
    public static final String BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG = "confluent.broker.clients.ssl.file.store.reload.enable";
    public static final String BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG_DOC = "This config enables dynamic reload of SSL key/trust file stores on file update for internal clients running on the broker. default is disabled.";
    public static final String LISTENER_PROXY_MODE_LOCAL_DEFAULT_CONFIG = "confluent.proxy.mode.local.default";
    public static final boolean LISTENER_PROXY_MODE_LOCAL_DEFAULT = false;
    public static final String LISTENER_PROXY_MODE_LOCAL_DEFAULT_ENABLED_DOC = "Boolean value stating whether connections to this listener should be handled like LOCAL proxy connections if no PROXY mode is specified.";
    public static final String ZK_METADATA_MIGRATION_TRIGGER_FILE_CONFIG = "confluent.zookeeper.metadata.migration.trigger.file.path";
    public static final String ZK_METADATA_MIGRATION_TRIGGER_FILE_DOC = "Setting this config enables the delay of ZooKeeper to KRaft metadata migration. If set, the migration will not begin until the file specified by this config exists.";
    public static final String ZK_METADATA_MIGRATION_CONTROLLER_CHECK_DISABLE_CONFIG = "confluent.zookeeper.metadata.migration.controller.check.disable";
    public static final String ZK_METADATA_MIGRATION_CONTROLLER_CHECK_DISABLE_DOC = "Disable the pre-migration check of the controller quorum readiness.";
    public static final String METADATA_ENCRYPTOR_REQUIRED_CONFIG = "confluent.metadata.encryptor.required";
    public static final String METADATA_ENCRYPTOR_REQUIRED_DOC = "When true, the node will fail to start if no metadata log encryptor is available.";
    public static final String METADATA_ENCRYPTOR_SECRET_FILE_CONFIG = "confluent.metadata.encryptor.secret.file";
    public static final String METADATA_ENCRYPTOR_SECRET_FILE_DOC = "K8s secret file to read for metadata encryptor secrets.";
    public static final String HEAP_WATCHER_TENURED_PREFIX = "confluent.heap.tenured.notify.";
    public static final String HEAP_WATCHER_TENURED_ENABLED_CONFIG = "confluent.heap.tenured.notify.enabled";
    public static final String HEAP_WATCHER_TENURED_ENABLED_DOC = "Should we alert on almost-OOMs when the tenured heap pool is above the alert limit";
    public static final boolean HEAP_WATCHER_TENURED_ENABLED_DEFAULT = false;
    public static final String HEAP_WATCHER_TENURED_NOTIFY_BYTES_CONFIG = "confluent.heap.tenured.notify.bytes";
    public static final String HEAP_WATCHER_TENURED_NOTIFY_BYTES_DOC = "Alert on almost-OOM when the tenured heap pool is above this size, in bytes. 0 means disabled.";
    public static final int HEAP_WATCHER_TENURED_NOTIFY_BYTES_DEFAULT = 0;
    public static final String TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_CONFIG = "confluent.topic.policy.use.computed.assignments";
    public static final String TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_DOC = "Whether to pass the computed topic assignments for a new topic to CreateTopicPolicy. True in Cloud, false in Confluent Platform";
    public static final boolean TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_CONFIG = "confluent.multitenant.interceptor.collect.client.apiversions.metric";
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_DOC = "Whether to collect the client_info_rate metric, tagging it with the client software and client id on a ApiVersions request. This could result in a memory exhaustion for a very high cardinality of client ids. Should only be true in ccloud, false everywhere else";
    public static final boolean MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_DEFAULT = false;
    public static final String NUM_PARTITIONS = "num.partitions";
    public static final int NUM_PARTITIONS_DEFAULT = 1;

    public static BrokerInterceptor buildBrokerInterceptor(Mode mode, Map<String, ?> configs) {
        if (mode == Mode.CLIENT) {
            return null;
        }
        BrokerInterceptor interceptor = new DefaultBrokerInterceptor();
        if (configs.containsKey(BROKER_INTERCEPTOR_CLASS_CONFIG)) {
            Class interceptorClass = (Class)configs.get(BROKER_INTERCEPTOR_CLASS_CONFIG);
            interceptor = (BrokerInterceptor)Utils.newInstance(interceptorClass);
        }
        interceptor.configure(configs);
        return interceptor;
    }

    public static boolean clusterLinkMetricReductionEnabled(Map<String, ?> configs) {
        Boolean clusterLinkEnableMetricsReduction = (Boolean)configs.get(CLUSTER_LINK_ENABLE_METRICS_REDUCTION_CONFIG);
        return clusterLinkEnableMetricsReduction == null ? false : clusterLinkEnableMetricsReduction;
    }

    public static boolean multiTenantInterceptorCollectApiVersionsEnabled(Map<String, ?> configs) {
        Boolean multiTenantInterceptorCollectApiVersions = (Boolean)configs.get(MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_CONFIG);
        return multiTenantInterceptorCollectApiVersions == null ? false : multiTenantInterceptorCollectApiVersions;
    }

    public static MultiTenantMetadata buildMultitenantMetadata(Map<String, ?> configs, Metrics metrics) {
        MultiTenantMetadata meta = null;
        if (configs.get(MULTITENANT_METADATA_CLASS_CONFIG) != null) {
            Class multitenantMetadataClass = (Class)configs.get(MULTITENANT_METADATA_CLASS_CONFIG);
            try {
                meta = (MultiTenantMetadata)Utils.newParameterizedInstance(multitenantMetadataClass.getName(), Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            meta.configure(configs);
        }
        return meta;
    }

    public static MultiTenantSecretsStore buildMultiTenantSecretsStore(AbstractConfig config, Map<String, ?> interBrokerClientConfig, Metrics metrics) {
        MultiTenantSecretsStore secretsStore = null;
        String topicName = config.getString(CDC_API_KEYS_TOPIC_CONFIG);
        if (topicName != null && !topicName.isEmpty()) {
            HashMap<String, Object> interBrokerClientConfigForMultiTenantSecretsStore = new HashMap<String, Object>(interBrokerClientConfig);
            Object processRoles = config.originals().get("process.roles");
            if (processRoles != null && processRoles.toString().equalsIgnoreCase("controller")) {
                String metadataSecurityProtocol;
                Object metadataBootstrapServersObject = config.originals().get("confluent.metadata.bootstrap.servers");
                Object metadataSecurityProtocolObject = config.originals().get("confluent.metadata.security.protocol");
                String metadataBootstrapServers = metadataBootstrapServersObject == null ? null : metadataBootstrapServersObject.toString();
                String string = metadataSecurityProtocol = metadataSecurityProtocolObject == null ? null : metadataSecurityProtocolObject.toString();
                if (metadataBootstrapServers != null && !metadataBootstrapServers.trim().isEmpty()) {
                    interBrokerClientConfigForMultiTenantSecretsStore.put("bootstrap.servers", metadataBootstrapServers);
                }
                if (metadataSecurityProtocol != null && !metadataSecurityProtocol.trim().isEmpty()) {
                    interBrokerClientConfigForMultiTenantSecretsStore.put("security.protocol", metadataSecurityProtocol);
                }
                ConfluentConfigs.updatePrefixedConfigs(config.originals(), interBrokerClientConfigForMultiTenantSecretsStore, CDC_TOPIC_METADATA_CONFIG_PREFIX, false);
            }
            try {
                secretsStore = (MultiTenantSecretsStore)Utils.newParameterizedInstance(MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME, Map.class, interBrokerClientConfigForMultiTenantSecretsStore, Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            secretsStore.configure(config.values());
        }
        return secretsStore;
    }

    public static List<String> multitenantListenerNames(AbstractConfig config, ListenerName interBrokerListenerName) {
        return ConfluentConfigs.multitenantListenerNames(config.values(), interBrokerListenerName);
    }

    public static List<String> multitenantListenerNames(Map<String, ?> config, ListenerName interBrokerListenerName) {
        return ConfluentConfigs.listenerNames(MULTITENANT_LISTENER_NAMES_CONFIG, config, interBrokerListenerName);
    }

    public static Double linkRequestPercentageMultiplier(Map<String, ?> config) {
        Double multipler = (Double)config.get(CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_CONFIG);
        if (multipler == null) {
            multipler = CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DEFAULT;
        }
        return multipler;
    }

    public static List<String> sslListenerNames(Map<String, ?> config) {
        ArrayList<String> sslEnabledListenerNames = new ArrayList<String>();
        String securityProtocolMapValue = (String)config.get("listener.security.protocol.map");
        if (securityProtocolMapValue != null) {
            String[] securityProtocolMap;
            for (String listenerEntry : securityProtocolMap = securityProtocolMapValue.split("\\s*,\\s*")) {
                String[] keyVal = listenerEntry.split(":");
                if (keyVal.length != 2) {
                    log.warn("Invalid listener security protocol map entry {}, skipping", (Object)listenerEntry);
                    continue;
                }
                if (!keyVal[1].toUpperCase(Locale.ROOT).contains("SSL")) continue;
                sslEnabledListenerNames.add(ListenerName.normalised(keyVal[0]).value());
            }
        }
        return sslEnabledListenerNames;
    }

    public static List<String> listenerNames(String listenersConfigName, Map<String, ?> config, ListenerName interBrokerListenerName) {
        List<String> listenerNames;
        String listenerNamesString = (String)config.get(listenersConfigName);
        if (listenerNamesString == null) {
            listenerNames = Collections.emptyList();
        } else {
            listenerNames = Arrays.stream(listenerNamesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).map(v -> ListenerName.normalised(v).value()).collect(Collectors.toList());
            if (interBrokerListenerName != null && listenerNames.contains(interBrokerListenerName.value())) {
                throw new ConfigException(listenersConfigName + " contains the internal listener " + interBrokerListenerName.value());
            }
        }
        return listenerNames;
    }

    public static List<String> ccloudHostSuffixes(Map<String, ?> config) {
        String ccloudHostSuffixesString = (String)config.get(CCLOUD_HOST_SUFFIXES_CONFIG);
        if (ccloudHostSuffixesString == null) {
            ccloudHostSuffixesString = CCLOUD_HOST_SUFFIXES_DEFAULT;
        }
        List<String> ccloudHostSuffixes = Arrays.stream(ccloudHostSuffixesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        return ccloudHostSuffixes;
    }

    public static MultiTenantQuotaConsumer buildMultitenantQuotaConsumer(AbstractConfig config, Endpoint interBrokerEndpoint, Metrics metrics) {
        MultiTenantQuotaConsumer multiTenantQuotaConsumer;
        if (!config.getBoolean(CDC_CLIENT_QUOTAS_ENABLE_CONFIG).booleanValue()) {
            return null;
        }
        Map<String, Object> clientConfig = ConfluentConfigs.clientConfigsForEndpoint(config, interBrokerEndpoint);
        try {
            multiTenantQuotaConsumer = (MultiTenantQuotaConsumer)Utils.newParameterizedInstance(MULTI_TENANT_QUOTA_CONSUMER_CLASS_NAME, Map.class, clientConfig, Metrics.class, metrics);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaException(e);
        }
        multiTenantQuotaConsumer.configure(config.values());
        return multiTenantQuotaConsumer;
    }

    public static UserMetadataStore buildUserMetadataStore(AbstractConfig config, Map<String, ?> interBrokerClientConfig, Metrics metrics) {
        UserMetadataStore userMetadataStore;
        Boolean enable = config.getBoolean(CDC_USER_METADATA_ENABLE_CONFIG);
        if (!enable.booleanValue() || enable == null) {
            return null;
        }
        String topic = config.getString(CDC_USER_METADATA_TOPIC_CONFIG);
        if (topic == null || topic.isEmpty()) {
            throw new ConfigException("Value for config confluent.cdc.user.metadata.topic can not be empty when user metadata store are enabled");
        }
        HashMap<String, Object> interBrokerClientConfigForUserMetadataStore = new HashMap<String, Object>(interBrokerClientConfig);
        Object processRoles = config.originals().get("process.roles");
        if (processRoles != null && processRoles.toString().equalsIgnoreCase("controller")) {
            String metadataSecurityProtocol;
            Object metadataBootstrapServersObject = config.originals().get("confluent.metadata.bootstrap.servers");
            Object metadataSecurityProtocolObject = config.originals().get("confluent.metadata.security.protocol");
            String metadataBootstrapServers = metadataBootstrapServersObject == null ? null : metadataBootstrapServersObject.toString();
            String string = metadataSecurityProtocol = metadataSecurityProtocolObject == null ? null : metadataSecurityProtocolObject.toString();
            if (metadataBootstrapServers != null && !metadataBootstrapServers.trim().isEmpty()) {
                interBrokerClientConfigForUserMetadataStore.put("bootstrap.servers", metadataBootstrapServers);
            }
            if (metadataSecurityProtocol != null && !metadataSecurityProtocol.trim().isEmpty()) {
                interBrokerClientConfigForUserMetadataStore.put("security.protocol", metadataSecurityProtocol);
            }
            ConfluentConfigs.updatePrefixedConfigs(config.originals(), interBrokerClientConfigForUserMetadataStore, CDC_TOPIC_METADATA_CONFIG_PREFIX, false);
        }
        try {
            userMetadataStore = (UserMetadataStore)Utils.newParameterizedInstance(CDC_USER_METADATA_STORE_CLASS_NAME, Map.class, interBrokerClientConfigForUserMetadataStore, Metrics.class, metrics);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaException(e);
        }
        userMetadataStore.configure(config.values());
        return userMetadataStore;
    }

    public static LicenseValidator buildLicenseValidator(AbstractConfig config, Endpoint interBrokerEndpoint) {
        Configurable licenseValidator = null;
        ServiceLoader<LicenseValidator> validators = ServiceLoader.load(LicenseValidator.class);
        for (LicenseValidator validator : validators) {
            if (!validator.enabled()) continue;
            licenseValidator = validator;
            break;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException("License validator not found");
        }
        licenseValidator.configure(ConfluentConfigs.clientConfigsForEndpoint(config, interBrokerEndpoint));
        return licenseValidator;
    }

    public static Map<String, Object> brokerToClientConfigs(Map<String, Object> originals, Map<String, ?> values) {
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(originals);
        Set<String> brokerConfigNames = values.keySet();
        clientConfigs.keySet().removeIf(n -> brokerConfigNames.contains(n) && !AdminClientConfig.configNames().contains(n) || n.startsWith("listener.name."));
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigsForEndpoint(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(originals, Collections.emptyMap(), interBrokerEndpoint);
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Map<String, ?> values, Endpoint interBrokerEndpoint) {
        ListenerName listenerName = new ListenerName(interBrokerEndpoint.listenerName().get());
        SecurityProtocol securityProtocol = interBrokerEndpoint.securityProtocol();
        Map<String, Object> clientConfigs = ConfluentConfigs.clientConfigsForEndpoint(originals, values, listenerName, securityProtocol);
        String ibpHost = interBrokerEndpoint.host() == null ? "" : interBrokerEndpoint.host();
        clientConfigs.put("bootstrap.servers", ibpHost + ":" + interBrokerEndpoint.port());
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Map<String, ?> values, ListenerName listenerName, SecurityProtocol securityProtocol) {
        Map<String, Object> clientConfigs = ConfluentConfigs.brokerToClientConfigs(originals, values);
        ConfluentConfigs.enableSslDynamicStoreUpdate(originals, clientConfigs);
        String listenerPrefix = listenerName.configPrefix();
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            String saslMechanism = (String)originals.get("sasl.mechanism.inter.broker.protocol");
            saslMechanism = saslMechanism != null ? saslMechanism : "GSSAPI";
            clientConfigs.put("sasl.mechanism", saslMechanism);
            String mechanismPrefix = listenerName.saslMechanismConfigPrefix(saslMechanism);
            ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, mechanismPrefix);
            if (!clientConfigs.containsKey("sasl.jaas.config")) {
                String jaasConfig = JaasContext.listenerSaslJaasConfig(listenerName, saslMechanism);
                clientConfigs.put("sasl.jaas.config", jaasConfig);
            }
        }
        ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, listenerPrefix);
        clientConfigs.put("security.protocol", securityProtocol.name);
        clientConfigs.remove("principal.builder.class");
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigs(AbstractConfig config, String configPrefix, ClientType clientType, String topicPrefix, String componentId) {
        Map<String, Object> srcConfigs = config.originals();
        srcConfigs.keySet().removeAll(config.values().keySet());
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(srcConfigs);
        clientConfigs.remove("metric.reporters");
        clientConfigs.remove("principal.builder.class");
        clientConfigs.put("client.id", String.format("%s-%s-%s", topicPrefix, clientType.type, componentId));
        ConfluentConfigs.enableSslDynamicStoreUpdate(srcConfigs, clientConfigs);
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix + clientType.type + ".");
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix);
        return clientConfigs;
    }

    public static void enableSslDynamicStoreUpdate(Map<String, ?> originals, Map<String, Object> clientConfigs) {
        String enableSslDynamicStoreUpdate = (String)originals.get(BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG);
        if (Boolean.parseBoolean(enableSslDynamicStoreUpdate)) {
            clientConfigs.put(SSL_ENABLE_DYNAMIC_STORE_UPDATE, AUDIT_LOGGER_ENABLE_DEFAULT);
        }
    }

    public static boolean clientConfigsLoggingEnabled(Map<String, ?> originals) {
        return Boolean.parseBoolean(originals.getOrDefault(CONFIGS_LOGGING_ENABLED_PROP, AUDIT_LOGGER_ENABLE_DEFAULT).toString());
    }

    public static boolean requireCompatibleKeystores(Map<String, ?> configs) {
        Object value = configs.get(REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG);
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + value + "` for configuration `" + REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG + "` (must be a boolean)");
    }

    public static FipsValidator buildFipsValidator() {
        FipsValidator fipsValidator = null;
        ServiceLoader<FipsValidator> validators = ServiceLoader.load(FipsValidator.class);
        for (FipsValidator validator : validators) {
            if (!validator.fipsEnabled()) continue;
            fipsValidator = validator;
            break;
        }
        if (fipsValidator == null) {
            throw new IllegalStateException("FIPS validator not found");
        }
        return fipsValidator;
    }

    private static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix) {
        ConfluentConfigs.updatePrefixedConfigs(configs, dstConfigs, prefix, true);
    }

    public static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix, Boolean deletePrefixConfigFromConfigs) {
        Set<String> prefixed = configs.keySet().stream().filter(n -> n.startsWith(prefix)).collect(Collectors.toSet());
        prefixed.forEach(name -> {
            dstConfigs.remove(name);
            dstConfigs.put(name.substring(prefix.length()), configs.get(name));
        });
        if (deletePrefixConfigFromConfigs.booleanValue()) {
            configs.keySet().removeAll(prefixed);
        }
    }

    static {
        CONNECTIONS_MAX_AGE_MS_MAX = CONNECTIONS_MAX_AGE_MS_DEFAULT = Long.valueOf(TimeUnit.MILLISECONDS.convert(36500L, TimeUnit.DAYS));
        CONNECTIONS_MAX_AGE_MS_DOC = "Max connection age timeout: the server socket processor threads close connections older than this. Can be set per-listener. Must be positive and less than 100 years (" + CONNECTIONS_MAX_AGE_MS_MAX + " ms).";
        CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT = 250L;
        DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
        DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT = 50;
        DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT = 1800000;
        DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT = 900000;
        DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT = 900000L;
        BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT = Duration.ofMinutes(3L).toMillis();
        PROXY_PROTOCOL_VERSION_DEFAULT = ProxyProtocol.NONE.toString();
        PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT = false;
        PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT = PROXY_PROTOCOL_VERSION_DEFAULT;
        PROXY_PROTOCOL_CLIENT_MODE_DOC = "This configuration specifies the origin of the connection: remote (PROXY, the default) or local (LOCAL) node. This configuration is only valid when confluent.proxy.protocol.client.version is set to " + (Object)((Object)ProxyProtocol.V2) + " and ignored otherwise.";
        PROXY_PROTOCOL_CLIENT_MODE_DEFAULT = ProxyProtocolCommand.PROXY.name();
        LKC_ID_DOC = "This configuration specifies the LKC of the originating caller.This configuration is only valid when confluent.proxy.protocol.client.version is set to " + (Object)((Object)ProxyProtocol.V2) + " and ignored otherwise.";
        CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT = true;
        ELIGIBLE_CONTROLLERS_DEFAULT = Collections.emptyList();
        TRANSACTION_LOGGING_VERBOSITY_DEFAULT = 0;
        MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT = false;
        SUBDOMAIN_SEPARATOR_MAP_DEFAULT = null;
        SUBDOMAIN_PREFIX_DEFAULT = null;
        CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DEFAULT = Duration.ofDays(7L).toMillis();
    }

    public static class EligibleControllersValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (!(value instanceof List)) {
                throw new ConfigException("Unexpected value `" + value + "` for config `" + name + "` (should be a comma-separated list of broker IDs)");
            }
            List lst = (List)value;
            for (Object item : lst) {
                if (item instanceof Integer) continue;
                if (item instanceof String) {
                    try {
                        Integer.parseInt((String)item);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ConfigException("Unexpected list item `" + item + "` found in config `" + name + "` (each list item should be an integral broker ID)");
                    }
                }
                throw new ConfigException("Unexpected list item `" + item + "` found in config `" + name + "` (each list item should be an integral broker ID)");
            }
        }
    }

    public static enum ClientType {
        PRODUCER("producer", ProducerConfig.configNames()),
        CONSUMER("consumer", ConsumerConfig.configNames()),
        ADMIN("admin", AdminClientConfig.configNames()),
        COORDINATOR("coordinator", ConsumerConfig.configNames());

        final String type;
        final Set<String> configNames;

        private ClientType(String type, Set<String> configNames) {
            this.type = type;
            this.configNames = configNames;
        }
    }

    public static class ChecksumEnabledFilesValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, (Object)null);
            }
            ConfigDef.ValidList validList = ConfigDef.ValidList.in(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL, ConfluentConfigs.CHECKSUM_ENABLED_FILES_TIERSTATE, "none");
            validList.ensureValid(name, value);
            List values = (List)value;
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.contains("none")) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain one of all or none");
            }
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain all");
            }
            if (values.contains("none") && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain none");
            }
        }
    }

    public static enum ClusterLinkAvailabilityCheckMode {
        LINK_COORDINATOR,
        ALL;

    }

    public static enum ClusterLinkThreadAffinity {
        LINK,
        TENANT;

    }

    public static enum ClusterLinkQuotaMode {
        CLUSTER_LINK_ONLY,
        TOTAL_INBOUND;

    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

