/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import io.confluent.kafka.multitenant.InetAddressToTenantContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthenticationTimeoutException;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.internals.IntCounterSuite;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.AsyncAuthRunnable;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.CipherInformation;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ConnectionExpiryManager;
import org.apache.kafka.common.network.DelayedResponseAuthenticationException;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.DefaultAuthenticationEvent;
import org.slf4j.Logger;

public class Selector
implements Selectable,
AutoCloseable {
    public static final long NO_IDLE_TIMEOUT_MS = -1L;
    public static final int NO_FAILED_AUTHENTICATION_DELAY = 0;
    private final Optional<AuditLogProvider> auditLogProvider;
    private final Logger log;
    private final java.nio.channels.Selector nioSelector;
    private final Map<String, KafkaChannel> channels;
    private final Set<KafkaChannel> explicitlyMutedChannels;
    private boolean outOfMemory;
    private final List<NetworkSend> completedSends;
    private final LinkedHashMap<String, NetworkReceive> completedReceives;
    private final Set<SelectionKey> immediatelyConnectedKeys;
    private final Map<String, KafkaChannel> closingChannels;
    private Set<SelectionKey> keysWithBufferedRead;
    private final Set<KafkaChannel> disconnected;
    private final List<String> connected;
    private final List<KafkaChannel> failedSends;
    private final Time time;
    private final SelectorMetrics sensors;
    private final ChannelBuilder channelBuilder;
    private final int maxReceiveSize;
    private final boolean recordTimePerConnection;
    private final ConnectionExpiryManager idleExpiryManager;
    private final LinkedHashMap<String, DelayedAuthenticationFailureClose> delayedClosingChannels;
    private final ExecutorService asyncAuthExecutorService;
    private final LinkedHashMap<String, AsyncAuth> asyncAuthsInFlight;
    private final Set<SelectionKey> asyncAuthsCompleted;
    private final MemoryPool memoryPool;
    private final long lowMemThreshold;
    private final int failedAuthenticationDelayMs;
    private final Metrics metrics;
    private final Set<OnNewEventListener> onNewEventListeners;
    private final List<KafkaChannel> proxyReadyChannels;
    private final List<KafkaChannel> lkcReadyChannels;
    private final List<KafkaChannel> authenticatedChannels;
    private final Map<KafkaChannel, CloseMode> handshakeFailedChannels;
    private final boolean saslServerAuthnAsyncEnable;
    private InetAddressToTenantContext inetAddressToTenantContext;
    private boolean madeReadProgressLastPoll = true;

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, boolean recordTimePerConnection, ChannelBuilder channelBuilder, MemoryPool memoryPool, LogContext logContext, Optional<AuditLogProvider> auditLogProvider, boolean saslServerAuthnAsyncEnable, int saslServerAuthnAsyncMaxThreads, InetAddressToTenantContext inetAddressToTenantContext, Set<ApiKeys> idlenessIgnoredApiKeys) {
        this(maxReceiveSize, connectionMaxIdleMs, failedAuthenticationDelayMs, new SelectorMetricsParams(metrics, metricGrpPrefix, metricTags, metricsPerConnection, recordTimePerConnection, null), time, channelBuilder, memoryPool, logContext, auditLogProvider, saslServerAuthnAsyncEnable, saslServerAuthnAsyncMaxThreads, inetAddressToTenantContext, idlenessIgnoredApiKeys);
    }

    private Selector(int maxReceiveSize, long connectionMaxIdleMs, int failedAuthenticationDelayMs, SelectorMetricsParams selectorMetricsParams, Time time, ChannelBuilder channelBuilder, MemoryPool memoryPool, LogContext logContext, Optional<AuditLogProvider> auditLogProvider, boolean saslServerAuthnAsyncEnable, int saslServerAuthnAsyncMaxThreads, InetAddressToTenantContext inetAddressToTenantContext, Set<ApiKeys> idlenessIgnoredApiKeys) {
        try {
            this.nioSelector = java.nio.channels.Selector.open();
        }
        catch (IOException e) {
            throw new KafkaException(e);
        }
        this.maxReceiveSize = maxReceiveSize;
        this.time = time;
        this.channels = new HashMap<String, KafkaChannel>();
        this.explicitlyMutedChannels = new HashSet<KafkaChannel>();
        this.outOfMemory = false;
        this.completedSends = new ArrayList<NetworkSend>();
        this.completedReceives = new LinkedHashMap();
        this.immediatelyConnectedKeys = new HashSet<SelectionKey>();
        this.closingChannels = new HashMap<String, KafkaChannel>();
        this.keysWithBufferedRead = new HashSet<SelectionKey>();
        this.connected = new ArrayList<String>();
        this.disconnected = new HashSet<KafkaChannel>();
        this.failedSends = new ArrayList<KafkaChannel>();
        this.log = logContext.logger(Selector.class);
        this.metrics = selectorMetricsParams.metrics;
        this.channelBuilder = channelBuilder;
        this.recordTimePerConnection = selectorMetricsParams.recordTimePerConnection;
        this.idleExpiryManager = connectionMaxIdleMs < 0L ? null : new ConnectionExpiryManager(time, connectionMaxIdleMs, idlenessIgnoredApiKeys);
        this.saslServerAuthnAsyncEnable = saslServerAuthnAsyncEnable;
        this.asyncAuthExecutorService = saslServerAuthnAsyncEnable ? new ThreadPoolExecutor(0, saslServerAuthnAsyncMaxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.createThreadFactory("async-auth-%d", true)) : null;
        this.onNewEventListeners = new HashSet<OnNewEventListener>();
        this.sensors = selectorMetricsParams.selectorMetrics == null ? new SelectorMetrics(selectorMetricsParams.metrics, selectorMetricsParams.metricGrpPrefix, selectorMetricsParams.metricTags, selectorMetricsParams.metricsPerConnection, saslServerAuthnAsyncEnable, this.log, time, this.onNewEventListeners, channelBuilder.securityMechanisms(), this.channels::size, this::asyncAuthTaskCount) : selectorMetricsParams.selectorMetrics;
        this.asyncAuthsInFlight = new LinkedHashMap();
        this.asyncAuthsCompleted = new HashSet<SelectionKey>();
        this.memoryPool = memoryPool;
        this.lowMemThreshold = (long)(0.1 * (double)this.memoryPool.size());
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.delayedClosingChannels = failedAuthenticationDelayMs > 0 ? new LinkedHashMap() : null;
        this.auditLogProvider = Objects.requireNonNull(auditLogProvider);
        this.proxyReadyChannels = new ArrayList<KafkaChannel>();
        this.lkcReadyChannels = new ArrayList<KafkaChannel>();
        this.authenticatedChannels = new ArrayList<KafkaChannel>();
        this.handshakeFailedChannels = new HashMap<KafkaChannel, CloseMode>();
        this.inetAddressToTenantContext = inetAddressToTenantContext;
    }

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, boolean recordTimePerConnection, ChannelBuilder channelBuilder, MemoryPool memoryPool, LogContext logContext, Optional<AuditLogProvider> auditLogProvider) {
        this(maxReceiveSize, connectionMaxIdleMs, failedAuthenticationDelayMs, metrics, time, metricGrpPrefix, metricTags, metricsPerConnection, recordTimePerConnection, channelBuilder, memoryPool, logContext, auditLogProvider, false, 0, null, Collections.emptySet());
    }

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, boolean recordTimePerConnection, ChannelBuilder channelBuilder, MemoryPool memoryPool, LogContext logContext) {
        this(maxReceiveSize, connectionMaxIdleMs, 0, metrics, time, metricGrpPrefix, metricTags, metricsPerConnection, recordTimePerConnection, channelBuilder, memoryPool, logContext, Optional.empty());
    }

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, ChannelBuilder channelBuilder, LogContext logContext) {
        this(maxReceiveSize, connectionMaxIdleMs, failedAuthenticationDelayMs, metrics, time, metricGrpPrefix, metricTags, metricsPerConnection, false, channelBuilder, MemoryPool.NONE, logContext, Optional.empty());
    }

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, ChannelBuilder channelBuilder, LogContext logContext, SelectorMetrics selectorMetrics) {
        this(maxReceiveSize, connectionMaxIdleMs, 0, new SelectorMetricsParams(metrics, metricGrpPrefix, metricTags, metricsPerConnection, false, selectorMetrics), time, channelBuilder, MemoryPool.NONE, logContext, Optional.empty(), false, 0, null, Collections.emptySet());
    }

    public Selector(int maxReceiveSize, long connectionMaxIdleMs, Metrics metrics, Time time, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, ChannelBuilder channelBuilder, LogContext logContext) {
        this(maxReceiveSize, connectionMaxIdleMs, 0, metrics, time, metricGrpPrefix, metricTags, metricsPerConnection, channelBuilder, logContext);
    }

    public Selector(long connectionMaxIdleMS, Metrics metrics, Time time, String metricGrpPrefix, ChannelBuilder channelBuilder, LogContext logContext) {
        this(-1, connectionMaxIdleMS, metrics, time, metricGrpPrefix, Collections.emptyMap(), true, channelBuilder, logContext);
    }

    public Selector(long connectionMaxIdleMS, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, ChannelBuilder channelBuilder, LogContext logContext) {
        this(-1, connectionMaxIdleMS, failedAuthenticationDelayMs, metrics, time, metricGrpPrefix, Collections.emptyMap(), true, channelBuilder, logContext);
    }

    public Selector(long connectionMaxIdleMS, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, ChannelBuilder channelBuilder, LogContext logContext, Optional<AuditLogProvider> auditLogProvider) {
        this(-1, connectionMaxIdleMS, failedAuthenticationDelayMs, metrics, time, metricGrpPrefix, Collections.emptyMap(), true, false, channelBuilder, MemoryPool.NONE, logContext, auditLogProvider);
    }

    Selector(long connectionMaxIdleMS, int failedAuthenticationDelayMs, Metrics metrics, Time time, String metricGrpPrefix, ChannelBuilder channelBuilder, LogContext logContext, Optional<AuditLogProvider> auditLogProvider, boolean saslServerAuthnAsyncEnable) {
        this(-1, connectionMaxIdleMS, failedAuthenticationDelayMs, metrics, time, metricGrpPrefix, Collections.emptyMap(), true, false, channelBuilder, MemoryPool.NONE, logContext, auditLogProvider, saslServerAuthnAsyncEnable, 1, null, Collections.emptySet());
    }

    @Override
    public void connect(String id, InetSocketAddress address, int sendBufferSize, int receiveBufferSize) throws IOException {
        this.ensureNotRegistered(id);
        SocketChannel socketChannel = SocketChannel.open();
        SelectionKey key = null;
        try {
            this.configureSocketChannel(socketChannel, sendBufferSize, receiveBufferSize);
            boolean connected = this.doConnect(socketChannel, address);
            key = this.registerChannel(id, socketChannel, 8);
            if (connected) {
                this.log.debug("Immediately connected to node {}", (Object)id);
                this.immediatelyConnectedKeys.add(key);
                key.interestOps(0);
            }
        }
        catch (IOException | RuntimeException e) {
            if (key != null) {
                this.immediatelyConnectedKeys.remove(key);
            }
            if (this.channels.remove(id) != null) {
                this.recordConnectionClosed();
            }
            socketChannel.close();
            throw e;
        }
    }

    protected boolean doConnect(SocketChannel channel, InetSocketAddress address) throws IOException {
        try {
            return channel.connect(address);
        }
        catch (UnresolvedAddressException e) {
            throw new IOException("Can't resolve address: " + address, e);
        }
    }

    private void configureSocketChannel(SocketChannel socketChannel, int sendBufferSize, int receiveBufferSize) throws IOException {
        socketChannel.configureBlocking(false);
        Socket socket = socketChannel.socket();
        socket.setKeepAlive(true);
        if (sendBufferSize != -1) {
            socket.setSendBufferSize(sendBufferSize);
        }
        if (receiveBufferSize != -1) {
            socket.setReceiveBufferSize(receiveBufferSize);
        }
        socket.setTcpNoDelay(true);
    }

    public void register(String id, SocketChannel socketChannel) throws IOException {
        this.ensureNotRegistered(id);
        this.registerChannel(id, socketChannel, 1);
        ChannelMetadataRegistry metadataRegistry = this.channel(id).channelMetadataRegistry();
        if (metadataRegistry.clientInformation() == null) {
            metadataRegistry.registerClientInformation(ClientInformation.EMPTY);
        }
    }

    protected void recordConnectionCreated() {
        this.sensors.connectionCreated.record();
    }

    protected void recordConnectionClosed() {
        this.sensors.connectionClosed.record();
    }

    protected void recordReverseConnectionAdded() {
        this.sensors.reverseConnectionAdded.record();
    }

    protected void recordReverseConnectionRemoved() {
        this.sensors.reverseConnectionRemoved.record();
    }

    private void ensureNotRegistered(String id) {
        if (this.channels.containsKey(id)) {
            throw new IllegalStateException("There is already a connection for id " + id);
        }
        if (this.closingChannels.containsKey(id)) {
            throw new IllegalStateException("There is already a connection for id " + id + " that is still being closed");
        }
    }

    protected SelectionKey registerChannel(String id, SocketChannel socketChannel, int interestedOps) throws IOException {
        SelectionKey key = socketChannel.register(this.nioSelector, interestedOps);
        KafkaChannel channel = this.buildAndAttachKafkaChannel(socketChannel, id, key);
        this.channels.put(id, channel);
        this.recordConnectionCreated();
        if (this.idleExpiryManager != null) {
            this.idleExpiryManager.update(channel.id(), this.time.nanoseconds());
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaChannel buildAndAttachKafkaChannel(SocketChannel socketChannel, String id, SelectionKey key) throws IOException {
        try {
            AsyncAuthExecutor executor = this.createAsyncAuthExecutor(id, key);
            KafkaChannel channel = this.channelBuilder.buildChannel(id, key, this.maxReceiveSize, executor, this.memoryPool, new SelectorChannelMetadataRegistry(this.sensors), this.time);
            key.attach(channel);
            channel.setInetAddressToTenantContext(this.inetAddressToTenantContext);
            return channel;
        }
        catch (Exception e) {
            try {
                socketChannel.close();
            }
            finally {
                key.cancel();
            }
            throw new IOException("Channel could not be created for socket " + socketChannel, e);
        }
    }

    private AsyncAuthExecutor createAsyncAuthExecutor(String id, SelectionKey key) {
        if (this.asyncAuthExecutorService != null) {
            return asyncAuthRunnable -> {
                Runnable r = () -> {
                    try {
                        asyncAuthRunnable.run();
                    }
                    finally {
                        this.wakeup();
                    }
                };
                Future<?> asyncAuthFuture = this.asyncAuthExecutorService.submit(r);
                AsyncAuth asyncAuth = new AsyncAuth(asyncAuthRunnable, asyncAuthFuture, key);
                this.asyncAuthsInFlight.put(id, asyncAuth);
            };
        }
        return asyncAuthRunnable -> this.log.error("Async authentication is not supported on this selector");
    }

    private int asyncAuthTaskCount() {
        if (this.asyncAuthExecutorService != null && this.asyncAuthExecutorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.asyncAuthExecutorService).getQueue().size();
        }
        return 0;
    }

    @Override
    public void wakeup() {
        this.nioSelector.wakeup();
    }

    @Override
    public void close() {
        Throwable exception;
        ArrayList<String> connections = new ArrayList<String>(this.channels.keySet());
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        Utils.closeAllQuietly(firstException, "release connections", (AutoCloseable[])connections.stream().map(id -> () -> this.close((String)id)).toArray(AutoCloseable[]::new));
        Utils.closeQuietly((AutoCloseable)this.nioSelector, "nioSelector", firstException);
        Utils.closeQuietly((AutoCloseable)this.sensors, "sensors", firstException);
        Utils.closeQuietly((AutoCloseable)this.channelBuilder, "channelBuilder", firstException);
        if (this.asyncAuthExecutorService != null) {
            this.asyncAuthExecutorService.shutdown();
        }
        if ((exception = firstException.get()) instanceof RuntimeException && !(exception instanceof SecurityException)) {
            throw (RuntimeException)exception;
        }
    }

    @Override
    public Collection<KafkaChannel> channelsWithCredential(PublicCredential matchingCredential) {
        ArrayList<KafkaChannel> matchingChannels = new ArrayList<KafkaChannel>();
        this.channels.values().stream().filter(channel -> channel.ready() && channel.publicCredential().matches(matchingCredential)).forEach(matchingChannels::add);
        this.closingChannels.values().stream().filter(channel -> channel.ready() && channel.publicCredential().matches(matchingCredential)).forEach(matchingChannels::add);
        return matchingChannels;
    }

    @Override
    public void send(NetworkSend send) {
        block4: {
            String connectionId = send.destinationId();
            KafkaChannel channel = this.openOrClosingChannelOrFail(connectionId);
            if (this.closingChannels.containsKey(connectionId)) {
                this.failedSends.add(channel);
            } else {
                try {
                    channel.setSend(send);
                }
                catch (Exception e) {
                    channel.state(ChannelState.FAILED_SEND);
                    this.failedSends.add(channel);
                    this.close(channel, CloseMode.DISCARD_NO_NOTIFY);
                    if (e instanceof CancelledKeyException) break block4;
                    this.log.error("Unexpected exception during send, closing connection {} and rethrowing exception.", (Object)connectionId, (Object)e);
                    throw e;
                }
            }
        }
    }

    @Override
    public void poll(long timeout) throws IOException {
        boolean dataInBuffers;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout should be >= 0");
        }
        boolean madeReadProgressLastCall = this.madeReadProgressLastPoll;
        this.clear();
        boolean bl = dataInBuffers = !this.keysWithBufferedRead.isEmpty();
        if (!this.immediatelyConnectedKeys.isEmpty() || madeReadProgressLastCall && dataInBuffers || !this.asyncAuthsCompleted.isEmpty()) {
            timeout = 0L;
        }
        if (!this.memoryPool.isOutOfMemory() && this.outOfMemory) {
            this.log.trace("Broker no longer low on memory - unmuting incoming sockets");
            for (KafkaChannel channel : this.channels.values()) {
                if (!channel.isInMutableState() || this.explicitlyMutedChannels.contains(channel)) continue;
                channel.maybeUnmute();
            }
            this.outOfMemory = false;
        }
        long startSelect = this.time.nanoseconds();
        int numReadyKeys = this.select(timeout);
        long endSelect = this.time.nanoseconds();
        long ioWaitRecordTimeMs = this.time.milliseconds();
        this.sensors.selectTime.record(endSelect - startSelect, ioWaitRecordTimeMs, false);
        this.sensors.recordIdleThreadMetrics(ioWaitRecordTimeMs);
        if (numReadyKeys > 0 || !this.immediatelyConnectedKeys.isEmpty() || dataInBuffers || !this.asyncAuthsCompleted.isEmpty()) {
            Set<SelectionKey> readyKeys = this.nioSelector.selectedKeys();
            if (dataInBuffers) {
                this.keysWithBufferedRead.removeAll(readyKeys);
                Set<SelectionKey> toPoll = this.keysWithBufferedRead;
                this.keysWithBufferedRead = new HashSet<SelectionKey>();
                this.pollSelectionKeys(toPoll, false, endSelect);
            }
            this.pollSelectionKeys(this.asyncAuthsCompleted, false, endSelect);
            this.asyncAuthsCompleted.clear();
            this.pollSelectionKeys(readyKeys, false, endSelect);
            readyKeys.clear();
            this.pollSelectionKeys(this.immediatelyConnectedKeys, true, endSelect);
            this.immediatelyConnectedKeys.clear();
        } else {
            this.madeReadProgressLastPoll = true;
        }
        long endIo = this.time.nanoseconds();
        this.sensors.ioTime.record(endIo - endSelect, this.time.milliseconds(), false);
        this.completeDelayedChannelClose(endIo);
        this.tryCancelAsyncAuth(endIo);
        this.maybeCloseOldestConnection(endSelect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSelectionKeys(Set<SelectionKey> selectionKeys, boolean isImmediatelyConnected, long currentTimeNanos) {
        for (SelectionKey key : this.determineHandlingOrder(selectionKeys)) {
            KafkaChannel channel = this.channel(key);
            long channelStartTimeNanos = this.recordTimePerConnection ? this.time.nanoseconds() : 0L;
            boolean sendFailed = false;
            String nodeId = channel.id();
            boolean performedWrite = false;
            this.sensors.maybeRegisterConnectionMetrics(nodeId);
            try {
                if (isImmediatelyConnected || key.isConnectable()) {
                    if (!channel.finishConnect()) continue;
                    this.connected.add(nodeId);
                    SocketChannel socketChannel = (SocketChannel)key.channel();
                    this.log.debug("Created socket with SO_RCVBUF = {}, SO_SNDBUF = {}, SO_TIMEOUT = {} to node {}", new Object[]{socketChannel.socket().getReceiveBufferSize(), socketChannel.socket().getSendBufferSize(), socketChannel.socket().getSoTimeout(), nodeId});
                }
                if (channel.isConnected() && !channel.ready()) {
                    try {
                        channel.prepare();
                    }
                    catch (AuthenticationException e) {
                        this.sensors.maybeRecordNewConnectionMetrics(channel, false, e.errorInfo().logicalClusterId());
                        throw e;
                    }
                    catch (IOException e) {
                        this.sensors.maybeRecordNewConnectionMetrics(channel, false, "");
                        throw e;
                    }
                    finally {
                        if (channel.proxyState() == KafkaChannel.ChannelProxyState.PROXY_READY) {
                            this.proxyReadyChannels.add(channel);
                        }
                        if (channel.lkcState() == KafkaChannel.ChannelLkcState.LKC_READY) {
                            this.lkcReadyChannels.add(channel);
                        }
                    }
                    if (channel.ready()) {
                        boolean isReauthentication;
                        long readyTimeMs = this.time.milliseconds();
                        boolean bl = isReauthentication = channel.metrics().successfulAuthentications() > 1;
                        if (isReauthentication) {
                            this.sensors.successfulReauthentication.record(1.0, readyTimeMs);
                            channel.maybeAddWriteInterestAfterReauth();
                            if (channel.reauthenticationLatencyMs() == null) {
                                this.log.warn("Should never happen: re-authentication latency for a re-authenticated channel was null; continuing...");
                            } else {
                                this.sensors.reauthenticationLatency.record(channel.reauthenticationLatencyMs().doubleValue(), readyTimeMs);
                            }
                        } else {
                            this.sensors.successfulAuthentication.record(1.0, readyTimeMs);
                            if (channel.hasMultiTenantPrincipal()) {
                                this.authenticatedChannels.add(channel);
                            }
                            this.maybeNotifyConnectionAdded(channel);
                            channel.maybeTrackInetAddressToTenant();
                            if (!channel.connectedClientSupportsReauthentication()) {
                                this.sensors.successfulAuthenticationNoReauth.record(1.0, readyTimeMs);
                            }
                            this.auditAuthenticationSuccess(channel);
                        }
                        this.log.debug("Successfully {}authenticated with {}", (Object)(isReauthentication ? "re-" : ""), (Object)channel.socketDescription());
                        this.sensors.maybeRecordNewConnectionMetrics(channel, true, "");
                    }
                }
                if (channel.ready() && channel.state() == ChannelState.NOT_CONNECTED) {
                    channel.state(ChannelState.READY);
                }
                Optional<NetworkReceive> responseReceivedDuringReauthentication = channel.pollResponseReceivedDuringReauthentication();
                responseReceivedDuringReauthentication.ifPresent(receive -> {
                    long currentTimeMs = this.time.milliseconds();
                    this.addToCompletedReceives(channel, (NetworkReceive)receive, currentTimeMs);
                });
                if (channel.ready() && (key.isReadable() || channel.hasBytesBuffered()) && !this.hasCompletedReceive(channel) && !this.explicitlyMutedChannels.contains(channel)) {
                    this.attemptRead(channel);
                }
                if (channel.hasBytesBuffered() && !this.explicitlyMutedChannels.contains(channel)) {
                    this.keysWithBufferedRead.add(key);
                }
                long nowNanos = channelStartTimeNanos != 0L ? channelStartTimeNanos : currentTimeNanos;
                try {
                    performedWrite = this.attemptWrite(key, channel, nowNanos);
                }
                catch (Exception e) {
                    sendFailed = true;
                    throw e;
                }
                if (key.isValid()) continue;
                this.close(channel, CloseMode.GRACEFUL);
            }
            catch (Exception e) {
                String desc = String.format("%s (channelId=%s)", channel.socketDescription(), channel.id());
                if (e instanceof IOException) {
                    this.log.debug("Connection with {} disconnected", (Object)desc, (Object)e);
                } else if (e instanceof AuthenticationException) {
                    boolean isReauthentication;
                    AuthenticationException authException = (AuthenticationException)e;
                    boolean bl = isReauthentication = channel.metrics().successfulAuthentications() > 0;
                    if (isReauthentication) {
                        this.sensors.failedReauthentication.record();
                    } else {
                        this.sensors.failedAuthentication.record();
                        if (channel.interceptor() != null) {
                            channel.interceptor().onFailedAuthentication(channel.id(), channel.socketAddress(), this.metrics);
                        }
                        if (e instanceof SslAuthenticationException) {
                            this.sensors.failedHandshake.record();
                        }
                    }
                    if (authException instanceof DelayedResponseAuthenticationException) {
                        authException = ((DelayedResponseAuthenticationException)authException).getCause();
                    }
                    if (authException instanceof AuthenticationTimeoutException) {
                        this.sensors.timedOutAuthentication.record();
                    }
                    String exceptionMessage = authException.logMessage();
                    this.auditAuthenticationFailure(channel, authException);
                    this.log.info("Failed {}authentication with {} ({})", new Object[]{isReauthentication ? "re-" : "", desc, exceptionMessage});
                } else {
                    this.log.warn("Unexpected error from {}; closing connection", (Object)desc, (Object)e);
                }
                if (e instanceof DelayedResponseAuthenticationException) {
                    this.maybeDelayCloseOnAuthenticationFailure(channel);
                    continue;
                }
                if (e instanceof SslAuthenticationException) {
                    this.handshakeFailedChannels.put(channel, sendFailed ? CloseMode.NOTIFY_ONLY : CloseMode.GRACEFUL);
                    continue;
                }
                this.close(channel, sendFailed ? CloseMode.NOTIFY_ONLY : CloseMode.GRACEFUL);
            }
            finally {
                this.maybeRecordTimePerConnection(channel, channelStartTimeNanos, performedWrite);
            }
        }
    }

    private void auditAuthenticationSuccess(KafkaChannel channel) {
        this.auditLogProvider.ifPresent(p -> {
            KafkaPrincipal principal = this.channelPrincipal(channel, true);
            try {
                DefaultAuthenticationEvent authenticationEvent = new DefaultAuthenticationEvent(principal, channel.authenticationContext(), AuditEventStatus.SUCCESS);
                p.logEvent(authenticationEvent, channel.isProxyModeLocal());
            }
            catch (Exception exception) {
                this.log.error("Unexpected error while authentication success audit event for principal: {}", (Object)principal, (Object)exception);
            }
        });
    }

    private KafkaPrincipal channelPrincipal(KafkaChannel channel, boolean failOnError) {
        try {
            return channel.principal();
        }
        catch (Throwable t2) {
            this.log.error("Could not determine channel principal", t2);
            if (failOnError) {
                throw new KafkaException("Could not determine KafkaPrincipal for " + channel.socketDescription(), t2);
            }
            return null;
        }
    }

    private void auditAuthenticationFailure(KafkaChannel channel, AuthenticationException authenticationException) {
        this.auditLogProvider.ifPresent(p -> {
            try {
                DefaultAuthenticationEvent authenticationEvent = new DefaultAuthenticationEvent(null, channel.authenticationContext(), authenticationException);
                p.logEvent(authenticationEvent, channel.isProxyModeLocal());
            }
            catch (Exception exception) {
                this.log.error("Unexpected error while authentication failure audit event. ", (Throwable)exception);
            }
        });
    }

    private boolean attemptWrite(SelectionKey key, KafkaChannel channel, long nowNanos) throws IOException {
        if (channel.hasSend() && channel.ready() && key.isWritable() && !channel.maybeBeginClientReauthentication(() -> nowNanos)) {
            this.write(channel);
            return true;
        }
        return false;
    }

    protected void write(KafkaChannel channel) throws IOException {
        String nodeId = channel.id();
        long bytesSent = channel.write();
        NetworkSend send = channel.maybeCompleteSend();
        if (bytesSent > 0L || send != null) {
            long currentTimeMs = this.time.milliseconds();
            if (bytesSent > 0L) {
                this.sensors.recordBytesSent(nodeId, bytesSent, currentTimeMs);
            }
            if (send != null) {
                this.completedSends.add(send);
                this.sensors.recordCompletedSend(nodeId, send.size(), currentTimeMs);
            }
        }
    }

    private Collection<SelectionKey> determineHandlingOrder(Set<SelectionKey> selectionKeys) {
        if (!this.outOfMemory && this.memoryPool.availableMemory() < this.lowMemThreshold) {
            ArrayList<SelectionKey> shuffledKeys = new ArrayList<SelectionKey>(selectionKeys);
            Collections.shuffle(shuffledKeys);
            return shuffledKeys;
        }
        return selectionKeys;
    }

    private void attemptRead(KafkaChannel channel) throws IOException {
        String nodeId = channel.id();
        long bytesReceived = channel.read();
        if (bytesReceived != 0L) {
            long currentTimeMs = this.time.milliseconds();
            this.sensors.recordBytesReceived(nodeId, bytesReceived, currentTimeMs);
            this.madeReadProgressLastPoll = true;
            NetworkReceive receive = channel.maybeCompleteReceive();
            if (receive != null) {
                this.addToCompletedReceives(channel, receive, currentTimeMs);
            }
        }
        if (channel.isMuted()) {
            this.outOfMemory = true;
        } else {
            this.madeReadProgressLastPoll = true;
        }
    }

    private boolean maybeReadFromClosingChannel(KafkaChannel channel) {
        boolean hasPending;
        if (channel.state().state() != ChannelState.State.READY) {
            hasPending = false;
        } else if (this.explicitlyMutedChannels.contains(channel) || this.hasCompletedReceive(channel)) {
            hasPending = true;
        } else {
            try {
                this.attemptRead(channel);
                hasPending = this.hasCompletedReceive(channel);
            }
            catch (Exception e) {
                this.log.trace("Read from closing channel failed, ignoring exception", (Throwable)e);
                hasPending = false;
            }
        }
        return hasPending;
    }

    private void maybeRecordTimePerConnection(KafkaChannel channel, long startTimeNanos, boolean hasWrite) {
        if (this.recordTimePerConnection) {
            channel.addNetworkIoTimeNanos(this.time.nanoseconds() - startTimeNanos, hasWrite);
        }
    }

    @Override
    public List<NetworkSend> completedSends() {
        return this.completedSends;
    }

    @Override
    public Collection<NetworkReceive> completedReceives() {
        return this.completedReceives.values();
    }

    @Override
    public Map<String, ChannelState> disconnected() {
        return this.disconnected.stream().collect(Collectors.toMap(KafkaChannel::id, KafkaChannel::state));
    }

    public Set<KafkaChannel> disconnectedChannels() {
        return this.disconnected;
    }

    @Override
    public List<String> connected() {
        return this.connected;
    }

    @Override
    public void mute(String id) {
        KafkaChannel channel = this.openOrClosingChannelOrFail(id);
        this.mute(channel);
    }

    private void mute(KafkaChannel channel) {
        channel.mute();
        this.explicitlyMutedChannels.add(channel);
        this.keysWithBufferedRead.remove(channel.selectionKey());
    }

    @Override
    public void unmute(String id) {
        KafkaChannel channel = this.openOrClosingChannelOrFail(id);
        this.unmute(channel);
    }

    private void unmute(KafkaChannel channel) {
        if (channel.maybeUnmute()) {
            this.explicitlyMutedChannels.remove(channel);
            if (channel.hasBytesBuffered()) {
                this.keysWithBufferedRead.add(channel.selectionKey());
                this.madeReadProgressLastPoll = true;
            }
        }
    }

    @Override
    public void muteAll() {
        for (KafkaChannel channel : this.channels.values()) {
            this.mute(channel);
        }
    }

    @Override
    public void unmuteAll() {
        for (KafkaChannel channel : this.channels.values()) {
            this.unmute(channel);
        }
    }

    void completeDelayedChannelClose(long currentTimeNanos) {
        DelayedAuthenticationFailureClose delayedClose;
        if (this.delayedClosingChannels == null) {
            return;
        }
        while (!this.delayedClosingChannels.isEmpty() && (delayedClose = this.delayedClosingChannels.values().iterator().next()).tryClose(currentTimeNanos)) {
        }
    }

    void tryCancelAsyncAuth(long currentTimeNanos) {
        for (AsyncAuth asyncAuth : this.asyncAuthsInFlight.values()) {
            asyncAuth.tryCancel(currentTimeNanos);
        }
    }

    private void maybeCloseOldestConnection(long currentTimeNanos) {
        String connectionId;
        KafkaChannel channel;
        if (this.idleExpiryManager == null) {
            return;
        }
        Map.Entry<String, Long> expiredConnection = this.idleExpiryManager.pollExpiredConnection(currentTimeNanos);
        if (expiredConnection != null && (channel = this.channels.get(connectionId = expiredConnection.getKey())) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("About to close the idle connection from {} due to being idle for {} millis", (Object)connectionId, (Object)((currentTimeNanos - expiredConnection.getValue()) / 1000L / 1000L));
            }
            channel.state(ChannelState.EXPIRED);
            this.close(channel, CloseMode.GRACEFUL);
            this.sensors.idleConnectionClosed.record();
        }
    }

    public void clearCompletedReceives() {
        this.completedReceives.clear();
    }

    public void clearCompletedSends() {
        this.completedSends.clear();
    }

    public void clearProxyReadyChannels() {
        this.proxyReadyChannels.clear();
    }

    public void clearLkcReadyChannels() {
        this.lkcReadyChannels.clear();
    }

    public void clearAuthenticatedChannels() {
        this.authenticatedChannels.clear();
    }

    public void clearHandshakeFailedChannels() {
        this.handshakeFailedChannels.clear();
    }

    private void clear() {
        this.completedSends.clear();
        this.completedReceives.clear();
        this.connected.clear();
        this.disconnected.clear();
        this.proxyReadyChannels.forEach(channel -> channel.proxyState(KafkaChannel.ChannelProxyState.PROXY_PROCESSED));
        this.proxyReadyChannels.clear();
        this.lkcReadyChannels.forEach(channel -> channel.lkcState(KafkaChannel.ChannelLkcState.LKC_PROCESSED));
        this.lkcReadyChannels.clear();
        this.authenticatedChannels.clear();
        this.handshakeFailedChannels.forEach(this::close);
        this.handshakeFailedChannels.clear();
        Iterator<Object> it = this.closingChannels.entrySet().iterator();
        while (it.hasNext()) {
            KafkaChannel channel2 = it.next().getValue();
            boolean sendFailed = this.failedSends.remove(channel2);
            boolean hasPending = false;
            if (!sendFailed) {
                hasPending = this.maybeReadFromClosingChannel(channel2);
            }
            if (hasPending) continue;
            this.doClose(channel2, true);
            it.remove();
        }
        for (KafkaChannel channel2 : this.failedSends) {
            channel2.state(ChannelState.FAILED_SEND);
            this.disconnected.add(channel2);
        }
        this.failedSends.clear();
        it = this.asyncAuthsInFlight.entrySet().iterator();
        while (it.hasNext()) {
            AsyncAuth asyncAuth = (AsyncAuth)((Map.Entry)it.next()).getValue();
            if (!asyncAuth.asyncAuthRunnable.isComplete()) continue;
            this.asyncAuthsCompleted.add(asyncAuth.selectionKey);
            it.remove();
        }
        this.madeReadProgressLastPoll = false;
    }

    private int select(long timeoutMs) throws IOException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("timeout should be >= 0");
        }
        if (timeoutMs == 0L) {
            return this.nioSelector.selectNow();
        }
        return this.nioSelector.select(timeoutMs);
    }

    @Override
    public void close(String connectionId) {
        KafkaChannel channel = this.channels.get(connectionId);
        if (channel != null) {
            channel.state(ChannelState.LOCAL_CLOSE);
            this.close(channel, CloseMode.DISCARD_NO_NOTIFY);
        } else {
            KafkaChannel closingChannel = this.closingChannels.remove(connectionId);
            if (closingChannel != null) {
                this.doClose(closingChannel, false);
            }
        }
    }

    public void maybeDelayCloseOnInvalidRequest(KafkaChannel channel) {
        DelayedAuthenticationFailureClose delayedClose = new DelayedAuthenticationFailureClose(channel, this.failedAuthenticationDelayMs, chan -> this.close((KafkaChannel)chan, CloseMode.NOTIFY_ONLY));
        this.handleDelayedClose(channel.id(), delayedClose);
    }

    private void maybeDelayCloseOnAuthenticationFailure(KafkaChannel channel) {
        DelayedAuthenticationFailureClose delayedClose = new DelayedAuthenticationFailureClose(channel, this.failedAuthenticationDelayMs, this::handleCloseOnAuthenticationFailure);
        this.handleDelayedClose(channel.id(), delayedClose);
    }

    private void handleCloseOnAuthenticationFailure(KafkaChannel channel) {
        try {
            channel.completeCloseOnAuthenticationFailure();
        }
        catch (Exception e) {
            this.log.error("Exception handling close on authentication failure node {}", (Object)channel.id(), (Object)e);
        }
        finally {
            this.close(channel, CloseMode.GRACEFUL);
        }
    }

    private void handleDelayedClose(String id, DelayedAuthenticationFailureClose delayedClose) {
        if (this.delayedClosingChannels != null) {
            this.delayedClosingChannels.put(id, delayedClose);
        } else {
            delayedClose.closeNow();
        }
    }

    private void maybeNotifyConnectionAdded(KafkaChannel channel) {
        if (channel.interceptor() != null) {
            channel.interceptor().onAuthenticatedConnection(channel.id(), channel.socketAddress(), this.channelPrincipal(channel, true), this.metrics);
        }
    }

    private void maybeNotifyConnectionRemoved(KafkaChannel channel) {
        KafkaPrincipal principal;
        if (channel.ready() && channel.interceptor() != null && (principal = this.channelPrincipal(channel, false)) != null) {
            channel.interceptor().onAuthenticatedDisconnection(channel.id(), channel.socketAddress(), principal, this.metrics);
        }
    }

    void close(KafkaChannel channel, CloseMode closeMode) {
        AsyncAuth asyncAuth;
        channel.disconnect();
        this.maybeNotifyConnectionRemoved(channel);
        this.connected.remove(channel.id());
        if (closeMode == CloseMode.GRACEFUL && this.maybeReadFromClosingChannel(channel)) {
            this.closingChannels.put(channel.id(), channel);
            this.log.debug("Tracking closing connection {} to process outstanding requests", (Object)channel.id());
        } else {
            this.doClose(channel, closeMode.notifyDisconnect);
        }
        this.channels.remove(channel.id());
        if (this.delayedClosingChannels != null) {
            this.delayedClosingChannels.remove(channel.id());
        }
        if ((asyncAuth = (AsyncAuth)this.asyncAuthsInFlight.remove(channel.id())) != null) {
            this.log.info("Closing connection, calling async auth cancel. Channel id: {}", (Object)channel.id());
            asyncAuth.cancelNow();
        }
        if (this.idleExpiryManager != null) {
            this.idleExpiryManager.remove(channel.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(KafkaChannel channel, boolean notifyDisconnect) {
        SelectionKey key = channel.selectionKey();
        try {
            this.log.trace("Closing connection {}", (Object)channel.id());
            this.immediatelyConnectedKeys.remove(key);
            this.keysWithBufferedRead.remove(key);
            channel.close();
        }
        catch (IOException e) {
            this.log.error("Exception closing connection to node {}:", (Object)channel.id(), (Object)e);
        }
        finally {
            key.cancel();
            key.attach(null);
        }
        this.recordConnectionClosed();
        this.explicitlyMutedChannels.remove(channel);
        if (notifyDisconnect) {
            this.disconnected.add(channel);
        }
    }

    @Override
    public boolean isChannelReady(String id) {
        KafkaChannel channel = this.channels.get(id);
        return channel != null && channel.ready();
    }

    private KafkaChannel openOrClosingChannelOrFail(String id) {
        KafkaChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = this.closingChannels.get(id);
        }
        if (channel == null) {
            throw new IllegalStateException("Attempt to retrieve channel for which there is no connection. Connection id " + id + " existing connections " + this.channels.keySet());
        }
        return channel;
    }

    public List<KafkaChannel> channels() {
        return new ArrayList<KafkaChannel>(this.channels.values());
    }

    public KafkaChannel channel(String id) {
        return this.channels.get(id);
    }

    public KafkaChannel closingChannel(String id) {
        return this.closingChannels.get(id);
    }

    public KafkaChannel lowestPriorityChannel() {
        KafkaChannel channel = null;
        String channelId = null;
        if (!this.closingChannels.isEmpty()) {
            channel = this.closingChannels.values().iterator().next();
        } else if (this.idleExpiryManager != null && (channelId = this.idleExpiryManager.peekOldestChannelId()) != null) {
            channel = this.channel(channelId);
        } else if (!this.channels.isEmpty()) {
            channel = this.channels.values().iterator().next();
        }
        if (channel != null) {
            this.sensors.forceConnectionClosed.record();
        }
        return channel;
    }

    public void setConnectionRegistrationTime(String connectionId, long timeNanos) {
        KafkaChannel channel = this.channels.get(connectionId);
        if (channel != null) {
            channel.setConnectionRegistrationTime(timeNanos);
        }
    }

    public List<KafkaChannel> proxyReadyChannels() {
        return this.proxyReadyChannels;
    }

    public List<KafkaChannel> lkcReadyChannels() {
        return this.lkcReadyChannels;
    }

    public List<KafkaChannel> authenticatedChannels() {
        return this.authenticatedChannels;
    }

    public Set<KafkaChannel> handshakeFailedChannels() {
        return this.handshakeFailedChannels.keySet();
    }

    private KafkaChannel channel(SelectionKey key) {
        return (KafkaChannel)key.attachment();
    }

    private boolean hasCompletedReceive(KafkaChannel channel) {
        return this.completedReceives.containsKey(channel.id());
    }

    private void addToCompletedReceives(KafkaChannel channel, NetworkReceive networkReceive, long currentTimeMs) {
        if (this.hasCompletedReceive(channel)) {
            throw new IllegalStateException("Attempting to add second completed receive to channel " + channel.id());
        }
        this.completedReceives.put(channel.id(), networkReceive);
        this.sensors.recordCompletedReceive(channel.id(), networkReceive.size(), currentTimeMs);
        if (this.idleExpiryManager != null) {
            this.idleExpiryManager.update(channel.id(), this.time.nanoseconds(), RequestHeader.parseApiKey(networkReceive.payload()));
        }
    }

    public Set<SelectionKey> keys() {
        return new HashSet<SelectionKey>(this.nioSelector.keys());
    }

    boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    boolean isMadeReadProgressLastPoll() {
        return this.madeReadProgressLastPoll;
    }

    Map<?, ?> delayedClosingChannels() {
        return this.delayedClosingChannels;
    }

    int numAsyncInFlightTasks() {
        return this.asyncAuthsInFlight.size();
    }

    public void removeChannelWithoutClosing(KafkaChannel channel) {
        if (this.channels.remove(channel.id()) != channel) {
            throw new IllegalStateException("Channel not found in Selector");
        }
        if (!channel.ready()) {
            throw new IllegalStateException("Channel not in ready state");
        }
        if (this.failedSends.contains(channel)) {
            throw new IllegalStateException("Channel has already failed");
        }
        this.closingChannels.remove(channel.id());
        if (this.idleExpiryManager != null) {
            this.idleExpiryManager.remove(channel.id());
        }
        if (this.delayedClosingChannels != null) {
            this.delayedClosingChannels.remove(channel.id());
        }
        this.removeChannelKeyFromSelection(channel);
        this.recordReverseConnectionRemoved();
        this.maybeNotifyConnectionRemoved(channel);
    }

    public void removeChannelKeyFromSelection(KafkaChannel channel) {
        this.asyncAuthsInFlight.remove(channel.id());
        this.explicitlyMutedChannels.remove(channel);
        SelectionKey key = channel.selectionKey();
        this.immediatelyConnectedKeys.remove(key);
        this.keysWithBufferedRead.remove(key);
        key.cancel();
        key.attach(null);
    }

    public void addReverseChannel(KafkaChannel channel) throws IOException {
        if (this.channels.containsKey(channel.id())) {
            throw new IllegalStateException("Reverse channel not added since a channel already exists with id " + channel.id());
        }
        SocketChannel socketChannel = channel.socketChannel();
        SelectionKey newKey = socketChannel.register(this.nioSelector, 1);
        channel.selectionKey(newKey);
        newKey.attach(channel);
        this.channels.put(channel.id(), channel);
        if (channel.hasBytesBuffered()) {
            this.keysWithBufferedRead.add(channel.selectionKey());
        }
        if (this.idleExpiryManager != null) {
            this.idleExpiryManager.update(channel.id(), this.time.nanoseconds());
        }
        this.recordReverseConnectionAdded();
        this.maybeNotifyConnectionAdded(channel);
        if (channel.channelMetadataRegistry() instanceof SelectorChannelMetadataRegistry) {
            ((SelectorChannelMetadataRegistry)channel.channelMetadataRegistry()).reverseAndAdd(this.sensors);
        }
    }

    public SelectorMetrics sensors() {
        return this.sensors;
    }

    public void registerOnNewEventListener(OnNewEventListener listener) {
        this.onNewEventListeners.add(listener);
    }

    public static interface OnNewEventListener {
        public void notifyOnConnection(KafkaChannel var1);

        public void notifyOnThreadUsage(String var1, double var2, long var4);
    }

    private class AsyncAuth {
        private final AsyncAuthRunnable asyncAuthRunnable;
        private final Future<?> future;
        private final SelectionKey selectionKey;
        private boolean wasCancelled;

        public AsyncAuth(AsyncAuthRunnable asyncAuthRunnable, Future<?> future, SelectionKey selectionKey) {
            this.asyncAuthRunnable = asyncAuthRunnable;
            this.future = future;
            this.selectionKey = selectionKey;
            this.wasCancelled = false;
        }

        public void tryCancel(long currentTimeNanos) {
            if (this.asyncAuthRunnable.shouldCancel()) {
                this.cancelNow();
            }
        }

        public void cancelNow() {
            if (!this.wasCancelled) {
                this.asyncAuthRunnable.markCancelled();
                this.future.cancel(true);
                this.wasCancelled = true;
                if (Selector.this.asyncAuthExecutorService != null && Selector.this.asyncAuthExecutorService instanceof ThreadPoolExecutor) {
                    int qSize = ((ThreadPoolExecutor)Selector.this.asyncAuthExecutorService).getQueue().size();
                    Selector.this.log.info("Async auth runnable cancelled - tasks in queue: {}", (Object)qSize);
                }
            }
        }
    }

    private class DelayedAuthenticationFailureClose {
        private final KafkaChannel channel;
        private final long endTimeNanos;
        private boolean closed;
        private Consumer<KafkaChannel> channelClosingCallback;

        public DelayedAuthenticationFailureClose(KafkaChannel channel, int delayMs, Consumer<KafkaChannel> channelClosingCallback) {
            this.channel = channel;
            this.endTimeNanos = Selector.this.time.nanoseconds() + (long)delayMs * 1000L * 1000L;
            this.closed = false;
            this.channelClosingCallback = channelClosingCallback;
        }

        public final boolean tryClose(long currentTimeNanos) {
            if (this.endTimeNanos <= currentTimeNanos) {
                this.closeNow();
            }
            return this.closed;
        }

        public final void closeNow() {
            if (this.closed) {
                throw new IllegalStateException("Attempt to close a channel that has already been closed");
            }
            this.channelClosingCallback.accept(this.channel);
            this.closed = true;
        }
    }

    public static class SelectorMetrics
    implements AutoCloseable {
        private final Metrics metrics;
        private final Map<String, String> metricTags;
        private final boolean metricsPerConnection;
        private final String metricGrpName;
        private final String perConnectionMetricGrpName;
        public final Sensor connectionClosed;
        public final Sensor idleConnectionClosed;
        public final Sensor forceConnectionClosed;
        public final Sensor connectionCreated;
        public final Sensor reverseConnectionAdded;
        public final Sensor reverseConnectionRemoved;
        public final Sensor successfulAuthentication;
        public final Sensor successfulReauthentication;
        public final Sensor successfulAuthenticationNoReauth;
        public final Sensor reauthenticationLatency;
        public final Sensor failedAuthentication;
        public final Sensor failedReauthentication;
        public final Sensor timedOutAuthentication;
        public final Sensor failedHandshake;
        public final Sensor connectionRegisterTime;
        public final Sensor transportHandshakeTime;
        public final Sensor connectionAuthenticationTime;
        public final Map<String, Sensor> connectionAuthenticationTimeMapByMechanism;
        public final Map<String, Sensor> connectionAuthenticationSuccessMapByMechanism;
        public final Map<String, Sensor> connectionAuthenticationFailureMapByMechanism;
        public final Map<String, Sensor> connectionLkcValidationFailureMapByTenant;
        public final Sensor requestLocalTime;
        public final Sensor bytesTransferred;
        public final Sensor bytesSent;
        public final Sensor requestsSent;
        public final Sensor bytesReceived;
        public final Sensor responsesReceived;
        public final Sensor selectTime;
        public final Sensor ioTime;
        public final IntCounterSuite<CipherInformation> connectionsByCipher;
        public final IntCounterSuite<ClientInformation> connectionsByClient;
        private final KafkaMetric selectIoWaitRatioMetric;
        private final List<MetricName> topLevelMetricNames = new ArrayList<MetricName>();
        private final List<Sensor> sensors = new ArrayList<Sensor>();
        private final Time time;
        private final Set<OnNewEventListener> onNewEventListeners;
        private final Set<String> securityMechanisms;
        private final Supplier<Integer> connectionCountSupplier;
        private final Supplier<Integer> asyncAuthTaskCountSupplier;

        public SelectorMetrics(Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, boolean saslServerAuthnAsyncEnable, Logger log, Time time, Set<OnNewEventListener> onNewEventListeners, Set<String> securityMechanisms, Supplier<Integer> connectionCountSupplier, Supplier<Integer> asyncAuthTaskCountSupplier) {
            this.metrics = metrics;
            this.metricTags = metricTags;
            this.metricsPerConnection = metricsPerConnection;
            this.metricGrpName = metricGrpPrefix + "-metrics";
            this.perConnectionMetricGrpName = metricGrpPrefix + "-node-metrics";
            this.time = time;
            this.onNewEventListeners = onNewEventListeners;
            this.securityMechanisms = securityMechanisms;
            this.connectionCountSupplier = connectionCountSupplier;
            this.asyncAuthTaskCountSupplier = asyncAuthTaskCountSupplier;
            String tagsSuffix = SelectorMetrics.buildTagSuffix(metricGrpPrefix, metricTags);
            this.connectionClosed = this.sensor("connections-closed:" + tagsSuffix, new Sensor[0]);
            this.connectionClosed.add(this.createMeter(metrics, this.metricGrpName, metricTags, "connection-close", "connections closed"));
            this.idleConnectionClosed = this.sensor("idle-connections-closed:" + tagsSuffix, new Sensor[0]);
            this.idleConnectionClosed.add(this.createMeter(metrics, this.metricGrpName, metricTags, "idle-connection-close", "idle connections closed"));
            this.forceConnectionClosed = this.sensor("force-connections-closed:" + tagsSuffix, new Sensor[0]);
            this.forceConnectionClosed.add(this.createMeter(metrics, this.metricGrpName, metricTags, "force-connection-close", "force connections closed"));
            this.connectionCreated = this.sensor("connections-created:" + tagsSuffix, new Sensor[0]);
            this.connectionCreated.add(this.createMeter(metrics, this.metricGrpName, metricTags, "connection-creation", "new connections established"));
            this.reverseConnectionAdded = this.sensor("reverse-connections-added:" + tagsSuffix, new Sensor[0]);
            this.reverseConnectionAdded.add(this.createMeter(metrics, this.metricGrpName, metricTags, "reverse-connection-added", "connections reversed and added"));
            this.reverseConnectionRemoved = this.sensor("reverse-connections-removed:" + tagsSuffix, new Sensor[0]);
            this.reverseConnectionRemoved.add(this.createMeter(metrics, this.metricGrpName, metricTags, "reverse-connection-removed", "connections reversed and removed"));
            this.successfulAuthentication = this.sensor("successful-authentication:" + tagsSuffix, new Sensor[0]);
            this.successfulAuthentication.add(this.createMeter(metrics, this.metricGrpName, metricTags, "successful-authentication", "connections with successful authentication"));
            this.successfulReauthentication = this.sensor("successful-reauthentication:" + tagsSuffix, new Sensor[0]);
            this.successfulReauthentication.add(this.createMeter(metrics, this.metricGrpName, metricTags, "successful-reauthentication", "successful re-authentication of connections"));
            this.successfulAuthenticationNoReauth = this.sensor("successful-authentication-no-reauth:" + tagsSuffix, new Sensor[0]);
            MetricName successfulAuthenticationNoReauthMetricName = metrics.metricName("successful-authentication-no-reauth-total", this.metricGrpName, "The total number of connections with successful authentication where the client does not support re-authentication", metricTags);
            this.successfulAuthenticationNoReauth.add(successfulAuthenticationNoReauthMetricName, new CumulativeSum());
            this.failedAuthentication = this.sensor("failed-authentication:" + tagsSuffix, new Sensor[0]);
            this.failedAuthentication.add(this.createMeter(metrics, this.metricGrpName, metricTags, "failed-authentication", "connections with failed authentication"));
            this.failedReauthentication = this.sensor("failed-reauthentication:" + tagsSuffix, new Sensor[0]);
            this.failedReauthentication.add(this.createMeter(metrics, this.metricGrpName, metricTags, "failed-reauthentication", "failed re-authentication of connections"));
            this.timedOutAuthentication = this.sensor("timed-out-authentication:" + tagsSuffix, new Sensor[0]);
            this.timedOutAuthentication.add(this.createMeter(metrics, this.metricGrpName, metricTags, "timed-out-authentication", "connections with failed authentication due to time out"));
            this.failedHandshake = this.sensor("failed-handshake:" + tagsSuffix, new Sensor[0]);
            this.failedHandshake.add(this.createMeter(metrics, this.metricGrpName, metricTags, "failed-handshake", "connections with failed handshake"));
            this.connectionRegisterTime = this.sensor("connection-register-time:" + tagsSuffix, new Sensor[0]);
            this.transportHandshakeTime = this.sensor("handshake-time:" + tagsSuffix, new Sensor[0]);
            MetricName handshakeTimeMaxMetricName = metrics.metricName("handshake-time-ns-max", this.metricGrpName, "Maximum time taken for a connection handshake (ns)", metricTags);
            this.transportHandshakeTime.add(handshakeTimeMaxMetricName, new Max());
            MetricName handshakeTimeAvgMetricName = metrics.metricName("handshake-time-ns-avg", this.metricGrpName, "Average time taken for a connection handshake (ns)", metricTags);
            this.transportHandshakeTime.add(handshakeTimeAvgMetricName, new Avg());
            this.connectionAuthenticationTime = this.sensor("connection-authentication-time:" + tagsSuffix, new Sensor[0]);
            this.connectionAuthenticationTimeMapByMechanism = new HashMap<String, Sensor>();
            this.connectionAuthenticationSuccessMapByMechanism = new HashMap<String, Sensor>();
            this.connectionAuthenticationFailureMapByMechanism = new HashMap<String, Sensor>();
            this.connectionLkcValidationFailureMapByTenant = new HashMap<String, Sensor>();
            this.createConnectionAuthenticationMetrics(tagsSuffix);
            this.requestLocalTime = this.sensor("request-local-time:" + tagsSuffix, new Sensor[0]);
            this.reauthenticationLatency = this.sensor("reauthentication-latency:" + tagsSuffix, new Sensor[0]);
            MetricName reauthenticationLatencyMaxMetricName = metrics.metricName("reauthentication-latency-max", this.metricGrpName, "The max latency observed due to re-authentication", metricTags);
            this.reauthenticationLatency.add(reauthenticationLatencyMaxMetricName, new Max());
            MetricName reauthenticationLatencyAvgMetricName = metrics.metricName("reauthentication-latency-avg", this.metricGrpName, "The average latency observed due to re-authentication", metricTags);
            this.reauthenticationLatency.add(reauthenticationLatencyAvgMetricName, new Avg());
            this.bytesTransferred = this.sensor("bytes-sent-received:" + tagsSuffix, new Sensor[0]);
            this.bytesTransferred.add(this.createMeter(metrics, this.metricGrpName, metricTags, new WindowedCount(), "network-io", "network operations (reads or writes) on all connections"));
            this.bytesSent = this.sensor("bytes-sent:" + tagsSuffix, this.bytesTransferred);
            this.bytesSent.add(this.createMeter(metrics, this.metricGrpName, metricTags, "outgoing-byte", "outgoing bytes sent to all servers"));
            this.requestsSent = this.sensor("requests-sent:" + tagsSuffix, new Sensor[0]);
            this.requestsSent.add(this.createMeter(metrics, this.metricGrpName, metricTags, new WindowedCount(), "request", "requests sent"));
            MetricName metricName = metrics.metricName("request-size-avg", this.metricGrpName, "The average size of requests sent.", metricTags);
            this.requestsSent.add(metricName, new Avg());
            metricName = metrics.metricName("request-size-max", this.metricGrpName, "The maximum size of any request sent.", metricTags);
            this.requestsSent.add(metricName, new Max());
            this.bytesReceived = this.sensor("bytes-received:" + tagsSuffix, this.bytesTransferred);
            this.bytesReceived.add(this.createMeter(metrics, this.metricGrpName, metricTags, "incoming-byte", "bytes read off all sockets"));
            this.responsesReceived = this.sensor("responses-received:" + tagsSuffix, new Sensor[0]);
            this.responsesReceived.add(this.createMeter(metrics, this.metricGrpName, metricTags, new WindowedCount(), "response", "responses received"));
            this.selectTime = this.sensor("select-time:" + tagsSuffix, new Sensor[0]);
            this.selectTime.add(this.createMeter(metrics, this.metricGrpName, metricTags, new WindowedCount(), "select", "times the I/O layer checked for new I/O to perform"));
            metricName = metrics.metricName("io-wait-time-ns-avg", this.metricGrpName, "The average length of time the I/O thread spent waiting for a socket ready for reads or writes in nanoseconds.", metricTags);
            this.selectTime.add(metricName, new Avg());
            this.selectTime.add(this.createIOThreadRatioMeterLegacy(metrics, this.metricGrpName, metricTags, "io-wait", "waiting"));
            this.selectTime.add(this.createIOThreadRatioMeter(metrics, this.metricGrpName, metricTags, "io-wait", "waiting"));
            this.selectIoWaitRatioMetric = metrics.metric(metrics.metricName("io-wait-ratio", this.metricGrpName, metricTags));
            this.ioTime = this.sensor("io-time:" + tagsSuffix, new Sensor[0]);
            metricName = metrics.metricName("io-time-ns-avg", this.metricGrpName, "The average length of time for I/O per select call in nanoseconds.", metricTags);
            this.ioTime.add(metricName, new Avg());
            this.ioTime.add(this.createIOThreadRatioMeterLegacy(metrics, this.metricGrpName, metricTags, "io", "doing I/O"));
            this.ioTime.add(this.createIOThreadRatioMeter(metrics, this.metricGrpName, metricTags, "io", "doing I/O"));
            this.connectionsByCipher = new IntCounterSuite<CipherInformation>(log, "sslCiphers", metrics, cipherInformation -> {
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                tags.put("cipher", cipherInformation.cipher());
                tags.put("protocol", cipherInformation.protocol());
                tags.putAll(metricTags);
                return metrics.metricName("connections", this.metricGrpName, "The number of connections with this SSL cipher and protocol.", tags);
            }, 100);
            this.connectionsByClient = new IntCounterSuite<ClientInformation>(log, "clients", metrics, clientInformation -> {
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                tags.put("clientSoftwareName", clientInformation.softwareName());
                tags.put("clientSoftwareVersion", clientInformation.softwareVersion());
                tags.putAll(metricTags);
                return metrics.metricName("connections", this.metricGrpName, "The number of connections with this client and version.", tags);
            }, 100);
            this.addTopLevelMetrics(saslServerAuthnAsyncEnable);
        }

        public static String buildTagSuffix(String metricGrpPrefix, Map<String, String> metricTags) {
            StringBuilder tagsSuffix = new StringBuilder();
            tagsSuffix.append(metricGrpPrefix);
            tagsSuffix.append("-");
            for (Map.Entry<String, String> tag : metricTags.entrySet()) {
                tagsSuffix.append(tag.getKey());
                tagsSuffix.append("-");
                tagsSuffix.append(tag.getValue());
            }
            return tagsSuffix.toString();
        }

        private void addTopLevelMetrics(boolean saslServerAuthnAsyncEnable) {
            MetricName metricName = this.metrics.metricName("connection-count", this.metricGrpName, "The current number of active connections.", this.metricTags);
            this.topLevelMetricNames.add(metricName);
            this.metrics.addMetric(metricName, (config, now) -> this.connectionCountSupplier.get().intValue());
            if (saslServerAuthnAsyncEnable) {
                metricName = this.metrics.metricName("queued-async-auth-tasks-count", this.metricGrpName, "Async auth task count in the queue.", this.metricTags);
                this.topLevelMetricNames.add(metricName);
                this.metrics.addMetric(metricName, (config, now) -> this.asyncAuthTaskCountSupplier.get().intValue());
            }
        }

        private void createConnectionAuthenticationMetrics(String tagsSuffix) {
            HashSet<String> mechanisms = new HashSet<String>(this.securityMechanisms);
            mechanisms.add("DEFAULT");
            LinkedHashMap<String, String> metricsTagsWithMechanism = new LinkedHashMap<String, String>(this.metricTags);
            for (String mechanism : mechanisms) {
                metricsTagsWithMechanism.put("mechanism", mechanism);
                Sensor sensor = this.sensor(mechanism + "-connection-authentication-time:" + tagsSuffix, new Sensor[0]);
                this.connectionAuthenticationTimeMapByMechanism.put(mechanism, sensor);
                MetricName metricsName = this.metrics.metricName("authentication-time-ns-max", this.metricGrpName, "Maximum time taken for authentication (ns)", metricsTagsWithMechanism);
                sensor.add(metricsName, new Max());
                metricsName = this.metrics.metricName("authentication-time-ns-avg", this.metricGrpName, "Average time taken for authentication (ns)", metricsTagsWithMechanism);
                sensor.add(metricsName, new Avg());
                sensor = this.sensor(mechanism + "-connection-authentication-success:" + tagsSuffix, new Sensor[0]);
                this.connectionAuthenticationSuccessMapByMechanism.put(mechanism, sensor);
                sensor.add(this.createMeter(this.metrics, this.metricGrpName, metricsTagsWithMechanism, "successful-connection-authentications", "connections with successful authentication"));
                sensor = this.sensor(mechanism + "-connection-authentication-failure:" + tagsSuffix, new Sensor[0]);
                this.connectionAuthenticationFailureMapByMechanism.put(mechanism, sensor);
                sensor.add(this.createMeter(this.metrics, this.metricGrpName, metricsTagsWithMechanism, "failed-connection-authentications", "connections with failed authentication"));
            }
        }

        private Meter createMeter(Metrics metrics, String groupName, Map<String, String> metricTags, SampledStat stat, String baseName, String descriptiveName) {
            MetricName rateMetricName = metrics.metricName(baseName + "-rate", groupName, String.format("The number of %s per second", descriptiveName), metricTags);
            MetricName totalMetricName = metrics.metricName(baseName + "-total", groupName, String.format("The total number of %s", descriptiveName), metricTags);
            if (stat == null) {
                return new Meter(rateMetricName, totalMetricName);
            }
            return new Meter(stat, rateMetricName, totalMetricName);
        }

        private Meter createMeter(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String descriptiveName) {
            return this.createMeter(metrics, groupName, metricTags, null, baseName, descriptiveName);
        }

        @Deprecated
        private Meter createIOThreadRatioMeterLegacy(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String action) {
            MetricName rateMetricName = metrics.metricName(baseName + "-ratio", groupName, String.format("*Deprecated* The fraction of time the I/O thread spent %s", action), metricTags);
            MetricName totalMetricName = metrics.metricName(baseName + "time-total", groupName, String.format("*Deprecated* The total time the I/O thread spent %s", action), metricTags);
            return new Meter(TimeUnit.NANOSECONDS, rateMetricName, totalMetricName);
        }

        private Meter createIOThreadRatioMeter(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String action) {
            MetricName rateMetricName = metrics.metricName(baseName + "-ratio", groupName, String.format("The fraction of time the I/O thread spent %s", action), metricTags);
            MetricName totalMetricName = metrics.metricName(baseName + "-time-ns-total", groupName, String.format("The total time the I/O thread spent %s", action), metricTags);
            return new Meter(TimeUnit.NANOSECONDS, rateMetricName, totalMetricName);
        }

        private Sensor sensor(String name, Sensor ... parents) {
            Sensor sensor = this.metrics.sensor(name, parents);
            this.sensors.add(sensor);
            return sensor;
        }

        public void maybeRegisterConnectionMetrics(String connectionId) {
            String nodeRequestName;
            Sensor nodeRequest;
            if (!connectionId.isEmpty() && this.metricsPerConnection && (nodeRequest = this.metrics.getSensor(nodeRequestName = "node-" + connectionId + ".requests-sent")) == null) {
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(this.metricTags);
                tags.put("node-id", "node-" + connectionId);
                nodeRequest = this.sensor(nodeRequestName, new Sensor[0]);
                nodeRequest.add(this.createMeter(this.metrics, this.perConnectionMetricGrpName, tags, new WindowedCount(), "request", "requests sent"));
                MetricName metricName = this.metrics.metricName("request-size-avg", this.perConnectionMetricGrpName, "The average size of requests sent.", tags);
                nodeRequest.add(metricName, new Avg());
                metricName = this.metrics.metricName("request-size-max", this.perConnectionMetricGrpName, "The maximum size of any request sent.", tags);
                nodeRequest.add(metricName, new Max());
                String bytesSentName = "node-" + connectionId + ".bytes-sent";
                Sensor bytesSent = this.sensor(bytesSentName, new Sensor[0]);
                bytesSent.add(this.createMeter(this.metrics, this.perConnectionMetricGrpName, tags, "outgoing-byte", "outgoing bytes"));
                String nodeResponseName = "node-" + connectionId + ".responses-received";
                Sensor nodeResponse = this.sensor(nodeResponseName, new Sensor[0]);
                nodeResponse.add(this.createMeter(this.metrics, this.perConnectionMetricGrpName, tags, new WindowedCount(), "response", "responses received"));
                String bytesReceivedName = "node-" + connectionId + ".bytes-received";
                Sensor bytesReceive = this.sensor(bytesReceivedName, new Sensor[0]);
                bytesReceive.add(this.createMeter(this.metrics, this.perConnectionMetricGrpName, tags, "incoming-byte", "incoming bytes"));
                String nodeTimeName = "node-" + connectionId + ".latency";
                Sensor nodeRequestTime = this.sensor(nodeTimeName, new Sensor[0]);
                metricName = this.metrics.metricName("request-latency-avg", this.perConnectionMetricGrpName, tags);
                nodeRequestTime.add(metricName, new Avg());
                metricName = this.metrics.metricName("request-latency-max", this.perConnectionMetricGrpName, tags);
                nodeRequestTime.add(metricName, new Max());
            }
        }

        public void recordBytesSent(String connectionId, long bytes, long currentTimeMs) {
            String bytesSentName;
            Sensor bytesSent;
            this.bytesSent.record(bytes, currentTimeMs, false);
            if (!connectionId.isEmpty() && (bytesSent = this.metrics.getSensor(bytesSentName = "node-" + connectionId + ".bytes-sent")) != null) {
                bytesSent.record(bytes, currentTimeMs);
            }
        }

        public void recordCompletedSend(String connectionId, long totalBytes, long currentTimeMs) {
            String nodeRequestName;
            Sensor nodeRequest;
            this.requestsSent.record(totalBytes, currentTimeMs, false);
            if (!connectionId.isEmpty() && (nodeRequest = this.metrics.getSensor(nodeRequestName = "node-" + connectionId + ".requests-sent")) != null) {
                nodeRequest.record(totalBytes, currentTimeMs);
            }
        }

        public void recordBytesReceived(String connectionId, long bytes, long currentTimeMs) {
            String bytesReceivedName;
            Sensor bytesReceived;
            this.bytesReceived.record(bytes, currentTimeMs, false);
            if (!connectionId.isEmpty() && (bytesReceived = this.metrics.getSensor(bytesReceivedName = "node-" + connectionId + ".bytes-received")) != null) {
                bytesReceived.record(bytes, currentTimeMs);
            }
        }

        public void recordCompletedReceive(String connectionId, long totalBytes, long currentTimeMs) {
            String nodeRequestName;
            Sensor nodeRequest;
            this.responsesReceived.record(totalBytes, currentTimeMs, false);
            if (!connectionId.isEmpty() && (nodeRequest = this.metrics.getSensor(nodeRequestName = "node-" + connectionId + ".responses-received")) != null) {
                nodeRequest.record(totalBytes, currentTimeMs);
            }
        }

        public Map<String, String> tags() {
            return this.metricTags;
        }

        public void maybeRecordNewConnectionMetrics(KafkaChannel channel, boolean success, String logicalClusterId) {
            if (channel != null) {
                this.onNewEventListeners.forEach(listener -> listener.notifyOnConnection(channel));
                channel.maybeRecordRegisterTime(this.connectionRegisterTime);
                channel.maybeRecordHandshakeTime(this.transportHandshakeTime);
                channel.maybeRecordAuthenticationTime(this.connectionAuthenticationTime, this.connectionAuthenticationTimeMapByMechanism);
                if (success) {
                    channel.maybeRecordAuthenticationCount(this.connectionAuthenticationSuccessMapByMechanism, this.time);
                } else {
                    channel.maybeRecordAuthenticationCount(this.connectionAuthenticationFailureMapByMechanism, this.time);
                    if (!logicalClusterId.isEmpty()) {
                        Sensor sensor = this.connectionLkcValidationFailureMapByTenant.get(logicalClusterId);
                        if (sensor == null) {
                            sensor = this.sensor(logicalClusterId + "-lkc-validation-failure:", new Sensor[0]);
                            this.connectionLkcValidationFailureMapByTenant.put(logicalClusterId, sensor);
                            LinkedHashMap<String, String> metricsTagsWithTenant = new LinkedHashMap<String, String>(this.metricTags);
                            metricsTagsWithTenant.put("tenant", logicalClusterId);
                            sensor.add(this.createMeter(this.metrics, this.metricGrpName, metricsTagsWithTenant, "failed-lkc-validation", "connections with failed LKC validation"));
                        }
                        sensor.record(1.0, this.time.milliseconds(), false);
                    }
                }
            }
        }

        public void recordIdleThreadMetrics(long timeMs) {
            String listenerName = this.metricTags.get("listener");
            if (listenerName != null) {
                double metricValue = this.selectIoWaitRatioMetric == null ? 0.0 : Math.min((Double)this.selectIoWaitRatioMetric.metricValue(), 1.0);
                this.onNewEventListeners.forEach(listener -> listener.notifyOnThreadUsage(listenerName, metricValue, timeMs));
            }
        }

        @Override
        public void close() {
            for (MetricName metricName : this.topLevelMetricNames) {
                this.metrics.removeMetric(metricName);
            }
            for (Sensor sensor : this.sensors) {
                this.metrics.removeSensor(sensor.name());
            }
            this.connectionsByCipher.close();
            this.connectionsByClient.close();
        }
    }

    public static class SelectorMetricsParams {
        private final Metrics metrics;
        private final String metricGrpPrefix;
        private final Map<String, String> metricTags;
        private final boolean metricsPerConnection;
        private final boolean recordTimePerConnection;
        private final SelectorMetrics selectorMetrics;

        public SelectorMetricsParams(Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags, boolean metricsPerConnection, boolean recordTimePerConnection, SelectorMetrics selectorMetrics) {
            this.metrics = metrics;
            this.metricGrpPrefix = metricGrpPrefix;
            this.metricTags = metricTags;
            this.metricsPerConnection = metricsPerConnection;
            this.recordTimePerConnection = recordTimePerConnection;
            this.selectorMetrics = selectorMetrics;
        }
    }

    static class SelectorChannelMetadataRegistry
    implements ChannelMetadataRegistry {
        private CipherInformation cipherInformation;
        private ClientInformation clientInformation;
        private SelectorMetrics sensors;

        public SelectorChannelMetadataRegistry(SelectorMetrics sensors) {
            this.sensors = sensors;
        }

        public void reverseAndAdd(SelectorMetrics sensors) {
            CipherInformation cipherInformationCopy = this.cipherInformation;
            this.close();
            this.sensors = sensors;
            if (cipherInformationCopy != null) {
                this.registerCipherInformation(cipherInformationCopy);
            }
            this.registerClientInformation(ClientInformation.EMPTY);
        }

        @Override
        public void registerCipherInformation(CipherInformation cipherInformation) {
            if (this.cipherInformation != null) {
                if (this.cipherInformation.equals(cipherInformation)) {
                    return;
                }
                this.sensors.connectionsByCipher.decrement(this.cipherInformation);
            }
            this.cipherInformation = cipherInformation;
            this.sensors.connectionsByCipher.increment(cipherInformation);
        }

        @Override
        public CipherInformation cipherInformation() {
            return this.cipherInformation;
        }

        @Override
        public void registerClientInformation(ClientInformation clientInformation) {
            if (this.clientInformation != null) {
                if (this.clientInformation.equals(clientInformation)) {
                    return;
                }
                this.sensors.connectionsByClient.decrement(this.clientInformation);
            }
            this.clientInformation = clientInformation;
            this.sensors.connectionsByClient.increment(clientInformation);
        }

        @Override
        public ClientInformation clientInformation() {
            return this.clientInformation;
        }

        @Override
        public void close() {
            if (this.cipherInformation != null) {
                this.sensors.connectionsByCipher.decrement(this.cipherInformation);
                this.cipherInformation = null;
            }
            if (this.clientInformation != null) {
                this.sensors.connectionsByClient.decrement(this.clientInformation);
                this.clientInformation = null;
            }
        }
    }

    public static enum CloseMode {
        GRACEFUL(true),
        NOTIFY_ONLY(true),
        DISCARD_NO_NOTIFY(false);

        boolean notifyDisconnect;

        private CloseMode(boolean notifyDisconnect) {
            this.notifyDisconnect = notifyDisconnect;
        }
    }
}

