/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreatePartitionsResponse
extends AbstractResponse {
    private final CreatePartitionsResponseData data;

    public CreatePartitionsResponse(CreatePartitionsResponseData data) {
        super(ApiKeys.CREATE_PARTITIONS);
        this.data = data;
    }

    @Override
    public CreatePartitionsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> this.updateErrorCounts(counts, Errors.forCode(result.errorCode())));
        return counts;
    }

    public static CreatePartitionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new CreatePartitionsResponse(new CreatePartitionsResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public CreatePartitionsResponse updateResponseWithValidationErrors(Map<CreatePartitionsRequestData.CreatePartitionsTopic, ApiError> validationErrors) {
        if (validationErrors.isEmpty()) {
            return this;
        }
        validationErrors.forEach((topic, error) -> this.data.results().add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(error.error().code()).setErrorMessage(error.message())));
        return this;
    }
}

