/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DescribeNetworkRequestData;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeNetworkResponse;

public class DescribeNetworkRequest
extends AbstractRequest {
    private final DescribeNetworkRequestData data;

    DescribeNetworkRequest(DescribeNetworkRequestData data, short version) {
        super(ApiKeys.DESCRIBE_NETWORK, version);
        this.data = data;
    }

    @Override
    public DescribeNetworkRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new DescribeNetworkResponse(new DescribeNetworkResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DescribeNetworkRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeNetworkRequest(new DescribeNetworkRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeNetworkRequest> {
        private final DescribeNetworkRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_NETWORK);
            this.data = new DescribeNetworkRequestData();
        }

        public Builder(DescribeNetworkRequestData data) {
            super(ApiKeys.DESCRIBE_NETWORK);
            this.data = data;
        }

        @Override
        public DescribeNetworkRequest build(short version) {
            return new DescribeNetworkRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

