/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthenticationTimeoutException;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.AsyncAuthRunnable;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.InvalidReceiveException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.ReauthenticationContext;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.kerberos.KerberosError;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerAuthenticator.class);
    public static final String SNI_BROKER_HOST_NAME_SASL_PROPERTY_KEY = "__confluent_sni_broker_host_name";
    public static final String SASL_HANDSHAKE_CONFIG_PREFIX = "sasl.handshake.";
    private final SecurityProtocol securityProtocol;
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private final String connectionId;
    private final long sessionId;
    private final Map<String, Subject> subjects;
    private final TransportLayer transportLayer;
    private final List<String> enabledMechanisms;
    private final Map<String, ?> configs;
    private final Map<String, Object> saslServerProps;
    private final KafkaPrincipalBuilder principalBuilder;
    private final Map<String, AuthenticateCallbackHandler> callbackHandlers;
    private final Map<String, Long> connectionsMaxReauthMsByMechanism;
    private final Time time;
    private final ReauthInfo reauthInfo;
    private final ChannelMetadataRegistry metadataRegistry;
    private final Supplier<ApiVersionsResponse> apiVersionSupplier;
    private PathAwareSniHostName sniHostName;
    private SaslState saslState = SaslState.INITIAL_REQUEST;
    private SaslState pendingSaslState = null;
    private AuthenticationException pendingException = null;
    private boolean shouldRestoreReadInterest;
    private SaslServer saslServer;
    private String saslMechanism;
    private KafkaPrincipal principal;
    private final Map<String, Boolean> asyncAuthEnabledByMechanism;
    private final Map<String, Long> asyncAuthTimeoutByMechanism;
    private final AsyncAuthExecutor asyncAuthExecutor;
    private Integer saslAuthRequestMaxReceiveSize;
    private NetworkReceive netInBuffer;
    private Send netOutBuffer;
    private Send authenticationFailureSend = null;
    private boolean enableKafkaSaslAuthenticateHeaders;
    private SaslTokenInfo saslTokenInfo;
    private RequestCallback requestCallback;
    private final Map<String, Integer> saslServerMaxReceiveSizeByMechanism;
    private Integer saslAuthRequestMaxHandshakeReceiveSize;

    public SaslServerAuthenticator(Map<String, ?> configs, Map<String, AuthenticateCallbackHandler> callbackHandlers, String connectionId, long sessionId, Map<String, Subject> subjects, KerberosShortNamer kerberosNameParser, ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, TransportLayer transportLayer, Map<String, Long> connectionsMaxReauthMsByMechanism, Map<String, Boolean> asyncAuthEnabledByMechanism, Map<String, Long> asyncAuthTimeoutByMechanism, Map<String, Integer> saslServerMaxReceiveSizeByMechanism, AsyncAuthExecutor asyncAuthExecutor, ChannelMetadataRegistry metadataRegistry, Time time, Supplier<ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallback) {
        this.callbackHandlers = callbackHandlers;
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.subjects = subjects;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.securityProtocol = securityProtocol;
        this.saslServerMaxReceiveSizeByMechanism = saslServerMaxReceiveSizeByMechanism;
        this.enableKafkaSaslAuthenticateHeaders = false;
        this.transportLayer = transportLayer;
        this.connectionsMaxReauthMsByMechanism = connectionsMaxReauthMsByMechanism;
        this.time = time;
        this.reauthInfo = new ReauthInfo();
        this.metadataRegistry = metadataRegistry;
        this.apiVersionSupplier = apiVersionSupplier;
        this.requestCallback = requestCallback;
        this.configs = configs;
        this.saslServerProps = new HashMap<String, Object>();
        List enabledMechanisms = (List)this.configs.get("sasl.enabled.mechanisms");
        if (enabledMechanisms == null || enabledMechanisms.isEmpty()) {
            throw new IllegalArgumentException("No SASL mechanisms are enabled");
        }
        this.enabledMechanisms = new ArrayList<String>(new HashSet(enabledMechanisms));
        for (String mechanism : this.enabledMechanisms) {
            if (!callbackHandlers.containsKey(mechanism)) {
                throw new IllegalArgumentException("Callback handler not specified for SASL mechanism " + mechanism);
            }
            if (!subjects.containsKey(mechanism)) {
                throw new IllegalArgumentException("Subject cannot be null for SASL mechanism " + mechanism);
            }
            LOG.trace("{} for mechanism={}: {}", new Object[]{"connections.max.reauth.ms", mechanism, connectionsMaxReauthMsByMechanism.get(mechanism)});
        }
        this.asyncAuthEnabledByMechanism = asyncAuthEnabledByMechanism;
        this.asyncAuthTimeoutByMechanism = asyncAuthTimeoutByMechanism;
        this.asyncAuthExecutor = asyncAuthExecutor;
        this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, kerberosNameParser, null);
        this.saslAuthRequestMaxReceiveSize = (Integer)configs.get("sasl.server.max.receive.size");
        if (this.saslAuthRequestMaxReceiveSize == null) {
            this.saslAuthRequestMaxReceiveSize = 524288;
        }
        this.saslAuthRequestMaxHandshakeReceiveSize = configs.get("sasl.handshake.sasl.server.max.receive.size") == null ? this.saslAuthRequestMaxReceiveSize : Integer.valueOf((String)configs.get("sasl.handshake.sasl.server.max.receive.size"));
    }

    private void createSaslServer(String networkId) throws IOException {
        if (this.saslServer != null) {
            return;
        }
        Subject subject = this.subjects.get(this.saslMechanism);
        AuthenticateCallbackHandler callbackHandler = this.callbackHandlers.get(this.saslMechanism);
        if (this.saslMechanism.equals("GSSAPI")) {
            this.saslServer = this.createSaslKerberosServer(callbackHandler, this.configs, subject);
        } else {
            try {
                Map<String, ?> newConfigs = this.configs;
                newConfigs.put(SNI_BROKER_HOST_NAME_SASL_PROPERTY_KEY, this.sniHostName);
                newConfigs.put("__confluent_traffic_network_id", networkId);
                newConfigs.putAll(this.saslServerProps);
                this.saslServer = Subject.doAs(subject, () -> Sasl.createSaslServer(this.saslMechanism, "kafka", this.serverAddress().getHostName(), newConfigs, callbackHandler));
                if (this.saslServer == null) {
                    throw new SaslException("Kafka Server failed to create a SaslServer to interact with a client during session authentication with server mechanism " + this.saslMechanism);
                }
            }
            catch (PrivilegedActionException e) {
                throw new SaslException("Kafka Server failed to create a SaslServer to interact with a client during session authentication with server mechanism " + this.saslMechanism, e.getCause());
            }
        }
    }

    private SaslServer createSaslKerberosServer(AuthenticateCallbackHandler saslServerCallbackHandler, Map<String, ?> configs, Subject subject) throws IOException {
        KerberosName kerberosName;
        String servicePrincipal = SaslClientAuthenticator.firstPrincipal(subject);
        try {
            kerberosName = KerberosName.parse(servicePrincipal);
        }
        catch (IllegalArgumentException e) {
            throw new KafkaException("Principal has name with unexpected format " + servicePrincipal);
        }
        String servicePrincipalName = kerberosName.serviceName();
        String serviceHostname = kerberosName.hostName();
        LOG.debug("Creating SaslServer for {} with mechanism {}", (Object)kerberosName, (Object)this.saslMechanism);
        try {
            return Subject.doAs(subject, () -> Sasl.createSaslServer(this.saslMechanism, servicePrincipalName, serviceHostname, configs, saslServerCallbackHandler));
        }
        catch (PrivilegedActionException e) {
            throw new SaslException("Kafka Server failed to create a SaslServer to interact with a client during session authentication", e.getCause());
        }
    }

    @Override
    public void authenticate() throws IOException {
        if (this.saslTokenInfo != null && this.saslTokenInfo instanceof SaslTokenInfoAsync) {
            if (((SaslTokenInfoAsync)this.saslTokenInfo).isComplete()) {
                try {
                    EvaluateResponseResultSupplier supplier = this.saslTokenInfo.evaluateResponseResultSupplier();
                    this.handleSaslTokenStep2(supplier);
                    if (this.saslServer.isComplete()) {
                        this.setSaslState(SaslState.COMPLETE);
                    }
                }
                catch (AuthenticationException e) {
                    this.setSaslState(SaslState.FAILED, e);
                }
                catch (Exception e) {
                    this.saslState = SaslState.FAILED;
                    LOG.debug("Failed during {}: {}", (Object)this.reauthInfo.authenticationOrReauthenticationText(), (Object)e.getMessage());
                    throw e;
                }
                finally {
                    this.saslTokenInfo = null;
                }
            }
            return;
        }
        if (this.saslState != SaslState.REAUTH_PROCESS_HANDSHAKE) {
            if (this.netOutBuffer != null && !this.flushNetOutBufferAndUpdateInterestOps()) {
                return;
            }
            if (this.saslServer != null && this.saslServer.isComplete()) {
                this.setSaslState(SaslState.COMPLETE);
                return;
            }
            if (this.netInBuffer == null) {
                this.netInBuffer = new NetworkReceive(this.maxNetInBufferSize(), this.connectionId);
            }
            try {
                this.netInBuffer.readFrom(this.transportLayer);
            }
            catch (InvalidReceiveException e) {
                throw new SaslAuthenticationException("Failing SASL authentication due to invalid receive size", e);
            }
            if (!this.netInBuffer.complete()) {
                return;
            }
            this.netInBuffer.payload().rewind();
        }
        byte[] clientToken = new byte[this.netInBuffer.payload().remaining()];
        this.netInBuffer.payload().get(clientToken, 0, clientToken.length);
        this.netInBuffer = null;
        try {
            switch (this.saslState) {
                case REAUTH_PROCESS_HANDSHAKE: 
                case HANDSHAKE_OR_VERSIONS_REQUEST: 
                case HANDSHAKE_REQUEST: {
                    this.handleKafkaRequest(clientToken);
                    break;
                }
                case REAUTH_BAD_MECHANISM: {
                    throw new SaslAuthenticationException(this.reauthInfo.badMechanismErrorMessage);
                }
                case INITIAL_REQUEST: {
                    if (this.handleKafkaRequest(clientToken)) break;
                }
                case AUTHENTICATE: {
                    this.authenticate(clientToken);
                    break;
                }
            }
        }
        catch (AuthenticationException e) {
            this.setSaslState(SaslState.FAILED, e);
        }
        catch (Exception e) {
            this.saslState = SaslState.FAILED;
            LOG.debug("Failed during {}: {}", (Object)this.reauthInfo.authenticationOrReauthenticationText(), (Object)e.getMessage());
            throw e;
        }
    }

    private int maxNetInBufferSize() {
        return this.saslMechanism == null ? this.saslAuthRequestMaxHandshakeReceiveSize.intValue() : this.saslServerMaxReceiveSizeByMechanism.get(this.saslMechanism).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(byte[] clientToken) throws IOException {
        boolean isAsyncAuthEnabled = Boolean.TRUE.equals(this.asyncAuthEnabledByMechanism.get(this.saslMechanism));
        if (isAsyncAuthEnabled) {
            Long timeoutMs = this.asyncAuthTimeoutByMechanism.get(this.saslMechanism);
            if (timeoutMs == null) {
                timeoutMs = 30000L;
                LOG.warn("SASL login async timeout not provided for {}, setting to default of {} ms.", (Object)this.saslMechanism, (Object)timeoutMs);
            }
            this.saslTokenInfo = new SaslTokenInfoAsync(this.time, timeoutMs);
        } else {
            this.saslTokenInfo = new SaslTokenInfoSync();
        }
        if ((this.transportLayer.selectionKey().interestOps() & 1) != 0) {
            this.transportLayer.removeInterestOps(1);
            this.shouldRestoreReadInterest = true;
        } else {
            this.shouldRestoreReadInterest = false;
        }
        this.handleSaslTokenStep1(clientToken);
        if (isAsyncAuthEnabled) {
            this.asyncAuthExecutor.execute((SaslTokenInfoAsync)this.saslTokenInfo);
        } else {
            try {
                EvaluateResponseResultSupplier supplier = this.saslTokenInfo.evaluateResponseResultSupplier();
                this.handleSaslTokenStep2(supplier);
                if (this.saslServer.isComplete()) {
                    this.setSaslState(SaslState.COMPLETE);
                }
            }
            finally {
                this.saslTokenInfo = null;
            }
        }
    }

    private KafkaPrincipal buildPrincipal() {
        Optional<SSLSession> sslSession = this.transportLayer instanceof SslTransportLayer ? Optional.of(((SslTransportLayer)this.transportLayer).sslSession()) : Optional.empty();
        SaslAuthenticationContext context = new SaslAuthenticationContext(this.sessionId, this.saslServer, this.securityProtocol, this.clientAddress(), this.listenerName.value(), sslSession);
        KafkaPrincipal principal = this.principalBuilder.build(context);
        if (ScramMechanism.isScram(this.saslMechanism) && Boolean.parseBoolean((String)this.saslServer.getNegotiatedProperty("tokenauth"))) {
            principal.tokenAuthenticated(true);
        }
        return principal;
    }

    @Override
    public KafkaPrincipal principal() {
        if (this.principal == null) {
            this.principal = this.buildPrincipal();
        }
        return this.principal;
    }

    @Override
    public Optional<KafkaPrincipalSerde> principalSerde() {
        return this.principalBuilder instanceof KafkaPrincipalSerde ? Optional.of((KafkaPrincipalSerde)((Object)this.principalBuilder)) : Optional.empty();
    }

    @Override
    public boolean complete() {
        return this.saslState == SaslState.COMPLETE;
    }

    @Override
    public void handleAuthenticationFailure() throws IOException {
        this.sendAuthenticationFailureResponse();
    }

    @Override
    public void close() throws IOException {
        if (this.principalBuilder instanceof Closeable) {
            Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
        }
        if (this.saslServer != null) {
            this.saslServer.dispose();
        }
    }

    @Override
    public void reauthenticate(ReauthenticationContext reauthenticationContext) throws IOException {
        NetworkReceive saslHandshakeReceive = reauthenticationContext.networkReceive();
        if (saslHandshakeReceive == null) {
            throw new IllegalArgumentException("Invalid saslHandshakeReceive in server-side re-authentication context: null");
        }
        SaslServerAuthenticator previousSaslServerAuthenticator = (SaslServerAuthenticator)reauthenticationContext.previousAuthenticator();
        this.reauthInfo.reauthenticating(previousSaslServerAuthenticator.saslMechanism, previousSaslServerAuthenticator.principal(), reauthenticationContext.reauthenticationBeginNanos());
        previousSaslServerAuthenticator.close();
        this.netInBuffer = saslHandshakeReceive;
        LOG.debug("Beginning re-authentication: {}", (Object)this);
        this.netInBuffer.payload().rewind();
        this.setSaslState(SaslState.REAUTH_PROCESS_HANDSHAKE);
        this.authenticate();
    }

    @Override
    public Long serverSessionExpirationTimeNanos() {
        return this.reauthInfo.sessionExpirationTimeNanos;
    }

    @Override
    public Long reauthenticationLatencyMs() {
        return this.reauthInfo.reauthenticationLatencyMs();
    }

    @Override
    public boolean connectedClientSupportsReauthentication() {
        return this.reauthInfo.connectedClientSupportsReauthentication;
    }

    @Override
    public AuthenticationContext authenticationContext() {
        return new SaslAuthenticationContext(this.sessionId, this.saslServer, this.securityProtocol, this.clientAddress(), this.listenerName.value());
    }

    public void setSniHostName(PathAwareSniHostName sniHostName) {
        this.sniHostName = sniHostName;
    }

    public void putSaslServerPropertyIfAbsent(String key, Object value) {
        if (!this.saslServerProps.containsKey(key)) {
            this.saslServerProps.put(key, value);
        }
    }

    private void setSaslState(SaslState saslState) {
        this.setSaslState(saslState, null);
    }

    private void setSaslState(SaslState saslState, AuthenticationException exception) {
        if (this.netOutBuffer != null && !this.netOutBuffer.completed()) {
            this.pendingSaslState = saslState;
            this.pendingException = exception;
        } else {
            this.saslState = saslState;
            LOG.debug("Set SASL server state to {} during {}", (Object)saslState, (Object)this.reauthInfo.authenticationOrReauthenticationText());
            this.pendingSaslState = null;
            this.pendingException = null;
            if (exception != null) {
                throw exception;
            }
        }
    }

    private boolean flushNetOutBufferAndUpdateInterestOps() throws IOException {
        boolean flushedCompletely = this.flushNetOutBuffer();
        if (flushedCompletely) {
            if (this.shouldRestoreReadInterest) {
                this.transportLayer.addInterestOps(1);
            }
            this.transportLayer.removeInterestOps(4);
            if (this.pendingSaslState != null) {
                this.setSaslState(this.pendingSaslState, this.pendingException);
            }
        } else {
            this.transportLayer.addInterestOps(4);
        }
        return flushedCompletely;
    }

    private boolean flushNetOutBuffer() throws IOException {
        if (!this.netOutBuffer.completed()) {
            this.netOutBuffer.writeTo(this.transportLayer);
        }
        return this.netOutBuffer.completed();
    }

    private InetAddress serverAddress() {
        return this.transportLayer.socketChannel().socket().getLocalAddress();
    }

    private InetAddress clientAddress() {
        return this.transportLayer.socketAddress();
    }

    private void handleSaslTokenStep1(byte[] clientToken) throws IOException {
        if (!this.enableKafkaSaslAuthenticateHeaders) {
            this.createSaslServer(null);
            this.saslTokenInfo.setClientToken(clientToken);
        } else {
            ByteBuffer requestBuffer = ByteBuffer.wrap(clientToken);
            RequestHeader header = RequestHeader.parse(requestBuffer);
            ApiKeys apiKey = header.apiKey();
            short version = header.apiVersion();
            RequestContext requestContext = new RequestContext(header, this.connectionId, this.clientAddress(), KafkaPrincipal.ANONYMOUS, this.listenerName, this.securityProtocol, ClientInformation.EMPTY, this.sniHostName, false, this.principalSerde(), this.transportLayer.isProxyModeLocal());
            RequestAndSize requestAndSize = requestContext.parseRequest(requestBuffer);
            if (apiKey != ApiKeys.SASL_AUTHENTICATE) {
                IllegalSaslStateException e = new IllegalSaslStateException("Unexpected Kafka request of type " + (Object)((Object)apiKey) + " during SASL authentication.");
                this.buildResponseOnAuthenticateFailure(requestContext, requestAndSize.request.getErrorResponse(e));
                throw e;
            }
            if (!apiKey.isVersionSupported(version)) {
                throw new UnsupportedVersionException("Version " + version + " is not supported for apiKey " + (Object)((Object)apiKey));
            }
            if (!this.reauthInfo.connectedClientSupportsReauthentication) {
                this.reauthInfo.connectedClientSupportsReauthentication = version > 0;
            }
            SaslAuthenticateRequest saslAuthenticateRequest = (SaslAuthenticateRequest)requestAndSize.request;
            SaslAuthenticateRequestData requestData = saslAuthenticateRequest.data();
            this.createSaslServer(requestData.networkId());
            this.saslTokenInfo.setClientToken(Utils.copyArray(requestData.authBytes()));
            this.saslTokenInfo.setRequestContext(requestContext);
        }
    }

    private void handleSaslTokenStep2(EvaluateResponseResultSupplier evaluateResponseResultSupplier) throws IOException {
        if (!this.enableKafkaSaslAuthenticateHeaders) {
            byte[] response = evaluateResponseResultSupplier.get();
            if (this.saslServer.isComplete()) {
                this.reauthInfo.calcCompletionTimesAndReturnSessionLifetimeMs();
                if (this.reauthInfo.reauthenticating()) {
                    this.reauthInfo.ensurePrincipalUnchanged(this.principal());
                }
            }
            if (response != null) {
                this.netOutBuffer = ByteBufferSend.sizePrefixed(ByteBuffer.wrap(response));
                this.flushNetOutBufferAndUpdateInterestOps();
            }
        } else {
            RequestContext requestContext = this.saslTokenInfo.requestContext();
            try {
                byte[] responseToken = evaluateResponseResultSupplier.get();
                if (this.reauthInfo.reauthenticating() && this.saslServer.isComplete()) {
                    this.reauthInfo.ensurePrincipalUnchanged(this.principal());
                }
                byte[] responseBytes = responseToken == null ? new byte[]{} : responseToken;
                long sessionLifetimeMs = !this.saslServer.isComplete() ? 0L : this.reauthInfo.calcCompletionTimesAndReturnSessionLifetimeMs();
                this.sendKafkaResponse(requestContext, new SaslAuthenticateResponse(new SaslAuthenticateResponseData().setErrorCode(Errors.NONE.code()).setAuthBytes(responseBytes).setSessionLifetimeMs(sessionLifetimeMs)));
            }
            catch (SaslAuthenticationException e) {
                this.buildResponseOnAuthenticateFailure(requestContext, new SaslAuthenticateResponse(new SaslAuthenticateResponseData().setErrorCode(Errors.SASL_AUTHENTICATION_FAILED.code()).setErrorMessage(e.getMessage())));
                throw e;
            }
            catch (SaslException e) {
                KerberosError kerberosError = KerberosError.fromException(e);
                if (kerberosError != null && kerberosError.retriable()) {
                    throw e;
                }
                String errorMessage = "Authentication failed during " + this.reauthInfo.authenticationOrReauthenticationText() + " due to invalid credentials with SASL mechanism " + this.saslMechanism;
                this.buildResponseOnAuthenticateFailure(requestContext, new SaslAuthenticateResponse(new SaslAuthenticateResponseData().setErrorCode(Errors.SASL_AUTHENTICATION_FAILED.code()).setErrorMessage(errorMessage)));
                throw new SaslAuthenticationException(errorMessage, e);
            }
        }
    }

    private boolean handleKafkaRequest(byte[] requestBytes) throws IOException, AuthenticationException {
        boolean isKafkaRequest = false;
        String clientMechanism = null;
        try {
            ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
            RequestHeader header = RequestHeader.parse(requestBuffer);
            ApiKeys apiKey = header.apiKey();
            if (this.saslState == SaslState.INITIAL_REQUEST) {
                this.setSaslState(SaslState.HANDSHAKE_OR_VERSIONS_REQUEST);
            }
            isKafkaRequest = true;
            if (apiKey != ApiKeys.API_VERSIONS && apiKey != ApiKeys.SASL_HANDSHAKE) {
                throw new IllegalSaslStateException("Unexpected Kafka request of type " + (Object)((Object)apiKey) + " during SASL handshake.");
            }
            LOG.debug("Handling Kafka request {} during {}", (Object)apiKey, (Object)this.reauthInfo.authenticationOrReauthenticationText());
            RequestContext requestContext = new RequestContext(header, this.connectionId, this.clientAddress(), KafkaPrincipal.ANONYMOUS, this.listenerName, this.securityProtocol, ClientInformation.EMPTY, this.sniHostName, false, this.principalSerde(), this.transportLayer.isProxyModeLocal());
            RequestAndSize requestAndSize = requestContext.parseRequest(requestBuffer);
            if (apiKey == ApiKeys.API_VERSIONS) {
                this.handleApiVersionsRequest(requestContext, (ApiVersionsRequest)requestAndSize.request);
            } else {
                clientMechanism = this.handleHandshakeRequest(requestContext, (SaslHandshakeRequest)requestAndSize.request);
            }
        }
        catch (InvalidRequestException e) {
            if (this.saslState == SaslState.INITIAL_REQUEST) {
                if (LOG.isDebugEnabled()) {
                    StringBuilder tokenBuilder = new StringBuilder();
                    for (byte b : requestBytes) {
                        tokenBuilder.append(String.format("%02x", b));
                        if (tokenBuilder.length() >= 20) break;
                    }
                    LOG.debug("Received client packet of length {} starting with bytes 0x{}, process as GSSAPI packet", (Object)requestBytes.length, (Object)tokenBuilder);
                }
                if (this.enabledMechanisms.contains("GSSAPI")) {
                    LOG.debug("First client packet is not a SASL mechanism request, using default mechanism GSSAPI");
                    clientMechanism = "GSSAPI";
                }
                throw new UnsupportedSaslMechanismException("Exception handling first SASL packet from client, GSSAPI is not supported by server", e);
            }
            throw e;
        }
        if (clientMechanism != null && (!this.reauthInfo.reauthenticating() || this.reauthInfo.saslMechanismUnchanged(clientMechanism))) {
            this.saslMechanism = clientMechanism;
            this.setSaslState(SaslState.AUTHENTICATE);
        }
        return isKafkaRequest;
    }

    private String handleHandshakeRequest(RequestContext context, SaslHandshakeRequest handshakeRequest) throws IOException, UnsupportedSaslMechanismException {
        String clientMechanism = handshakeRequest.data().mechanism();
        short version = context.header.apiVersion();
        if (version >= 1) {
            this.enableKafkaSaslAuthenticateHeaders(true);
        }
        if (this.enabledMechanisms.contains(clientMechanism)) {
            LOG.debug("Using SASL mechanism '{}' provided by client", (Object)clientMechanism);
            this.sendKafkaResponse(context, new SaslHandshakeResponse(new SaslHandshakeResponseData().setErrorCode(Errors.NONE.code()).setMechanisms(this.enabledMechanisms)));
            return clientMechanism;
        }
        LOG.debug("SASL mechanism '{}' requested by client is not supported", (Object)clientMechanism);
        this.buildResponseOnAuthenticateFailure(context, new SaslHandshakeResponse(new SaslHandshakeResponseData().setErrorCode(Errors.UNSUPPORTED_SASL_MECHANISM.code()).setMechanisms(this.enabledMechanisms)));
        throw new UnsupportedSaslMechanismException("Unsupported SASL mechanism " + clientMechanism);
    }

    protected void enableKafkaSaslAuthenticateHeaders(boolean flag) {
        this.enableKafkaSaslAuthenticateHeaders = flag;
    }

    private void handleApiVersionsRequest(RequestContext context, ApiVersionsRequest apiVersionsRequest) throws IOException {
        if (this.saslState != SaslState.HANDSHAKE_OR_VERSIONS_REQUEST) {
            throw new IllegalStateException("Unexpected ApiVersions request received during SASL authentication state " + (Object)((Object)this.saslState));
        }
        if (apiVersionsRequest.hasUnsupportedRequestVersion()) {
            this.sendKafkaResponse(context, apiVersionsRequest.getErrorResponse(0, Errors.UNSUPPORTED_VERSION.exception()));
        } else if (!apiVersionsRequest.isValid()) {
            this.sendKafkaResponse(context, apiVersionsRequest.getErrorResponse(0, Errors.INVALID_REQUEST.exception()));
        } else {
            this.metadataRegistry.registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
            this.sendKafkaResponse(context, this.apiVersionSupplier.get());
            this.setSaslState(SaslState.HANDSHAKE_REQUEST);
            this.requestCallback.onRequest(KafkaPrincipal.ANONYMOUS, apiVersionsRequest, Optional.empty(), Optional.empty());
        }
    }

    private void buildResponseOnAuthenticateFailure(RequestContext context, AbstractResponse response) {
        RequestContext.ResponseSend responseSend = context.buildResponseSend(response);
        responseSend.getDelayedActions().forEach(action -> action.run());
        this.authenticationFailureSend = responseSend.getSend();
    }

    private void sendAuthenticationFailureResponse() throws IOException {
        if (this.authenticationFailureSend == null) {
            return;
        }
        this.sendKafkaResponse(this.authenticationFailureSend);
        this.authenticationFailureSend = null;
    }

    private void sendKafkaResponse(RequestContext context, AbstractResponse response) throws IOException {
        RequestContext.ResponseSend responseSend = context.buildResponseSend(response);
        this.sendKafkaResponse(responseSend.getSend());
        responseSend.getDelayedActions().forEach(action -> action.run());
    }

    private void sendKafkaResponse(Send send) throws IOException {
        this.netOutBuffer = send;
        this.flushNetOutBufferAndUpdateInterestOps();
    }

    @Override
    public String securityMechanism() {
        return this.saslMechanism;
    }

    private class SaslTokenInfoAsync
    extends SaslTokenInfo
    implements AsyncAuthRunnable {
        private final long timeoutMs;
        private final Time time;
        private volatile byte[] evaluateResponseOkResult;
        private volatile Throwable evaluateResponseErrResult;
        private volatile AsyncAuthState state;
        private volatile long endTimeNanos;

        public SaslTokenInfoAsync(Time time, long timeoutMs) {
            this.time = time;
            this.timeoutMs = timeoutMs;
            this.state = AsyncAuthState.ENQUEUED;
        }

        @Override
        public void run() {
            if (this.state != AsyncAuthState.TIMED_OUT) {
                try {
                    this.endTimeNanos = this.time.nanoseconds() + this.timeoutMs * 1000L * 1000L;
                    this.state = AsyncAuthState.STARTED;
                    this.evaluateResponseOkResult = SaslServerAuthenticator.this.saslServer.evaluateResponse(this.clientToken);
                    this.state = AsyncAuthState.SUCCESS;
                }
                catch (Throwable t2) {
                    LOG.debug("Error in asynchronous authentication", t2);
                    this.evaluateResponseErrResult = t2;
                    this.state = AsyncAuthState.FAILURE;
                }
            }
        }

        @Override
        public boolean isComplete() {
            return this.state == AsyncAuthState.TIMED_OUT || this.state == AsyncAuthState.SUCCESS || this.state == AsyncAuthState.FAILURE;
        }

        @Override
        public void markCancelled() {
            this.state = AsyncAuthState.TIMED_OUT;
        }

        @Override
        public boolean shouldCancel() {
            return this.state == AsyncAuthState.STARTED && this.time.nanoseconds() >= this.endTimeNanos;
        }

        @Override
        public EvaluateResponseResultSupplier evaluateResponseResultSupplier() {
            return () -> {
                switch (this.state) {
                    case SUCCESS: {
                        if (this.evaluateResponseOkResult == null) {
                            throw new IllegalStateException(String.format("The asynchronous authentication task is in the %s state but the result of the execution is missing", new Object[]{this.state}));
                        }
                        return this.evaluateResponseOkResult;
                    }
                    case FAILURE: {
                        if (this.evaluateResponseErrResult == null) {
                            throw new IllegalStateException(String.format("The asynchronous authentication task is in the %s state but the failure detail for the execution is missing", new Object[]{this.state}));
                        }
                        for (Throwable t2 = this.evaluateResponseErrResult; t2 != null; t2 = t2.getCause()) {
                            if (!(t2 instanceof InterruptedException)) continue;
                            throw new AuthenticationTimeoutException(this.evaluateResponseErrResult.getMessage(), this.evaluateResponseErrResult);
                        }
                        if (this.evaluateResponseErrResult instanceof SaslException) {
                            throw (SaslException)this.evaluateResponseErrResult;
                        }
                        if (this.evaluateResponseErrResult instanceof IOException) {
                            throw (IOException)this.evaluateResponseErrResult;
                        }
                        if (this.evaluateResponseErrResult instanceof SaslAuthenticationException) {
                            throw (SaslAuthenticationException)this.evaluateResponseErrResult;
                        }
                        throw new KafkaException(this.evaluateResponseErrResult);
                    }
                    case TIMED_OUT: {
                        this.evaluateResponseErrResult = new InterruptedException("The asynchronous authentication task was interrupted before execution completed.");
                        throw new AuthenticationTimeoutException(this.evaluateResponseErrResult.getMessage(), this.evaluateResponseErrResult);
                    }
                }
                throw new IllegalStateException(String.format("The asynchronous authentication task is in the %s state but a result was requested before execution completed", new Object[]{this.state}));
            };
        }
    }

    private static enum AsyncAuthState {
        ENQUEUED,
        STARTED,
        TIMED_OUT,
        SUCCESS,
        FAILURE;

    }

    class SaslTokenInfoSync
    extends SaslTokenInfo {
        SaslTokenInfoSync() {
        }

        @Override
        public EvaluateResponseResultSupplier evaluateResponseResultSupplier() {
            return () -> SaslServerAuthenticator.this.saslServer.evaluateResponse(this.clientToken);
        }
    }

    private static abstract class SaslTokenInfo {
        protected volatile byte[] clientToken;
        protected volatile RequestContext requestContext;

        private SaslTokenInfo() {
        }

        public void setClientToken(byte[] clientToken) {
            this.clientToken = clientToken;
        }

        public RequestContext requestContext() {
            return this.requestContext;
        }

        public void setRequestContext(RequestContext requestContext) {
            this.requestContext = requestContext;
        }

        public abstract EvaluateResponseResultSupplier evaluateResponseResultSupplier();
    }

    private static interface EvaluateResponseResultSupplier {
        public byte[] get() throws IOException;
    }

    private class ReauthInfo {
        public String previousSaslMechanism;
        public KafkaPrincipal previousKafkaPrincipal;
        public long reauthenticationBeginNanos;
        public Long sessionExpirationTimeNanos;
        public boolean connectedClientSupportsReauthentication;
        public long authenticationEndNanos;
        public String badMechanismErrorMessage;

        private ReauthInfo() {
        }

        public void reauthenticating(String previousSaslMechanism, KafkaPrincipal previousKafkaPrincipal, long reauthenticationBeginNanos) {
            this.previousSaslMechanism = Objects.requireNonNull(previousSaslMechanism);
            this.previousKafkaPrincipal = Objects.requireNonNull(previousKafkaPrincipal);
            this.reauthenticationBeginNanos = reauthenticationBeginNanos;
        }

        public boolean reauthenticating() {
            return this.previousSaslMechanism != null;
        }

        public String authenticationOrReauthenticationText() {
            return this.reauthenticating() ? "re-authentication" : "authentication";
        }

        public void ensurePrincipalUnchanged(KafkaPrincipal reauthenticatedKafkaPrincipal) throws SaslAuthenticationException {
            if (!this.previousKafkaPrincipal.equals(reauthenticatedKafkaPrincipal)) {
                throw new SaslAuthenticationException(String.format("Cannot change principals during re-authentication from %s.%s: %s.%s", this.previousKafkaPrincipal.getPrincipalType(), this.previousKafkaPrincipal.getName(), reauthenticatedKafkaPrincipal.getPrincipalType(), reauthenticatedKafkaPrincipal.getName()));
            }
        }

        public boolean saslMechanismUnchanged(String clientMechanism) {
            if (this.previousSaslMechanism.equals(clientMechanism)) {
                return true;
            }
            this.badMechanismErrorMessage = String.format("SASL mechanism '%s' requested by client is not supported for re-authentication of mechanism '%s'", clientMechanism, this.previousSaslMechanism);
            LOG.debug(this.badMechanismErrorMessage);
            SaslServerAuthenticator.this.setSaslState(SaslState.REAUTH_BAD_MECHANISM);
            return false;
        }

        private long calcCompletionTimesAndReturnSessionLifetimeMs() {
            boolean maxReauthSet;
            long retvalSessionLifetimeMs = 0L;
            long authenticationEndMs = SaslServerAuthenticator.this.time.milliseconds();
            this.authenticationEndNanos = SaslServerAuthenticator.this.time.nanoseconds();
            Long credentialExpirationMs = (Long)SaslServerAuthenticator.this.saslServer.getNegotiatedProperty("CREDENTIAL.LIFETIME.MS");
            Long connectionsMaxReauthMs = (Long)SaslServerAuthenticator.this.connectionsMaxReauthMsByMechanism.get(SaslServerAuthenticator.this.saslMechanism);
            boolean bl = maxReauthSet = connectionsMaxReauthMs != null && connectionsMaxReauthMs > 0L;
            if (credentialExpirationMs != null || maxReauthSet) {
                retvalSessionLifetimeMs = credentialExpirationMs == null ? this.zeroIfNegative(connectionsMaxReauthMs) : (!maxReauthSet ? this.zeroIfNegative(credentialExpirationMs - authenticationEndMs) : this.zeroIfNegative(Math.min(credentialExpirationMs - authenticationEndMs, connectionsMaxReauthMs)));
                this.sessionExpirationTimeNanos = this.authenticationEndNanos + 1000000L * retvalSessionLifetimeMs;
            }
            if (credentialExpirationMs != null) {
                LOG.debug("Authentication complete; session max lifetime from broker config={} ms, credential expiration={} ({} ms); session expiration = {} ({} ms), sending {} ms to client", new Object[]{connectionsMaxReauthMs, new Date(credentialExpirationMs), credentialExpirationMs - authenticationEndMs, new Date(authenticationEndMs + retvalSessionLifetimeMs), retvalSessionLifetimeMs, retvalSessionLifetimeMs});
            } else if (this.sessionExpirationTimeNanos != null) {
                LOG.debug("Authentication complete; session max lifetime from broker config={} ms, no credential expiration; session expiration = {} ({} ms), sending {} ms to client", new Object[]{connectionsMaxReauthMs, new Date(authenticationEndMs + retvalSessionLifetimeMs), retvalSessionLifetimeMs, retvalSessionLifetimeMs});
            } else {
                LOG.debug("Authentication complete; session max lifetime from broker config={} ms, no credential expiration; no session expiration, sending 0 ms to client", (Object)connectionsMaxReauthMs);
            }
            return retvalSessionLifetimeMs;
        }

        public Long reauthenticationLatencyMs() {
            if (!this.reauthenticating()) {
                return null;
            }
            long latencyNanos = this.authenticationEndNanos - this.reauthenticationBeginNanos;
            return latencyNanos == 0L ? 0L : Math.max(1L, Math.round((double)latencyNanos / 1000.0 / 1000.0));
        }

        private long zeroIfNegative(long value) {
            return Math.max(0L, value);
        }
    }

    private static enum SaslState {
        INITIAL_REQUEST,
        HANDSHAKE_OR_VERSIONS_REQUEST,
        HANDSHAKE_REQUEST,
        AUTHENTICATE,
        COMPLETE,
        FAILED,
        REAUTH_PROCESS_HANDSHAKE,
        REAUTH_BAD_MECHANISM;

    }
}

