/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.Utils;
import org.bouncycastle.jsse.BCSSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSslSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(HostSslSocketFactory.class);
    private final SSLSocketFactory sslSocketFactory;
    private final boolean setKeepAlive;
    private final String peerHost;

    public HostSslSocketFactory(Map<String, ?> sslConfigs, String peerHost, boolean setKeepAlive) {
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(sslConfigs);
        this.sslSocketFactory = DefaultSslEngineFactory.castOrThrow(sslFactory.sslEngineFactory()).sslContext().getSocketFactory();
        this.peerHost = peerHost;
        this.setKeepAlive = setKeepAlive;
    }

    public HostSslSocketFactory(SSLSocketFactory sslSocketFactory, String peerHost, boolean setKeepAlive) {
        this.sslSocketFactory = sslSocketFactory;
        this.peerHost = peerHost;
        this.setKeepAlive = setKeepAlive;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.interceptAndSetHost(this.sslSocketFactory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        this.setKeepAlive(socket);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        this.setKeepAlive(socket);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        this.setKeepAlive(socket);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port);
        this.setKeepAlive(socket);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress remoteAddress, int remotePort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port, remoteAddress, remotePort);
        this.setKeepAlive(socket);
        return this.interceptAndSetHost(socket);
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean autoClose) throws IOException {
        return this.interceptAndSetHost(this.sslSocketFactory.createSocket(socket, inputStream, autoClose));
    }

    private Socket interceptAndSetHost(Socket socket) {
        if (this.peerHost != null && Utils.isFipsDeployment() && socket instanceof BCSSLSocket) {
            BCSSLSocket bcsslSocket = (BCSSLSocket)socket;
            if (!Strings.isNullOrEmpty(this.peerHost)) {
                log.debug("Setting hostname on Bouncy Castle SSL socket: {}", (Object)this.peerHost);
                bcsslSocket.setHost(this.peerHost);
            }
        }
        return socket;
    }

    private void setKeepAlive(Socket socket) throws SocketException {
        if (this.setKeepAlive) {
            socket.setKeepAlive(true);
        }
    }
}

