/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import io.confluent.rest.handlers.SniHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixSniHandler
extends HandlerWrapper {
    private static final Logger log = LoggerFactory.getLogger(PrefixSniHandler.class);
    private static final String DOT_SEPARATOR = ".";
    private static final String DASH_SEPARATOR = "-";

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String prefix;
        String hostHeader = request.getServerName();
        String sniServerName = SniHandler.getSniServerName(baseRequest);
        if (sniServerName != null && ((prefix = PrefixSniHandler.getFirstPart(sniServerName)) == null || !hostHeader.startsWith(prefix + DOT_SEPARATOR) && !hostHeader.startsWith(prefix + DASH_SEPARATOR))) {
            log.warn("SNI prefix check failed, host header: {}, sni tenantId: {}, full sni: {}", new Object[]{hostHeader, prefix, sniServerName});
            baseRequest.setHandled(true);
            response.sendError(HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
            return;
        }
        super.handle(target, baseRequest, request, response);
    }

    private static String getFirstPart(String hostname) {
        if (hostname == null) {
            return null;
        }
        int dotIndex = hostname.indexOf(DOT_SEPARATOR);
        return dotIndex == -1 ? null : hostname.substring(0, dotIndex);
    }
}

