/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.util.Timestamps;
import com.google.type.Date;
import com.google.type.TimeOfDay;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.connect.schema.ConnectUnion;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import io.confluent.protobuf.MetaProto;
import io.confluent.protobuf.type.utils.DecimalUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;

public class ProtobufData {
    public static final String NAMESPACE = "io.confluent.connect.protobuf";
    public static final String DEFAULT_SCHEMA_NAME = "ConnectDefault";
    public static final String MAP_ENTRY_SUFFIX = "Entry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String PROTOBUF_TYPE_ENUM = "io.confluent.connect.protobuf.Enum";
    public static final String PROTOBUF_TYPE_ENUM_PREFIX = "io.confluent.connect.protobuf.Enum.";
    public static final String PROTOBUF_TYPE_UNION = "io.confluent.connect.protobuf.Union";
    public static final String PROTOBUF_TYPE_UNION_PREFIX = "io.confluent.connect.protobuf.Union.";
    public static final String PROTOBUF_TYPE_TAG = "io.confluent.connect.protobuf.Tag";
    public static final String PROTOBUF_TYPE_PROP = "io.confluent.connect.protobuf.Type";
    public static final String PROTOBUF_PRECISION_PROP = "precision";
    public static final String PROTOBUF_SCALE_PROP = "scale";
    public static final String PROTOBUF_DECIMAL_LOCATION = "confluent/type/decimal.proto";
    public static final String PROTOBUF_DECIMAL_TYPE = "confluent.type.Decimal";
    public static final String PROTOBUF_DATE_LOCATION = "google/type/date.proto";
    public static final String PROTOBUF_DATE_TYPE = "google.type.Date";
    public static final String PROTOBUF_TIME_LOCATION = "google/type/timeofday.proto";
    public static final String PROTOBUF_TIME_TYPE = "google.type.TimeOfDay";
    public static final String PROTOBUF_TIMESTAMP_LOCATION = "google/protobuf/timestamp.proto";
    public static final String PROTOBUF_TIMESTAMP_TYPE = "google.protobuf.Timestamp";
    public static final String PROTOBUF_WRAPPER_LOCATION = "google/protobuf/wrappers.proto";
    public static final String PROTOBUF_DOUBLE_WRAPPER_TYPE = "google.protobuf.DoubleValue";
    public static final String PROTOBUF_FLOAT_WRAPPER_TYPE = "google.protobuf.FloatValue";
    public static final String PROTOBUF_INT64_WRAPPER_TYPE = "google.protobuf.Int64Value";
    public static final String PROTOBUF_UINT64_WRAPPER_TYPE = "google.protobuf.UInt64Value";
    public static final String PROTOBUF_INT32_WRAPPER_TYPE = "google.protobuf.Int32Value";
    public static final String PROTOBUF_UINT32_WRAPPER_TYPE = "google.protobuf.UInt32Value";
    public static final String PROTOBUF_BOOL_WRAPPER_TYPE = "google.protobuf.BoolValue";
    public static final String PROTOBUF_STRING_WRAPPER_TYPE = "google.protobuf.StringValue";
    public static final String PROTOBUF_BYTES_WRAPPER_TYPE = "google.protobuf.BytesValue";
    public static final String CONNECT_PRECISION_PROP = "connect.decimal.precision";
    public static final String CONNECT_SCALE_PROP = "scale";
    public static final String CONNECT_TYPE_PROP = "connect.type";
    public static final String CONNECT_TYPE_INT8 = "int8";
    public static final String CONNECT_TYPE_INT16 = "int16";
    public static final String GENERALIZED_TYPE_UNION = "org.apache.kafka.connect.data.Union";
    public static final String GENERALIZED_TYPE_ENUM = "org.apache.kafka.connect.data.Enum";
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final int MILLIS_PER_NANO = 1000000;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final HashMap<String, LogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
    private static final HashMap<String, LogicalTypeConverter> TO_PROTOBUF_LOGICAL_CONVERTERS;
    private final Map<Schema, ProtobufSchema> fromConnectSchemaCache;
    private final Map<Pair<String, ProtobufSchema>, Schema> toConnectSchemaCache;
    private boolean generalizedSumTypeSupport;
    private boolean ignoreDefaultForNullables;
    private boolean enhancedSchemaSupport;
    private boolean scrubInvalidNames;
    private boolean useIntForEnums;
    private boolean useOptionalForNullables;
    private boolean supportOptionalForProto2;
    private boolean useWrapperForNullables;
    private boolean useWrapperForRawPrimitives;
    private boolean generateStructForNulls;
    private boolean generateIndexForUnions;
    private boolean flattenUnions;

    public ProtobufData() {
        this(new ProtobufDataConfig.Builder().with("schemas.cache.config", 1000).build());
    }

    public ProtobufData(int cacheSize) {
        this(new ProtobufDataConfig.Builder().with("schemas.cache.config", cacheSize).build());
    }

    public ProtobufData(ProtobufDataConfig protobufDataConfig) {
        this.fromConnectSchemaCache = new BoundedConcurrentHashMap(protobufDataConfig.schemaCacheSize());
        this.toConnectSchemaCache = new BoundedConcurrentHashMap(protobufDataConfig.schemaCacheSize());
        this.generalizedSumTypeSupport = protobufDataConfig.isGeneralizedSumTypeSupport();
        this.ignoreDefaultForNullables = protobufDataConfig.ignoreDefaultForNullables();
        this.enhancedSchemaSupport = protobufDataConfig.isEnhancedProtobufSchemaSupport();
        this.scrubInvalidNames = protobufDataConfig.isScrubInvalidNames();
        this.useIntForEnums = protobufDataConfig.useIntForEnums();
        this.useOptionalForNullables = protobufDataConfig.useOptionalForNullables();
        this.supportOptionalForProto2 = protobufDataConfig.supportOptionalForProto2();
        this.useWrapperForNullables = protobufDataConfig.useWrapperForNullables();
        this.useWrapperForRawPrimitives = protobufDataConfig.useWrapperForRawPrimitives();
        this.generateStructForNulls = protobufDataConfig.generateStructForNulls();
        this.generateIndexForUnions = protobufDataConfig.generateIndexForUnions();
        this.flattenUnions = protobufDataConfig.flattenUnions();
    }

    public ProtobufSchemaAndValue fromConnectData(Schema schema, Object value) {
        ProtobufSchema protobufSchema = this.fromConnectSchema(schema);
        Descriptors.Descriptor ctx = null;
        if (schema != null) {
            String fullName = schema.name();
            if (fullName == null) {
                fullName = "ConnectDefault1";
            }
            String[] split = this.splitName(fullName);
            String namespace = split[0];
            String name = split[1];
            ctx = protobufSchema.toDescriptor(namespace != null ? namespace + "." + name : name);
        }
        return new ProtobufSchemaAndValue(protobufSchema, this.fromConnectData(ctx, schema, "", value, protobufSchema));
    }

    protected ProtobufSchemaAndValue fromConnectData(SchemaAndValue schemaAndValue) {
        return this.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
    }

    private Object fromConnectData(Object ctx, Schema schema, String scope, Object value, ProtobufSchema protobufSchema) {
        LogicalTypeConverter logicalConverter;
        if (value == null) {
            return null;
        }
        if (schema.name() != null && (logicalConverter = TO_PROTOBUF_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.convert(schema, value);
        }
        boolean isWrapper = this.isWrapper(protobufSchema) || this.useWrapperForNullables && schema.isOptional();
        Schema.Type schemaType = schema.type();
        try {
            switch (schemaType) {
                case INT8: 
                case INT16: 
                case INT32: {
                    int intValue = ((Number)value).intValue();
                    if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                        String enumType = (String)schema.parameters().get(PROTOBUF_TYPE_ENUM);
                        return protobufSchema.getEnumValue(scope + enumType, intValue);
                    }
                    return isWrapper ? Int32Value.newBuilder().setValue(intValue).build() : Integer.valueOf(intValue);
                }
                case INT64: {
                    String protobufType;
                    String string = protobufType = schema.parameters() != null ? (String)schema.parameters().get(PROTOBUF_TYPE_PROP) : null;
                    if (Objects.equals(protobufType, "uint32") || Objects.equals(protobufType, "fixed32")) {
                        int intValue = (int)((Number)value).longValue();
                        return isWrapper ? Int32Value.newBuilder().setValue(intValue).build() : Integer.valueOf(intValue);
                    }
                    long longValue = ((Number)value).longValue();
                    return isWrapper ? Int64Value.newBuilder().setValue(longValue).build() : Long.valueOf(longValue);
                }
                case FLOAT32: {
                    float floatValue = ((Number)value).floatValue();
                    return isWrapper ? FloatValue.newBuilder().setValue(floatValue).build() : Float.valueOf(floatValue);
                }
                case FLOAT64: {
                    double doubleValue = ((Number)value).doubleValue();
                    return isWrapper ? DoubleValue.newBuilder().setValue(doubleValue).build() : Double.valueOf(doubleValue);
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    return isWrapper ? BoolValue.newBuilder().setValue(boolValue.booleanValue()).build() : boolValue;
                }
                case STRING: {
                    String stringValue = (String)value;
                    if (schema.parameters() != null && (schema.parameters().containsKey(GENERALIZED_TYPE_ENUM) || schema.parameters().containsKey(PROTOBUF_TYPE_ENUM))) {
                        String paramName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_ENUM : PROTOBUF_TYPE_ENUM;
                        String enumType = (String)schema.parameters().get(paramName);
                        String tag = (String)schema.parameters().get(paramName + "." + stringValue);
                        if (tag != null) {
                            return protobufSchema.getEnumValue(scope + enumType, Integer.parseInt(tag));
                        }
                    }
                    return isWrapper ? StringValue.newBuilder().setValue(stringValue).build() : stringValue;
                }
                case BYTES: {
                    ByteBuffer bytesValue = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : (ByteBuffer)value;
                    ByteString byteString = ByteString.copyFrom((ByteBuffer)bytesValue);
                    return isWrapper ? BytesValue.newBuilder().setValue(byteString).build() : byteString;
                }
                case ARRAY: {
                    Collection listValue = (Collection)value;
                    if (listValue.isEmpty()) {
                        return null;
                    }
                    ArrayList<Object> newListValue = new ArrayList<Object>();
                    for (Object o : listValue) {
                        newListValue.add(this.fromConnectData(ctx, schema.valueSchema(), scope, o, protobufSchema));
                    }
                    return newListValue;
                }
                case MAP: {
                    Map mapValue = (Map)value;
                    String scopedMapName = ((Descriptors.Descriptor)ctx).getFullName();
                    ArrayList<DynamicMessage> newMapValue = new ArrayList<DynamicMessage>();
                    for (Map.Entry mapEntry : mapValue.entrySet()) {
                        Object entryValue;
                        DynamicMessage.Builder mapBuilder = protobufSchema.newMessageBuilder(scopedMapName);
                        if (mapBuilder == null) {
                            throw new IllegalStateException("Invalid message name: " + scopedMapName);
                        }
                        Descriptors.Descriptor mapDescriptor = mapBuilder.getDescriptorForType();
                        Descriptors.FieldDescriptor keyDescriptor = mapDescriptor.findFieldByName(KEY_FIELD);
                        Descriptors.FieldDescriptor valueDescriptor = mapDescriptor.findFieldByName(VALUE_FIELD);
                        Object entryKey = this.fromConnectData(this.getFieldType(keyDescriptor), schema.keySchema(), scopedMapName + ".", mapEntry.getKey(), protobufSchema);
                        if (entryKey != null) {
                            mapBuilder.setField(keyDescriptor, entryKey);
                        }
                        if ((entryValue = this.fromConnectData(this.getFieldType(valueDescriptor), schema.valueSchema(), scopedMapName + ".", mapEntry.getValue(), protobufSchema)) != null) {
                            mapBuilder.setField(valueDescriptor, entryValue);
                        }
                        newMapValue.add(mapBuilder.build());
                    }
                    return newMapValue;
                }
                case STRUCT: {
                    Struct struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching struct schema");
                    }
                    if (ProtobufData.isUnionSchema(schema)) {
                        for (Field field : schema.fields()) {
                            Object object = this.ignoreDefaultForNullables ? struct.getWithoutDefault(field.name()) : struct.get(field);
                            if (object == null) continue;
                            String fieldName = this.scrubName(field.name());
                            Object fieldCtx = this.getFieldType(ctx, fieldName);
                            return new Pair<String, Object>(fieldName, this.fromConnectData(fieldCtx, field.schema(), scope, object, protobufSchema));
                        }
                        throw new DataException("Cannot find non-null field");
                    }
                    String scopedStructName = ((Descriptors.Descriptor)ctx).getFullName();
                    DynamicMessage.Builder messageBuilder = protobufSchema.newMessageBuilder(scopedStructName);
                    if (messageBuilder == null) {
                        throw new DataException("Invalid message name: " + scopedStructName);
                    }
                    for (Field field : schema.fields()) {
                        Descriptors.FieldDescriptor fieldDescriptor;
                        Object connectFieldVal;
                        String fieldName = this.scrubName(field.name());
                        Object fieldCtx = this.getFieldType(ctx, fieldName);
                        Object object = connectFieldVal = this.ignoreDefaultForNullables ? struct.getWithoutDefault(field.name()) : struct.get(field);
                        Object fieldValue = this.fromConnectData(fieldCtx, field.schema(), scopedStructName + ".", connectFieldVal, protobufSchema);
                        if (fieldValue == null) continue;
                        if (fieldValue instanceof Pair) {
                            Pair union = (Pair)fieldValue;
                            fieldDescriptor = messageBuilder.getDescriptorForType().findFieldByName((String)union.getKey());
                            fieldValue = union.getValue();
                        } else {
                            fieldDescriptor = messageBuilder.getDescriptorForType().findFieldByName(fieldName);
                        }
                        if (fieldDescriptor == null) {
                            throw new DataException("Cannot find field with name " + fieldName);
                        }
                        if (fieldValue == null) continue;
                        messageBuilder.setField(fieldDescriptor, fieldValue);
                    }
                    return messageBuilder.build();
                }
            }
            throw new DataException("Unknown schema type: " + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private boolean isWrapper(ProtobufSchema protobufSchema) {
        String name;
        switch (name = protobufSchema.name()) {
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.UInt64Value": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.BoolValue": 
            case "google.protobuf.StringValue": 
            case "google.protobuf.BytesValue": {
                return true;
            }
        }
        return false;
    }

    private Object getFieldType(Object ctx, String name) {
        Descriptors.FieldDescriptor field = ((Descriptors.Descriptor)ctx).findFieldByName(name);
        if (field == null) {
            return ctx;
        }
        return this.getFieldType(field);
    }

    private Object getFieldType(Descriptors.FieldDescriptor field) {
        switch (field.getJavaType()) {
            case MESSAGE: {
                return field.getMessageType();
            }
            case ENUM: {
                return field.getEnumType();
            }
        }
        return field.getJavaType();
    }

    public ProtobufSchema fromConnectSchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        ProtobufSchema cachedSchema = this.fromConnectSchemaCache.get(schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        FromConnectContext ctx = new FromConnectContext();
        String fullName = this.getNameOrDefault(ctx, schema.name());
        String[] split = this.splitName(fullName);
        String namespace = split[0];
        String name = split[1];
        Descriptors.Descriptor descriptor = this.descriptorFromConnectSchema(ctx, namespace, name, schema);
        ProtobufSchema resultSchema = new ProtobufSchema(descriptor);
        this.fromConnectSchemaCache.put(schema, resultSchema);
        return resultSchema;
    }

    private Descriptors.Descriptor descriptorFromConnectSchema(FromConnectContext ctx, String namespace, String name, Schema rootElem) {
        Schema.Type type = rootElem.type();
        switch (type) {
            case INT8: {
                return this.typeToDescriptor(PROTOBUF_INT32_WRAPPER_TYPE);
            }
            case INT16: {
                return this.typeToDescriptor(PROTOBUF_INT32_WRAPPER_TYPE);
            }
            case INT32: {
                return this.typeToDescriptor(PROTOBUF_INT32_WRAPPER_TYPE);
            }
            case INT64: {
                return this.typeToDescriptor(PROTOBUF_INT64_WRAPPER_TYPE);
            }
            case FLOAT32: {
                return this.typeToDescriptor(PROTOBUF_FLOAT_WRAPPER_TYPE);
            }
            case FLOAT64: {
                return this.typeToDescriptor(PROTOBUF_DOUBLE_WRAPPER_TYPE);
            }
            case BOOLEAN: {
                return this.typeToDescriptor(PROTOBUF_BOOL_WRAPPER_TYPE);
            }
            case STRING: {
                return this.typeToDescriptor(PROTOBUF_STRING_WRAPPER_TYPE);
            }
            case BYTES: {
                return this.typeToDescriptor(PROTOBUF_BYTES_WRAPPER_TYPE);
            }
            case STRUCT: {
                DynamicSchema dynamicSchema = this.rawSchemaFromConnectSchema(ctx, namespace, name, rootElem);
                return dynamicSchema.getMessageDescriptor(name);
            }
        }
        throw new IllegalArgumentException("Unsupported root schema of type " + type);
    }

    private DynamicSchema rawSchemaFromConnectSchema(FromConnectContext ctx, String namespace, String name, Schema rootElem) {
        if (rootElem.type() != Schema.Type.STRUCT) {
            throw new IllegalArgumentException("Unsupported root schema of type " + rootElem.type());
        }
        try {
            DynamicSchema.Builder schema = DynamicSchema.newBuilder();
            schema.setSyntax("proto3");
            if (namespace != null) {
                schema.setPackage(namespace);
            }
            schema.addMessageDefinition(this.messageDefinitionFromConnectSchema(ctx, schema, name, rootElem));
            return schema.build();
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private MessageDefinition messageDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, String name, Schema messageElem) {
        MessageDefinition.Builder message = MessageDefinition.newBuilder((String)name);
        int index = 1;
        for (Field field : messageElem.fields()) {
            int tag;
            Schema fieldSchema = field.schema();
            String fieldTag = fieldSchema.parameters() != null ? (String)fieldSchema.parameters().get(PROTOBUF_TYPE_TAG) : null;
            int n = tag = fieldTag != null ? Integer.parseInt(fieldTag) : index++;
            FieldDefinition fieldDef = this.fieldDefinitionFromConnectSchema(ctx, schema, message, fieldSchema, this.scrubName(field.name()), tag);
            if (fieldDef == null) continue;
            boolean isProto3Optional = "optional".equals(fieldDef.getLabel());
            if (isProto3Optional) {
                MessageDefinition.OneofBuilder oneofBuilder = message.addOneof("_" + fieldDef.getName());
                oneofBuilder.addField(new Context(), true, fieldDef.getType(), fieldDef.getName(), fieldDef.getNum(), fieldDef.getDefaultVal(), fieldDef.getMeta());
                continue;
            }
            message.addField(new Context(), fieldDef.getLabel(), fieldDef.getType(), fieldDef.getName(), fieldDef.getNum(), fieldDef.getDefaultVal(), fieldDef.getMeta());
        }
        return message.build();
    }

    private void oneofDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, MessageDefinition.Builder message, Schema unionElem, String unionName) {
        MessageDefinition.OneofBuilder oneof = message.addOneof(unionName);
        for (Field field : unionElem.fields()) {
            int tag;
            Schema fieldSchema = field.schema();
            String fieldTag = fieldSchema.parameters() != null ? (String)fieldSchema.parameters().get(PROTOBUF_TYPE_TAG) : null;
            int n = tag = fieldTag != null ? Integer.parseInt(fieldTag) : 0;
            FieldDefinition fieldDef = this.fieldDefinitionFromConnectSchema(ctx, schema, message, field.schema(), this.scrubName(field.name()), tag);
            if (fieldDef == null) continue;
            oneof.addField(new Context(), fieldDef.getType(), fieldDef.getName(), fieldDef.getNum(), fieldDef.getDefaultVal(), fieldDef.getMeta());
        }
    }

    private FieldDefinition fieldDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, MessageDefinition.Builder message, Schema fieldSchema, String name, int tag) {
        String label = null;
        if (fieldSchema.type() == Schema.Type.ARRAY) {
            label = "repeated";
            fieldSchema = fieldSchema.valueSchema();
        } else if (fieldSchema.type() == Schema.Type.MAP) {
            label = "repeated";
        } else if (this.useOptionalForNullables && fieldSchema.isOptional()) {
            label = "optional";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String type = this.dataTypeFromConnectSchema(ctx, fieldSchema, name, params);
        Object defaultVal = null;
        if (fieldSchema.type() == Schema.Type.STRUCT) {
            String fieldSchemaName = fieldSchema.name();
            if (ProtobufData.isUnionSchema(fieldSchema)) {
                String unionName = this.generalizedSumTypeSupport ? (String)fieldSchema.parameters().get(GENERALIZED_TYPE_UNION) : this.getUnqualifiedName(ctx, fieldSchemaName.substring(PROTOBUF_TYPE_UNION_PREFIX.length()));
                this.oneofDefinitionFromConnectSchema(ctx, schema, message, fieldSchema, unionName);
                return null;
            }
            if (!ctx.contains(message, type)) {
                ctx.add(message, type);
                message.addMessageDefinition(this.messageDefinitionFromConnectSchema(ctx, schema, type, fieldSchema));
            }
        } else if (fieldSchema.type() == Schema.Type.MAP) {
            message.addMessageDefinition(this.mapDefinitionFromConnectSchema(ctx, schema, type, fieldSchema));
        } else if (fieldSchema.parameters() != null && (fieldSchema.parameters().containsKey(GENERALIZED_TYPE_ENUM) || fieldSchema.parameters().containsKey(PROTOBUF_TYPE_ENUM))) {
            String enumName = this.getUnqualifiedName(ctx, fieldSchema.name());
            if (!message.containsEnum(enumName)) {
                message.addEnumDefinition(this.enumDefinitionFromConnectSchema(ctx, schema, fieldSchema));
            }
        } else {
            DynamicSchema dynamicSchema = this.typeToDynamicSchema(type);
            if (dynamicSchema != null) {
                schema.addSchema(dynamicSchema);
                schema.addDependency(dynamicSchema.getFileDescriptorProto().getName());
            } else {
                defaultVal = fieldSchema.defaultValue();
            }
        }
        return new FieldDefinition(label, type, name, tag, defaultVal != null ? defaultVal.toString() : null, new ProtobufSchema.ProtobufMeta(null, params, null));
    }

    private Descriptors.Descriptor typeToDescriptor(String type) {
        DynamicSchema dynamicSchema = this.typeToDynamicSchema(type);
        if (dynamicSchema == null) {
            return null;
        }
        return dynamicSchema.getMessageDescriptor(type);
    }

    private DynamicSchema typeToDynamicSchema(String type) {
        switch (type) {
            case "confluent.type.Decimal": {
                ProtobufSchema dep = new ProtobufSchema(io.confluent.protobuf.type.Decimal.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_DECIMAL_LOCATION);
            }
            case "google.type.Date": {
                ProtobufSchema dep = new ProtobufSchema(Date.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_DATE_LOCATION);
            }
            case "google.type.TimeOfDay": {
                ProtobufSchema dep = new ProtobufSchema(TimeOfDay.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_TIME_LOCATION);
            }
            case "google.protobuf.Timestamp": {
                ProtobufSchema dep = new ProtobufSchema(Timestamp.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_TIMESTAMP_LOCATION);
            }
            case "google.protobuf.DoubleValue": {
                ProtobufSchema dep = new ProtobufSchema(DoubleValue.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.FloatValue": {
                ProtobufSchema dep = new ProtobufSchema(FloatValue.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.Int64Value": {
                ProtobufSchema dep = new ProtobufSchema(Int64Value.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.UInt64Value": {
                ProtobufSchema dep = new ProtobufSchema(UInt64Value.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.Int32Value": {
                ProtobufSchema dep = new ProtobufSchema(Int32Value.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.UInt32Value": {
                ProtobufSchema dep = new ProtobufSchema(UInt32Value.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.BoolValue": {
                ProtobufSchema dep = new ProtobufSchema(BoolValue.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.StringValue": {
                ProtobufSchema dep = new ProtobufSchema(StringValue.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
            case "google.protobuf.BytesValue": {
                ProtobufSchema dep = new ProtobufSchema(BytesValue.getDescriptor());
                return dep.toDynamicSchema(PROTOBUF_WRAPPER_LOCATION);
            }
        }
        return null;
    }

    private MessageDefinition mapDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, String name, Schema mapElem) {
        MessageDefinition.Builder map = MessageDefinition.newBuilder((String)name);
        FieldDefinition key = this.fieldDefinitionFromConnectSchema(ctx, schema, map, mapElem.keySchema(), KEY_FIELD, 1);
        map.addField(new Context(), key.getLabel(), key.getType(), key.getName(), key.getNum(), key.getDefaultVal(), null);
        FieldDefinition val = this.fieldDefinitionFromConnectSchema(ctx, schema, map, mapElem.valueSchema(), VALUE_FIELD, 2);
        map.addField(new Context(), val.getLabel(), val.getType(), val.getName(), val.getNum(), val.getDefaultVal(), null);
        return map.build();
    }

    private EnumDefinition enumDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, Schema enumElem) {
        String enumName = this.getUnqualifiedName(ctx, enumElem.name());
        EnumDefinition.Builder enumBuilder = EnumDefinition.newBuilder((String)enumName);
        String paramName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_ENUM : PROTOBUF_TYPE_ENUM;
        for (Map.Entry entry : enumElem.parameters().entrySet()) {
            if (!((String)entry.getKey()).startsWith(paramName + ".")) continue;
            String name = ((String)entry.getKey()).substring(paramName.length() + 1);
            int tag = Integer.parseInt((String)entry.getValue());
            enumBuilder.addValue(name, tag);
        }
        return enumBuilder.build();
    }

    private String dataTypeFromConnectSchema(FromConnectContext ctx, Schema schema, String fieldName, Map<String, String> params) {
        if (this.isDecimalSchema(schema)) {
            if (schema.parameters() != null) {
                String scale;
                String precision = (String)schema.parameters().get(CONNECT_PRECISION_PROP);
                if (precision != null) {
                    params.put(PROTOBUF_PRECISION_PROP, precision);
                }
                if ((scale = (String)schema.parameters().get("scale")) != null) {
                    params.put("scale", scale);
                }
            }
            return PROTOBUF_DECIMAL_TYPE;
        }
        if (this.isDateSchema(schema)) {
            return PROTOBUF_DATE_TYPE;
        }
        if (this.isTimeSchema(schema)) {
            return PROTOBUF_TIME_TYPE;
        }
        if (this.isTimestampSchema(schema)) {
            return PROTOBUF_TIMESTAMP_TYPE;
        }
        switch (schema.type()) {
            case INT8: {
                params.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT8);
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_INT32_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.INT32.toString().toLowerCase();
            }
            case INT16: {
                params.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT16);
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_INT32_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.INT32.toString().toLowerCase();
            }
            case INT32: {
                if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                    return (String)schema.parameters().get(PROTOBUF_TYPE_ENUM);
                }
                String defaultType = Descriptors.FieldDescriptor.Type.INT32.toString().toLowerCase();
                if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_PROP)) {
                    defaultType = (String)schema.parameters().get(PROTOBUF_TYPE_PROP);
                }
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_INT32_WRAPPER_TYPE : defaultType;
            }
            case INT64: {
                String wrapperType;
                String defaultType = Descriptors.FieldDescriptor.Type.INT64.toString().toLowerCase();
                if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_PROP)) {
                    defaultType = (String)schema.parameters().get(PROTOBUF_TYPE_PROP);
                }
                switch (defaultType) {
                    case "uint32": 
                    case "fixed32": {
                        wrapperType = PROTOBUF_UINT32_WRAPPER_TYPE;
                        break;
                    }
                    case "uint64": 
                    case "fixed64": {
                        wrapperType = PROTOBUF_UINT64_WRAPPER_TYPE;
                        break;
                    }
                    default: {
                        wrapperType = PROTOBUF_INT64_WRAPPER_TYPE;
                    }
                }
                return this.useWrapperForNullables && schema.isOptional() ? wrapperType : defaultType;
            }
            case FLOAT32: {
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_FLOAT_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.FLOAT.toString().toLowerCase();
            }
            case FLOAT64: {
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_DOUBLE_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.DOUBLE.toString().toLowerCase();
            }
            case BOOLEAN: {
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_BOOL_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.BOOL.toString().toLowerCase();
            }
            case STRING: {
                if (schema.parameters() != null) {
                    if (schema.parameters().containsKey(GENERALIZED_TYPE_ENUM)) {
                        return (String)schema.parameters().get(GENERALIZED_TYPE_ENUM);
                    }
                    if (schema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                        return (String)schema.parameters().get(PROTOBUF_TYPE_ENUM);
                    }
                }
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_STRING_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.STRING.toString().toLowerCase();
            }
            case BYTES: {
                return this.useWrapperForNullables && schema.isOptional() ? PROTOBUF_BYTES_WRAPPER_TYPE : Descriptors.FieldDescriptor.Type.BYTES.toString().toLowerCase();
            }
            case ARRAY: {
                throw new IllegalArgumentException("Array cannot be nested");
            }
            case MAP: {
                return ProtobufSchema.toMapEntry((String)this.getUnqualifiedName(ctx, schema.name()));
            }
            case STRUCT: {
                String name = this.getUnqualifiedName(ctx, schema.name());
                if (name.equals(fieldName)) {
                    name = name + "Message";
                }
                return name;
            }
        }
        throw new DataException("Unknown schema type: " + schema.type());
    }

    private boolean isDecimalSchema(Schema schema) {
        return "org.apache.kafka.connect.data.Decimal".equals(schema.name());
    }

    private boolean isDateSchema(Schema schema) {
        return "org.apache.kafka.connect.data.Date".equals(schema.name());
    }

    private boolean isTimeSchema(Schema schema) {
        return "org.apache.kafka.connect.data.Time".equals(schema.name());
    }

    private boolean isTimestampSchema(Schema schema) {
        return "org.apache.kafka.connect.data.Timestamp".equals(schema.name());
    }

    private static boolean isUnionSchema(Schema schema) {
        return schema.name() != null && schema.name().startsWith(PROTOBUF_TYPE_UNION) || ConnectUnion.isUnion((Schema)schema);
    }

    public SchemaAndValue toConnectData(ProtobufSchema protobufSchema, Message message) {
        if (message == null) {
            return SchemaAndValue.NULL;
        }
        Schema schema = this.toConnectSchema(protobufSchema);
        return new SchemaAndValue(schema, this.toConnectData(schema, (Object)message));
    }

    protected Object toConnectData(Schema schema, Object value) {
        try {
            LogicalTypeConverter logicalConverter;
            if (value == null) {
                return null;
            }
            if (schema.name() != null && (logicalConverter = TO_CONNECT_LOGICAL_CONVERTERS.get(schema.name())) != null) {
                return logicalConverter.convert(schema, value);
            }
            Struct converted = null;
            switch (schema.type()) {
                case INT8: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    converted = Byte.valueOf(((Number)((Object)value)).byteValue());
                    break;
                }
                case INT16: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    converted = Short.valueOf(((Number)((Object)value)).shortValue());
                    break;
                }
                case INT32: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    if (value instanceof Number) {
                        converted = Integer.valueOf(((Number)((Object)value)).intValue());
                        break;
                    }
                    if (value instanceof Enum) {
                        converted = Integer.valueOf(((Enum)((Object)value)).ordinal());
                        break;
                    }
                    if (!(value instanceof Descriptors.EnumValueDescriptor)) break;
                    converted = Integer.valueOf(((Descriptors.EnumValueDescriptor)value).getNumber());
                    break;
                }
                case INT64: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    long longValue = value instanceof Long ? (Long)((Object)value) : Integer.toUnsignedLong(((Number)((Object)value)).intValue());
                    converted = Long.valueOf(longValue);
                    break;
                }
                case FLOAT32: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    converted = Float.valueOf(((Number)((Object)value)).floatValue());
                    break;
                }
                case FLOAT64: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    converted = Double.valueOf(((Number)((Object)value)).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    converted = value;
                    break;
                }
                case STRING: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    if (value instanceof String) {
                        converted = value;
                        break;
                    }
                    if (value instanceof CharSequence || value instanceof Enum || value instanceof Descriptors.EnumValueDescriptor) {
                        converted = ((Object)value).toString();
                        break;
                    }
                    throw new DataException("Invalid class for string type, expecting String or CharSequence but found " + value.getClass());
                }
                case BYTES: {
                    if (value instanceof Message) {
                        value = this.getWrappedValue((Message)value);
                    }
                    if (value instanceof byte[]) {
                        converted = ByteBuffer.wrap((byte[])value);
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        converted = value;
                        break;
                    }
                    if (value instanceof ByteString) {
                        converted = ByteBuffer.wrap(((ByteString)value).toByteArray());
                        break;
                    }
                    throw new DataException("Invalid class for bytes type, expecting byte[], ByteBuffer, or ByteString but found " + value.getClass());
                }
                case ARRAY: {
                    Schema elemSchema = schema.valueSchema();
                    Collection array = value;
                    ArrayList<Object> newArray = new ArrayList<Object>(array.size());
                    for (Object elem : array) {
                        newArray.add(this.toConnectData(elemSchema, elem));
                    }
                    converted = newArray;
                    break;
                }
                case MAP: {
                    Schema keySchema = schema.keySchema();
                    Schema valueSchema = schema.valueSchema();
                    Collection map = value;
                    HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                    for (Message message : map) {
                        Descriptors.Descriptor descriptor = message.getDescriptorForType();
                        Object elemKey = message.getField(descriptor.findFieldByName(KEY_FIELD));
                        Object elemValue = message.getField(descriptor.findFieldByName(VALUE_FIELD));
                        newMap.put(this.toConnectData(keySchema, elemKey), this.toConnectData(valueSchema, elemValue));
                    }
                    converted = newMap;
                    break;
                }
                case STRUCT: {
                    Message message = (Message)value;
                    Struct struct = new Struct(schema.schema());
                    Descriptors.Descriptor descriptor = message.getDescriptorForType();
                    for (Descriptors.OneofDescriptor oneOfDescriptor : descriptor.getRealOneofs()) {
                        Descriptors.FieldDescriptor fieldDescriptor;
                        Object obj;
                        if (!message.hasOneof(oneOfDescriptor) || (obj = message.getField(fieldDescriptor = message.getOneofFieldDescriptor(oneOfDescriptor))) == null) continue;
                        if (this.flattenUnions) {
                            this.setStructField(schema, message, struct, fieldDescriptor);
                            continue;
                        }
                        this.setUnionField(schema, message, struct, oneOfDescriptor, fieldDescriptor);
                    }
                    for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                        Descriptors.OneofDescriptor oneOfDescriptor = fieldDescriptor.getRealContainingOneof();
                        if (oneOfDescriptor != null) continue;
                        this.setStructField(schema, message, struct, fieldDescriptor);
                    }
                    converted = struct;
                    break;
                }
                default: {
                    throw new DataException("Unknown Connect schema type: " + schema.type());
                }
            }
            return converted;
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private Object getWrappedValue(Message message) {
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(VALUE_FIELD);
        return message.getField(fieldDescriptor);
    }

    private void setUnionField(Schema schema, Message message, Struct result, Descriptors.OneofDescriptor oneOfDescriptor, Descriptors.FieldDescriptor fieldDescriptor) {
        String unionFieldName = this.unionFieldName(oneOfDescriptor);
        Field unionField = schema.field(unionFieldName);
        Schema unionSchema = unionField.schema();
        Struct union = new Struct(unionSchema);
        String fieldName = fieldDescriptor.getName();
        Field field = unionSchema.field(fieldName);
        Object obj = message.getField(fieldDescriptor);
        union.put(fieldName, this.toConnectData(field.schema(), obj));
        result.put(unionField, (Object)union);
    }

    private String unionFieldName(Descriptors.OneofDescriptor oneofDescriptor) {
        String name = oneofDescriptor.getName();
        if (this.generateIndexForUnions) {
            name = name + "_" + oneofDescriptor.getIndex();
        }
        return name;
    }

    private void setStructField(Schema schema, Message message, Struct result, Descriptors.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        Field field = schema.field(fieldName);
        if (this.isPrimitiveOrRepeated(fieldDescriptor) && !this.isOptional(fieldDescriptor) || this.generateStructForNulls || message.hasField(fieldDescriptor)) {
            Object obj = message.getField(fieldDescriptor);
            result.put(fieldName, this.toConnectData(field.schema(), obj));
        }
    }

    private boolean isPrimitiveOrRepeated(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || fieldDescriptor.isRepeated();
    }

    private boolean isOptional(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.toProto().getProto3Optional() || this.supportOptionalForProto2 && fieldDescriptor.hasOptionalKeyword();
    }

    private boolean isProto3Optional(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.toProto().getProto3Optional();
    }

    public Schema toConnectSchema(ProtobufSchema schema) {
        if (schema == null) {
            return null;
        }
        Pair<String, ProtobufSchema> cacheKey = new Pair<String, ProtobufSchema>(schema.name(), schema);
        Schema cachedSchema = this.toConnectSchemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        Descriptors.Descriptor descriptor = schema.toDescriptor();
        ToConnectContext ctx = new ToConnectContext();
        Schema resultSchema = this.toConnectSchema(ctx, descriptor, schema.version()).build();
        this.toConnectSchemaCache.put(cacheKey, resultSchema);
        return resultSchema;
    }

    private SchemaBuilder toConnectSchema(ToConnectContext ctx, Descriptors.Descriptor descriptor, Integer version) {
        SchemaBuilder builder = null;
        if (this.useWrapperForRawPrimitives) {
            builder = this.toUnwrappedSchema(descriptor);
        }
        if (builder == null) {
            builder = SchemaBuilder.struct();
            ctx.put(descriptor.getFullName(), builder);
            String name = this.enhancedSchemaSupport ? descriptor.getFullName() : descriptor.getName();
            builder.name(name);
            List oneOfDescriptors = descriptor.getRealOneofs();
            for (Descriptors.OneofDescriptor oneOfDescriptor : oneOfDescriptors) {
                if (this.flattenUnions) {
                    List fieldDescriptors = oneOfDescriptor.getFields();
                    for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
                        builder.field(fieldDescriptor.getName(), this.toConnectSchema(ctx, fieldDescriptor));
                    }
                    continue;
                }
                String unionFieldName = this.unionFieldName(oneOfDescriptor);
                builder.field(unionFieldName, this.toConnectSchema(ctx, oneOfDescriptor));
            }
            List fieldDescriptors = descriptor.getFields();
            for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Descriptors.OneofDescriptor oneOfDescriptor = fieldDescriptor.getRealContainingOneof();
                if (oneOfDescriptor != null) continue;
                builder.field(fieldDescriptor.getName(), this.toConnectSchema(ctx, fieldDescriptor));
            }
        }
        if (version != null) {
            builder.version(version);
        }
        return builder;
    }

    private Schema toConnectSchema(ToConnectContext ctx, Descriptors.OneofDescriptor descriptor) {
        String name;
        SchemaBuilder builder = SchemaBuilder.struct();
        if (this.generalizedSumTypeSupport) {
            name = descriptor.getName();
            builder.name(name);
            builder.parameter(GENERALIZED_TYPE_UNION, name);
        } else {
            name = this.enhancedSchemaSupport ? descriptor.getFullName() : descriptor.getName();
            builder.name(PROTOBUF_TYPE_UNION_PREFIX + name);
        }
        List fieldDescriptors = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            builder.field(fieldDescriptor.getName(), this.toConnectSchema(ctx, fieldDescriptor));
        }
        builder.optional();
        return builder.build();
    }

    private Schema toConnectSchema(ToConnectContext ctx, Descriptors.FieldDescriptor descriptor) {
        SchemaBuilder builder;
        switch (descriptor.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                MetaProto.Meta fieldMeta;
                Map params;
                if (descriptor.getOptions().hasExtension(MetaProto.fieldMeta) && (params = (fieldMeta = (MetaProto.Meta)descriptor.getOptions().getExtension(MetaProto.fieldMeta)).getParamsMap()) != null) {
                    String connectType = (String)params.get(CONNECT_TYPE_PROP);
                    if (CONNECT_TYPE_INT8.equals(connectType)) {
                        builder = SchemaBuilder.int8();
                        break;
                    }
                    if (CONNECT_TYPE_INT16.equals(connectType)) {
                        builder = SchemaBuilder.int16();
                        break;
                    }
                }
                builder = SchemaBuilder.int32();
                if (descriptor.getType() == Descriptors.FieldDescriptor.Type.INT32) break;
                builder.parameter(PROTOBUF_TYPE_PROP, descriptor.getType().toString().toLowerCase());
                break;
            }
            case UINT32: 
            case FIXED32: 
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                builder = SchemaBuilder.int64();
                if (descriptor.getType() == Descriptors.FieldDescriptor.Type.INT64) break;
                builder.parameter(PROTOBUF_TYPE_PROP, descriptor.getType().toString().toLowerCase());
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case BOOL: {
                builder = SchemaBuilder.bool();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case ENUM: {
                builder = this.useIntForEnums ? SchemaBuilder.int32() : SchemaBuilder.string();
                Descriptors.EnumDescriptor enumDescriptor = descriptor.getEnumType();
                String name = this.enhancedSchemaSupport ? enumDescriptor.getFullName() : enumDescriptor.getName();
                builder.name(name);
                String paramName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_ENUM : PROTOBUF_TYPE_ENUM;
                builder.parameter(paramName, enumDescriptor.getName());
                for (Descriptors.EnumValueDescriptor enumValueDesc : enumDescriptor.getValues()) {
                    String enumSymbol = enumValueDesc.getName();
                    String enumTag = String.valueOf(enumValueDesc.getNumber());
                    builder.parameter(paramName + "." + enumSymbol, enumTag);
                }
                builder.optional();
                break;
            }
            case MESSAGE: {
                String fullName;
                switch (fullName = descriptor.getMessageType().getFullName()) {
                    case "confluent.type.Decimal": {
                        Integer precision = null;
                        int scale = 0;
                        if (descriptor.getOptions().hasExtension(MetaProto.fieldMeta)) {
                            String scaleStr;
                            MetaProto.Meta fieldMeta = (MetaProto.Meta)descriptor.getOptions().getExtension(MetaProto.fieldMeta);
                            Map params = fieldMeta.getParamsMap();
                            String precisionStr = (String)params.get(PROTOBUF_PRECISION_PROP);
                            if (precisionStr != null) {
                                try {
                                    precision = Integer.parseInt(precisionStr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if ((scaleStr = (String)params.get("scale")) != null) {
                                try {
                                    scale = Integer.parseInt(scaleStr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                        builder = Decimal.builder((int)scale);
                        if (precision == null) break;
                        builder.parameter(CONNECT_PRECISION_PROP, precision.toString());
                        break;
                    }
                    case "google.type.Date": {
                        builder = org.apache.kafka.connect.data.Date.builder();
                        break;
                    }
                    case "google.type.TimeOfDay": {
                        builder = Time.builder();
                        break;
                    }
                    case "google.protobuf.Timestamp": {
                        builder = org.apache.kafka.connect.data.Timestamp.builder();
                        break;
                    }
                    default: {
                        builder = this.toUnwrappedOrStructSchema(ctx, descriptor);
                    }
                }
                builder.optional();
                break;
            }
            default: {
                throw new DataException("Unknown Connect schema type: " + descriptor.getType());
            }
        }
        if (descriptor.isRepeated() && builder.type() != Schema.Type.MAP) {
            Schema schema = builder.optional().build();
            builder = SchemaBuilder.array((Schema)schema);
            builder.optional();
        }
        if (this.useOptionalForNullables) {
            if (descriptor.hasOptionalKeyword()) {
                builder.optional();
            }
        } else if (!this.useWrapperForNullables) {
            builder.optional();
        }
        builder.parameter(PROTOBUF_TYPE_TAG, String.valueOf(descriptor.getNumber()));
        return builder.build();
    }

    private SchemaBuilder toUnwrappedOrStructSchema(ToConnectContext ctx, Descriptors.FieldDescriptor descriptor) {
        if (!this.useWrapperForNullables) {
            return this.toStructSchema(ctx, descriptor);
        }
        SchemaBuilder builder = this.toUnwrappedSchema(descriptor.getMessageType());
        return builder != null ? builder : this.toStructSchema(ctx, descriptor);
    }

    private SchemaBuilder toUnwrappedSchema(Descriptors.Descriptor descriptor) {
        String fullName;
        switch (fullName = descriptor.getFullName()) {
            case "google.protobuf.DoubleValue": {
                return SchemaBuilder.float64();
            }
            case "google.protobuf.FloatValue": {
                return SchemaBuilder.float32();
            }
            case "google.protobuf.Int64Value": {
                return SchemaBuilder.int64();
            }
            case "google.protobuf.UInt64Value": {
                return SchemaBuilder.int64();
            }
            case "google.protobuf.Int32Value": {
                return SchemaBuilder.int32();
            }
            case "google.protobuf.UInt32Value": {
                return SchemaBuilder.int64();
            }
            case "google.protobuf.BoolValue": {
                return SchemaBuilder.bool();
            }
            case "google.protobuf.StringValue": {
                return SchemaBuilder.string();
            }
            case "google.protobuf.BytesValue": {
                return SchemaBuilder.bytes();
            }
        }
        return null;
    }

    private SchemaBuilder toStructSchema(ToConnectContext ctx, Descriptors.FieldDescriptor descriptor) {
        if (ProtobufData.isMapDescriptor(descriptor)) {
            return this.toMapSchema(ctx, descriptor.getMessageType());
        }
        String fullName = descriptor.getMessageType().getFullName();
        SchemaBuilder builder = ctx.get(fullName);
        builder = builder != null ? new SchemaWrapper(builder) : this.toConnectSchema(ctx, descriptor.getMessageType(), null);
        return builder;
    }

    private static boolean isMapDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!fieldDescriptor.isRepeated()) {
            return false;
        }
        Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
        List fieldDescriptors = descriptor.getFields();
        return descriptor.getName().endsWith(MAP_ENTRY_SUFFIX) && fieldDescriptors.size() == 2 && ((Descriptors.FieldDescriptor)fieldDescriptors.get(0)).getName().equals(KEY_FIELD) && ((Descriptors.FieldDescriptor)fieldDescriptors.get(1)).getName().equals(VALUE_FIELD) && !((Descriptors.FieldDescriptor)fieldDescriptors.get(0)).isRepeated() && !((Descriptors.FieldDescriptor)fieldDescriptors.get(1)).isRepeated();
    }

    private SchemaBuilder toMapSchema(ToConnectContext ctx, Descriptors.Descriptor descriptor) {
        List fieldDescriptors = descriptor.getFields();
        String name = ProtobufSchema.toMapField((String)(this.enhancedSchemaSupport ? descriptor.getFullName() : descriptor.getName()));
        return SchemaBuilder.map((Schema)this.toConnectSchema(ctx, (Descriptors.FieldDescriptor)fieldDescriptors.get(0)), (Schema)this.toConnectSchema(ctx, (Descriptors.FieldDescriptor)fieldDescriptors.get(1))).name(name);
    }

    private String[] splitName(String fullName) {
        String[] result = new String[2];
        if (fullName == null || fullName.isEmpty()) {
            result[0] = null;
            result[1] = fullName;
            return result;
        }
        String[] parts = fullName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.scrubName(parts[i]);
        }
        if (parts.length <= 1) {
            result[0] = null;
            result[1] = parts[0];
        } else {
            result[0] = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, parts.length - 1));
            result[1] = parts[parts.length - 1];
        }
        return result;
    }

    private String getUnqualifiedName(FromConnectContext ctx, String name) {
        String fullName = this.getNameOrDefault(ctx, name);
        int indexLastDot = fullName.lastIndexOf(46);
        String result = indexLastDot >= 0 ? fullName.substring(indexLastDot + 1) : fullName;
        return this.scrubName(result);
    }

    private String scrubName(String name) {
        return this.scrubInvalidNames ? ProtobufData.doScrubName(name) : name;
    }

    protected static String doScrubName(String name) {
        try {
            if (name == null || name.isEmpty()) {
                return name;
            }
            boolean nameOK = true;
            int n = name.length();
            for (int i = 0; i < n; ++i) {
                char ch = name.charAt(i);
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
                nameOK = false;
            }
            boolean bl = nameOK = nameOK && (name.charAt(0) < '0' || name.charAt(0) > '9') && name.charAt(0) != '_';
            if (nameOK) {
                return name;
            }
            String encoded = URLEncoder.encode(name, "UTF-8");
            if (encoded.charAt(0) >= '0' && encoded.charAt(0) <= '9' || encoded.charAt(0) == '_') {
                encoded = "x" + encoded;
            }
            StringBuilder sb = new StringBuilder(encoded);
            int n2 = sb.length();
            for (int i = 0; i < n2; ++i) {
                char ch = sb.charAt(i);
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
                sb.setCharAt(i, '_');
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private String getNameOrDefault(FromConnectContext ctx, String name) {
        return name != null && !name.isEmpty() ? name : DEFAULT_SCHEMA_NAME + ctx.incrementAndGetNameIndex();
    }

    static {
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value) -> {
            if (!(value instanceof Message)) {
                throw new DataException("Invalid type for Date, expected Message but was " + value.getClass());
            }
            return DecimalUtils.toBigDecimal((Message)((Message)value));
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value) -> {
            if (!(value instanceof Message)) {
                throw new DataException("Invalid type for Date, expected Message but was " + value.getClass());
            }
            Message message = (Message)value;
            int year = 0;
            int month = 0;
            int day = 0;
            for (Map.Entry entry : message.getAllFields().entrySet()) {
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("year")) {
                    year = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("month")) {
                    month = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("day")) continue;
                day = ((Number)entry.getValue()).intValue();
            }
            Calendar cal = Calendar.getInstance(UTC);
            cal.setLenient(false);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value) -> {
            if (!(value instanceof Message)) {
                throw new DataException("Invalid type for Time, expected Message but was " + value.getClass());
            }
            Message message = (Message)value;
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int nanos = 0;
            for (Map.Entry entry : message.getAllFields().entrySet()) {
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("hours")) {
                    hours = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("minutes")) {
                    minutes = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("seconds")) {
                    seconds = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("nanos")) continue;
                nanos = ((Number)entry.getValue()).intValue();
            }
            LocalTime localTime = LocalTime.of(hours, minutes, seconds, nanos);
            return new java.util.Date(localTime.toNanoOfDay() / 1000000L);
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value) -> {
            if (!(value instanceof Message)) {
                throw new DataException("Invalid type for Timestamp, expected Message but was " + value.getClass());
            }
            Message message = (Message)value;
            long seconds = 0L;
            int nanos = 0;
            for (Map.Entry entry : message.getAllFields().entrySet()) {
                if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("seconds")) {
                    seconds = ((Number)entry.getValue()).longValue();
                    continue;
                }
                if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("nanos")) continue;
                nanos = ((Number)entry.getValue()).intValue();
            }
            Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
            return org.apache.kafka.connect.data.Timestamp.toLogical((Schema)schema, (long)Timestamps.toMillis((Timestamp)timestamp));
        });
        TO_PROTOBUF_LOGICAL_CONVERTERS = new HashMap();
        TO_PROTOBUF_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value) -> {
            if (!(value instanceof BigDecimal)) {
                throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
            }
            return DecimalUtils.fromBigDecimal((BigDecimal)((BigDecimal)value));
        });
        TO_PROTOBUF_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Date, expected Date but was " + value.getClass());
            }
            java.util.Date date = (java.util.Date)value;
            Calendar calendar = Calendar.getInstance(UTC);
            calendar.setTime(date);
            if (calendar.get(11) != 0 || calendar.get(12) != 0 || calendar.get(13) != 0 || calendar.get(14) != 0) {
                throw new DataException("Kafka Connect Date type should not have any time fields set to non-zero values.");
            }
            return Date.newBuilder().setYear(calendar.get(1)).setMonth(calendar.get(2) + 1).setDay(calendar.get(5)).build();
        });
        TO_PROTOBUF_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Time, expected Date but was " + value.getClass());
            }
            java.util.Date date = (java.util.Date)value;
            Calendar calendar = Calendar.getInstance(UTC);
            calendar.setTime(date);
            long unixMillis = calendar.getTimeInMillis();
            if (unixMillis < 0L || unixMillis > 86400000L) {
                throw new DataException("Time values must use number of millis greater than 0 and less than 86400000");
            }
            return TimeOfDay.newBuilder().setHours(calendar.get(11)).setMinutes(calendar.get(12)).setSeconds(calendar.get(13)).setNanos(calendar.get(14) * 1000000).build();
        });
        TO_PROTOBUF_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Timestamp, expected Date but was " + value.getClass());
            }
            java.util.Date date = (java.util.Date)value;
            return Timestamps.fromMillis((long)org.apache.kafka.connect.data.Timestamp.fromLogical((Schema)schema, (java.util.Date)date));
        });
    }

    private static class FromConnectContext {
        private final Map<MessageDefinition.Builder, Set<String>> messageNames = new IdentityHashMap<MessageDefinition.Builder, Set<String>>();
        private int defaultSchemaNameIndex = 0;

        public boolean contains(MessageDefinition.Builder parent, String child) {
            if (parent.getName().equals(child)) {
                return true;
            }
            Set<String> children = this.messageNames.get(parent);
            if (child == null || children == null) {
                return false;
            }
            return children.contains(child);
        }

        public void add(MessageDefinition.Builder parent, String child) {
            if (child != null) {
                Set children = this.messageNames.computeIfAbsent(parent, k -> new HashSet());
                children.add(child);
            }
        }

        public int incrementAndGetNameIndex() {
            return ++this.defaultSchemaNameIndex;
        }
    }

    private static class ToConnectContext {
        private final Map<String, SchemaBuilder> messageToStructMap = new HashMap<String, SchemaBuilder>();

        public SchemaBuilder get(String messageName) {
            return this.messageToStructMap.get(messageName);
        }

        public void put(String messageName, SchemaBuilder builder) {
            this.messageToStructMap.put(messageName, builder);
        }
    }

    private static interface LogicalTypeConverter {
        public Object convert(Schema var1, Object var2);
    }

    static class SchemaWrapper
    extends SchemaBuilder {
        private final SchemaBuilder builder;
        private final Map<String, String> parameters;

        public SchemaWrapper(SchemaBuilder builder) {
            super(Schema.Type.STRUCT);
            this.builder = builder;
            this.parameters = new LinkedHashMap<String, String>();
        }

        public boolean isOptional() {
            return this.builder.isOptional();
        }

        public SchemaBuilder optional() {
            this.builder.optional();
            return this;
        }

        public SchemaBuilder required() {
            this.builder.required();
            return this;
        }

        public Object defaultValue() {
            return this.builder.defaultValue();
        }

        public SchemaBuilder defaultValue(Object value) {
            this.builder.defaultValue(value);
            return this;
        }

        public String name() {
            return this.builder.name();
        }

        public SchemaBuilder name(String name) {
            this.builder.name(name);
            return this;
        }

        public Integer version() {
            return this.builder.version();
        }

        public SchemaBuilder version(Integer version) {
            this.builder.version(version);
            return this;
        }

        public String doc() {
            return this.builder.doc();
        }

        public SchemaBuilder doc(String doc) {
            this.builder.doc(doc);
            return this;
        }

        public Map<String, String> parameters() {
            HashMap<String, String> allParameters = new HashMap<String, String>();
            if (this.builder.parameters() != null) {
                allParameters.putAll(this.builder.parameters());
            }
            allParameters.putAll(this.parameters);
            return allParameters;
        }

        public SchemaBuilder parameters(Map<String, String> props) {
            this.parameters.putAll(props);
            return this;
        }

        public SchemaBuilder parameter(String propertyName, String propertyValue) {
            this.parameters.put(propertyName, propertyValue);
            return this;
        }

        public Schema.Type type() {
            return this.builder.type();
        }

        public List<Field> fields() {
            return this.builder.fields();
        }

        public Field field(String fieldName) {
            return this.builder.field(fieldName);
        }

        public SchemaBuilder field(String fieldName, Schema fieldSchema) {
            this.builder.field(fieldName, fieldSchema);
            return this;
        }

        public Schema keySchema() {
            return this.builder.keySchema();
        }

        public Schema valueSchema() {
            return this.builder.valueSchema();
        }

        public Schema build() {
            return this;
        }

        public Schema schema() {
            return this;
        }
    }

    static class FieldDefinition {
        private final String label;
        private final String type;
        private final String name;
        private final int num;
        private final String defaultVal;
        private final ProtobufSchema.ProtobufMeta meta;

        public FieldDefinition(String label, String type, String name, int num, String defaultVal, ProtobufSchema.ProtobufMeta meta) {
            this.label = label;
            this.type = type;
            this.name = name;
            this.num = num;
            this.defaultVal = defaultVal;
            this.meta = meta;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getNum() {
            return this.num;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        public String getLabel() {
            return this.label;
        }

        public ProtobufSchema.ProtobufMeta getMeta() {
            return this.meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldDefinition that = (FieldDefinition)o;
            return this.num == that.num && Objects.equals(this.label, that.label) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.defaultVal, that.defaultVal) && Objects.equals(this.meta, that.meta);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.type, this.name, this.num, this.defaultVal, this.meta);
        }
    }

    static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Pair{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

