/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage.utils;

import io.kcache.CacheUpdateHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;

public class CompositeCacheUpdateHandler<K, V>
implements CacheUpdateHandler<K, V> {
    private final List<? extends CacheUpdateHandler<K, V>> handlers;

    public CompositeCacheUpdateHandler(List<? extends CacheUpdateHandler<K, V>> handlers) {
        this.handlers = handlers;
    }

    public void cacheInitialized(int count, Map<TopicPartition, Long> checkpoints) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.cacheInitialized(count, checkpoints);
        }
    }

    public void cacheReset() {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.cacheReset();
        }
    }

    public void cacheSynchronized(int count, Map<TopicPartition, Long> checkpoints) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.cacheSynchronized(count, checkpoints);
        }
    }

    public void startBatch(int count) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.startBatch(count);
        }
    }

    public CacheUpdateHandler.ValidationStatus validateUpdate(Headers headers, K key, V value, TopicPartition tp, long offset, long ts, TimestampType tsType, Optional<Integer> leaderEpoch) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            CacheUpdateHandler.ValidationStatus status = handler.validateUpdate(key, value, tp, offset, ts);
            if (status == CacheUpdateHandler.ValidationStatus.SUCCESS) continue;
            return status;
        }
        return CacheUpdateHandler.ValidationStatus.SUCCESS;
    }

    public void handleUpdate(K key, V value, V oldValue, TopicPartition tp, long offset, long ts) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.handleUpdate(key, value, oldValue, tp, offset, ts);
        }
    }

    public Map<TopicPartition, Long> checkpoint(int count) {
        HashMap result = null;
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            Map offsets = handler.checkpoint(count);
            if (offsets == null) continue;
            if (result != null) {
                for (Map.Entry entry : offsets.entrySet()) {
                    result.merge(entry.getKey(), (Long)entry.getValue(), Long::min);
                }
                continue;
            }
            result = new HashMap(offsets);
        }
        return result;
    }

    public void endBatch(int count) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.endBatch(count);
        }
    }

    public void failBatch(int count, Throwable t) {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.failBatch(count, t);
        }
    }

    public void cacheFlushed() {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.cacheFlushed();
        }
    }

    public void close() throws IOException {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.close();
        }
    }

    public void cacheDestroyed() {
        for (CacheUpdateHandler<K, V> handler : this.handlers) {
            handler.cacheDestroyed();
        }
    }
}

