/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;

public interface StateUpdater {
    public void start();

    public void shutdown(Duration var1);

    public void add(Task var1);

    public void remove(TaskId var1);

    public void signalResume();

    public Set<StreamTask> drainRestoredActiveTasks(Duration var1);

    public Set<Task> drainRemovedTasks();

    public boolean hasRemovedTasks();

    public List<ExceptionAndTasks> drainExceptionsAndFailedTasks();

    public boolean hasExceptionsAndFailedTasks();

    public Set<Task> getTasks();

    public Set<Task> getUpdatingTasks();

    public boolean restoresActiveTasks();

    public Set<StandbyTask> getStandbyTasks();

    public KafkaFutureImpl<Uuid> restoreConsumerInstanceId(Duration var1);

    public static class ExceptionAndTasks {
        private final Set<Task> tasks;
        private final RuntimeException exception;

        public ExceptionAndTasks(Set<Task> tasks, RuntimeException exception) {
            this.tasks = Objects.requireNonNull(tasks);
            this.exception = Objects.requireNonNull(exception);
        }

        public Set<Task> getTasks() {
            return Collections.unmodifiableSet(this.tasks);
        }

        public RuntimeException exception() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExceptionAndTasks)) {
                return false;
            }
            ExceptionAndTasks that = (ExceptionAndTasks)o;
            return this.tasks.equals(that.tasks) && this.exception.equals(that.exception);
        }

        public int hashCode() {
            return Objects.hash(this.tasks, this.exception);
        }
    }
}

