/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Command;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.QueryInfo;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.tools.migrations.util.ServerVersionUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="destroy-metadata", description="Destroys all ksqlDB server resources related to migrations, including the migrations metadata stream and table and their underlying Kafka topics. WARNING: this is not reversible!")
public class DestroyMigrationsCommand
extends BaseCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DestroyMigrationsCommand.class);

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(config, MigrationsUtil::getKsqlClient);
    }

    @VisibleForTesting
    int command(MigrationConfig config, Function<MigrationConfig, Client> clientSupplier) {
        Client ksqlClient;
        String streamName = config.getString("ksql.migrations.stream.name");
        String tableName = config.getString("ksql.migrations.table.name");
        try {
            ksqlClient = clientSupplier.apply(config);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        LOGGER.info("Cleaning migrations metadata stream and table from ksqlDB server");
        if (ServerVersionUtil.serverVersionCompatible(ksqlClient, config) && this.deleteMigrationsTable(ksqlClient, tableName) && this.deleteMigrationsStream(ksqlClient, streamName)) {
            LOGGER.info("Migrations metadata cleaned successfully");
            ksqlClient.close();
            return 0;
        }
        ksqlClient.close();
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private boolean deleteMigrationsTable(Client ksqlClient, String tableName) {
        try {
            if (!DestroyMigrationsCommand.sourceExists(ksqlClient, tableName, true)) {
                LOGGER.info("Metadata table does not exist. Skipping cleanup.");
                return true;
            }
            SourceDescription tableInfo = DestroyMigrationsCommand.getSourceInfo(ksqlClient, tableName, true);
            DestroyMigrationsCommand.terminateQueryForTable(ksqlClient, tableInfo);
            DestroyMigrationsCommand.dropSource(ksqlClient, tableName, true);
            return true;
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    private boolean deleteMigrationsStream(Client ksqlClient, String streamName) {
        try {
            if (!DestroyMigrationsCommand.sourceExists(ksqlClient, streamName, false)) {
                LOGGER.info("Metadata stream does not exist. Skipping cleanup.");
                return true;
            }
            DestroyMigrationsCommand.dropSource(ksqlClient, streamName, false);
            return true;
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    private static boolean sourceExists(Client ksqlClient, String sourceName, boolean isTable) {
        try {
            if (isTable) {
                List tables = (List)ksqlClient.listTables().get();
                return tables.stream().anyMatch(tableInfo -> tableInfo.getName().equalsIgnoreCase(sourceName));
            }
            List streams = (List)ksqlClient.listStreams().get();
            return streams.stream().anyMatch(streamInfo -> streamInfo.getName().equalsIgnoreCase(sourceName));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Failed to check for presence of metadata %s '%s': %s", isTable ? "table" : "stream", sourceName, e.getMessage()));
        }
    }

    private static SourceDescription getSourceInfo(Client ksqlClient, String sourceName, boolean isTable) {
        try {
            return (SourceDescription)ksqlClient.describeSource(sourceName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Failed to describe metadata %s '%s': %s", isTable ? "table" : "stream", sourceName, e.getMessage()));
        }
    }

    private static void terminateQueryForTable(Client ksqlClient, SourceDescription tableDesc) {
        List queries = tableDesc.writeQueries();
        if (queries.size() == 0) {
            LOGGER.info("Found 0 queries writing to the metadata table");
            return;
        }
        if (queries.size() > 1) {
            throw new MigrationException("Found multiple queries writing to the metadata table. Query IDs: " + queries.stream().map(QueryInfo::getId).collect(Collectors.joining("', '", "'", "'.")));
        }
        String queryId = ((QueryInfo)queries.get(0)).getId();
        LOGGER.info("Found 1 query writing to the metadata table. Query ID: {}", (Object)queryId);
        LOGGER.info("Terminating query with ID: {}", (Object)queryId);
        try {
            ksqlClient.executeStatement("TERMINATE " + queryId + ";").get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Failed to terminate query populating metadata table. Query ID: %s. Error: %s", queryId, e.getMessage()));
        }
    }

    private static void dropSource(Client ksqlClient, String sourceName, boolean isTable) {
        String sourceType = isTable ? "table" : "stream";
        LOGGER.info("Dropping migrations metadata {}: {}", (Object)sourceType, (Object)sourceName);
        try {
            String sql = String.format("DROP %s %s DELETE TOPIC;", sourceType.toUpperCase(), sourceName);
            ksqlClient.executeStatement(sql).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Failed to drop metadata %s '%s': %s", sourceType, sourceName, e.getMessage()));
        }
    }
}

