/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GenericRow {
    private final ArrayList<Object> values;

    public GenericRow() {
        this(0);
    }

    public GenericRow(int initialCapacity) {
        this.values = new ArrayList(initialCapacity);
    }

    @VisibleForTesting
    public static GenericRow genericRow(Object ... columns) {
        return new GenericRow().appendAll(Arrays.asList(columns));
    }

    public static GenericRow fromList(List<?> columns) {
        return new GenericRow().appendAll(columns);
    }

    public void ensureAdditionalCapacity(int additionalCapacity) {
        this.values.ensureCapacity(additionalCapacity + this.values.size());
    }

    public int size() {
        return this.values.size();
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public void set(int index, Object value) {
        this.values.set(index, value);
    }

    public GenericRow append(Object value) {
        this.values.add(value);
        return this;
    }

    public GenericRow appendAll(Collection<?> values) {
        this.values.addAll(values);
        return this;
    }

    @JsonProperty(value="columns")
    public List<Object> values() {
        return Collections.unmodifiableList(this.values);
    }

    public String toString() {
        return this.values.stream().map(GenericRow::formatValue).collect(Collectors.joining(" | ", "[ ", " ]"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericRow that = (GenericRow)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    static String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Long) {
            return value.toString() + "L";
        }
        return value.toString();
    }
}

