/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public class QueryId {
    private final String id;
    private final String cachedUpperCase;

    @JsonCreator
    public QueryId(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.cachedUpperCase = id.toUpperCase();
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryId)) {
            return false;
        }
        QueryId queryId = (QueryId)o;
        return Objects.equals(this.cachedUpperCase, queryId.cachedUpperCase);
    }

    public int hashCode() {
        return Objects.hash(this.cachedUpperCase);
    }
}

