/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.OffsetVector;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class PushOffsetVector
implements OffsetVector {
    private final AtomicReference<List<Long>> offsets = new AtomicReference();

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PushOffsetVector(@JsonProperty(value="o") List<Long> offsets) {
        this.offsets.set((List<Long>)ImmutableList.copyOf(offsets));
    }

    public PushOffsetVector() {
        this.offsets.set(Collections.emptyList());
    }

    @Override
    public void merge(OffsetVector other) {
        List<Long> offsetsOther = other.getDenseRepresentation();
        if (this.offsets.get().isEmpty()) {
            this.offsets.set(offsetsOther);
            return;
        }
        if (offsetsOther.isEmpty()) {
            return;
        }
        Preconditions.checkState((offsetsOther.size() == this.offsets.get().size() ? 1 : 0) != 0, (Object)("Should be equal other:" + offsetsOther.size() + ",  offsets:" + this.offsets.get().size()));
        ImmutableList.Builder builder = ImmutableList.builder();
        int partition = 0;
        for (Long offset : this.offsets.get()) {
            builder.add((Object)Math.max(offsetsOther.get(partition), offset));
            ++partition;
        }
        this.offsets.set((List<Long>)builder.build());
    }

    public PushOffsetVector mergeCopy(OffsetVector other) {
        PushOffsetVector copy = this.copy();
        copy.merge(other);
        return copy;
    }

    @Override
    public boolean lessThanOrEqualTo(OffsetVector other) {
        List<Long> offsetsOther = other.getDenseRepresentation();
        if (offsetsOther.isEmpty()) {
            return true;
        }
        Preconditions.checkState((offsetsOther.size() == this.offsets.get().size() ? 1 : 0) != 0);
        int partition = 0;
        for (Long offset : this.offsets.get()) {
            long offsetOther = offsetsOther.get(partition);
            if (offset >= 0L && offsetOther >= 0L && offset > offsetOther) {
                return false;
            }
            ++partition;
        }
        return true;
    }

    @Override
    @JsonIgnore
    public List<Long> getDenseRepresentation() {
        return this.getOffsets();
    }

    @JsonIgnore
    public Map<Integer, Long> getSparseRepresentation() {
        int i = 0;
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>();
        for (Long offset : this.getOffsets()) {
            offsets.put(i++, offset);
        }
        return ImmutableMap.copyOf(offsets);
    }

    @JsonProperty(value="o")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public List<Long> getOffsets() {
        return this.offsets.get();
    }

    @Override
    @JsonIgnore
    public boolean dominates(OffsetVector other) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @JsonIgnore
    public void update(String topic, int partition, long offset) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @JsonIgnore
    public String serialize() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public PushOffsetVector copy() {
        return new PushOffsetVector(this.offsets.get());
    }

    @JsonIgnore
    public String toString() {
        return "PushOffsetVector{offsets=" + this.offsets + '}';
    }

    public int hashCode() {
        return Objects.hash(this.offsets.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushOffsetVector that = (PushOffsetVector)o;
        return Objects.equals(this.offsets.get(), that.offsets.get());
    }

    public static boolean isContinuationTokenEnabled(Map<String, Object> properties) {
        Object pushV2Enabled = properties.get("ksql.query.push.v2.enabled");
        Object pushV2AlosEnabled = properties.get("ksql.query.push.v2.alos.enabled");
        if (pushV2AlosEnabled == null) {
            pushV2AlosEnabled = true;
        }
        if (pushV2Enabled instanceof Boolean && pushV2AlosEnabled instanceof Boolean) {
            return (Boolean)pushV2Enabled != false && (Boolean)pushV2AlosEnabled != false;
        }
        return false;
    }
}

