/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.api.auth.ApiSecurityContext;
import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.security.KsqlPrincipal;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DefaultApiSecurityContext
implements ApiSecurityContext {
    private final Optional<KsqlPrincipal> principal;
    private final Optional<String> authToken;
    private final List<Map.Entry<String, String>> requestHeaders;

    public static DefaultApiSecurityContext create(RoutingContext routingContext, Server server) {
        User user = routingContext.user();
        if (user != null && !(user instanceof ApiUser)) {
            throw new IllegalStateException("Not an ApiUser: " + user);
        }
        ApiUser apiUser = (ApiUser)user;
        String authToken = routingContext.request().getHeader("Authorization");
        if (server.getAuthenticationPlugin().isPresent()) {
            authToken = server.getAuthenticationPlugin().get().getAuthHeader(routingContext);
        }
        List requestHeaders = routingContext.request().headers().entries();
        String ipAddress = routingContext.request().remoteAddress().host();
        int port = routingContext.request().remoteAddress().port();
        return new DefaultApiSecurityContext((KsqlPrincipal)(apiUser != null ? apiUser.getPrincipal().withIpAddressAndPort(ipAddress == null ? "" : ipAddress, port) : null), authToken, requestHeaders);
    }

    private DefaultApiSecurityContext(KsqlPrincipal principal, String authToken, List<Map.Entry<String, String>> requestHeaders) {
        this.principal = Optional.ofNullable(principal);
        this.authToken = Optional.ofNullable(authToken);
        this.requestHeaders = requestHeaders;
    }

    @Override
    public Optional<KsqlPrincipal> getPrincipal() {
        return this.principal;
    }

    @Override
    public Optional<String> getAuthHeader() {
        return this.authToken;
    }

    @Override
    public List<Map.Entry<String, String>> getRequestHeaders() {
        return ImmutableList.copyOf(this.requestHeaders);
    }
}

