/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.api.auth.BasicCallbackHandler;
import io.confluent.ksql.api.auth.JaasPrincipal;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.security.DefaultKsqlPrincipal;
import io.confluent.ksql.security.KsqlPrincipal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasAuthProvider
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JaasAuthProvider.class);
    private final Server server;
    private final String contextName;
    private final LoginContextSupplier loginContext;

    public JaasAuthProvider(Server server, String contextName) {
        this(server, contextName, JAASLoginService::new);
    }

    @VisibleForTesting
    JaasAuthProvider(Server server, String contextName, LoginContextSupplier loginContextSupplier) {
        this.server = Objects.requireNonNull(server, "server");
        this.contextName = Objects.requireNonNull(contextName, "contextName");
        this.loginContext = Objects.requireNonNull(loginContextSupplier, "loginContextSupplier");
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString("username");
        if (username == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo missing 'username' field"));
            return;
        }
        String password = authInfo.getString("password");
        if (password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo missing 'password' field"));
            return;
        }
        this.server.getWorkerExecutor().executeBlocking(promisedUser -> this.getUser(this.contextName, username, password, (Promise<User>)promisedUser), false, resultHandler);
    }

    private void getUser(String contextName, String username, String password, Promise<User> promisedUser) {
        JAASLoginService login = this.loginContext.get();
        login.setCallbackHandlerClass(BasicCallbackHandler.class.getName());
        login.setLoginModuleName(contextName);
        try {
            login.start();
        }
        catch (Exception e) {
            LOG.error("Could not start login service.", (Throwable)e);
            promisedUser.fail("Could not start login service.");
        }
        UserIdentity user = login.login(username, (Object)password, null);
        if (user == null) {
            LOG.error("Failed to log in. ");
            promisedUser.fail("Failed to log in: Invalid username/password.");
            return;
        }
        Optional<KsqlPrincipal> ksqlPrincipal = user.getSubject().getPrincipals().stream().filter(KsqlPrincipal.class::isInstance).map(KsqlPrincipal.class::cast).findFirst();
        AuthorizationsImpl authorizations = new AuthorizationsImpl();
        user.getSubject().getPrincipals().forEach(arg_0 -> JaasAuthProvider.lambda$getUser$1((Authorizations)authorizations, arg_0));
        promisedUser.complete((Object)new ApiUser((Authorizations)authorizations, ksqlPrincipal, username, password){
            final /* synthetic */ Authorizations val$authorizations;
            final /* synthetic */ Optional val$ksqlPrincipal;
            final /* synthetic */ String val$username;
            final /* synthetic */ String val$password;
            {
                this.val$authorizations = authorizations;
                this.val$ksqlPrincipal = optional;
                this.val$username = string;
                this.val$password = string2;
            }

            public Authorizations authorizations() {
                return this.val$authorizations;
            }

            @Override
            public DefaultKsqlPrincipal getPrincipal() {
                return this.val$ksqlPrincipal.map(DefaultKsqlPrincipal::new).orElseGet(() -> new JaasPrincipal(this.val$username, this.val$password));
            }

            public JsonObject attributes() {
                throw new UnsupportedOperationException();
            }

            public User isAuthorized(Authorization authority, Handler<AsyncResult<Boolean>> resultHandler) {
                throw new UnsupportedOperationException();
            }

            public JsonObject principal() {
                throw new UnsupportedOperationException();
            }

            public void setAuthProvider(AuthProvider authProvider) {
                throw new UnsupportedOperationException();
            }

            public User merge(User other) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static /* synthetic */ void lambda$getUser$1(Authorizations authorizations, Principal p) {
        authorizations.add("default", (Authorization)RoleBasedAuthorization.create((String)p.getName()));
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface LoginContextSupplier {
        public JAASLoginService get();
    }
}

