/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.InsertResult;
import io.confluent.ksql.api.server.InsertsStreamResponseWriter;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.InsertAck;
import io.confluent.ksql.rest.entity.InsertError;
import io.vertx.core.Context;
import io.vertx.core.http.HttpServerResponse;
import java.util.Objects;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcksSubscriber
extends BaseSubscriber<InsertResult> {
    private static final Logger log = LoggerFactory.getLogger(AcksSubscriber.class);
    private static final int REQUEST_BATCH_SIZE = 200;
    private final HttpServerResponse response;
    private final InsertsStreamResponseWriter insertsStreamResponseWriter;
    private Long insertsSent;
    private long acksSent;
    private boolean drainHandlerSet;
    private boolean responseEnded;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AcksSubscriber(Context context, HttpServerResponse response, InsertsStreamResponseWriter insertsStreamResponseWriter) {
        super(context);
        this.response = Objects.requireNonNull(response);
        this.insertsStreamResponseWriter = Objects.requireNonNull(insertsStreamResponseWriter);
    }

    protected void afterSubscribe(Subscription subscription) {
        this.makeRequest(200L);
    }

    public void handleValue(InsertResult result) {
        this.checkContext();
        if (this.responseEnded) {
            return;
        }
        if (result.succeeded()) {
            this.handleSuccessfulInsert(result);
        } else {
            this.handleFailedInsert(result);
        }
    }

    public void handleComplete() {
        this.insertsStreamResponseWriter.end();
    }

    public void handleError(Throwable t) {
        log.error("Error in processing inserts", t);
    }

    private void handleSuccessfulInsert(InsertResult result) {
        this.insertsStreamResponseWriter.writeInsertResponse(new InsertAck(result.sequenceNumber()));
        ++this.acksSent;
        if (this.insertsSent != null && this.insertsSent == this.acksSent) {
            this.close();
        } else if (this.response.writeQueueFull()) {
            if (!this.drainHandlerSet) {
                this.response.drainHandler(v -> {
                    this.drainHandlerSet = false;
                    this.checkMakeRequest();
                });
                this.drainHandlerSet = true;
            }
        } else {
            this.checkMakeRequest();
        }
    }

    private void handleFailedInsert(InsertResult result) {
        log.error("Error in processing inserts", (Throwable)result.exception());
        Exception exception = result.exception();
        InsertError insertError = exception instanceof KsqlApiException ? new InsertError(result.sequenceNumber(), ((KsqlApiException)((Object)exception)).getErrorCode(), exception.getMessage()) : new InsertError(result.sequenceNumber(), Errors.ERROR_CODE_SERVER_ERROR, "Error in processing inserts. Check server logs for details.");
        this.insertsStreamResponseWriter.writeError(insertError).end();
        this.responseEnded = true;
    }

    private void checkMakeRequest() {
        if (this.acksSent % 200L == 0L) {
            this.makeRequest(200L);
        }
    }

    private void close() {
        this.insertsStreamResponseWriter.end();
        this.complete();
    }

    void insertsSent(long num) {
        this.insertsSent = num;
        if (this.acksSent == num) {
            this.close();
        }
    }
}

