/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.api.auth.AuthenticationPlugin;
import io.confluent.ksql.api.auth.AuthenticationPluginHandler;
import io.confluent.ksql.api.auth.JaasAuthProvider;
import io.confluent.ksql.api.auth.KsqlAuthorizationProviderHandler;
import io.confluent.ksql.api.auth.RoleBasedAuthZHandler;
import io.confluent.ksql.api.auth.SystemAuthenticationHandler;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlSecurityExtension;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientAuth;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class AuthHandlers {
    private static final Set<String> KSQL_AUTHENTICATION_SKIP_PATHS = ImmutableSet.of((Object)"/v1/metadata", (Object)"/v1/metadata/id", (Object)"/healthcheck");
    private static final String PROVIDER_KEY = "provider";

    private AuthHandlers() {
    }

    static void setupAuthHandlers(Server server, Router router, boolean isInternalListener) {
        Optional<BasicAuthHandler> jaas = AuthHandlers.getJaasAuthHandler(server);
        KsqlSecurityExtension securityExtension = server.getSecurityExtension();
        Optional<AuthenticationPlugin> authenticationPlugin = server.getAuthenticationPlugin();
        Optional<Handler> pluginHandler = authenticationPlugin.map(plugin -> new AuthenticationPluginHandler(server, (AuthenticationPlugin)plugin));
        Optional<SystemAuthenticationHandler> systemAuthenticationHandler = AuthHandlers.getSystemAuthenticationHandler(server, isInternalListener);
        systemAuthenticationHandler.ifPresent(handler -> AuthHandlers.registerAuthHandler(router, handler));
        if (jaas.isPresent() || authenticationPlugin.isPresent()) {
            List skipPaths = server.getConfig().getList("authentication.skip.paths");
            Pattern skipPathPattern = AuthHandlers.getAuthenticationSkipPathPattern(skipPaths);
            AuthHandlers.registerAuthHandler(router, (Handler<RoutingContext>)((Handler)rc -> AuthHandlers.selectHandler(rc, skipPathPattern, jaas.isPresent(), pluginHandler.isPresent())));
            jaas.ifPresent(h -> AuthHandlers.registerAuthHandler(router, AuthHandlers.selectiveHandler((Handler<RoutingContext>)h, Provider.JAAS::equals)));
            AuthHandlers.registerAuthHandler(router, AuthHandlers.selectiveHandler(new RoleBasedAuthZHandler(server.getConfig().getList("authentication.roles")), Provider.JAAS::equals));
            pluginHandler.ifPresent(h -> AuthHandlers.registerAuthHandler(router, AuthHandlers.selectiveHandler((Handler<RoutingContext>)h, Provider.PLUGIN::equals)));
            securityExtension.getAuthorizationProvider().ifPresent(ksqlAuthorizationProvider -> AuthHandlers.registerAuthHandler(router, AuthHandlers.selectiveHandler(new KsqlAuthorizationProviderHandler(server, (KsqlAuthorizationProvider)ksqlAuthorizationProvider), provider -> provider == Provider.JAAS || provider == Provider.PLUGIN)));
            router.route().handler(AuthHandlers::resumeHandler);
        }
    }

    private static void registerAuthHandler(Router router, Handler<RoutingContext> routingContext) {
        router.route().handler(AuthHandlers::pauseHandler);
        router.route().handler(routingContext);
    }

    private static Handler<RoutingContext> selectiveHandler(Handler<RoutingContext> handler, Predicate<Provider> providerTest) {
        return rc -> {
            if (!providerTest.test((Provider)((Object)((Object)rc.data().get(PROVIDER_KEY))))) {
                rc.next();
            } else {
                handler.handle(rc);
            }
        };
    }

    @VisibleForTesting
    static void selectHandler(RoutingContext context, Pattern skipPathsPattern, boolean jaasAvailable, boolean pluginAvailable) {
        if (skipPathsPattern.matcher(context.normalizedPath()).matches()) {
            context.data().put(PROVIDER_KEY, Provider.SKIP);
            context.next();
            return;
        }
        if (SystemAuthenticationHandler.isAuthenticatedAsSystemUser(context)) {
            context.data().put(PROVIDER_KEY, Provider.SYSTEM);
            context.next();
            return;
        }
        String authHeader = context.request().getHeader("Authorization");
        if (jaasAvailable && authHeader != null && authHeader.toLowerCase().startsWith("basic ")) {
            context.data().put(PROVIDER_KEY, Provider.JAAS);
        } else if (pluginAvailable) {
            context.data().put(PROVIDER_KEY, Provider.PLUGIN);
        } else {
            context.fail(HttpResponseStatus.UNAUTHORIZED.code(), (Throwable)((Object)new KsqlApiException("Unauthorized", Errors.ERROR_CODE_UNAUTHORIZED)));
        }
        context.next();
    }

    private static Optional<BasicAuthHandler> getJaasAuthHandler(Server server) {
        String authMethod;
        switch (authMethod = server.getConfig().getString("authentication.method")) {
            case "BASIC": {
                return Optional.of(AuthHandlers.basicAuthHandler(server));
            }
            case "NONE": {
                return Optional.empty();
            }
        }
        throw new IllegalStateException(String.format("Unexpected value for %s: %s", "authentication.method", authMethod));
    }

    private static BasicAuthHandler basicAuthHandler(Server server) {
        String realm = server.getConfig().getString("authentication.realm");
        JaasAuthProvider authProvider = new JaasAuthProvider(server, realm);
        return BasicAuthHandler.create((AuthenticationProvider)authProvider, (String)realm);
    }

    private static Optional<SystemAuthenticationHandler> getSystemAuthenticationHandler(Server server, boolean isInternalListener) {
        String internalListener = server.getConfig().getString("ksql.internal.listener");
        if (internalListener == null) {
            return Optional.empty();
        }
        String scheme = URI.create(internalListener).getScheme();
        if (server.getConfig().getClientAuthInternal() == ClientAuth.REQUIRED && "https".equalsIgnoreCase(scheme) && isInternalListener) {
            return Optional.of(new SystemAuthenticationHandler());
        }
        return Optional.empty();
    }

    private static void pauseHandler(RoutingContext routingContext) {
        routingContext.request().pause();
        routingContext.next();
    }

    private static void resumeHandler(RoutingContext routingContext) {
        routingContext.request().resume();
        routingContext.next();
    }

    static Pattern getAuthenticationSkipPathPattern(List<String> skipPaths) {
        HashSet<String> unauthenticatedPaths = new HashSet<String>(KSQL_AUTHENTICATION_SKIP_PATHS);
        unauthenticatedPaths.addAll(skipPaths);
        String paths = String.join((CharSequence)",", unauthenticatedPaths);
        String converted = ServerUtils.convertCommaSeparatedWilcardsToRegex(paths);
        return Pattern.compile(converted);
    }

    static enum Provider {
        SYSTEM,
        JAAS,
        PLUGIN,
        SKIP;

    }
}

