/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.vertx.core.Context;
import io.vertx.core.http.HttpServerResponse;
import java.util.Objects;
import org.reactivestreams.Subscription;

public class PrintSubscriber
extends BaseSubscriber<String> {
    private static final int REQUEST_BATCH_SIZE = 200;
    private final HttpServerResponse response;
    private int tokens;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PrintSubscriber(Context context, HttpServerResponse response) {
        super(context);
        this.response = Objects.requireNonNull(response);
    }

    protected void afterSubscribe(Subscription subscription) {
        this.checkMakeRequest();
    }

    public void handleValue(String row) {
        this.response.write(row + "\n");
        --this.tokens;
        if (this.response.writeQueueFull()) {
            this.response.drainHandler(v -> this.checkMakeRequest());
        } else {
            this.checkMakeRequest();
        }
    }

    private void checkMakeRequest() {
        if (this.tokens == 0) {
            this.tokens = 200;
            this.makeRequest(200L);
        }
    }

    public void handleComplete() {
        this.response.end();
    }
}

