/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.QueryStreamResponseWriter;
import io.confluent.ksql.execution.streams.materialization.ks.NotUpToBoundException;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.RowMetadata;
import io.vertx.core.Context;
import io.vertx.core.http.HttpServerResponse;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySubscriber
extends BaseSubscriber<KeyValueMetadata<List<?>, GenericRow>> {
    private static final Logger log = LoggerFactory.getLogger(QuerySubscriber.class);
    private static final int REQUEST_BATCH_SIZE = 200;
    private final HttpServerResponse response;
    private final QueryStreamResponseWriter queryStreamResponseWriter;
    private final Supplier<Boolean> hitLimit;
    private int tokens;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public QuerySubscriber(Context context, HttpServerResponse response, QueryStreamResponseWriter queryStreamResponseWriter, Supplier<Boolean> hitLimit) {
        super(context);
        this.response = Objects.requireNonNull(response);
        this.queryStreamResponseWriter = Objects.requireNonNull(queryStreamResponseWriter);
        this.hitLimit = hitLimit;
    }

    protected void afterSubscribe(Subscription subscription) {
        this.checkMakeRequest();
    }

    public void handleValue(KeyValueMetadata<List<?>, GenericRow> row) {
        if (row.getRowMetadata().isPresent() && ((RowMetadata)row.getRowMetadata().get()).isStandaloneRow()) {
            if (((RowMetadata)row.getRowMetadata().get()).getPushOffsetsRange().isPresent()) {
                this.queryStreamResponseWriter.writeContinuationToken(new PushContinuationToken(((PushOffsetRange)((RowMetadata)row.getRowMetadata().get()).getPushOffsetsRange().get()).serialize()));
            } else if (((RowMetadata)row.getRowMetadata().get()).getConsistencyOffsetVector().isPresent()) {
                this.queryStreamResponseWriter.writeConsistencyToken(new ConsistencyToken(((ConsistencyOffsetVector)((RowMetadata)row.getRowMetadata().get()).getConsistencyOffsetVector().get()).serialize()));
            }
        } else {
            this.queryStreamResponseWriter.writeRow(row);
        }
        --this.tokens;
        if (this.response.writeQueueFull()) {
            this.response.drainHandler(v -> this.checkMakeRequest());
        } else {
            this.checkMakeRequest();
        }
    }

    private void checkMakeRequest() {
        if (this.tokens == 0) {
            this.tokens = 200;
            this.makeRequest(200L);
        }
    }

    public void handleError(Throwable t) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(t);
        for (Throwable s : t.getSuppressed()) {
            if (s instanceof NotUpToBoundException) {
                stringBuilder.append(" Failed to get value from materialized table, reason: NOT_UP_TO_BOUND");
                continue;
            }
            stringBuilder.append(s.getMessage());
        }
        KsqlErrorMessage errorResponse = new KsqlErrorMessage(Errors.ERROR_CODE_SERVER_ERROR, stringBuilder.toString());
        log.error("Error in processing query {}", (Object)stringBuilder, (Object)t);
        this.queryStreamResponseWriter.writeError(errorResponse).end();
    }

    public void handleComplete() {
        if (this.hitLimit.get().booleanValue()) {
            this.queryStreamResponseWriter.writeLimitMessage();
        } else {
            this.queryStreamResponseWriter.writeCompletionMessage();
        }
        this.queryStreamResponseWriter.end();
    }
}

