/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.server.state.ServerState;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Optional;

public class ServerStateHandler
implements Handler<RoutingContext> {
    private final ServerState serverState;

    ServerStateHandler(ServerState serverState) {
        this.serverState = Objects.requireNonNull(serverState, "serverState");
    }

    public void handle(RoutingContext routingContext) {
        Optional<EndpointResponse> response = this.serverState.checkReady();
        if (response.isPresent()) {
            KsqlErrorMessage errorMsg = (KsqlErrorMessage)response.get().getEntity();
            routingContext.fail(HttpResponseStatus.SERVICE_UNAVAILABLE.code(), (Throwable)((Object)new KsqlApiException(errorMsg.getMessage(), errorMsg.getErrorCode())));
        } else {
            routingContext.next();
        }
    }
}

