/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.util;

import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.util.FileWatcher;
import io.confluent.ksql.util.QueryMask;
import io.confluent.ksql.util.VertxSslOptionsFactory;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ApiServerUtils.class);

    private ApiServerUtils() {
    }

    public static void setMaskedSqlIfNeeded(KsqlRequest request) {
        try {
            request.getMaskedKsql();
        }
        catch (Exception e) {
            ApiServerUtils.setMaskedSql(request);
        }
    }

    public static void setMaskedSql(KsqlRequest request) {
        request.setMaskedKsql(QueryMask.getMaskedStatement((String)request.getUnmaskedKsql()));
    }

    public static void unhandledExceptionHandler(Throwable t) {
        if (t instanceof ClosedChannelException) {
            LOG.debug("Unhandled ClosedChannelException (connection likely closed early)", t);
        } else if (t instanceof HAProxyProtocolException) {
            LOG.error("Failed to decode proxy protocol header", t);
        } else {
            LOG.error("Unhandled exception", t);
        }
    }

    public static void chcHandler(RoutingContext routingContext) {
        routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").end(new JsonObject().toBuffer());
    }

    public static FileWatcher configureTlsCertReload(KsqlRestConfig config, FileWatcher.Callback onChange) {
        if (config.getBoolean("ssl.keystore.reload").booleanValue()) {
            Path watchLocation = !config.getString("ssl.keystore.watch.location").isEmpty() ? Paths.get(config.getString("ssl.keystore.watch.location"), new String[0]) : Paths.get(config.getString("ssl.keystore.location"), new String[0]);
            FileWatcher fileWatcher = null;
            try {
                fileWatcher = new FileWatcher(watchLocation, onChange);
                fileWatcher.start();
                LOG.info("Enabled SSL cert auto reload for: " + watchLocation);
            }
            catch (IOException e) {
                LOG.error("Failed to enable SSL cert auto reload", (Throwable)e);
            }
            return fileWatcher;
        }
        return null;
    }

    public static List<URI> parseListenerStrings(KsqlRestConfig config, List<String> stringListeners) {
        ArrayList<URI> listeners = new ArrayList<URI>();
        for (String listenerName : stringListeners) {
            try {
                String keyStoreLocation;
                URI uri = new URI(listenerName);
                String scheme = uri.getScheme();
                if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                    throw new ConfigException("Invalid URI scheme should be http or https: " + listenerName);
                }
                if ("https".equalsIgnoreCase(scheme) && ((keyStoreLocation = config.getString("ssl.keystore.location")) == null || keyStoreLocation.isEmpty())) {
                    throw new ConfigException("https listener specified but no keystore provided");
                }
                listeners.add(uri);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Invalid listener URI: " + listenerName);
            }
        }
        return listeners;
    }

    public static List<URI> parseListeners(KsqlRestConfig config) {
        List sListeners = config.getList("listeners");
        return ApiServerUtils.parseListenerStrings(config, sListeners);
    }

    public static List<URI> parseProxyProtocolListeners(KsqlRestConfig config) {
        List sListeners = config.getList("listeners.proxy.protocol");
        HashSet<URI> listenUriSet = new HashSet<URI>(ApiServerUtils.parseListeners(config));
        List<URI> proxyProtocolListenUris = ApiServerUtils.parseListenerStrings(config, sListeners);
        for (URI u : proxyProtocolListenUris) {
            if (listenUriSet.contains(u)) continue;
            throw new ConfigException(String.format("Listener %s is listed in %s but not in %s.", u, "listeners.proxy.protocol", "listeners"));
        }
        return proxyProtocolListenUris;
    }

    public static void setTlsOptions(KsqlRestConfig ksqlRestConfig, HttpServerOptions options, String keyStoreAlias, ClientAuth clientAuth) {
        List cipherSuites;
        options.setUseAlpn(true).setSsl(true);
        if (ksqlRestConfig.getBoolean("ksql.server.sni.check.enable").booleanValue()) {
            options.setSni(true);
        }
        ApiServerUtils.configureTlsKeyStore(ksqlRestConfig, options, keyStoreAlias);
        ApiServerUtils.configureTlsTrustStore(ksqlRestConfig, options);
        List enabledProtocols = ksqlRestConfig.getList("ssl.enabled.protocols");
        if (!enabledProtocols.isEmpty()) {
            options.setEnabledSecureTransportProtocols(new HashSet(enabledProtocols));
        }
        if (!(cipherSuites = ksqlRestConfig.getList("ssl.cipher.suites")).isEmpty()) {
            Set enabledCipherSuites = options.getEnabledCipherSuites();
            enabledCipherSuites.clear();
            enabledCipherSuites.addAll(cipherSuites);
        }
        options.setClientAuth(clientAuth);
    }

    private static void configureTlsKeyStore(KsqlRestConfig ksqlRestConfig, HttpServerOptions httpServerOptions, String keyStoreAlias) {
        Map props = PropertiesUtil.toMapStrings((Map)ksqlRestConfig.originals());
        String keyStoreType = ksqlRestConfig.getString("ssl.keystore.type");
        if (keyStoreType.equals("JKS")) {
            Optional keyStoreOptions = VertxSslOptionsFactory.buildJksKeyStoreOptions((Map)props, Optional.ofNullable(keyStoreAlias));
            keyStoreOptions.ifPresent(options -> httpServerOptions.setKeyStoreOptions(options));
        } else if (keyStoreType.equals("PKCS12")) {
            Optional keyStoreOptions = VertxSslOptionsFactory.getPfxKeyStoreOptions((Map)props);
            keyStoreOptions.ifPresent(options -> httpServerOptions.setPfxKeyCertOptions(options));
        } else if (keyStoreType.equals("BCFKS")) {
            Optional keyStoreOptions = VertxSslOptionsFactory.getBcfksKeyStoreOptions((Map)props);
            keyStoreOptions.ifPresent(options -> httpServerOptions.setKeyCertOptions((KeyCertOptions)options));
        }
    }

    private static void configureTlsTrustStore(KsqlRestConfig ksqlRestConfig, HttpServerOptions httpServerOptions) {
        Map props = PropertiesUtil.toMapStrings((Map)ksqlRestConfig.originals());
        String trustStoreType = ksqlRestConfig.getString("ssl.truststore.type");
        if (trustStoreType.equals("JKS")) {
            Optional trustStoreOptions = VertxSslOptionsFactory.getJksTrustStoreOptions((Map)props);
            trustStoreOptions.ifPresent(options -> httpServerOptions.setTrustOptions((TrustOptions)options));
        } else if (trustStoreType.equals("PKCS12")) {
            Optional trustStoreOptions = VertxSslOptionsFactory.getPfxTrustStoreOptions((Map)props);
            trustStoreOptions.ifPresent(options -> httpServerOptions.setTrustOptions((TrustOptions)options));
        } else if (trustStoreType.equals("BCFKS")) {
            Optional trustStoreOptions = VertxSslOptionsFactory.getBcfksTrustStoreOptions((Map)props);
            trustStoreOptions.ifPresent(options -> httpServerOptions.setTrustOptions((TrustOptions)options));
        }
    }
}

