/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.collect.Lists;
import io.confluent.ksql.rest.server.CommandTopicBackup;
import io.confluent.ksql.rest.server.computation.QueuedCommand;
import io.confluent.ksql.rest.server.resources.CommandTopicCorruptionException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTopic {
    private static final Logger log = LoggerFactory.getLogger(CommandTopic.class);
    private final TopicPartition commandTopicPartition;
    private Consumer<byte[], byte[]> commandConsumer;
    private final String commandTopicName;
    private CommandTopicBackup commandTopicBackup;

    public CommandTopic(String commandTopicName, Map<String, Object> kafkaConsumerProperties, CommandTopicBackup commandTopicBackup) {
        this(commandTopicName, (Consumer<byte[], byte[]>)new KafkaConsumer(Objects.requireNonNull(kafkaConsumerProperties, "kafkaClientProperties"), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()), commandTopicBackup);
    }

    CommandTopic(String commandTopicName, Consumer<byte[], byte[]> commandConsumer, CommandTopicBackup commandTopicBackup) {
        this.commandTopicPartition = new TopicPartition(commandTopicName, 0);
        this.commandConsumer = Objects.requireNonNull(commandConsumer, "commandConsumer");
        this.commandTopicName = Objects.requireNonNull(commandTopicName, "commandTopicName");
        this.commandTopicBackup = Objects.requireNonNull(commandTopicBackup, "commandTopicBackup");
    }

    public String getCommandTopicName() {
        return this.commandTopicName;
    }

    public void start() {
        this.commandTopicBackup.initialize();
        this.commandConsumer.assign(Collections.singleton(this.commandTopicPartition));
    }

    public Iterable<ConsumerRecord<byte[], byte[]>> getNewCommands(Duration timeout) {
        ConsumerRecords iterable = this.commandConsumer.poll(timeout);
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        if (iterable != null) {
            for (ConsumerRecord record : iterable) {
                try {
                    CommandTopic.backupRecord(Optional.of(this.commandTopicBackup), (ConsumerRecord<byte[], byte[]>)record);
                }
                catch (CommandTopicCorruptionException e) {
                    log.warn("Backup is out of sync with the current command topic. Backups will not work until the previous command topic is restored or all backup files are deleted.", (Throwable)((Object)e));
                    return records;
                }
                records.add((ConsumerRecord<byte[], byte[]>)record);
            }
        }
        return records;
    }

    public List<QueuedCommand> getRestoreCommands(Duration duration) {
        if (this.commandTopicBackup.commandTopicCorruption()) {
            log.warn("Corruption detected. Use backup to restore command topic.");
            return Collections.emptyList();
        }
        return CommandTopic.getAllCommandsInCommandTopic(this.commandConsumer, this.commandTopicPartition, Optional.of(this.commandTopicBackup), duration);
    }

    public static List<QueuedCommand> getAllCommandsInCommandTopic(Consumer<byte[], byte[]> commandConsumer, TopicPartition topicPartition, Optional<CommandTopicBackup> backup, Duration duration) {
        ArrayList commands = Lists.newArrayList();
        long endOffset = CommandTopic.getEndOffsetFromTopicPartition(commandConsumer, topicPartition);
        commandConsumer.seekToBeginning(Collections.singletonList(topicPartition));
        log.info("Reading prior command records up to offset {}", (Object)endOffset);
        while (commandConsumer.position(topicPartition) < endOffset) {
            ConsumerRecords records = commandConsumer.poll(duration);
            log.info("Received {} records from command topic restore poll", (Object)records.count());
            for (ConsumerRecord record : records) {
                try {
                    CommandTopic.backupRecord(backup, (ConsumerRecord<byte[], byte[]>)record);
                }
                catch (CommandTopicCorruptionException e) {
                    log.warn("Backup is out of sync with the current command topic. Backups will not work until the previous command topic is restored or all backup files are deleted.", (Throwable)((Object)e));
                    return commands;
                }
                if (record.value() == null) continue;
                commands.add(new QueuedCommand((byte[])record.key(), (byte[])record.value(), Optional.empty(), (Long)record.offset()));
            }
        }
        return commands;
    }

    public long getCommandTopicConsumerPosition() {
        return this.commandConsumer.position(this.commandTopicPartition);
    }

    public long getEndOffset() {
        return CommandTopic.getEndOffsetFromTopicPartition(this.commandConsumer, this.commandTopicPartition);
    }

    private static long getEndOffsetFromTopicPartition(Consumer<byte[], byte[]> commandConsumer, TopicPartition commandTopicPartition) {
        return (Long)commandConsumer.endOffsets(Collections.singletonList(commandTopicPartition)).get(commandTopicPartition);
    }

    public void wakeup() {
        this.commandConsumer.wakeup();
    }

    public void close() {
        this.commandConsumer.close();
        this.commandTopicBackup.close();
    }

    private static void backupRecord(Optional<CommandTopicBackup> backup, ConsumerRecord<byte[], byte[]> record) {
        backup.ifPresent(topicBackup -> topicBackup.writeRecord(record));
    }
}

