/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.rest.server.Executable;
import java.io.IOException;
import java.net.BindException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.cli.ConnectDistributed;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Connect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectExecutable
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectExecutable.class);
    private final ConnectDistributed connectDistributed;
    private final Map<String, String> workerProps;
    private Connect connect;
    private final CountDownLatch terminateLatch = new CountDownLatch(1);

    public static ConnectExecutable of(String configFile) throws IOException {
        Map workerProps = !configFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)configFile)) : Collections.emptyMap();
        return new ConnectExecutable(workerProps);
    }

    @VisibleForTesting
    ConnectExecutable(Map<String, String> workerProps) {
        this.workerProps = Objects.requireNonNull(workerProps, "workerProps");
        this.connectDistributed = new ConnectDistributed(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAsync() {
        block6: {
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            try {
                this.connect = this.connectDistributed.startConnect(this.workerProps, new String[0]);
            }
            catch (ConnectException e) {
                if (e.getCause() instanceof IOException && e.getCause().getCause() instanceof BindException) {
                    LOG.warn("Cannot start a local connect instance because connect is running locally!", (Throwable)e);
                    break block6;
                }
                throw e;
            }
            finally {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.connect != null) {
            this.connect.stop();
        }
    }

    @Override
    public void notifyTerminated() {
        this.terminateLatch.countDown();
    }

    @Override
    public void awaitTerminated() throws InterruptedException {
        this.terminateLatch.await();
    }
}

