/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlRestApplicationMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(KsqlRestApplicationMetrics.class);
    private static final String GROUP = "ksql-rest-application";
    private final Metrics metrics;

    KsqlRestApplicationMetrics(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
    }

    void recordServerStartLatency(Duration latency) {
        MetricName metricName = this.metrics.metricName("startup-time-ms", GROUP);
        if (this.metrics.metric(metricName) != null) {
            LOGGER.error("ksql server startup latency already registered");
            return;
        }
        LOGGER.info("ksql server took {} to become ready", (Object)latency.toString());
        this.metrics.addMetric(metricName, (c, t) -> latency.toMillis());
    }
}

