/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.rest.server.LocalCommand;
import io.confluent.ksql.rest.server.LocalCommandsFile;
import io.confluent.ksql.rest.server.TransientQueryLocalCommand;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.TransientQueryMetadata;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCommands
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCommands.class);
    static final String LOCAL_COMMANDS_FILE_SUFFIX = ".cmds";
    static final String LOCAL_COMMANDS_PROCESSED_SUFFIX = ".processed";
    private static final Random RANDOM = new Random();
    private final File directory;
    private final KsqlEngine ksqlEngine;
    private final LocalCommandsFile currentLocalCommands;

    LocalCommands(File directory, KsqlEngine ksqlEngine, LocalCommandsFile currentLocalCommands) {
        this.directory = directory;
        this.ksqlEngine = ksqlEngine;
        this.currentLocalCommands = currentLocalCommands;
    }

    public File getCurrentLocalCommandsFile() {
        return this.currentLocalCommands.getFile();
    }

    public void processLocalCommandFiles(ServiceContext serviceContext) {
        FilenameFilter filter = (dir, fileName) -> fileName.endsWith(LOCAL_COMMANDS_FILE_SUFFIX);
        File[] files = this.directory.listFiles(filter);
        if (files == null) {
            throw new KsqlServerException("Bad local commands directory " + this.directory.getAbsolutePath() + ". Please check your configuration for " + "ksql.local.commands.location");
        }
        for (File file : files) {
            if (file.equals(this.currentLocalCommands.getFile())) continue;
            try (LocalCommandsFile localCommandsFile = LocalCommandsFile.createReadonly(file);){
                List<LocalCommand> localCommands = localCommandsFile.readRecords();
                this.cleanUpTransientQueryState(localCommands, serviceContext);
                this.markFileAsProcessed(file);
            }
            catch (Exception e) {
                LOG.error("Error processing local commands " + file.getAbsolutePath() + ". There may be orphaned transient topics or abandoned state stores.", (Throwable)e);
            }
        }
    }

    public void write(TransientQueryMetadata queryMetadata) {
        try {
            this.currentLocalCommands.write(new TransientQueryLocalCommand(queryMetadata.getQueryApplicationId()));
        }
        catch (IOException e) {
            LOG.error("Failed to write local command for transient query:" + queryMetadata.getQueryApplicationId(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public static LocalCommands open(KsqlEngine ksqlEngine, File directory) {
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                throw new KsqlServerException("Couldn't create the local commands directory: " + directory.getPath() + "\n Make sure the directory exists and is readable/writable for KSQL server \n or its parent directory is readable/writable by KSQL server\n or change it to a readable/writable directory by setting '" + "ksql.local.commands.location" + "' config in the properties file.");
            }
            try {
                Files.setPosixFilePermissions(directory.toPath(), PosixFilePermissions.fromString("rwx------"));
            }
            catch (IOException e) {
                throw new KsqlServerException(String.format("Couldn't set POSIX permissions on the backups directory: %s. Error = %s", directory.getPath(), e.getMessage()));
            }
        }
        if (!directory.isDirectory()) {
            throw new KsqlServerException(directory.getPath() + " is not a directory.\n Make sure the directory exists and is readable/writable for KSQL server \n or its parent directory is readable/writable by KSQL server\n or change it to a readable/writable directory by setting '" + "ksql.local.commands.location" + "' config in the properties file.");
        }
        if (!(directory.canWrite() && directory.canRead() && directory.canExecute())) {
            throw new KsqlServerException("The local commands directory is not readable/writable for KSQL server: " + directory.getPath() + "\n Make sure the directory exists and is readable/writable for KSQL server \n or change it to a readable/writable directory by setting '" + "ksql.local.commands.location" + "' config in the properties file.");
        }
        File file = new File(directory, String.format("local_commands_%d_%s%s", System.currentTimeMillis(), Integer.toHexString(RANDOM.nextInt()), LOCAL_COMMANDS_FILE_SUFFIX));
        return new LocalCommands(directory, ksqlEngine, LocalCommandsFile.createWriteable(file));
    }

    private void markFileAsProcessed(File file) {
        File updatedName = new File(file.getParentFile(), file.getName() + LOCAL_COMMANDS_PROCESSED_SUFFIX);
        if (!file.renameTo(updatedName)) {
            throw new KsqlException("Couldn't rename file " + file.getAbsolutePath());
        }
    }

    private void cleanUpTransientQueryState(List<LocalCommand> localCommands, ServiceContext serviceContext) {
        Set queryApplicationIds = localCommands.stream().filter(c -> c.getType().equals("transient_query")).map(TransientQueryLocalCommand.class::cast).map(TransientQueryLocalCommand::getQueryApplicationId).collect(Collectors.toSet());
        if (queryApplicationIds.size() > 0) {
            this.ksqlEngine.cleanupOrphanedInternalTopics(serviceContext, queryApplicationIds);
            this.ksqlEngine.populateTransientQueryCleanupServiceWithOldCommands(queryApplicationIds);
        }
    }

    @Override
    public void close() throws IOException {
        this.currentLocalCommands.close();
    }
}

