/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.server.Executable;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.KsqlServerPrecondition;
import io.confluent.ksql.rest.server.PreconditionServer;
import io.confluent.ksql.rest.server.services.InternalKsqlClientFactory;
import io.confluent.ksql.rest.server.services.RestServiceContextFactory;
import io.confluent.ksql.rest.server.state.ServerState;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.services.ConnectClientFactory;
import io.confluent.ksql.services.DefaultConnectClientFactory;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.KafkaTopicClientImpl;
import io.confluent.ksql.services.LazyServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.RetryUtil;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.net.SocketAddress;
import java.io.Closeable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreconditionChecker
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(PreconditionChecker.class);
    final KsqlRestConfig restConfig;
    final Supplier<Map<String, String>> propertiesLoader;
    final Supplier<Clients> clientsSupplier;
    final Vertx vertx;
    final List<KsqlServerPrecondition> preconditions;
    final PreconditionServer server;
    final ServerState serverState;
    private final CompletableFuture<Void> terminatedFuture = new CompletableFuture();

    public PreconditionChecker(Supplier<Map<String, String>> propertiesLoader, ServerState serverState) {
        this.propertiesLoader = Objects.requireNonNull(propertiesLoader, "propertiesLoader");
        Map<String, String> properties = propertiesLoader.get();
        this.restConfig = new KsqlRestConfig(properties);
        this.serverState = Objects.requireNonNull(serverState, "serverState");
        this.clientsSupplier = () -> PreconditionChecker.buildClients(this.propertiesLoader);
        this.preconditions = this.restConfig.getConfiguredInstances("ksql.server.preconditions", KsqlServerPrecondition.class);
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS).setMaxWorkerExecuteTime(Long.MAX_VALUE));
        this.server = new PreconditionServer(this.vertx, this.restConfig, serverState);
    }

    @VisibleForTesting
    PreconditionChecker(Supplier<Map<String, String>> propertiesLoader, KsqlRestConfig restConfig, Supplier<Clients> clientsSupplier, Vertx vertx, List<KsqlServerPrecondition> preconditions, PreconditionServer server, ServerState state) {
        this.propertiesLoader = Objects.requireNonNull(propertiesLoader, "propertiesLoader");
        this.clientsSupplier = Objects.requireNonNull(clientsSupplier, "clientsSupplier");
        this.restConfig = Objects.requireNonNull(restConfig, "restConfig");
        this.vertx = Objects.requireNonNull(vertx, "vertx");
        this.preconditions = Objects.requireNonNull(preconditions, "preconditions");
        this.server = Objects.requireNonNull(server, "server");
        this.serverState = Objects.requireNonNull(state, "state");
    }

    private boolean shouldCheckPreconditions() {
        try (Clients clients = this.clientsSupplier.get();){
            boolean bl = this.preconditions.stream().map(p -> p.checkPrecondition(this.propertiesLoader.get(), clients.serviceContext, clients.topicClient)).peek(r -> r.ifPresent(rr -> LOG.info("Precondition failed: {}", rr))).anyMatch(Optional::isPresent);
            return bl;
        }
    }

    @Override
    public void startAsync() {
        if (!this.shouldCheckPreconditions()) {
            LOG.info("All preconditions passed, skipping precondition server start");
            return;
        }
        LOG.info("Some preconditions not passed, starting precondition server");
        this.server.start();
    }

    @Override
    public void notifyTerminated() {
        this.terminatedFuture.complete(null);
    }

    @Override
    public void shutdown() {
        if (this.server.started()) {
            this.server.stop();
        }
        this.vertx.close();
    }

    @Override
    public void awaitTerminated() {
        ImmutableList predicates = ImmutableList.of(e -> !(e instanceof KsqlFailedPrecondition));
        RetryUtil.retryWithBackoff((int)Integer.MAX_VALUE, (int)1000, (int)Math.toIntExact(this.restConfig.getLong("ksql.server.precondition.max.backoff.ms")), this::checkPreconditions, this.terminatedFuture::isDone, (List)predicates);
    }

    public List<URI> getListeners() {
        return this.server.getListeners();
    }

    private void checkPreconditions() {
        LOG.info("Checking preconditions...");
        for (KsqlServerPrecondition precondition : this.preconditions) {
            Optional<KsqlErrorMessage> error;
            try (Clients clients = this.clientsSupplier.get();){
                error = precondition.checkPrecondition(this.propertiesLoader.get(), clients.serviceContext, clients.topicClient);
            }
            if (!error.isPresent()) continue;
            LOG.info("Precondition failed: {}", (Object)error.get());
            this.serverState.setInitializingReason(error.get());
            throw new KsqlFailedPrecondition(error.get().toString());
        }
    }

    private static Admin createCommandTopicAdminClient(KsqlRestConfig ksqlRestConfig, KsqlConfig ksqlConfig) {
        HashMap<String, Object> adminClientConfigs = new HashMap<String, Object>(ksqlConfig.getKsqlAdminClientConfigProps());
        adminClientConfigs.putAll(ksqlRestConfig.getCommandProducerProperties());
        return new DefaultKafkaClientSupplier().getAdmin(adminClientConfigs);
    }

    private static Clients buildClients(Supplier<Map<String, String>> propertiesLoader) {
        Map<String, String> properties = propertiesLoader.get();
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS).setMaxWorkerExecuteTime(Long.MAX_VALUE));
        KsqlConfig ksqlConfig = new KsqlConfig(properties);
        KsqlClient sharedClient = InternalKsqlClientFactory.createInternalClient(ksqlConfig.originalsStrings(), SocketAddress::inetSocketAddress, vertx);
        Supplier<SchemaRegistryClient> schemaRegistryClientFactory = () -> ((KsqlSchemaRegistryClientFactory)new KsqlSchemaRegistryClientFactory(ksqlConfig, Collections.emptyMap())).get();
        DefaultConnectClientFactory connectClientFactory = new DefaultConnectClientFactory(ksqlConfig);
        LazyServiceContext serviceContext = new LazyServiceContext(() -> PreconditionChecker.lambda$buildClients$5(ksqlConfig, schemaRegistryClientFactory, (ConnectClientFactory)connectClientFactory, sharedClient));
        Admin admin = PreconditionChecker.createCommandTopicAdminClient(new KsqlRestConfig(properties), new KsqlConfig(properties));
        return new Clients((ServiceContext)serviceContext, vertx, admin, (KafkaTopicClient)new KafkaTopicClientImpl(() -> admin));
    }

    private static /* synthetic */ ServiceContext lambda$buildClients$5(KsqlConfig ksqlConfig, Supplier schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient) {
        return RestServiceContextFactory.create(ksqlConfig, Optional.empty(), schemaRegistryClientFactory, connectClientFactory, sharedClient, Collections.emptyList(), Optional.empty());
    }

    static final class Clients
    implements Closeable {
        private final ServiceContext serviceContext;
        private final Vertx vertx;
        private final Admin admin;
        private final KafkaTopicClient topicClient;

        Clients(ServiceContext serviceContext, Vertx vertx, Admin admin, KafkaTopicClient topicClient) {
            this.serviceContext = serviceContext;
            this.vertx = vertx;
            this.admin = admin;
            this.topicClient = topicClient;
        }

        @Override
        public void close() {
            this.serviceContext.close();
            this.vertx.close();
            this.admin.close();
        }
    }

    @VisibleForTesting
    static class KsqlFailedPrecondition
    extends RuntimeException {
        KsqlFailedPrecondition(String error) {
            super(error);
        }
    }
}

