/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import java.io.Closeable;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;

public class CommandRunnerMetrics
implements Closeable {
    private static final String DEFAULT_METRIC_GROUP_PREFIX = "ksql-rest-app";
    private static final String METRIC_GROUP_POST_FIX = "-command-runner";
    private final Metrics metrics;
    private final MetricName commandRunnerStatusMetricNameLegacy;
    private final MetricName commandRunnerDegradedReasonMetricNameLegacy;
    private final MetricName commandRunnerStatusMetricName;
    private final MetricName commandRunnerDegradedReasonMetricName;
    private final MetricName commandRunnerStatusNumMetricName;
    private final MetricName commandRunnerDegradedReasonNumMetricName;

    CommandRunnerMetrics(String ksqlServiceId, CommandRunner commandRunner, String metricGroupPrefix, Metrics metrics) {
        this(metrics, commandRunner, ksqlServiceId, metricGroupPrefix.isEmpty() ? DEFAULT_METRIC_GROUP_PREFIX : metricGroupPrefix);
    }

    @VisibleForTesting
    CommandRunnerMetrics(Metrics metrics, CommandRunner commandRunner, String ksqlServiceId, String metricsGroupPrefix) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        String metricGroupName = metricsGroupPrefix + METRIC_GROUP_POST_FIX;
        this.commandRunnerStatusMetricNameLegacy = metrics.metricName("status", "_confluent-ksql-" + ksqlServiceId + metricGroupName, "The status of the commandRunner thread as it processes the command topic.", Collections.emptyMap());
        this.commandRunnerDegradedReasonMetricNameLegacy = metrics.metricName("degraded-reason", "_confluent-ksql-" + ksqlServiceId + metricGroupName, "The reason for why the commandRunner thread is in a DEGRADED state.", Collections.emptyMap());
        this.commandRunnerStatusMetricName = metrics.metricName("status", "_confluent-" + metricGroupName, "The status of the commandRunner thread as it processes the command topic.", Collections.singletonMap("ksql_service_id", ksqlServiceId));
        this.commandRunnerDegradedReasonMetricName = metrics.metricName("degraded-reason", "_confluent-" + metricGroupName, "The reason for why the commandRunner thread is in a DEGRADED state.", Collections.singletonMap("ksql_service_id", ksqlServiceId));
        this.commandRunnerStatusNumMetricName = metrics.metricName("status-num", "_confluent-" + metricGroupName, "The status number of the commandRunner thread as it processes the command topic.", Collections.singletonMap("ksql_service_id", ksqlServiceId));
        this.commandRunnerDegradedReasonNumMetricName = metrics.metricName("degraded-reason-num", "_confluent-" + metricGroupName, "The reason number for why the commandRunner thread is in a DEGRADED state.", Collections.singletonMap("ksql_service_id", ksqlServiceId));
        this.metrics.addMetric(this.commandRunnerStatusMetricNameLegacy, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.checkCommandRunnerStatus().name()));
        this.metrics.addMetric(this.commandRunnerDegradedReasonMetricNameLegacy, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.getCommandRunnerDegradedReason().name()));
        this.metrics.addMetric(this.commandRunnerStatusMetricName, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.checkCommandRunnerStatus().name()));
        this.metrics.addMetric(this.commandRunnerDegradedReasonMetricName, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.getCommandRunnerDegradedReason().name()));
        this.metrics.addMetric(this.commandRunnerStatusNumMetricName, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.checkCommandRunnerStatus().ordinal()));
        this.metrics.addMetric(this.commandRunnerDegradedReasonNumMetricName, (MetricValueProvider)((Gauge)(config, now) -> commandRunner.getCommandRunnerDegradedReason().ordinal()));
    }

    @Override
    public void close() {
        this.metrics.removeMetric(this.commandRunnerStatusNumMetricName);
        this.metrics.removeMetric(this.commandRunnerDegradedReasonNumMetricName);
        this.metrics.removeMetric(this.commandRunnerStatusMetricName);
        this.metrics.removeMetric(this.commandRunnerDegradedReasonMetricName);
        this.metrics.removeMetric(this.commandRunnerStatusMetricNameLegacy);
        this.metrics.removeMetric(this.commandRunnerDegradedReasonMetricNameLegacy);
    }
}

