/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

class SequenceNumberFutureStore {
    private final ConcurrentHashMap<Long, CompletableFuture<Void>> sequenceNumberFutures = new ConcurrentHashMap();
    private long lastCompletedSequenceNumber = -1L;

    SequenceNumberFutureStore() {
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    synchronized CompletableFuture<Void> getFutureForSequenceNumber(long seqNum) {
        if (seqNum <= this.lastCompletedSequenceNumber) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sequenceNumberFutures.computeIfAbsent(seqNum, k -> new CompletableFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeFuturesUpToAndIncludingSequenceNumber(long seqNum) {
        SequenceNumberFutureStore sequenceNumberFutureStore = this;
        synchronized (sequenceNumberFutureStore) {
            this.lastCompletedSequenceNumber = seqNum;
        }
        this.sequenceNumberFutures.keySet().stream().filter(k -> k <= seqNum).forEach(k -> {
            this.sequenceNumberFutures.get(k).complete(null);
            this.sequenceNumberFutures.remove(k);
        });
    }
}

