/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.parser.tree.AssertResource;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.RetryUtil;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public final class AssertExecutor {
    private static final int RETRY_MS = 100;

    private AssertExecutor() {
    }

    static StatementExecutorResponse execute(String statementText, AssertResource statement, int defaultTimeout, ServiceContext serviceContext, BiConsumer<AssertResource, ServiceContext> assertResource, BiFunction<String, AssertResource, KsqlEntity> createSuccessfulEntity) {
        int timeout = statement.getTimeout().isPresent() ? (int)((WindowTimeClause)statement.getTimeout().get()).toDuration().toMillis() : defaultTimeout;
        try {
            RetryUtil.retryWithBackoff((int)(timeout / 100), (int)100, (int)100, () -> assertResource.accept(statement, serviceContext), (Class[])new Class[0]);
        }
        catch (KsqlException e) {
            throw new KsqlRestException(Errors.assertionFailedError((String)e.getMessage()));
        }
        return StatementExecutorResponse.handled(Optional.of(createSuccessfulEntity.apply(statementText, statement)));
    }
}

