/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.AssertResource;
import io.confluent.ksql.parser.tree.AssertSchema;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.AssertSchemaEntity;
import io.confluent.ksql.rest.server.execution.AssertExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlException;
import java.util.Optional;

public final class AssertSchemaExecutor {
    private static final int HTTP_NOT_FOUND = 404;
    private static final int SCHEMA_NOT_FOUND_ERROR_CODE = 40403;
    private static final int SUBJECT_NOT_FOUND_ERROR_CODE = 40401;

    private AssertSchemaExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<AssertSchema> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        return AssertExecutor.execute(statement.getMaskedStatementText(), (AssertResource)statement.getStatement(), executionContext.getKsqlConfig().getInt("ksql.assert.schema.default.timeout.ms"), serviceContext, (stmt, sc) -> AssertSchemaExecutor.assertSchema(sc.getSchemaRegistryClient(), ((AssertSchema)stmt).getSubject(), ((AssertSchema)stmt).getId(), stmt.checkExists()), (str, stmt) -> new AssertSchemaEntity(str, ((AssertSchema)stmt).getSubject(), ((AssertSchema)stmt).getId(), stmt.checkExists()));
    }

    private static void assertSchema(SchemaRegistryClient client, Optional<String> subject, Optional<Integer> id, boolean assertExists) {
        String idString;
        boolean schemaExists = AssertSchemaExecutor.checkSchemaExistence(client, subject, id);
        String subjectString = subject.isPresent() ? " subject name " + subject.get() : "";
        String string = idString = id.isPresent() ? " id " + id.get() : "";
        if (!assertExists) {
            if (schemaExists) {
                throw new KsqlException("Schema with" + subjectString + idString + " exists");
            }
        } else if (!schemaExists) {
            throw new KsqlException("Schema with" + subjectString + idString + " does not exist");
        }
    }

    private static boolean checkSchemaExistence(SchemaRegistryClient client, Optional<String> subject, Optional<Integer> id) {
        try {
            if (subject.isPresent() && id.isPresent()) {
                return client.getAllSubjectsById(id.get().intValue()).contains(subject.get());
            }
            if (id.isPresent()) {
                client.getSchemaById(id.get().intValue());
            } else if (subject.isPresent()) {
                client.getLatestSchemaMetadata(subject.get());
            }
            return true;
        }
        catch (Exception e) {
            if (AssertSchemaExecutor.isSchemaNotFoundException(e)) {
                return false;
            }
            throw new KsqlException("Cannot check schema existence: " + e.getMessage());
        }
    }

    private static boolean isSchemaNotFoundException(Exception e) {
        if (e instanceof RestClientException) {
            return ((RestClientException)e).getStatus() == 404 && (((RestClientException)e).getErrorCode() == 40403 || ((RestClientException)e).getErrorCode() == 40401);
        }
        return false;
    }
}

