/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.connect.Connector;
import io.confluent.ksql.connect.supported.Connectors;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.tree.DescribeConnector;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ConnectorDescription;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import io.confluent.ksql.rest.entity.ConnectorStateInfo;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.QueryOffsetSummary;
import io.confluent.ksql.rest.entity.RunningQuery;
import io.confluent.ksql.rest.entity.SourceDescriptionFactory;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DescribeConnectorExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DescribeConnectorExecutor.class);
    @VisibleForTesting
    static final String TOPICS_KEY = "topics";
    private final Function<ConnectorInfo, Optional<Connector>> connectorFactory;

    public DescribeConnectorExecutor() {
        this(Connectors::from);
    }

    @VisibleForTesting
    DescribeConnectorExecutor(Function<ConnectorInfo, Optional<Connector>> connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    public StatementExecutorResponse execute(ConfiguredStatement<DescribeConnector> configuredStatement, SessionProperties sessionProperties, KsqlExecutionContext ksqlExecutionContext, ServiceContext serviceContext) {
        ImmutableList warnings;
        Object topics;
        String connectorName = ((DescribeConnector)configuredStatement.getStatement()).getConnectorName();
        ConnectClient.ConnectResponse statusResponse = serviceContext.getConnectClient().status(connectorName);
        if (statusResponse.error().isPresent()) {
            String errorMsg = "Failed to query connector status: " + (String)statusResponse.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(statusResponse.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)statusResponse.httpCode()), errorMsg)).build());
        }
        ConnectClient.ConnectResponse infoResponse = serviceContext.getConnectClient().describe(connectorName);
        if (infoResponse.error().isPresent()) {
            String errorMsg = "Failed to describe connector: " + (String)infoResponse.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(infoResponse.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)infoResponse.httpCode()), errorMsg)).build());
        }
        ConnectorStateInfo status = (ConnectorStateInfo)statusResponse.datum().get();
        ConnectorInfo info = (ConnectorInfo)infoResponse.datum().get();
        Optional<Connector> connector = this.connectorFactory.apply(info);
        if (connector.isPresent()) {
            ConnectClient.ConnectResponse topicsResponse = serviceContext.getConnectClient().topics(connectorName);
            if (topicsResponse.error().isPresent() && topicsResponse.httpCode() == 404) {
                topics = ImmutableList.of();
                warnings = ImmutableList.of();
                LOG.warn("Could not list related topics due to error: " + (String)topicsResponse.error().get());
            } else if (topicsResponse.error().isPresent()) {
                topics = ImmutableList.of();
                warnings = ImmutableList.of((Object)new KsqlWarning("Could not list related topics due to error: " + (String)topicsResponse.error().get()));
            } else {
                topics = (List)((Map)((Map)topicsResponse.datum().get()).get(connectorName)).getOrDefault(TOPICS_KEY, ImmutableList.of());
                warnings = ImmutableList.of();
            }
        } else {
            topics = ImmutableList.of();
            warnings = ImmutableList.of();
        }
        Object sources = connector.isPresent() ? ksqlExecutionContext.getMetaStore().getAllDataSources().values().stream().filter(arg_0 -> DescribeConnectorExecutor.lambda$execute$0((List)topics, arg_0)).map(source -> SourceDescriptionFactory.create(source, false, (List<RunningQuery>)ImmutableList.of(), (List<RunningQuery>)ImmutableList.of(), Optional.empty(), (List<QueryOffsetSummary>)ImmutableList.of(), (List<String>)ImmutableList.of(), ksqlExecutionContext.metricCollectors())).collect(Collectors.toList()) : ImmutableList.of();
        ConnectorDescription description = new ConnectorDescription(configuredStatement.getMaskedStatementText(), (String)info.config().get("connector.class"), status, (List)sources, (List)topics, (List)warnings);
        return StatementExecutorResponse.handled(Optional.of(description));
    }

    private static /* synthetic */ boolean lambda$execute$0(List topics, DataSource source) {
        return topics.contains(source.getKafkaTopicName());
    }
}

