/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.DropConnector;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.DropConnectorEntity;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.WarningEntity;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.Optional;

public final class DropConnectorExecutor {
    private DropConnectorExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<DropConnector> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        String connectorName = ((DropConnector)statement.getStatement()).getConnectorName();
        boolean ifExists = ((DropConnector)statement.getStatement()).getIfExists();
        ConnectClient.ConnectResponse response = serviceContext.getConnectClient().delete(connectorName);
        if (response.error().isPresent()) {
            if (ifExists && response.httpCode() == 404) {
                return StatementExecutorResponse.handled(Optional.of(new WarningEntity(statement.getMaskedStatementText(), "Connector '" + connectorName + "' does not exist.")));
            }
            String errorMsg = "Failed to drop connector: " + (String)response.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(response.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)response.httpCode()), errorMsg)).build());
        }
        return StatementExecutorResponse.handled(Optional.of(new DropConnectorEntity(statement.getMaskedStatementText(), connectorName)));
    }
}

