/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.engine.generic.GenericRecordFactory;
import io.confluent.ksql.engine.generic.KsqlGenericRecord;
import io.confluent.ksql.exception.KsqlSchemaAuthorizationException;
import io.confluent.ksql.exception.KsqlTopicAuthorizationException;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.registry.SchemaAndId;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.KeySerdeFactory;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.protobuf.ProtobufFormat;
import io.confluent.ksql.serde.protobuf.ProtobufProperties;
import io.confluent.ksql.serde.protobuf.ProtobufSchemaTranslator;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.ReservedInternalTopics;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.serialization.Serde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertValuesExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(InsertValuesExecutor.class);
    private static final Duration MAX_SEND_TIMEOUT = Duration.ofSeconds(5L);
    private final LongSupplier clock;
    private final boolean canBeDisabledByConfig;
    private final RecordProducer producer;
    private final ValueSerdeFactory valueSerdeFactory;
    private final KeySerdeFactory keySerdeFactory;

    public InsertValuesExecutor() {
        this(true, InsertValuesExecutor::sendRecord);
    }

    @VisibleForTesting
    public InsertValuesExecutor(boolean canBeDisabledByConfig, RecordProducer producer) {
        this(producer, canBeDisabledByConfig, System::currentTimeMillis, (KeySerdeFactory)new GenericKeySerDe(), (ValueSerdeFactory)new GenericRowSerDe());
    }

    @VisibleForTesting
    InsertValuesExecutor(LongSupplier clock, KeySerdeFactory keySerdeFactory, ValueSerdeFactory valueSerdeFactory) {
        this(InsertValuesExecutor::sendRecord, true, clock, keySerdeFactory, valueSerdeFactory);
    }

    private InsertValuesExecutor(RecordProducer producer, boolean canBeDisabledByConfig, LongSupplier clock, KeySerdeFactory keySerdeFactory, ValueSerdeFactory valueSerdeFactory) {
        this.canBeDisabledByConfig = canBeDisabledByConfig;
        this.producer = Objects.requireNonNull(producer, "producer");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.keySerdeFactory = Objects.requireNonNull(keySerdeFactory, "keySerdeFactory");
        this.valueSerdeFactory = Objects.requireNonNull(valueSerdeFactory, "valueSerdeFactory");
    }

    public void execute(ConfiguredStatement<InsertValues> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        InsertValues insertValues = (InsertValues)statement.getStatement();
        MetaStore metaStore = executionContext.getMetaStore();
        KsqlConfig config = statement.getSessionConfig().getConfig(true);
        DataSource dataSource = InsertValuesExecutor.getDataSource(config, metaStore, insertValues);
        this.validateInsert(insertValues.getColumns(), dataSource);
        ProducerRecord<byte[], byte[]> record = this.buildRecord(statement, metaStore, dataSource, serviceContext);
        try {
            this.producer.sendRecord(record, serviceContext, config.getProducerClientConfigProps());
        }
        catch (TopicAuthorizationException e) {
            KsqlTopicAuthorizationException rootCause = new KsqlTopicAuthorizationException(AclOperation.WRITE, (Collection)e.unauthorizedTopics());
            throw new KsqlException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues), (Throwable)rootCause);
        }
        catch (ClusterAuthorizationException e) {
            throw new KsqlException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues), (Throwable)InsertValuesExecutor.createClusterAuthorizationExceptionRootCause(dataSource));
        }
        catch (KafkaException e) {
            if (e.getCause() != null && e.getCause() instanceof ClusterAuthorizationException) {
                throw new KsqlException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues), (Throwable)InsertValuesExecutor.createClusterAuthorizationExceptionRootCause(dataSource));
            }
            throw new KsqlException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues), (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues), (Throwable)e);
        }
    }

    private void validateInsert(List<ColumnName> columns, DataSource dataSource) {
        List headerColumns = columns.isEmpty() ? dataSource.getSchema().headers().stream().map(column -> column.name().text()).collect(Collectors.toList()) : columns.stream().filter(columnName -> dataSource.getSchema().isHeaderColumn(columnName)).map(Name::text).collect(Collectors.toList());
        if (!headerColumns.isEmpty()) {
            throw new KsqlException("Cannot insert into HEADER columns: " + String.join((CharSequence)", ", headerColumns));
        }
    }

    private static DataSource getDataSource(KsqlConfig ksqlConfig, MetaStore metaStore, InsertValues insertValues) {
        DataSource dataSource = metaStore.getSource(insertValues.getTarget());
        if (dataSource == null) {
            throw new KsqlException("Cannot insert values into an unknown stream/table: " + insertValues.getTarget() + metaStore.checkAlternatives(insertValues.getTarget(), Optional.empty()));
        }
        if (dataSource.getKsqlTopic().getKeyFormat().isWindowed()) {
            throw new KsqlException("Cannot insert values into windowed stream/table!");
        }
        ReservedInternalTopics internalTopics = new ReservedInternalTopics(ksqlConfig);
        if (internalTopics.isReadOnly(dataSource.getKafkaTopicName())) {
            throw new KsqlException("Cannot insert values into read-only topic: " + dataSource.getKafkaTopicName());
        }
        if (dataSource.isSource()) {
            throw new KsqlException(String.format("Cannot insert values into read-only %s: %s", dataSource.getDataSourceType().getKsqlType().toLowerCase(), dataSource.getName().text()));
        }
        return dataSource;
    }

    private ProducerRecord<byte[], byte[]> buildRecord(ConfiguredStatement<InsertValues> statement, MetaStore metaStore, DataSource dataSource, ServiceContext serviceContext) {
        this.throwIfDisabled(statement.getSessionConfig().getConfig(false));
        InsertValues insertValues = (InsertValues)statement.getStatement();
        KsqlConfig config = statement.getSessionConfig().getConfig(true);
        try {
            KsqlGenericRecord row = new GenericRecordFactory(config, (FunctionRegistry)metaStore, this.clock).build(insertValues.getColumns(), insertValues.getValues(), dataSource.getSchema(), dataSource.getDataSourceType());
            byte[] key = this.serializeKey(row.key, dataSource, config, serviceContext);
            byte[] value = this.serializeValue(row.value, dataSource, config, serviceContext);
            String topicName = dataSource.getKafkaTopicName();
            return new ProducerRecord(topicName, null, Long.valueOf(row.ts), (Object)key, (Object)value);
        }
        catch (Exception e) {
            throw new KsqlStatementException(InsertValuesExecutor.createInsertFailedExceptionMessage(insertValues) + " " + e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    private static String createInsertFailedExceptionMessage(InsertValues insertValues) {
        return "Failed to insert values into '" + insertValues.getTarget().text() + "'.";
    }

    private void throwIfDisabled(KsqlConfig config) {
        boolean isEnabled = config.getBoolean("ksql.insert.into.values.enabled");
        if (this.canBeDisabledByConfig && !isEnabled) {
            throw new KsqlException("The server has disabled INSERT INTO ... VALUES functionality. To enable it, restart your ksqlDB server with 'ksql.insert.into.values.enabled'=true");
        }
    }

    private static Exception createClusterAuthorizationExceptionRootCause(DataSource dataSource) {
        return new KsqlTopicAuthorizationException(AclOperation.WRITE, Collections.singletonList(dataSource.getKafkaTopicName()), "The producer is not authorized to do idempotent sends. Check that you have write permissions to the specified topic, and disable idempotent sends by setting 'enable.idempotent=false'  if necessary.");
    }

    private byte[] serializeKey(GenericKey keyValue, DataSource dataSource, KsqlConfig config, ServiceContext serviceContext) {
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)dataSource.getSchema(), (SerdeFeatures)dataSource.getKsqlTopic().getKeyFormat().getFeatures(), (SerdeFeatures)dataSource.getKsqlTopic().getValueFormat().getFeatures());
        Optional<Integer> schemaId = InsertValuesExecutor.ensureKeySchemasMatch(physicalSchema.keySchema(), dataSource, serviceContext);
        FormatInfo formatInfo = InsertValuesExecutor.addSerializerMissingFormatFields(dataSource.getKsqlTopic().getKeyFormat().getFormatInfo(), dataSource.getKafkaTopicName(), true, schemaId);
        Throwable throwable = null;
        try (Serde keySerde = this.keySerdeFactory.create(formatInfo, physicalSchema.keySchema(), config, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());){
            String topicName = dataSource.getKafkaTopicName();
            try {
                byte[] byArray = keySerde.serializer().serialize(topicName, (Object)keyValue);
                return byArray;
            }
            catch (Exception e) {
                try {
                    InsertValuesExecutor.maybeThrowSchemaRegistryAuthError(FormatFactory.fromName((String)dataSource.getKsqlTopic().getKeyFormat().getFormat()), topicName, true, AclOperation.WRITE, e);
                    LOG.error("Could not serialize key.", (Throwable)e);
                    throw new KsqlException("Could not serialize key", (Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static Optional<Integer> ensureKeySchemasMatch(PersistenceSchema keySchema, DataSource dataSource, ServiceContext serviceContext) {
        Optional latest;
        KeyFormat keyFormat = dataSource.getKsqlTopic().getKeyFormat();
        Format format = FormatFactory.fromName((String)keyFormat.getFormat());
        if (!format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
            return Optional.empty();
        }
        Map formatProps = keyFormat.getFormatInfo().getProperties();
        SchemaTranslator translator = format.getSchemaTranslator(formatProps);
        ParsedSchema schema = translator.toParsedSchema(keySchema);
        SchemaRegistryClient schemaRegistryClient = serviceContext.getSchemaRegistryClient();
        try {
            latest = SchemaRegistryUtil.getLatestSchemaAndId((SchemaRegistryClient)schemaRegistryClient, (String)dataSource.getKafkaTopicName(), (boolean)true);
        }
        catch (KsqlException e) {
            InsertValuesExecutor.maybeThrowSchemaRegistryAuthError(format, dataSource.getKafkaTopicName(), true, AclOperation.READ, (Exception)((Object)e));
            throw new KsqlException("Could not determine that insert values operations is safe; operation potentially overrides existing key schema in schema registry.", (Throwable)e);
        }
        if (!latest.isPresent()) {
            String subject = KsqlConstants.getSRSubject((String)dataSource.getKafkaTopicName(), (boolean)true);
            throw new KsqlException(String.format("Failed to fetch key schema (%s). Please check if schema exists in Schema Registry and/or check connection with Schema Registry.", subject));
        }
        ParsedSchema srSchema = ((SchemaAndId)latest.get()).getSchema();
        if (format instanceof ProtobufFormat && formatProps.containsKey("fullSchemaName")) {
            ProtobufSchemaTranslator protoTranslator = new ProtobufSchemaTranslator(new ProtobufProperties(formatProps));
            srSchema = protoTranslator.fromConnectSchema(protoTranslator.toConnectSchema(((SchemaAndId)latest.get()).getSchema()));
        }
        if (InsertValuesExecutor.schemaEquals(translator, keySchema, schema, srSchema)) {
            return Optional.of(((SchemaAndId)latest.get()).getId());
        }
        throw new KsqlException("Cannot INSERT VALUES into data source " + dataSource.getName() + ". ksqlDB generated schema would overwrite existing key schema.\n\tExisting Schema: " + InsertValuesExecutor.getColumns(translator, keySchema, ((SchemaAndId)latest.get()).getSchema(), true).toString() + "\n\tksqlDB Generated: " + keySchema.columns());
    }

    private static List<SimpleColumn> getColumns(SchemaTranslator translator, PersistenceSchema schema, ParsedSchema parsedSchema, boolean isKey) {
        return translator.toColumns(parsedSchema, schema.features(), isKey);
    }

    private static boolean schemaEquals(SchemaTranslator translator, PersistenceSchema keySchema, ParsedSchema ksqlSchema, ParsedSchema srSchema) {
        List<SimpleColumn> columns = InsertValuesExecutor.getColumns(translator, keySchema, ksqlSchema, true);
        List<SimpleColumn> srColumns = InsertValuesExecutor.getColumns(translator, keySchema, srSchema, true);
        if (columns.size() != srColumns.size()) {
            return false;
        }
        for (int i = 0; i < columns.size(); ++i) {
            SimpleColumn column = columns.get(i);
            SimpleColumn srColumn = srColumns.get(i);
            if (column.name().equals((Object)srColumn.name()) && column.type().equals(srColumn.type())) continue;
            return false;
        }
        return true;
    }

    private byte[] serializeValue(GenericRow row, DataSource dataSource, KsqlConfig config, ServiceContext serviceContext) {
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)dataSource.getSchema(), (SerdeFeatures)dataSource.getKsqlTopic().getKeyFormat().getFeatures(), (SerdeFeatures)dataSource.getKsqlTopic().getValueFormat().getFeatures());
        FormatInfo formatInfo = InsertValuesExecutor.addSerializerMissingFormatFields(dataSource.getKsqlTopic().getValueFormat().getFormatInfo(), dataSource.getKafkaTopicName(), false, Optional.empty());
        Throwable throwable = null;
        try (Serde valueSerde = this.valueSerdeFactory.create(formatInfo, physicalSchema.valueSchema(), config, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());){
            String topicName = dataSource.getKafkaTopicName();
            try {
                byte[] byArray = valueSerde.serializer().serialize(topicName, (Object)row);
                return byArray;
            }
            catch (Exception e) {
                try {
                    InsertValuesExecutor.maybeThrowSchemaRegistryAuthError(FormatFactory.fromName((String)dataSource.getKsqlTopic().getValueFormat().getFormat()), topicName, false, AclOperation.WRITE, e);
                    LOG.error("Could not serialize value.", (Throwable)e);
                    throw new KsqlException("Could not serialize value" + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static FormatInfo addSerializerMissingFormatFields(FormatInfo formatInfo, String topicName, boolean isKey, Optional<Integer> schemaId) {
        Set supportedProperties;
        Format format = FormatFactory.fromName((String)formatInfo.getFormat());
        if (!format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
            return formatInfo;
        }
        if (schemaId.isPresent() && !formatInfo.getProperties().containsKey("schemaId")) {
            ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
            propertiesBuilder.putAll(formatInfo.getProperties());
            propertiesBuilder.put((Object)"schemaId", (Object)String.valueOf(schemaId.get()));
            return FormatInfo.of((String)formatInfo.getFormat(), (Map)propertiesBuilder.build());
        }
        if (!formatInfo.getProperties().containsKey("schemaId") && (supportedProperties = format.getSupportedProperties()).contains("subjectName")) {
            ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
            propertiesBuilder.putAll(formatInfo.getProperties());
            propertiesBuilder.put((Object)"subjectName", (Object)KsqlConstants.getSRSubject((String)topicName, (boolean)isKey));
            return FormatInfo.of((String)formatInfo.getFormat(), (Map)propertiesBuilder.build());
        }
        return formatInfo;
    }

    private static void maybeThrowSchemaRegistryAuthError(Format format, String topicName, boolean isKey, AclOperation op, Exception e) {
        Throwable rootCause;
        if (format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE) && (rootCause = (Throwable)ObjectUtils.defaultIfNull((Object)ExceptionUtils.getRootCause((Throwable)e), (Object)e)) instanceof RestClientException) {
            switch (((RestClientException)rootCause).getStatus()) {
                case 401: 
                case 403: {
                    throw new KsqlSchemaAuthorizationException(op, KsqlConstants.getSRSubject((String)topicName, (boolean)isKey));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRecord(ProducerRecord<byte[], byte[]> record, ServiceContext serviceContext, Map<String, Object> producerProps) {
        Future producerCallResult;
        Producer producer = serviceContext.getKafkaClientSupplier().getProducer(producerProps);
        try {
            producerCallResult = producer.send(record);
        }
        finally {
            producer.close(MAX_SEND_TIMEOUT);
        }
        try {
            producerCallResult.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static interface RecordProducer {
        public void sendRecord(ProducerRecord<byte[], byte[]> var1, ServiceContext var2, Map<String, Object> var3);
    }
}

