/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.parser.tree.ListProperties;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListPropertiesExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListPropertiesExecutor.class);

    private ListPropertiesExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListProperties> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        KsqlConfigResolver resolver = new KsqlConfigResolver();
        Map engineProperties = statement.getSessionConfig().getConfig(false).getAllConfigPropsWithSecretsObfuscated();
        List<PropertiesList.Property> mergedProperties = ListPropertiesExecutor.mergedProperties(statement);
        List overwritten = mergedProperties.stream().filter(property -> !Objects.equals(engineProperties.get(property.getName()), property.getValue())).map(PropertiesList.Property::getName).collect(Collectors.toList());
        List defaultProps = mergedProperties.stream().filter(property -> resolver.resolve(property.getName(), false).map(resolved -> resolved.isDefaultValue((Object)property.getValue())).orElse(false)).map(PropertiesList.Property::getName).collect(Collectors.toList());
        return StatementExecutorResponse.handled(Optional.of(new PropertiesList(statement.getMaskedStatementText(), mergedProperties, overwritten, defaultProps)));
    }

    private static List<PropertiesList.Property> mergedProperties(ConfiguredStatement<ListProperties> statement) {
        ArrayList<PropertiesList.Property> mergedProperties = new ArrayList<PropertiesList.Property>();
        statement.getSessionConfig().getConfig(true).getAllConfigPropsWithSecretsObfuscated().forEach((key, value) -> mergedProperties.add(new PropertiesList.Property(key, "KSQL", value)));
        ListPropertiesExecutor.embeddedConnectWorkerProperties(statement).forEach((key, value) -> mergedProperties.add(new PropertiesList.Property(key, "EMBEDDED CONNECT WORKER", value)));
        return mergedProperties;
    }

    private static Map<String, String> embeddedConnectWorkerProperties(ConfiguredStatement<ListProperties> statement) {
        String configFile = statement.getSessionConfig().getConfig(false).getString("ksql.connect.worker.config");
        if (configFile.isEmpty()) {
            return Collections.emptyMap();
        }
        Map workerProps = Utils.propsToStringMap((Properties)ListPropertiesExecutor.getWorkerProps(configFile));
        Set<String> allowList = ListPropertiesExecutor.embeddedConnectWorkerPropertiesAllowList(workerProps);
        return workerProps.keySet().stream().filter(allowList::contains).collect(Collectors.toMap(k -> k, workerProps::get));
    }

    private static Set<String> embeddedConnectWorkerPropertiesAllowList(Map<String, String> workerProps) {
        DistributedConfig config;
        try {
            config = new DistributedConfig(workerProps);
        }
        catch (ConfigException e) {
            LOGGER.warn("Could not create Connect worker config to validate properties; not displaying Connect worker properties as a result. Note that this should not happen if ksqlDB was able to start with embedded Connect. Error: {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
        return config.values().keySet().stream().filter(k -> config.typeOf(k) != ConfigDef.Type.PASSWORD).collect(Collectors.toSet());
    }

    private static Properties getWorkerProps(String configFile) {
        try {
            return Utils.loadProps((String)configFile);
        }
        catch (IOException e) {
            return new Properties();
        }
    }
}

