/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.server.ServerUtil;
import io.confluent.ksql.rest.util.DiscoverRemoteHostsUtil;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.Pair;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.state.HostInfo;

public final class RemoteHostExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteHostExecutor.class);
    private final ConfiguredStatement<?> statement;
    private final SessionProperties sessionProperties;
    private final KsqlExecutionContext executionContext;
    private final SimpleKsqlClient ksqlClient;

    private RemoteHostExecutor(ConfiguredStatement<?> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, SimpleKsqlClient ksqlClient) {
        this.statement = Objects.requireNonNull(statement);
        this.sessionProperties = Objects.requireNonNull(sessionProperties);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.ksqlClient = Objects.requireNonNull(ksqlClient);
    }

    public static RemoteHostExecutor create(ConfiguredStatement<?> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, SimpleKsqlClient ksqlClient) {
        return new RemoteHostExecutor(statement, sessionProperties, executionContext, ksqlClient);
    }

    private RestResponse<KsqlEntityList> makeKsqlRequest(HostInfo host, String statementText) {
        return this.ksqlClient.makeKsqlRequest(ServerUtil.buildRemoteUri(this.sessionProperties.getLocalUrl(), host.host(), host.port()), statementText, Collections.singletonMap("request.ksql.internal.request", true));
    }

    private CompletableFuture<RestResponse<KsqlEntityList>> fetchRemoteData(String statementText, HostInfo host, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.makeKsqlRequest(host, statementText), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Map<HostInfo, KsqlEntity>, Set<HostInfo>> fetchAllRemoteResults() {
        Set<HostInfo> remoteHosts = DiscoverRemoteHostsUtil.getRemoteHosts(this.executionContext.getPersistentQueries(), this.sessionProperties.getKsqlHostInfo());
        if (remoteHosts.isEmpty() || this.sessionProperties.getInternalRequest()) {
            return new Pair((Object)ImmutableMap.of(), (Object)ImmutableSet.of());
        }
        HashSet unresponsiveHosts = new HashSet();
        ExecutorService executorService = Executors.newFixedThreadPool(remoteHosts.size());
        try {
            HashMap<HostInfo, CompletableFuture<RestResponse<KsqlEntityList>>> futureResponses = new HashMap<HostInfo, CompletableFuture<RestResponse<KsqlEntityList>>>();
            for (HostInfo host : remoteHosts) {
                futureResponses.put(host, this.fetchRemoteData(this.statement.getUnMaskedStatementText(), host, executorService));
            }
            ImmutableMap.Builder results = ImmutableMap.builder();
            for (Map.Entry e : futureResponses.entrySet()) {
                try {
                    RestResponse response = (RestResponse)((CompletableFuture)e.getValue()).get(this.executionContext.getKsqlConfig().getLong("ksql.fetch.remote.hosts.max.timeout.seconds"), TimeUnit.SECONDS);
                    if (response.isErroneous()) {
                        LOG.warn((Object)"Error response from host. host: {}, cause: {}", new Object[]{e.getKey(), response.getErrorMessage().getMessage()});
                        unresponsiveHosts.add(e.getKey());
                        continue;
                    }
                    results.put(e.getKey(), ((KsqlEntityList)response.getResponse()).get(0));
                }
                catch (Exception cause) {
                    LOG.warn((Object)"Failed to retrieve info from host: {}, statement: {}, cause: {}", new Object[]{e.getKey(), this.statement.getMaskedStatementText(), cause});
                    unresponsiveHosts.add(e.getKey());
                }
            }
            Pair pair = new Pair((Object)results.build(), unresponsiveHosts);
            return pair;
        }
        finally {
            executorService.shutdown();
        }
    }
}

