/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.DefineVariable;
import io.confluent.ksql.parser.tree.UndefineVariable;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.WarningEntity;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.Optional;

public final class VariableExecutor {
    private VariableExecutor() {
    }

    public static StatementExecutorResponse set(ConfiguredStatement<DefineVariable> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        DefineVariable defineVariable = (DefineVariable)statement.getStatement();
        sessionProperties.setVariable(defineVariable.getVariableName(), defineVariable.getVariableValue());
        return StatementExecutorResponse.handled(Optional.empty());
    }

    public static StatementExecutorResponse unset(ConfiguredStatement<UndefineVariable> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        String variableName = ((UndefineVariable)statement.getStatement()).getVariableName();
        if (!sessionProperties.getSessionVariables().containsKey(variableName)) {
            return StatementExecutorResponse.handled(Optional.of(new WarningEntity(statement.getMaskedStatementText(), String.format("Cannot undefine variable '%s' which was never defined", variableName))));
        }
        sessionProperties.unsetVariable(variableName);
        return StatementExecutorResponse.handled(Optional.empty());
    }
}

