/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.DescribeFunction;
import io.confluent.ksql.parser.tree.ListFunctions;
import io.confluent.ksql.parser.tree.ListProperties;
import io.confluent.ksql.parser.tree.ListTopics;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.properties.DenyListPropertyValidator;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ClusterTerminateRequest;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.KsqlTestResult;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.rest.server.ServerUtil;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import io.confluent.ksql.rest.server.computation.DistributingExecutor;
import io.confluent.ksql.rest.server.computation.ValidatedCommandFactory;
import io.confluent.ksql.rest.server.execution.CustomExecutors;
import io.confluent.ksql.rest.server.execution.DefaultCommandQueueSync;
import io.confluent.ksql.rest.server.execution.RequestHandler;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.rest.server.validation.CustomValidators;
import io.confluent.ksql.rest.server.validation.RequestValidator;
import io.confluent.ksql.rest.util.CommandStoreUtil;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.services.SandboxedServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.statement.Injectors;
import io.confluent.ksql.tools.test.SqlTestExecutor;
import io.confluent.ksql.tools.test.parser.SqlTestLoader;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConfigurable;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.KsqlRequestConfig;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.version.metrics.ActivenessRegistrar;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlResource
implements KsqlConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlResource.class);
    private static final List<KsqlParser.ParsedStatement> TERMINATE_CLUSTER = new DefaultKsqlParser().parse("TERMINATE CLUSTER;");
    private static final Set<Class<? extends Statement>> SYNC_BLACKLIST = ImmutableSet.builder().add(ListTopics.class).add(ListFunctions.class).add(DescribeFunction.class).add(ListProperties.class).add(SetProperty.class).add(UnsetProperty.class).build();
    private final KsqlExecutionContext ksqlEngine;
    private final CommandRunner commandRunner;
    private final Duration distributedCmdResponseTimeout;
    private final ActivenessRegistrar activenessRegistrar;
    private final BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory;
    private final Optional<KsqlAuthorizationValidator> authorizationValidator;
    private final DenyListPropertyValidator denyListPropertyValidator;
    private final Supplier<String> commandRunnerWarning;
    private RequestValidator validator;
    private RequestHandler handler;
    private final Errors errorHandler;
    private KsqlHostInfo localHost;
    private URL localUrl;

    public KsqlResource(KsqlEngine ksqlEngine, CommandRunner commandRunner, Duration distributedCmdResponseTimeout, ActivenessRegistrar activenessRegistrar, Optional<KsqlAuthorizationValidator> authorizationValidator, Errors errorHandler, DenyListPropertyValidator denyListPropertyValidator) {
        this(ksqlEngine, commandRunner, distributedCmdResponseTimeout, activenessRegistrar, (BiFunction<KsqlExecutionContext, ServiceContext, Injector>)Injectors.DEFAULT, authorizationValidator, errorHandler, denyListPropertyValidator, commandRunner::getCommandRunnerDegradedWarning);
    }

    KsqlResource(KsqlEngine ksqlEngine, CommandRunner commandRunner, Duration distributedCmdResponseTimeout, ActivenessRegistrar activenessRegistrar, BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory, Optional<KsqlAuthorizationValidator> authorizationValidator, Errors errorHandler, DenyListPropertyValidator denyListPropertyValidator, Supplier<String> commandRunnerWarning) {
        this.ksqlEngine = (KsqlExecutionContext)Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.commandRunner = Objects.requireNonNull(commandRunner, "commandRunner");
        this.distributedCmdResponseTimeout = Objects.requireNonNull(distributedCmdResponseTimeout, "distributedCmdResponseTimeout");
        this.activenessRegistrar = Objects.requireNonNull(activenessRegistrar, "activenessRegistrar");
        this.injectorFactory = Objects.requireNonNull(injectorFactory, "injectorFactory");
        this.authorizationValidator = Objects.requireNonNull(authorizationValidator, "authorizationValidator");
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.denyListPropertyValidator = Objects.requireNonNull(denyListPropertyValidator, "denyListPropertyValidator");
        this.commandRunnerWarning = Objects.requireNonNull(commandRunnerWarning, "commandRunnerWarning");
    }

    public void configure(KsqlConfig config) {
        if (!config.getKsqlStreamConfigProps().containsKey("application.server")) {
            throw new IllegalArgumentException("Need KS application server set");
        }
        String applicationServer = (String)config.getKsqlStreamConfigProps().get("application.server");
        HostInfo hostInfo = ServerUtil.parseHostInfo(applicationServer);
        this.localHost = new KsqlHostInfo(hostInfo.host(), hostInfo.port());
        try {
            this.localUrl = new URL(applicationServer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert remote host info to URL. remoteInfo: " + this.localHost.host() + ":" + this.localHost.host());
        }
        this.validator = new RequestValidator(CustomValidators.VALIDATOR_MAP, this.injectorFactory, arg_0 -> ((KsqlExecutionContext)this.ksqlEngine).createSandbox(arg_0), new ValidatedCommandFactory());
        this.handler = new RequestHandler(CustomExecutors.EXECUTOR_MAP, new DistributingExecutor(config, this.commandRunner.getCommandQueue(), this.distributedCmdResponseTimeout, this.injectorFactory, this.authorizationValidator, new ValidatedCommandFactory(), this.errorHandler, this.commandRunnerWarning), this.ksqlEngine, new DefaultCommandQueueSync(this.commandRunner.getCommandQueue(), KsqlResource::shouldSynchronize, this.distributedCmdResponseTimeout));
    }

    public EndpointResponse terminateCluster(KsqlSecurityContext securityContext, ClusterTerminateRequest request) {
        LOG.info("Received: " + request);
        this.throwIfNotConfigured();
        KsqlResource.ensureValidPatterns(request.getDeleteTopicList());
        try {
            Map streamsProperties = request.getStreamsProperties();
            this.denyListPropertyValidator.validateAll(streamsProperties);
            KsqlEntityList entities = this.handler.execute(securityContext, TERMINATE_CLUSTER, new SessionProperties(streamsProperties, this.localHost, this.localUrl, false));
            return EndpointResponse.ok((Object)entities);
        }
        catch (Exception e) {
            return Errors.serverErrorForStatement((Throwable)e, (String)"TERMINATE CLUSTER;", (KsqlEntityList)new KsqlEntityList());
        }
    }

    public EndpointResponse isValidProperty(String property) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(property, "");
            this.denyListPropertyValidator.validateAll(properties);
            KsqlConfigResolver resolver = new KsqlConfigResolver();
            Optional resolvedItem = resolver.resolve(property, false);
            if (this.ksqlEngine.getKsqlConfig().getBoolean("ksql.runtime.feature.shared.enabled").booleanValue() && resolvedItem.isPresent() && !PropertiesList.QueryLevelProperties.contains(((ConfigItem)resolvedItem.get()).getPropertyName())) {
                throw new KsqlException(String.format("When shared runtimes are enabled, the config %s can only be set for the entire cluster and all queries currently running in it, and not configurable for individual queries. Please use ALTER SYSTEM to change this config for all queries.", properties));
            }
            return EndpointResponse.ok((Object)true);
        }
        catch (KsqlException e) {
            LOG.info("Processed unsuccessfully, reason: ", (Throwable)e);
            return this.errorHandler.generateResponse((Exception)((Object)e), Errors.badRequest((Throwable)e));
        }
        catch (Exception e) {
            LOG.info("Processed unsuccessfully, reason: ", (Throwable)e);
            throw e;
        }
    }

    public EndpointResponse handleKsqlStatements(KsqlSecurityContext securityContext, KsqlRequest request) {
        ApiServerUtils.setMaskedSqlIfNeeded(request);
        QueryLogger.info((Object)("Received: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql());
        this.throwIfNotConfigured();
        this.activenessRegistrar.updateLastRequestTime();
        try {
            CommandStoreUtil.httpWaitForCommandSequenceNumber(this.commandRunner.getCommandQueue(), request, this.distributedCmdResponseTimeout);
            Map configProperties = request.getConfigOverrides();
            this.denyListPropertyValidator.validateAll(configProperties);
            KsqlRequestConfig requestConfig = new KsqlRequestConfig(request.getRequestProperties());
            List statements = this.ksqlEngine.parse(request.getUnmaskedKsql());
            this.validator.validate((ServiceContext)SandboxedServiceContext.create((ServiceContext)securityContext.getServiceContext()), statements, new SessionProperties(configProperties, this.localHost, this.localUrl, requestConfig.getBoolean("request.ksql.internal.request").booleanValue(), request.getSessionVariables()), request.getUnmaskedKsql());
            statements.forEach(s -> {
                if (s.getUnMaskedStatementText().toLowerCase().contains("terminate") || s.getUnMaskedStatementText().toLowerCase().contains("drop")) {
                    QueryLogger.info((Object)"Query terminated", (String)s.getMaskedStatementText());
                } else {
                    QueryLogger.info((Object)"Query created", (String)s.getMaskedStatementText());
                }
            });
            KsqlEntityList entities = this.handler.execute(securityContext, statements, new SessionProperties(configProperties, this.localHost, this.localUrl, requestConfig.getBoolean("request.ksql.internal.request").booleanValue(), request.getSessionVariables()));
            QueryLogger.info((Object)("Processed successfully: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql());
            KsqlResource.addCommandRunnerWarning(entities, this.commandRunnerWarning);
            return EndpointResponse.ok((Object)entities);
        }
        catch (KsqlRestException e) {
            QueryLogger.info((Object)("Processed unsuccessfully: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql(), (Throwable)e);
            throw e;
        }
        catch (KsqlStatementException e) {
            QueryLogger.info((Object)("Processed unsuccessfully: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql(), (Throwable)e);
            EndpointResponse response = e.getProblem() == KsqlStatementException.Problem.STATEMENT ? Errors.badStatement((String)e.getRawUnloggedDetails(), (String)e.getSqlStatement()) : (e.getProblem() == KsqlStatementException.Problem.OTHER ? Errors.serverErrorForStatement((Throwable)e, (String)e.getSqlStatement()) : Errors.badRequest((Throwable)e));
            return this.errorHandler.generateResponse((Exception)((Object)e), response);
        }
        catch (KsqlException e) {
            QueryLogger.info((Object)("Processed unsuccessfully: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql(), (Throwable)e);
            return this.errorHandler.generateResponse((Exception)((Object)e), Errors.badRequest((Throwable)e));
        }
        catch (Exception e) {
            QueryLogger.info((Object)("Processed unsuccessfully: " + request.toStringWithoutQuery()), (String)request.getMaskedKsql(), (Throwable)e);
            return this.errorHandler.generateResponse(e, Errors.serverErrorForStatement((Throwable)e, (String)request.getMaskedKsql()));
        }
    }

    public EndpointResponse runTest(String test) {
        try {
            List tests = SqlTestLoader.loadTest((String)test);
            return EndpointResponse.ok(this.runTests(tests));
        }
        catch (Exception e) {
            return this.errorHandler.generateResponse(e, Errors.badRequest((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KsqlTestResult> runTests(List<SqlTestLoader.SqlTest> tests) throws IOException {
        ArrayList<KsqlTestResult> results = new ArrayList<KsqlTestResult>();
        for (SqlTestLoader.SqlTest test : tests) {
            Path tempFolder = Files.createTempDirectory("test-temp", new FileAttribute[0]);
            SqlTestExecutor executor = SqlTestExecutor.create((Path)tempFolder);
            try {
                executor.executeTest(test);
                results.add(new KsqlTestResult(true, test.getName(), ""));
            }
            catch (Throwable e) {
                results.add(new KsqlTestResult(false, test.getName(), e.getMessage()));
            }
            finally {
                KsqlResource.cleanUp(executor, tempFolder);
                executor.close();
            }
        }
        return results;
    }

    private static void cleanUp(SqlTestExecutor executor, Path tempFolder) {
        executor.close();
        try {
            FileUtils.deleteDirectory((File)tempFolder.toFile());
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up temporary test folder: " + e.getMessage());
        }
    }

    private void throwIfNotConfigured() {
        if (this.validator == null || this.handler == null) {
            throw new KsqlRestException(Errors.notReady());
        }
    }

    private static boolean shouldSynchronize(Class<? extends Statement> statementClass) {
        return !SYNC_BLACKLIST.contains(statementClass) && CustomExecutors.EXECUTOR_MAP.containsKey(statementClass);
    }

    private static void ensureValidPatterns(List<String> deleteTopicList) {
        deleteTopicList.forEach(pattern -> {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new KsqlRestException(Errors.badRequest((String)("Invalid pattern: " + pattern)));
            }
        });
    }

    private static void addCommandRunnerWarning(KsqlEntityList entityList, Supplier<String> commandRunnerWarning) {
        String commandRunnerIssueString = commandRunnerWarning.get();
        if (!commandRunnerIssueString.equals("")) {
            for (KsqlEntity entity : entityList) {
                entity.updateWarnings(Collections.singletonList(new KsqlWarning(commandRunnerIssueString)));
            }
        }
    }
}

