/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import com.google.common.base.Suppliers;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.ServerInfo;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import io.confluent.ksql.services.KafkaClusterUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.util.KsqlConfig;
import java.util.function.Supplier;

public class ServerInfoResource {
    private final Supplier<String> appVersion = Suppliers.memoize(AppInfo::getVersion);
    private final Supplier<String> kafkaClusterId = Suppliers.memoize(() -> KafkaClusterUtil.getKafkaClusterId((ServiceContext)serviceContext));
    private final Supplier<String> ksqlServiceId = Suppliers.memoize(() -> ksqlConfig.getString("ksql.service.id"));
    private final Supplier<CommandRunner.CommandRunnerStatus> serverStatus = commandRunner::checkCommandRunnerStatus;

    public ServerInfoResource(ServiceContext serviceContext, KsqlConfig ksqlConfig, CommandRunner commandRunner) {
    }

    public EndpointResponse get() {
        return EndpointResponse.ok((Object)new ServerInfo(this.appVersion.get(), this.kafkaClusterId.get(), this.ksqlServiceId.get(), this.serverStatus.get().toString()));
    }
}

