/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.rest.server.resources.streaming.PollingSubscription;
import io.confluent.ksql.rest.server.resources.streaming.PrintTopicUtil;
import io.confluent.ksql.rest.server.resources.streaming.RecordFormatter;
import io.confluent.ksql.services.ServiceContext;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintPublisher
implements Flow.Publisher<Collection<String>> {
    private static final Logger log = LoggerFactory.getLogger(PrintPublisher.class);
    private final ListeningScheduledExecutorService exec;
    private final ServiceContext serviceContext;
    private final Map<String, Object> consumerProperties;
    private final PrintTopic printTopic;

    public PrintPublisher(ListeningScheduledExecutorService exec, ServiceContext serviceContext, Map<String, Object> consumerProperties, PrintTopic printTopic) {
        this.exec = Objects.requireNonNull(exec, "exec");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.consumerProperties = Objects.requireNonNull(consumerProperties, "consumerProperties");
        this.printTopic = Objects.requireNonNull(printTopic, "printTopic");
    }

    @Override
    public void subscribe(Flow.Subscriber<Collection<String>> subscriber) {
        KafkaConsumer<Bytes, Bytes> topicConsumer = PrintTopicUtil.createTopicConsumer(this.serviceContext, this.consumerProperties, this.printTopic);
        subscriber.onSubscribe(new PrintSubscription(this.exec, this.printTopic, subscriber, topicConsumer, new RecordFormatter(this.serviceContext.getSchemaRegistryClient(), this.printTopic.getTopic())));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static final class LimitIntervalCollection<T>
    extends AbstractCollection<T> {
        private final Iterable<T> source;
        private final int limit;
        private final int interval;
        private final int size;

        private LimitIntervalCollection(Collection<T> source, int limit, int interval, int start) {
            Preconditions.checkArgument((interval > 0 ? 1 : 0) != 0, (Object)"interval must be greater than 0");
            Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start must be greater than or equal to 0");
            Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be greater than or equal to 0");
            Objects.requireNonNull(source, "source");
            this.source = Iterables.skip(source, (int)start);
            this.size = Math.min(IntMath.divide((int)(source.size() - start), (int)interval, (RoundingMode)RoundingMode.CEILING), limit);
            this.interval = interval;
            this.limit = limit;
        }

        @Override
        @Nonnull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                final Iterator<T> it;
                int remaining;
                {
                    this.it = source.iterator();
                    this.remaining = limit;
                }

                @Override
                public boolean hasNext() {
                    return this.remaining > 0 && this.it.hasNext();
                }

                @Override
                public T next() {
                    --this.remaining;
                    Object next = this.it.next();
                    Iterators.advance(this.it, (int)(interval - 1));
                    return next;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class PrintSubscription
    extends PollingSubscription<Collection<String>> {
        private final PrintTopic printTopic;
        private final KafkaConsumer<Bytes, Bytes> topicConsumer;
        private final RecordFormatter formatter;
        private boolean closed = false;
        private int numPolled = 0;
        private int numWritten = 0;

        PrintSubscription(ListeningScheduledExecutorService exec, PrintTopic printTopic, Flow.Subscriber<Collection<String>> subscriber, KafkaConsumer<Bytes, Bytes> topicConsumer, RecordFormatter formatter) {
            super(exec, subscriber, null);
            this.printTopic = Objects.requireNonNull(printTopic, "printTopic");
            this.topicConsumer = Objects.requireNonNull(topicConsumer, "topicConsumer");
            this.formatter = Objects.requireNonNull(formatter, "formatter");
        }

        @Override
        public Collection<String> poll() {
            try {
                ConsumerRecords records = this.topicConsumer.poll(Duration.ZERO);
                if (records.isEmpty()) {
                    return null;
                }
                List<String> formatted = this.formatter.format((Iterable<ConsumerRecord<Bytes, Bytes>>)records);
                LimitIntervalCollection<String> limited = new LimitIntervalCollection<String>(formatted, this.printTopic.getLimit().orElse(Integer.MAX_VALUE) - this.numWritten, this.printTopic.getIntervalValue(), this.numPolled % this.printTopic.getIntervalValue());
                this.numPolled += formatted.size();
                this.numWritten += limited.size();
                if (this.printTopic.getLimit().isPresent() && this.numWritten >= this.printTopic.getLimit().getAsInt()) {
                    this.setDone();
                }
                return limited;
            }
            catch (Exception e) {
                this.setError(e);
                return null;
            }
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                log.info("Closing consumer for topic {}", (Object)this.printTopic.getTopic());
                this.closed = true;
                this.topicConsumer.close();
            }
        }
    }
}

