/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.rest.server.resources.streaming.PollingSubscription;
import io.confluent.ksql.rest.server.resources.streaming.WebSocketSubscriber;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.RowMetadata;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PullQueryPublisher
implements Flow.Publisher<Collection<StreamedRow>> {
    private static final Logger LOG = LoggerFactory.getLogger(PullQueryPublisher.class);
    private final ListeningScheduledExecutorService exec;
    private final PullQueryResult result;
    private final MetricsCallbackHolder metricsCallbackHolder;
    private final long startTimeNanos;

    @VisibleForTesting
    PullQueryPublisher(ListeningScheduledExecutorService exec, PullQueryResult result, MetricsCallbackHolder metricsCallbackHolder, long startTimeNanos) {
        this.exec = Objects.requireNonNull(exec, "exec");
        this.result = Objects.requireNonNull(result, "result");
        this.metricsCallbackHolder = metricsCallbackHolder;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    public synchronized void subscribe(Flow.Subscriber<Collection<StreamedRow>> subscriber) {
        PullQuerySubscription subscription = new PullQuerySubscription(this.exec, subscriber, this.result);
        this.result.start();
        WebSocketSubscriber webSocketSubscriber = (WebSocketSubscriber)subscriber;
        webSocketSubscriber.onSubscribe(subscription, this.metricsCallbackHolder, this.startTimeNanos);
    }

    private static final class PullQuerySubscription
    extends PollingSubscription<Collection<StreamedRow>> {
        private final Flow.Subscriber<Collection<StreamedRow>> subscriber;
        private final PullQueryResult result;

        private PullQuerySubscription(ListeningScheduledExecutorService exec, Flow.Subscriber<Collection<StreamedRow>> subscriber, PullQueryResult result) {
            super(exec, subscriber, result.getSchema());
            this.subscriber = Objects.requireNonNull(subscriber, "subscriber");
            this.result = Objects.requireNonNull(result, "result");
            result.onCompletion(v -> {
                result.getConsistencyOffsetVector().ifPresent(arg_0 -> ((PullQueryWriteStream)result.getPullQueryQueue()).putConsistencyVector(arg_0));
                this.setDone();
            });
            result.onException(this::setError);
        }

        @Override
        Collection<StreamedRow> poll() {
            LinkedList rows = Lists.newLinkedList();
            this.result.getPullQueryQueue().drainTo((Collection)rows);
            if (rows.isEmpty()) {
                return null;
            }
            return rows.stream().map(kv -> {
                if (kv.getRowMetadata().isPresent() && ((RowMetadata)kv.getRowMetadata().get()).getConsistencyOffsetVector().isPresent()) {
                    return StreamedRow.consistencyToken((ConsistencyToken)new ConsistencyToken(((ConsistencyOffsetVector)((RowMetadata)kv.getRowMetadata().get()).getConsistencyOffsetVector().get()).serialize()));
                }
                return StreamedRow.pushRow((GenericRow)((GenericRow)kv.getKeyValue().value()));
            }).collect(Collectors.toCollection(Lists::newLinkedList));
        }

        @Override
        void close() {
            this.result.stop();
        }
    }
}

