/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.StreamingOutput;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.pull.PullQueryRow;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullQueryStreamWriter
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(PullQueryStreamWriter.class);
    private static final int WRITE_TIMEOUT_MS = 3000;
    private static final int FLUSH_SIZE_BYTES = 51200;
    private static final long MAX_FLUSH_MS = 1000L;
    private final long disconnectCheckInterval;
    private final PullQueryWriteStream pullQueryQueue;
    private final Clock clock;
    private final PullQueryResult result;
    private final ObjectMapper objectMapper;
    private AtomicBoolean completed = new AtomicBoolean(false);
    private AtomicBoolean connectionClosed = new AtomicBoolean(false);
    private AtomicReference<Throwable> pullQueryException = new AtomicReference<Object>(null);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private boolean sentAtLeastOneRow = false;

    PullQueryStreamWriter(PullQueryResult result, long disconnectCheckInterval, ObjectMapper objectMapper, PullQueryWriteStream pullQueryQueue, Clock clock, CompletableFuture<Void> connectionClosedFuture, KsqlParser.PreparedStatement<Query> statement) {
        this.result = Objects.requireNonNull(result, "result");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.disconnectCheckInterval = disconnectCheckInterval;
        this.pullQueryQueue = Objects.requireNonNull(pullQueryQueue, "pullQueryQueue");
        this.clock = Objects.requireNonNull(clock, "clock");
        connectionClosedFuture.thenAccept(v -> this.connectionClosed.set(true));
        result.onException(t -> {
            if (this.pullQueryException.getAndSet((Throwable)t) == null) {
                this.interruptWriterThread();
            }
        });
        result.onCompletion(v -> {
            if (!this.completed.getAndSet(true)) {
                result.getConsistencyOffsetVector().ifPresent(arg_0 -> ((PullQueryWriteStream)pullQueryQueue).putConsistencyVector(arg_0));
                this.interruptWriterThread();
            }
        });
        try {
            result.start();
        }
        catch (Exception e) {
            throw new KsqlStatementException(e.getMessage() == null ? "Server Error" : e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output) {
        try {
            WriterState writerState = new WriterState(this.clock);
            QueueWrapper queueWrapper = new QueueWrapper(this.pullQueryQueue, this.disconnectCheckInterval);
            StreamedRow header = StreamedRow.header((QueryId)this.result.getQueryId(), (LogicalSchema)this.result.getSchema());
            writerState.append("[").append(this.writeValueAsString(header));
            while (!this.connectionClosed.get() && !this.isCompletedOrHasException()) {
                this.processRow(output, writerState, queueWrapper);
            }
            if (this.connectionClosed.get()) {
                return;
            }
            this.drainAndThrowOnError(output, writerState, queueWrapper);
            this.drainAndWrite(writerState, queueWrapper);
            writerState.append("]");
            if (writerState.length() > 0) {
                output.write(writerState.getStringToFlush().getBytes(StandardCharsets.UTF_8));
                output.flush();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while writing to connection stream");
        }
        catch (Throwable e) {
            LOG.error("Exception occurred while writing to connection stream: ", e);
            this.outputException(output, e);
        }
        finally {
            this.close();
        }
    }

    private void processRow(OutputStream output, WriterState writerState, QueueWrapper queueWrapper) throws Throwable {
        PullQueryRow toProcess = queueWrapper.pollNextRow();
        if (toProcess == QueueWrapper.END_ROW) {
            return;
        }
        if (toProcess != null) {
            this.writeRow(toProcess, writerState, queueWrapper.hasAnotherRow());
            if (writerState.length() >= 51200 || this.clock.millis() - writerState.getLastFlushMs() >= 1000L) {
                output.write(writerState.getStringToFlush().getBytes(StandardCharsets.UTF_8));
                output.flush();
            }
        }
        this.drainAndThrowOnError(output, writerState, queueWrapper);
    }

    private void writeRow(PullQueryRow row, WriterState writerState, boolean hasAnotherRow) {
        if (!this.sentAtLeastOneRow) {
            writerState.append(",").append(System.lineSeparator());
            this.sentAtLeastOneRow = true;
        }
        StreamedRow streamedRow = null;
        streamedRow = row.getConsistencyOffsetVector().isPresent() ? StreamedRow.consistencyToken((ConsistencyToken)new ConsistencyToken(((ConsistencyOffsetVector)row.getConsistencyOffsetVector().get()).serialize())) : StreamedRow.pullRow((GenericRow)row.getGenericRow(), (Optional)row.getSourceNode());
        writerState.append(this.writeValueAsString(streamedRow));
        if (hasAnotherRow) {
            writerState.append(",").append(System.lineSeparator());
        }
    }

    private void drainAndThrowOnError(OutputStream output, WriterState writerState, QueueWrapper queueWrapper) throws Throwable {
        if (this.pullQueryException.get() != null) {
            this.drainAndWrite(writerState, queueWrapper);
            output.write(writerState.getStringToFlush().getBytes(StandardCharsets.UTF_8));
            output.flush();
            throw this.pullQueryException.get();
        }
    }

    private void drainAndWrite(WriterState writerState, QueueWrapper queueWrapper) {
        List<PullQueryRow> rows = queueWrapper.drain();
        int i = 0;
        for (PullQueryRow row : rows) {
            this.writeRow(row, writerState, i + 1 < rows.size());
            ++i;
        }
    }

    private void outputException(OutputStream out, Throwable exception) {
        if (this.connectionClosed.get()) {
            return;
        }
        try {
            out.write(",\n".getBytes(StandardCharsets.UTF_8));
            if (exception.getCause() instanceof KsqlException) {
                this.objectMapper.writeValue(out, (Object)StreamedRow.error((Throwable)exception.getCause(), (int)Errors.ERROR_CODE_SERVER_ERROR));
            } else {
                this.objectMapper.writeValue(out, (Object)StreamedRow.error((Throwable)exception, (int)Errors.ERROR_CODE_SERVER_ERROR));
            }
            out.write("]\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            LOG.debug("Client disconnected while attempting to write an error message");
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.result.stop();
        }
    }

    @Override
    public int getWriteTimeoutMs() {
        return 3000;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private boolean isCompletedOrHasException() {
        return this.completed.get() || this.pullQueryException.get() != null;
    }

    private void interruptWriterThread() {
        this.pullQueryQueue.end();
    }

    private String writeValueAsString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static final class QueueWrapper {
        public static final PullQueryRow END_ROW = new PullQueryRow(null, null, null, null);
        private final PullQueryWriteStream pullQueryQueue;
        private final long disconnectCheckInterval;
        private PullQueryRow head = null;

        QueueWrapper(PullQueryWriteStream pullQueryQueue, long disconnectCheckInterval) {
            this.pullQueryQueue = pullQueryQueue;
            this.disconnectCheckInterval = disconnectCheckInterval;
        }

        public boolean hasAnotherRow() {
            return this.head != null;
        }

        public PullQueryRow pollNextRow() throws InterruptedException {
            PullQueryRow row = this.pullQueryQueue.pollRow(this.disconnectCheckInterval, TimeUnit.MILLISECONDS);
            if (row == END_ROW) {
                return END_ROW;
            }
            if (row != null) {
                PullQueryRow toProcess = this.head;
                this.head = row;
                return toProcess;
            }
            return null;
        }

        public List<PullQueryRow> drain() {
            ArrayList rows = Lists.newArrayList();
            if (this.head != null) {
                rows.add(this.head);
            }
            this.head = null;
            this.pullQueryQueue.drainRowsTo((Collection)rows);
            rows.remove(END_ROW);
            return rows;
        }
    }

    private static class WriterState {
        private final Clock clock;
        private StringBuilder sb = new StringBuilder();
        private long lastFlushMs;

        WriterState(Clock clock) {
            this.clock = clock;
        }

        public WriterState append(String str) {
            this.sb.append(str);
            return this;
        }

        public int length() {
            return this.sb.length();
        }

        public long getLastFlushMs() {
            return this.lastFlushMs;
        }

        public String getStringToFlush() {
            String str = this.sb.toString();
            this.sb = new StringBuilder();
            this.lastFlushMs = this.clock.millis();
            return str;
        }
    }
}

