/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.vertx.core.http.ServerWebSocket;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtil.class);
    private static final int MAX_REASON_LEN = 123;
    private static final int ECLIPSE_LEN = "...".getBytes(StandardCharsets.UTF_8).length;

    private SessionUtil() {
    }

    static void closeSilently(ServerWebSocket webSocket, int code, String message) {
        try {
            ImmutableMap finalMessage = ImmutableMap.of((Object)"error", (Object)(message != null ? message : ""));
            String json = ApiJsonMapper.INSTANCE.get().writeValueAsString((Object)finalMessage);
            webSocket.writeFinalTextFrame(json, r -> {}).close((short)code, SessionUtil.truncate(message));
        }
        catch (Exception e) {
            LOG.info("Exception caught closing websocket", (Throwable)e);
        }
    }

    private static String truncate(String reason) {
        if (reason == null) {
            return "";
        }
        if (reason.getBytes(StandardCharsets.UTF_8).length <= 123) {
            return reason;
        }
        String truncated = reason.substring(0, Math.min(reason.length(), 123 - ECLIPSE_LEN));
        while (truncated.getBytes(StandardCharsets.UTF_8).length > 123 - ECLIPSE_LEN) {
            truncated = truncated.substring(0, truncated.length() - 2);
        }
        return truncated + "...";
    }
}

