/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.services;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.server.services.DefaultKsqlClient;
import io.confluent.ksql.security.KsqlPrincipal;
import io.confluent.ksql.services.ConnectClientFactory;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.ServiceContextFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;

public final class RestServiceContextFactory {
    private RestServiceContextFactory() {
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, Optional<String> authHeader, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient, List<Map.Entry<String, String>> requestHeaders, Optional<KsqlPrincipal> userPrincipal) {
        return RestServiceContextFactory.create(ksqlConfig, authHeader, (KafkaClientSupplier)new DefaultKafkaClientSupplier(), schemaRegistryClientFactory, connectClientFactory, sharedClient, requestHeaders, userPrincipal);
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, Optional<String> authHeader, KafkaClientSupplier kafkaClientSupplier, Supplier<SchemaRegistryClient> srClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient, List<Map.Entry<String, String>> requestHeaders, Optional<KsqlPrincipal> userPrincipal) {
        return ServiceContextFactory.create((KsqlConfig)ksqlConfig, (KafkaClientSupplier)kafkaClientSupplier, srClientFactory, () -> connectClientFactory.get(authHeader, requestHeaders, userPrincipal), () -> new DefaultKsqlClient(authHeader, sharedClient, ksqlConfig), userPrincipal);
    }

    public static interface UserServiceContextFactory {
        public ServiceContext create(KsqlConfig var1, Optional<String> var2, KafkaClientSupplier var3, Supplier<SchemaRegistryClient> var4, ConnectClientFactory var5, KsqlClient var6, List<Map.Entry<String, String>> var7, Optional<KsqlPrincipal> var8);
    }

    public static interface DefaultServiceContextFactory {
        public ServiceContext create(KsqlConfig var1, Optional<String> var2, Supplier<SchemaRegistryClient> var3, ConnectClientFactory var4, KsqlClient var5, List<Map.Entry<String, String>> var6, Optional<KsqlPrincipal> var7);
    }
}

