/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public final class CommandStoreUtil {
    private CommandStoreUtil() {
    }

    public static void httpWaitForCommandSequenceNumber(CommandQueue commandQueue, KsqlRequest request, Duration timeout) {
        try {
            CommandStoreUtil.waitForCommandSequenceNumber(commandQueue, request, timeout);
        }
        catch (InterruptedException e) {
            ApiServerUtils.setMaskedSqlIfNeeded(request);
            long seqNum = request.getCommandSequenceNumber().orElse(-1L);
            String errorMsg = "Interrupted while waiting for command with the supplied sequence number to execute. sequence number: " + seqNum + ", request: " + request.getMaskedKsql();
            throw new KsqlRestException(Errors.serverErrorForStatement((Throwable)e, (String)errorMsg, (KsqlEntityList)new KsqlEntityList()));
        }
        catch (TimeoutException e) {
            throw new KsqlRestException(Errors.commandQueueCatchUpTimeout((long)request.getCommandSequenceNumber().orElse(-1L)));
        }
    }

    public static void waitForCommandSequenceNumber(CommandQueue commandQueue, KsqlRequest request, Duration timeout) throws InterruptedException, TimeoutException {
        Optional commandSequenceNumber = request.getCommandSequenceNumber();
        if (commandSequenceNumber.isPresent()) {
            long seqNum = (Long)commandSequenceNumber.get();
            commandQueue.ensureConsumedPast(seqNum, timeout);
        }
    }
}

