/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectMetrics {
    public static final String JMX_PREFIX = "kafka.connect";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectMetrics.class);
    private final Metrics metrics;
    private final Time time;
    private final String workerId;
    private final ConcurrentMap<MetricGroupId, MetricGroup> groupsByName = new ConcurrentHashMap<MetricGroupId, MetricGroup>();
    private final ConnectMetricsRegistry registry;

    public ConnectMetrics(String workerId, WorkerConfig config, Time time, String clusterId) {
        this.workerId = workerId;
        this.time = time;
        int numSamples = config.getInt("metrics.num.samples");
        long sampleWindowMs = config.getLong("metrics.sample.window.ms");
        String metricsRecordingLevel = config.getString("metrics.recording.level");
        List reporters = CommonClientConfigs.metricsReporters((String)workerId, (AbstractConfig)config);
        MetricConfig metricConfig = new MetricConfig().samples(numSamples).timeWindow(sampleWindowMs, TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName((String)metricsRecordingLevel));
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            contextLabels.put("connect.group.id", groupId);
        }
        contextLabels.put("resource.type", "connect");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX, contextLabels);
        this.metrics = new Metrics(metricConfig, reporters, time, (MetricsContext)metricsContext);
        this.registry = new ConnectMetricsRegistry(config);
        LOG.debug("Registering Connect metrics with JMX for worker '{}'", (Object)workerId);
        AppInfoParser.registerAppInfo((String)JMX_PREFIX, (String)workerId, (Metrics)this.metrics, (long)time.milliseconds());
    }

    public String workerId() {
        return this.workerId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ConnectMetricsRegistry registry() {
        return this.registry;
    }

    public MetricGroup group(String groupName, String ... tagKeyValues) {
        MetricGroup previous;
        MetricGroupId groupId = this.groupId(groupName, tagKeyValues);
        MetricGroup group = (MetricGroup)this.groupsByName.get(groupId);
        if (group == null && (previous = this.groupsByName.putIfAbsent(groupId, group = new MetricGroup(groupId))) != null) {
            group = previous;
        }
        return group;
    }

    protected MetricGroupId groupId(String groupName, String ... tagKeyValues) {
        Map tags = MetricsUtils.getTags((String[])tagKeyValues);
        return new MetricGroupId(groupName, tags);
    }

    public Time time() {
        return this.time;
    }

    public void stop() {
        this.metrics.close();
        LOG.debug("Unregistering Connect metrics with JMX for worker '{}'", (Object)this.workerId);
        AppInfoParser.unregisterAppInfo((String)JMX_PREFIX, (String)this.workerId, (Metrics)this.metrics);
    }

    public static void main(String[] args) {
        ConnectMetricsRegistry metrics = new ConnectMetricsRegistry(null);
        System.out.println(Metrics.toHtmlTable((String)JMX_PREFIX, metrics.getAllTemplates()));
    }

    public static interface LiteralSupplier<T> {
        public T metricValue(long var1);
    }

    public class MetricGroup
    implements AutoCloseable {
        private final MetricGroupId groupId;
        private final Set<String> sensorNames = new HashSet<String>();
        private final String sensorPrefix;

        protected MetricGroup(MetricGroupId groupId) {
            Objects.requireNonNull(groupId);
            this.groupId = groupId;
            this.sensorPrefix = "connect-sensor-group: " + groupId + ";";
        }

        public MetricGroupId groupId() {
            return this.groupId;
        }

        public MetricName metricName(MetricNameTemplate template) {
            return ConnectMetrics.this.metrics.metricInstance(template, this.groupId.tags());
        }

        MetricName metricName(String name) {
            return ConnectMetrics.this.metrics.metricName(name, this.groupId.groupName(), "", this.groupId.tags());
        }

        public Metrics metrics() {
            return ConnectMetrics.this.metrics;
        }

        Map<String, String> tags() {
            return this.groupId.tags();
        }

        public <T> void addValueMetric(MetricNameTemplate nameTemplate, LiteralSupplier<T> supplier) {
            MetricName metricName = this.metricName(nameTemplate);
            this.metrics().addMetricIfAbsent(metricName, null, (MetricValueProvider)((Gauge)(config, now) -> supplier.metricValue(now)));
        }

        public <T> void addImmutableValueMetric(MetricNameTemplate nameTemplate, T value) {
            MetricName metricName = this.metricName(nameTemplate);
            this.metrics().addMetricIfAbsent(metricName, null, (MetricValueProvider)((Gauge)(config, now) -> value));
        }

        public Sensor sensor(String name) {
            return this.sensor(name, null, Sensor.RecordingLevel.INFO, new Sensor[0]);
        }

        public Sensor sensor(String name, Sensor ... parents) {
            return this.sensor(name, null, Sensor.RecordingLevel.INFO, parents);
        }

        public Sensor sensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
            return this.sensor(name, null, recordingLevel, parents);
        }

        public Sensor sensor(String name, MetricConfig config, Sensor ... parents) {
            return this.sensor(name, config, Sensor.RecordingLevel.INFO, parents);
        }

        public synchronized Sensor sensor(String name, MetricConfig config, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
            Sensor result = ConnectMetrics.this.metrics.sensor(this.sensorPrefix + name, config, Long.MAX_VALUE, recordingLevel, parents);
            if (result != null) {
                this.sensorNames.add(result.name());
            }
            return result;
        }

        @Override
        public synchronized void close() {
            for (String sensorName : this.sensorNames) {
                ConnectMetrics.this.metrics.removeSensor(sensorName);
            }
            this.sensorNames.clear();
            for (MetricName metricName : new HashSet(ConnectMetrics.this.metrics.metrics().keySet())) {
                if (!this.groupId.includes(metricName)) continue;
                ConnectMetrics.this.metrics.removeMetric(metricName);
            }
        }
    }

    public static class MetricGroupId {
        private final String groupName;
        private final Map<String, String> tags;
        private final int hc;
        private final String str;

        public MetricGroupId(String groupName, Map<String, String> tags) {
            Objects.requireNonNull(groupName);
            Objects.requireNonNull(tags);
            this.groupName = groupName;
            this.tags = Collections.unmodifiableMap(new LinkedHashMap<String, String>(tags));
            this.hc = Objects.hash(this.groupName, this.tags);
            StringBuilder sb = new StringBuilder(this.groupName);
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                sb.append(";").append(entry.getKey()).append('=').append(entry.getValue());
            }
            this.str = sb.toString();
        }

        public String groupName() {
            return this.groupName;
        }

        public Map<String, String> tags() {
            return this.tags;
        }

        public boolean includes(MetricName metricName) {
            return metricName != null && this.groupName.equals(metricName.group()) && this.tags.equals(metricName.tags());
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MetricGroupId) {
                MetricGroupId that = (MetricGroupId)obj;
                return this.groupName.equals(that.groupName) && this.tags.equals(that.tags);
            }
            return false;
        }

        public String toString() {
            return this.str;
        }
    }
}

